---
title: Changelogs | Cloudflare Docs
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/
  md: https://developers.cloudflare.com/changelog/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

Select...

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

Nov 19, 2025

1. ### [AI Search support for crawling login protected website content](https://developers.cloudflare.com/changelog/2025-11-19-add-extra-headers-for-website-crawling/)

   [AI Search](https://developers.cloudflare.com/ai-search/)

   [AI Search](https://developers.cloudflare.com/ai-search/) now supports [custom HTTP headers](https://developers.cloudflare.com/ai-search/configuration/data-source/website/#access-protected-content) for website crawling, solving a common problem where valuable content behind authentication or access controls could not be indexed.

   Previously, AI Search could only crawl publicly accessible pages, leaving knowledge bases, documentation, and other protected content out of your search results. With custom headers support, you can now include authentication credentials that allow the crawler to access this protected content.

   This is particularly useful for indexing content like:

   * **Internal documentation** behind corporate login systems
   * **Premium content** that requires users to provide access to unlock
   * **Sites protected by Cloudflare Access** using service tokens

   To add custom headers when creating an AI Search instance, select **Parse options**. In the **Extra headers** section, you can add up to five custom headers per Website data source.

   ![Custom headers configuration in AI Search](https://developers.cloudflare.com/_astro/ai-search-extra-headers.B7A2spby_Z1O7uXI.webp)

   For example, to crawl a site protected by [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/), you can add service token credentials as custom headers:

   ```plaintext
   CF-Access-Client-Id: your-token-id.access
   CF-Access-Client-Secret: your-token-secret
   ```

   The crawler will automatically include these headers in all requests, allowing it to access protected pages that would otherwise be blocked.

   Learn more about [configuring custom headers for website crawling](https://developers.cloudflare.com/ai-search/configuration/data-source/website/#access-protected-content) in AI Search.

Nov 18, 2025

1. ### [Temporary Adjustment to Final Disposition Column](https://developers.cloudflare.com/changelog/2025-11-18-temporary-adjustment-to-final-disposition-column/)

   [Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

   #### Temporary Adjustment to Final Disposition Column

   To facilitate significant enhancements to our submission processes, the **Final Disposition** column of the **Team Submissions > Reclassifications** page inside the **Email Security Zero Trust** application will be temporarily removed.

   ***

   #### What's Changing

   The column displaying the final disposition status for submitted email misses will no longer be visible on the specified page.

   #### Why We're Doing This

   This temporary change is required as we revamp and integrate a more powerful backend infrastructure for processing these security-critical submissions. This update is designed to make even more effective use of the data you provide to improve our detection capabilities. We assure you that your submissions are continuing to be addressed at an even greater rate than before, fueling faster and more accurate security improvements.

   #### Next Steps

   Rest assured, the ability to submit email misses and the underlying analysis work remain **fully operational**. We are committed to reintroducing a refined, more valuable status update feature once the new infrastructure is completed.

Nov 17, 2025

1. ### [New Cloudflare One Navigation and Product Experience](https://developers.cloudflare.com/changelog/new-cloudflare-one-navigation-and-product-experience/)

   [Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

   The Zero Trust dashboard and navigation is receiving significant and exciting updates. The dashboard is being restructured to better support common tasks and workflows, and various pages have been moved and consolidated.

   There is a new guided experience on login detailing the changes, and you can use the Zero Trust dashboard search to find product pages by both their new and old names, as well as your created resources. To replay the guided experience, you can find it in Overview > Get Started.

   ![Cloudflare One Dash Changes](https://developers.cloudflare.com/_astro/cf1-dash-changes.Uk_Y-2V-_1OJ1r7.webp)

   Notable changes

   * Product names have been removed from many top-level navigation items to help bring clarity to what they help you accomplish. For example, you can find Gateway policies under ‘Traffic policies’ and CASB findings under ‘Cloud & SaaS findings.’
   * You can view all analytics, logs, and real-time monitoring tools from ‘Insights.’
   * ‘Networks’ better maps the ways that your corporate network interacts with Cloudflare. Some pages like Tunnels, are now a tab rather than a full page as part of these changes. You can find them at Networks > Connectors.
   * Settings are now located closer to the tools and resources they impact. For example, this means you’ll find your WARP configurations at Team & Resources > Devices.

   ![New Cloudflare One Navigation](https://developers.cloudflare.com/_astro/new-cf1-navigation.B7-E-9CV_Z1b4O9p.webp)

   No changes to our API endpoint structure or to any backend services have been made as part of this effort.

Nov 17, 2025

1. ### [WAF Release - 2025-11-17](https://developers.cloudflare.com/changelog/2025-11-17-waf-release/)

   [WAF](https://developers.cloudflare.com/waf/)

   This week highlights enhancements to detection signatures improving coverage for vulnerabilities in DELMIA Apriso, linked to CVE-2025-6205.

   **Key Findings**

   This vulnerability allows unauthenticated attackers to gain privileged access to the application. The latest update provides enhanced detection logic for resilient protection against exploitation attempts.

   **Impact**

   * DELMIA Apriso (CVE-2025-6205): Exploitation could allow an unauthenticated remote attacker to bypass security checks by sending specially crafted requests to the application's message processor. This enables the creation of arbitrary employee accounts, which can be leveraged to modify system configurations and achieve full system compromise.

   | Ruleset | Rule ID | Legacy Rule ID | Description | Previous Action | New Action | Comments |
   | - | - | - | - | - | - | - |
   | Cloudflare Managed Ruleset | ec1e2aa190e64e7cb468e16dd256f4bc | N/A | DELMIA Apriso - Auth Bypass - CVE:CVE-2025-6205 | Log | Block | This is a new detection. |
   | Cloudflare Managed Ruleset | fae6fa37ae9249d58628e54b1a3e521e | N/A | PHP Wrapper Injection - Body | N/A | Disabled | Rule metadata description refined. Detection unchanged. |
   | Cloudflare Managed Ruleset | 9c02e585db34440da620eb668f76bd74 | N/A | PHP Wrapper Injection - URI | N/A | Disabled | Rule metadata description refined. Detection unchanged. |

Nov 17, 2025

1. ### [WAF Release - Scheduled changes for 2025-11-24](https://developers.cloudflare.com/changelog/scheduled-waf-release/)

   [WAF](https://developers.cloudflare.com/waf/)

   | Announcement Date | Release Date | Release Behavior | Legacy Rule ID | Rule ID | Description | Comments |
   | - | - | - | - | - | - | - |
   | 2025-11-17 | 2025-11-24 | Log | N/A | e3871391a93248fa98a78e03b6c44ed5 | PHP Wrapper Injection - Body - Beta | This is a beta detection and will replace the action on original detection "PHP Wrapper Injection - Body" (ID: fae6fa37ae9249d58628e54b1a3e521e ) |
   | 2025-11-17 | 2025-11-24 | Log | N/A | e6b1b66e0e3b46969102baed900f4015 | PHP Wrapper Injection - URI - Beta | This is a beta detection and will replace the action on original detection "PHP Wrapper Injection - URI" (ID: 9c02e585db34440da620eb668f76bd74 ) |
   | 2025-11-17 | 2025-11-24 | Log | N/A | b957ace6e9844bf29244401c4e2e1a2e | FortiWeb - Authentication Bypass via CGIINFO Header - CVE:CVE-2025-64446 | This is a new detection |
   | 2025-11-17 | 2025-11-24 | Log | N/A | 2380b125c53d42ac94479c42b7492846 | XSS - JS Context Escape - Beta | This is a beta detection and will replace the action on original detection "PHP Wrapper Injection - URI" (ID: c1ad1bc37caa4cbeb104f44f7a3769d3 ) |

Nov 14, 2025

1. ### [New SaaS Security weekly digests with API CASB](https://developers.cloudflare.com/changelog/2025-11-14-casb-digest/)

   [CASB](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)

   You can now stay on top of your SaaS security posture with the new **CASB Weekly Digest** notification. This opt-in email digest is delivered to your inbox every Monday morning and provides a high-level summary of your organization's Cloudflare API CASB findings from the previous week.

   This allows security teams and IT administrators to get proactive, at-a-glance visibility into new risks and integration health without having to log in to the dashboard.

   To opt in, navigate to **Manage Account** > **Notifications** in the Cloudflare dashboard to configure the **CASB Weekly Digest** alert type.

   #### Key capabilities

   * **At-a-glance summary** — Review new high/critical findings, most frequent finding types, and new content exposures from the past 7 days.
   * **Integration health** — Instantly see the status of all your connected SaaS integrations (Healthy, Unhealthy, or Paused) to spot API connection issues.
   * **Proactive alerting** — The digest is sent automatically to all subscribed users every Monday morning.
   * **Easy to configure** — Users can opt in by enabling the notification in the Cloudflare dashboard under **Manage Account** > **Notifications**.

   #### Learn more

   * Configure [notification preferences](https://developers.cloudflare.com/notifications/) in Cloudflare.

   The CASB Weekly Digest notification is available to all Cloudflare users today.

Nov 13, 2025

1. ### [Fixed custom SQL date picker inconsistencies](https://developers.cloudflare.com/changelog/2025-11-13-fixed-custom-date/)

   [Log Explorer](https://developers.cloudflare.com/log-explorer/)

   We've resolved a bug in Log Explorer that caused inconsistencies between the custom SQL date field filters and the date picker dropdown. Previously, users attempting to filter logs based on a custom date field via a SQL query sometimes encountered unexpected results or mismatching dates when using the interactive date picker.

   This fix ensures that the custom SQL date field filters now align correctly with the selection made in the date picker dropdown, providing a reliable and predictable filtering experience for your log data. This is particularly important for users creating custom log views based on time-sensitive fields.

Nov 13, 2025

1. ### [Log Explorer adds 14 new datasets](https://developers.cloudflare.com/changelog/2025-11-13-new-datasets/)

   [Log Explorer](https://developers.cloudflare.com/log-explorer/)

   We've significantly enhanced Log Explorer by adding support for 14 additional Cloudflare product datasets.

   This expansion enables Operations and Security Engineers to gain deeper visibility and telemetry across a wider range of Cloudflare services. By integrating these new datasets, users can now access full context to efficiently investigate security incidents, troubleshoot application performance issues, and correlate logged events across different layers (like application and network) within a single interface. This capability is crucial for a complete and cohesive understanding of event flows across your Cloudflare environment.

   The newly supported datasets include:

   #### Zone Level

   * `Dns_logs`
   * `Nel_reports`
   * `Page_shield_events`
   * `Spectrum_events`
   * `Zaraz_events`

   #### Account Level

   * `Audit Logs`
   * `Audit_logs_v2`
   * `Biso_user_actions`
   * `DNS firewall logs`
   * `Email_security_alerts`
   * `Magic Firewall IDS`
   * `Network Analytics`
   * `Sinkhole HTTP`
   * `ipsec_logs`

   Note

   `Auditlog` and `Auditlog_v2` datasets require `audit-log.read` permission for querying.

   The `biso_user_actions` dataset requires either the `Super Admin` or `ZT PII` role for querying.

   #### Example: Correlating logs

   You can now use Log Explorer to query and filter with each of these datasets. For example, you can identify an IP address exhibiting suspicious behavior in the `FW_event` logs, and then instantly pivot to the `Network Analytics` logs or `Access` logs to see its network-level traffic profile or if it bypassed a corporate policy.

   To learn more and get started, refer to the [Log Explorer documentation](https://developers.cloudflare.com/log-explorer/) and the [Cloudflare Logs documentation](https://developers.cloudflare.com/logs/).

Nov 12, 2025

1. ### [DEX Logpush jobs](https://developers.cloudflare.com/changelog/2025-11-12-dex-logpush-jobsmdx/)

   [Digital Experience Monitoring](https://developers.cloudflare.com/cloudflare-one/insights/dex/)

   [Digital Experience Monitoring (DEX)](https://developers.cloudflare.com/cloudflare-one/insights/dex/) provides visibility into WARP device metrics, connectivity, and network performance across your Cloudflare SASE deployment.

   We've released four new WARP and DEX device data sets that can be exported via [Cloudflare Logpush](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/). These Logpush data sets can be exported to R2, a cloud bucket, or a SIEM to build a customized logging and analytics experience.

   1. [DEX Application Tests](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/dex_application_tests/)
   2. [DEX Device State Events](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/dex_device_state_events/)
   3. [WARP Config Changes](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/warp_config_changes/)
   4. [WARP Toggle Changes](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/warp_toggle_changes/)

   To create a new DEX or WARP Logpush job, customers can go to the account level of the Cloudflare dashboard > Analytics & Logs > Logpush to get started.

   ![DEX logpush job creation dashboard](https://developers.cloudflare.com/_astro/dex_logpush_datasets.CtCk36pX_2dm9s2.webp)

Nov 12, 2025

1. ### [More SQL aggregate, date and time functions available in Workers Analytics Engine](https://developers.cloudflare.com/changelog/2025-11-12-analytics-engine-further-sql-enhancements/)

   [Workers Analytics Engine ](https://developers.cloudflare.com/analytics/analytics-engine/)[Workers](https://developers.cloudflare.com/workers/)

   You can now perform more powerful queries directly in [Workers Analytics Engine](https://developers.cloudflare.com/analytics/analytics-engine/) with a major expansion of our SQL function library.

   Workers Analytics Engine allows you to ingest and store high-cardinality data at scale (such as custom analytics) and query your data through a simple SQL API.

   Today, we've expanded Workers Analytics Engine's SQL capabilities with several new functions:

   [**New aggregate functions:**](https://developers.cloudflare.com/analytics/analytics-engine/sql-reference/aggregate-functions/)

   * `countIf()` - count the number of rows which satisfy a provided condition
   * `sumIf()` - calculate a sum from rows which satisfy a provided condition
   * `avgIf()` - calculate an average from rows which satisfy a provided condition

   [**New date and time functions:**](https://developers.cloudflare.com/analytics/analytics-engine/sql-reference/date-time-functions/)

   * `toYear()`
   * `toMonth()`
   * `toDayOfMonth()`
   * `toDayOfWeek()`
   * `toHour()`
   * `toMinute()`
   * `toSecond()`
   * `toStartOfYear()`
   * `toStartOfMonth()`
   * `toStartOfWeek()`
   * `toStartOfDay()`
   * `toStartOfHour()`
   * `toStartOfFifteenMinutes()`
   * `toStartOfTenMinutes()`
   * `toStartOfFiveMinutes()`
   * `toStartOfMinute()`
   * `today()`
   * `toYYYYMM()`

   #### Ready to get started?

   Whether you're building usage-based billing systems, customer analytics dashboards, or other custom analytics, these functions let you get the most out of your data. [Get started ](https://developers.cloudflare.com/analytics/analytics-engine/get-started/)with Workers Analytics Engine and explore all available functions in our [SQL reference documentation](https://developers.cloudflare.com/analytics/analytics-engine/sql-reference/).

Nov 11, 2025

1. ### [WARP client for Windows (version 2025.9.558.0)](https://developers.cloudflare.com/changelog/2025-11-11-warp-windows-ga/)

   [Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

   A new GA release for the Windows WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

   This release contains minor fixes, improvements, and new features including [Path Maximum Transmission Unit Discovery (PMTUD)](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery). When PMTUD is enabled, the client will dynamically adjust packet sizing to optimize connection performance. There is also a new connection status message in the GUI to inform users that the local network connection may be unstable. This will make it easier to diagnose connectivity issues.

   **Changes and improvements**

   * Fixed an inconsistency with [Global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override) settings in multi-user environments when switching between users.
   * The GUI now displays the health of the tunnel and DNS connections by showing a connection status message when the network may be unstable. This will make it easier to diagnose connectivity issues.
   * Fixed an issue where deleting a registration was erroneously reported as having failed.
   * Path Maximum Transmission Unit Discovery (PMTUD) may now be used to discover the effective MTU of the connection. This allows the WARP client to improve connectivity optimized for each network. PMTUD is disabled by default. To enable it, refer to the [PMTUD documentation](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery).
   * Improvements for the [OS version](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/os-version/) WARP client check. Windows Updated Build Revision (UBR) numbers can now be checked by the client to ensure devices have required security patches and features installed.
   * The WARP client now supports Windows 11 ARM-based machines. For information on known limitations, refer to the [Known limitations page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/known-limitations/#warp-disconnected-on-windows-arm).

   **Known issues**

   * For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 KB5062553](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

   * Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

   * Devices with KB5055523 installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

   * DNS resolution may be broken when the following conditions are all true:

     * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
     * A custom DNS server address is configured on the primary network adapter.
     * The custom DNS server address on the primary network adapter is changed while WARP is connected.

     To work around this issue, reconnect the WARP client by toggling off and back on.

Nov 11, 2025

1. ### [WARP client for macOS (version 2025.9.558.0)](https://developers.cloudflare.com/changelog/2025-11-11-warp-macos-ga/)

   [Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

   A new GA release for the macOS WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

   This release contains minor fixes, improvements, and new features including [Path Maximum Transmission Unit Discovery (PMTUD)](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery). When PMTUD is enabled, the client will dynamically adjust packet sizing to optimize connection performance. There is also a new connection status message in the GUI to inform users that the local network connection may be unstable. This will make it easier to diagnose connectivity issues.

   **Changes and improvements**

   * The GUI now displays the health of the tunnel and DNS connections by showing a connection status message when the network may be unstable. This will make it easier to diagnose connectivity issues.
   * Fixed an issue where deleting a registration was erroneously reported as having failed.
   * Path Maximum Transmission Unit Discovery (PMTUD) may now be used to discover the effective MTU of the connection. This allows the WARP client to improve connectivity optimized for each network. PMTUD is disabled by default. To enable it, refer to the [PMTUD documentation](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery).

   **Known issues**

   * Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/connections/connect-devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

Nov 11, 2025

1. ### [WARP client for Linux (version 2025.9.558.0)](https://developers.cloudflare.com/changelog/2025-11-11-warp-linux-ga/)

   [Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

   A new GA release for the Linux WARP client is now available on the [stable releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

   This release contains minor fixes, improvements, and new features including [Path Maximum Transmission Unit Discovery (PMTUD)](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery). When PMTUD is enabled, the client will dynamically adjust packet sizing to optimize connection performance. There is also a new connection status message in the GUI to inform users that the local network connection may be unstable. This will make it easier to diagnose connectivity issues.

   WARP client version 2025.8.779.0 introduced an updated public key for Linux packages. The public key must be updated if it was installed before September 12, 2025 to ensure the repository remains functional after December 4, 2025. Instructions to make this update are available at [pkg.cloudflareclient.com](https://pkg.cloudflareclient.com/).

   **Changes and improvements**

   * The GUI now displays the health of the tunnel and DNS connections by showing a connection status message when the network may be unstable. This will make it easier to diagnose connectivity issues.
   * Fixed an issue where deleting a registration was erroneously reported as having failed.
   * Path Maximum Transmission Unit Discovery (PMTUD) may now be used to discover the effective MTU of the connection. This allows the WARP client to improve connectivity optimized for each network. PMTUD is disabled by default. To enable it, refer to the [PMTUD documentation](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/path-mtu-discovery/#enable-path-mtu-discovery).

Nov 11, 2025

1. ### [cloudflared proxy-dns command will be removed starting February 2, 2026](https://developers.cloudflare.com/changelog/2025-11-11-cloudflared-proxy-dns/)

   [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

   Starting February 2, 2026, the `cloudflared proxy-dns` command will be removed from all new `cloudflared` [releases](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/downloads/).

   This change is being made to enhance security and address a potential vulnerability in an underlying DNS library. This vulnerability is specific to the `proxy-dns` command and does not affect any other `cloudflared` features, such as the core [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/) service.

   The `proxy-dns` command, which runs a client-side [DNS-over-HTTPS (DoH)](https://developers.cloudflare.com/1.1.1.1/encryption/dns-over-https/) proxy, has been an officially undocumented feature for several years. This functionality is fully and securely supported by our actively developed products.

   Versions of `cloudflared` released before this date will not be affected and will continue to operate. However, note that our [official support policy](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/downloads/#deprecated-releases) for any `cloudflared` release is one year from its release date.

   #### Migration paths

   We strongly advise users of this undocumented feature to migrate to one of the following officially supported solutions before February 2, 2026, to continue benefiting from secure [DNS-over-HTTPS](https://developers.cloudflare.com/1.1.1.1/encryption/dns-over-https/).

   #### End-user devices

   The preferred method for enabling DNS-over-HTTPS on user devices is the [Cloudflare WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/). The WARP client automatically secures and proxies all DNS traffic from your device, integrating it with your organization's [Zero Trust policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) and [posture checks](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/).

   #### Servers, routers, and IoT devices

   For scenarios where installing a client on every device is not possible (such as servers, routers, or IoT devices), we recommend using the [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/).

   Instead of running `cloudflared proxy-dns` on a machine, you can install the WARP Connector on a single Linux host within your private network. This connector will act as a gateway, securely routing all DNS and network traffic from your [entire subnet](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/site-to-internet/) to Cloudflare for [filtering and logging](https://developers.cloudflare.com/cloudflare-one/traffic-policies/).

Nov 11, 2025

1. ### [Resize your custom SQL window in Log Explorer](https://developers.cloudflare.com/changelog/2025-11-11-resize-sql-window/)

   [Log Explorer](https://developers.cloudflare.com/log-explorer/)

   We're excited to announce a quality-of-life improvement for Log Explorer users. You can now resize the custom SQL query window to accommodate longer and more complex queries.

   Previously, if you were writing a long custom SQL query, the fixed-size window required excessive scrolling to view the full query. This update allows you to easily drag the bottom edge of the query window to make it taller. This means you can view your entire custom query at once, improving the efficiency and experience of writing and debugging complex queries.

   To learn more and get started, refer to the [Log Explorer documentation](https://developers.cloudflare.com/log-explorer/).

Nov 11, 2025

1. ### [Logpush Health Dashboards](https://developers.cloudflare.com/changelog/2025-11-11-health-dashboards/)

   [Logs](https://developers.cloudflare.com/logs/)

   We’re excited to introduce **Logpush Health Dashboards**, giving customers real-time visibility into the status, reliability, and performance of their [Logpush](https://developers.cloudflare.com/logs/logpush/) jobs. Health dashboards make it easier to detect delivery issues, monitor job stability, and track performance across destinations. The dashboards are divided into two sections:

   * **Upload Health**: See how much data was successfully uploaded, where drops occurred, and how your jobs are performing overall. This includes data completeness, success rate, and upload volume.

   * **Upload Reliability** – Diagnose issues impacting stability, retries, or latency, and monitor key metrics such as retry counts, upload duration, and destination availability.

   ![Health Dashboard](https://developers.cloudflare.com/_astro/Health-Dashboard.CP0mV0IW_16n4kl.webp)

   Health Dashboards can be accessed from the Logpush page in the Cloudflare dashboard at the account or zone level, under the Health tab. For more details, refer to our [**Logpush Health Dashboards**](https://developers.cloudflare.com/logs/logpush/logpush-health) documentation, which includes a comprehensive troubleshooting guide to help interpret and resolve common issues.

Nov 10, 2025

1. ### [Crawler drilldowns with extended actions menu](https://developers.cloudflare.com/changelog/2025-11-10-ai-crawl-control-crawler-info/)

   [AI Crawl Control](https://developers.cloudflare.com/ai-crawl-control/)

   AI Crawl Control now supports per-crawler drilldowns with an extended actions menu and status code analytics. Drill down into Metrics, Cloudflare Radar, and Security Analytics, or export crawler data for use in [WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/), [Redirect Rules](https://developers.cloudflare.com/rules/url-forwarding/), and robots.txt files.

   #### What's new

   #### Status code distribution chart

   The **Metrics** tab includes a status code distribution chart showing HTTP response codes (2xx, 3xx, 4xx, 5xx) over time. Filter by individual crawler, category, operator, or time range to analyze how specific crawlers interact with your site.

   ![AI Crawl Control status code distribution chart](https://developers.cloudflare.com/_astro/ai-crawl-control-status-codes.DESJcAiK_Z27ymS5.webp)

   #### Extended actions menu

   Each crawler row includes a three-dot menu with per-crawler actions:

   * **View Metrics** — Filter the AI Crawl Control Metrics page to the selected crawler.
   * **View on Cloudflare Radar** — Access verified crawler details on Cloudflare Radar.
   * **Copy User Agent** — Copy user agent strings for use in WAF custom rules, Redirect Rules, or robots.txt files.
   * **View in Security Analytics** — Filter Security Analytics by detection IDs (Bot Management customers).
   * **Copy Detection ID** — Copy detection IDs for use in WAF custom rules (Bot Management customers).

   ![AI Crawl Control crawler actions menu](https://developers.cloudflare.com/_astro/ai-crawl-control-crawler-info.Dwc39LqI_Z1c2Xs.webp)

   #### Get started

   1. Log in to the Cloudflare dashboard, and select your account and domain.
   2. Go to **AI Crawl Control** > **Metrics** to access the status code distribution chart.
   3. Go to **AI Crawl Control** > **Crawlers** and select the three-dot menu for any crawler to access per-crawler actions.
   4. Select multiple crawlers to use bulk copy buttons for user agents or detection IDs.

   Learn more about [AI Crawl Control](https://developers.cloudflare.com/ai-crawl-control/).

Nov 10, 2025

1. ### [WAF Release - 2025-11-10](https://developers.cloudflare.com/changelog/2025-11-10-waf-release/)

   [WAF](https://developers.cloudflare.com/waf/)

   This week’s release introduces new detections for Prototype Pollution across three common vectors: URI, Body, and Header/Form.

   **Key Findings**

   * These attacks can affect both API and web applications by altering normal behavior or bypassing security controls.

   **Impact**

   Exploitation may allow attackers to change internal logic or cause unexpected behavior in applications using JavaScript or Node.js frameworks. Developers should sanitize input keys and avoid merging untrusted data structures.

   | Ruleset | Rule ID | Legacy Rule ID | Description | Previous Action | New Action | Comments |
   | - | - | - | - | - | - | - |
   | Cloudflare Managed Ruleset | 32405a50728746dd8caa057b606285e6 | N/A | Generic Rules - Prototype Pollution - URI | Log | Disabled | This is a new detection |
   | Cloudflare Managed Ruleset | a7da00c63c4243d2a72456fe4f59ff26 | N/A | Generic Rules - Prototype Pollution - Body | Log | Disabled | This is a new detection |
   | Cloudflare Managed Ruleset | 833078bdcfa04bb7aa7b8fb67efbeb39 | N/A | Generic Rules - Prototype Pollution - Header - Form | Log | Disabled | This is a new detection |

Nov 07, 2025

1. ### [Workers automatic tracing, now in open beta](https://developers.cloudflare.com/changelog/2025-11-07-automatic-tracing/)

   [Workers](https://developers.cloudflare.com/workers/)

   Enable automatic tracing on your Workers, giving you detailed metadata and timing information for every operation your Worker performs.

   ![Tracing example](https://developers.cloudflare.com/_astro/R2_Screenshot.DAnOidMq_Deoqf.webp)

   Tracing helps you identify performance bottlenecks, resolve errors, and understand how your Worker interacts with other services on the Workers platform. You can now answer questions like:

   * Which calls are slowing down my application?
   * Which queries to my database take the longest?
   * What happened within a request that resulted in an error?

   **You can now:**

   * View traces alongside your logs in the Workers Observability dashboard
   * Export traces (and correlated logs) to any [OTLP-compatible destination](https://opentelemetry.io/docs/specs/otel/protocol/), such as [Honeycomb](https://developers.cloudflare.com/workers/observability/exporting-opentelemetry-data/honeycomb/), [Sentry](https://developers.cloudflare.com/workers/observability/exporting-opentelemetry-data/sentry/) or [Grafana](https://developers.cloudflare.com/workers/observability/exporting-opentelemetry-data/grafana-cloud/), by configuring a tracing destination in the [Cloudflare dashboard](https://dash.cloudflare.com/?to=/:account/workers-and-pages/observability/destinations)
   * Analyze and query across span attributes (operation type, status, duration, errors)

   #### To get started, set:

   ```jsonc
   {
     "observability": {
       "tracing": {
         "enabled": true,
       },
     },
   }
   ```

   Note

   In the future, Cloudflare plans to enable automatic tracing in addition to logs when you set `observability.enabled = true` in your Wrangler configuration.

   While automatic tracing is in early beta, this setting will not enable tracing by default, and will only enable logs.

   An updated [`compatibility_date`](https://developers.cloudflare.com/workers/configuration/compatibility-dates/) will be required for this change to take effect.

   #### Want to learn more?

   * [Read the announcement](https://blog.cloudflare.com/workers-tracing-now-in-open-beta/)
   * [Check out the documentation](https://developers.cloudflare.com/workers/observability/traces/)

Nov 06, 2025

1. ### [Applications to be remapped to the new categories](https://developers.cloudflare.com/changelog/2025-11-06-applications-recategorised-plan/)

   [Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

   We have previously added new application categories to better reflect their content and improve HTTP traffic management: refer to [Changelog](https://developers.cloudflare.com/cloudflare-one/changelog/gateway/#2025-10-28). While the new categories are live now, we want to ensure you have ample time to review and adjust any existing rules you have configured against old categories. The remapping of existing applications into these new categories will be completed by January 30, 2026. This timeline allows you a dedicated period to:

   * Review the new category structure.
   * Identify any policies you have that target the older categories.
   * Adjust your rules to reference the new, more precise categories before the old mappings change. Once the applications have been fully remapped by January 30, 2026, you might observe some changes in the traffic being mitigated or allowed by your existing policies. We encourage you to use the intervening time to prepare for a smooth transition.

   **Applications being remappedd**

   | Application Name | Existing Category | New Category |
   | - | - | - |
   | Google Photos | File Sharing | Photography & Graphic Design |
   | Flickr | File Sharing | Photography & Graphic Design |
   | ADP | Human Resources | Business |
   | Greenhouse | Human Resources | Business |
   | myCigna | Human Resources | Health & Fitness |
   | UnitedHealthcare | Human Resources | Health & Fitness |
   | ZipRecruiter | Human Resources | Business |
   | Amazon Business | Human Resources | Business |
   | Jobcenter | Human Resources | Business |
   | Jobsuche | Human Resources | Business |
   | Zenjob | Human Resources | Business |
   | DocuSign | Legal | Business |
   | Postident | Legal | Business |
   | Adobe Creative Cloud | Productivity | Photography & Graphic Design |
   | Airtable | Productivity | Development |
   | Autodesk Fusion360 | Productivity | IT Management |
   | Coursera | Productivity | Education |
   | Microsoft Power BI | Productivity | Business |
   | Tableau | Productivity | Business |
   | Duolingo | Productivity | Education |
   | Adobe Reader | Productivity | Business |
   | AnpiReport | Productivity | Travel |
   | ビズリーチ | Productivity | Business |
   | doda (デューダ) | Productivity | Business |
   | 求人ボックス | Productivity | Business |
   | マイナビ2026 | Productivity | Business |
   | Power Apps | Productivity | Business |
   | RECRUIT AGENT | Productivity | Business |
   | シフトボード | Productivity | Business |
   | スタンバイ | Productivity | Business |
   | Doctolib | Productivity | Health & Fitness |
   | Miro | Productivity | Photography & Graphic Design |
   | MyFitnessPal | Productivity | Health & Fitness |
   | Sentry Mobile | Productivity | Travel |
   | Slido | Productivity | Photography & Graphic Design |
   | Arista Networks | Productivity | IT Management |
   | Atlassian | Productivity | Business |
   | CoderPad | Productivity | Business |
   | eAgreements | Productivity | Business |
   | Vmware | Productivity | IT Management |
   | Vmware Vcenter | Productivity | IT Management |
   | AWS Skill Builder | Productivity | Education |
   | Microsoft Office 365 (GCC) | Productivity | Business |
   | Microsoft Exchange Online (GCC) | Productivity | Business |
   | Canva | Sales & Marketing | Photography & Graphic Design |
   | Instacart | Shopping | Food & Drink |
   | Wawa | Shopping | Food & Drink |
   | McDonald's | Shopping | Food & Drink |
   | Vrbo | Shopping | Travel |
   | American Airlines | Shopping | Travel |
   | Booking.com | Shopping | Travel |
   | Ticketmaster | Shopping | Entertainment & Events |
   | Airbnb | Shopping | Travel |
   | DoorDash | Shopping | Food & Drink |
   | Expedia | Shopping | Travel |
   | EasyPark | Shopping | Travel |
   | UEFA Tickets | Shopping | Entertainment & Events |
   | DHL Express | Shopping | Business |
   | UPS | Shopping | Business |

   For more information on creating HTTP policies, refer to [Applications and app types](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/).

Nov 05, 2025

1. ### [D1 can restrict data localization with jurisdictions](https://developers.cloudflare.com/changelog/2025-11-05-d1-jurisdiction/)

   [D1 ](https://developers.cloudflare.com/d1/)[Workers](https://developers.cloudflare.com/workers/)

   You can now set a [jurisdiction](https://developers.cloudflare.com/d1/configuration/data-location/) when creating a D1 database to guarantee where your database runs and stores data. Jurisdictions can help you comply with data localization regulations such as GDPR. Supported jurisdictions include `eu` and `fedramp`.

   A jurisdiction can only be set at database creation time via wrangler, REST API or the UI and cannot be added/updated after the database already exists.

   ```sh
   npx wrangler@latest d1 create db-with-jurisdiction --jurisdiction eu
   ```

   ```plaintext
   curl -X POST "https://api.cloudflare.com/client/v4/accounts/<account_id>/d1/database" \
        -H "Authorization: Bearer $TOKEN" \
        -H "Content-Type: application/json" \
        --data '{"name": "db-wth-jurisdiction", "jurisdiction": "eu" }'
   ```

   To learn more, visit D1's data location [documentation](https://developers.cloudflare.com/d1/configuration/data-location/).

Nov 05, 2025

1. ### [Logpush Permission Update for Zero Trust Datasets](https://developers.cloudflare.com/changelog/2025-11-05-logpush-permissions-update/)

   [Logs](https://developers.cloudflare.com/logs/)

   [Permissions](https://developers.cloudflare.com/logs/logpush/permissions/) for managing Logpush jobs related to [Zero Trust datasets](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/) (Access, Gateway, and DEX) have been updated to improve data security and enforce appropriate access controls.

   To view, create, update, or delete Logpush jobs for Zero Trust datasets, users must now have both of the following permissions:

   * Logs Edit
   * Zero Trust: PII Read

   Note

   Update your UI, API or Terraform configurations to include the new permissions. Requests to Zero Trust datasets will fail due to insufficient access without the additional permission.

Nov 05, 2025

1. ### [WAF Release - 2025-11-05 - Emergency](https://developers.cloudflare.com/changelog/2025-11-05-emergency-waf-release/)

   [WAF](https://developers.cloudflare.com/waf/)

   This week’s emergency release introduces a new detection signature that enhances coverage for a critical vulnerability in the React Native Metro Development Server, tracked as CVE-2025-11953.

   **Key Findings**

   The Metro Development Server exposes an HTTP endpoint that is vulnerable to OS command injection (CWE-78). An unauthenticated network attacker can send a crafted request to this endpoint and execute arbitrary commands on the host running Metro. The vulnerability affects Metro/cli-server-api builds used by React Native Community CLI in pre-patch development releases.

   **Impact**

   Successful exploitation of CVE-2025-11953 may result in remote command execution on developer workstations or CI/build agents, leading to credential and secret exposure, source tampering, and potential lateral movement into internal networks. Administrators and developers are strongly advised to apply the vendor's patches and restrict Metro’s network exposure to reduce this risk.

   | Ruleset | Rule ID | Legacy Rule ID | Description | Previous Action | New Action | Comments |
   | - | - | - | - | - | - | - |
   | Cloudflare Managed Ruleset | db6b9e1ac1494971ae8c70aac8e30c5b | N/A | React Native Metro - Command Injection - CVE:CVE-2025-11953 | N/A | Block | This is a New Detection |

Nov 05, 2025

1. ### [Announcing Workers VPC Services (Beta)](https://developers.cloudflare.com/changelog/2025-09-25-workers-vpc/)

   [Workers VPC](https://developers.cloudflare.com/workers-vpc/)

   **Workers VPC Services** is now available, enabling your Workers to securely access resources in your private networks, without having to expose them on the public Internet.

   #### What's new

   * **VPC Services**: Create secure connections to internal APIs, databases, and services using familiar Worker binding syntax
   * **Multi-cloud Support**: Connect to resources in private networks in any external cloud (AWS, Azure, GCP, etc.) or on-premise using Cloudflare Tunnels

   ```js
   export default {
     async fetch(request, env, ctx) {
       // Perform application logic in Workers here


       // Sample call to an internal API running on ECS in AWS using the binding
       const response = await env.AWS_VPC_ECS_API.fetch("https://internal-host.example.com");


       // Additional application logic in Workers
       return new Response();
     },
   };
   ```

   #### Getting started

   Set up a Cloudflare Tunnel, create a VPC Service, add service bindings to your Worker, and access private resources securely. [Refer to the documentation](https://developers.cloudflare.com/workers-vpc/) to get started.

Nov 04, 2025

1. ### [Log Explorer now supports query cancellation](https://developers.cloudflare.com/changelog/2025-11-04-query-cancellation/)

   [Log Explorer](https://developers.cloudflare.com/log-explorer/)

   We're excited to announce that Log Explorer users can now cancel queries that are currently running.

   This new feature addresses a common pain point: waiting for a long, unintended, or misconfigured query to complete before you can submit a new, correct one. With query cancellation, you can immediately stop the execution of any undesirable query, allowing you to quickly craft and submit a new query, significantly improving your investigative workflow and productivity within Log Explorer.

Nov 04, 2025

1. ### [Log Explorer now shows query result distribution](https://developers.cloudflare.com/changelog/2025-11-13-query-result-distribution/)

   [Log Explorer](https://developers.cloudflare.com/log-explorer/)

   We're excited to announce a new feature in Log Explorer that significantly enhances how you analyze query results: the Query results distribution chart.

   This new chart provides a graphical distribution of your results over the time window of the query. Immediately after running a query, you will see the distribution chart above your result table. This visualization allows Log Explorer users to quickly spot trends, identify anomalies, and understand the temporal concentration of log events that match their criteria. For example, you can visually confirm if a spike in traffic or errors occurred at a specific time, allowing you to focus your investigation efforts more effectively. This feature makes it faster and easier to extract meaningful insights from your vast log data.

   The chart will dynamically update to reflect the logs matching your current query.

Nov 03, 2025

1. ### [WAF Release - 2025-11-03](https://developers.cloudflare.com/changelog/2025-11-03-waf-release/)

   [WAF](https://developers.cloudflare.com/waf/)

   This week highlights enhancements to detection signatures improving coverage for vulnerabilities in Adobe Commerce and Magento Open Source, linked to CVE-2025-54236.

   **Key Findings**

   This vulnerability allows unauthenticated attackers to take over customer accounts through the Commerce REST API and, in certain configurations, may lead to remote code execution. The latest update provides enhanced detection logic for resilient protection against exploitation attempts.

   **Impact**

   * Adobe Commerce (CVE-2025-54236): Exploitation may allow attackers to hijack sessions, execute arbitrary commands, steal data, and disrupt storefronts, resulting in confidentiality and integrity risks for merchants. Administrators are strongly encouraged to apply vendor patches without delay.

   | Ruleset | Rule ID | Legacy Rule ID | Description | Previous Action | New Action | Comments |
   | - | - | - | - | - | - | - |
   | Cloudflare Managed Ruleset | f5295d8333b7428c816654d8cb6d5fe5 | 100774C | Adobe Commerce - Remote Code Execution - CVE:CVE-2025-54236 | Log | Block | This is an improved detection. |

Oct 31, 2025

1. ### [Report logo misuse to Cloudflare directly from the Brand Protection dashboard](https://developers.cloudflare.com/changelog/2025-10-31-brand-protection-logo-dashboard-report-abuse/)

   [Security Center](https://developers.cloudflare.com/security-center/)

   The Brand Protection logo query dashboard now allows you to use the **Report to Cloudflare** button to submit an Abuse report directly from the Brand Protection logo queries dashboard. While you could previously report new domains that were impersonating your brand before, now you can do the same for websites found to be using your logo wihtout your permission. The abuse reports wiull be prefilled and you will only need to validate a few fields before you can click the submit button, after which our team process your request.

   Ready to start? Check out the [Brand Protection docs](https://developers.cloudflare.com/security-center/brand-protection/).

Oct 31, 2025

1. ### [Workers WebSocket message size limit increased from 1 MiB to 32 MiB](https://developers.cloudflare.com/changelog/2025-10-31-increased-websocket-message-size-limit/)

   [Workers ](https://developers.cloudflare.com/workers/)[Durable Objects ](https://developers.cloudflare.com/durable-objects/)[Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

   Workers, including those using [Durable Objects](https://developers.cloudflare.com/durable-objects/) and [Browser Rendering](https://developers.cloudflare.com/browser-rendering/workers-bindings/), may now process WebSocket messages up to 32 MiB in size. Previously, this limit was 1 MiB.

   This change allows Workers to handle use cases requiring large message sizes, such as processing Chrome Devtools Protocol messages.

   For more information, please see the [Durable Objects startup limits](https://developers.cloudflare.com/durable-objects/platform/limits/#SQLite-backed-Durable-Objects-general-limits).

Oct 31, 2025

1. ### [Increased Workflows instance and concurrency limits](https://developers.cloudflare.com/changelog/2025-10-28-raising-limits/)

   [Workflows ](https://developers.cloudflare.com/workflows/)[Workers](https://developers.cloudflare.com/workers/)

   We've raised the [Cloudflare Workflows](https://developers.cloudflare.com/workflows/) account-level limits for all accounts on the [Workers paid plan](https://developers.cloudflare.com/workers/platform/pricing/):

   * **Instance creation rate** increased from 100 workflow instances per 10 seconds to 100 instances per second
   * **Concurrency limit** increased from 4,500 to 10,000 workflow instances per account

   These increases mean you can create new instances up to 10x faster, and have more workflow instances concurrently executing. To learn more and get started with Workflows, refer to [the getting started guide](https://developers.cloudflare.com/workflows/get-started/guide/).

   If your application requires a higher limit, fill out the [Limit Increase Request Form](https://developers.cloudflare.com/workers/platform/limits/) or contact your account team. Please refer to [Workflows pricing](https://developers.cloudflare.com/workflows/reference/pricing/) for more information.

Oct 30, 2025

1. ### [Introducing email two-factor authentication](https://developers.cloudflare.com/changelog/2025-10-30-email-2fa/)

   [Cloudflare Fundamentals](https://developers.cloudflare.com/fundamentals/)

   Two-factor authentication (2FA) is one of the best ways to protect your account from the risk of account takeover. Cloudflare has offered phishing resistant 2FA options including hardware based keys (for example, a Yubikey) and app based TOTP (time-based one-time password) options which use apps like Google or Microsoft's Authenticator app. Unfortunately, while these solutions are very secure, they can be lost if you misplace the hardware based key, or lose the phone which includes that app. The result is that users sometimes get locked out of their accounts and need to contact support.

   Today, we are announcing the addition of email as a 2FA factor for all Cloudflare accounts. Email 2FA is in wide use across the industry as a least common denominator for 2FA because it is low friction, loss resistant, and still improves security over username/password login only. We also know that most commercial email providers already require 2FA, so your email address is usually well protected already.

   You can now enable email 2FA on the Cloudflare dashboard:

   1. Go to **Profile** at the top right corner.
   2. Select **Authentication**.
   3. Under **Two-Factor Authentication**, select **Set up**.

   #### Sign-in security best practices

   Cloudflare is critical infrastructure, and you should protect it as such. Review the following best practices and make sure you are doing your part to secure your account:

   * Use a unique password for every website, including Cloudflare, and store it in a password manager like 1Password or Keeper. These services are cross-platform and simplify the process of managing secure passwords.

   * Use 2FA to make it harder for an attacker to get into your account in the event your password is leaked.

   * Store your backup codes securely. A password manager is the best place since it keeps the backup codes encrypted, but you can also print them and put them somewhere safe in your home.

   * If you use an app to manage your 2FA keys, enable cloud backup, so that you don't lose your keys in the event you lose your phone.

   * If you use a custom email domain to sign in, [configure SSO](https://developers.cloudflare.com/fundamentals/manage-members/dashboard-sso/).

   * If you use a public email domain like Gmail or Hotmail, you can also use social login with Apple, GitHub, or Google to sign in.

   * If you manage a Cloudflare account for work:

     * Have at least two administrators in case one of them unexpectedly leaves your company.
     * Use SCIM to automate permissions management for members in your Cloudflare account.

Oct 30, 2025

1. ### [Revamped Member Management UI](https://developers.cloudflare.com/changelog/2025-10-30-member-management-improvements/)

   [Cloudflare Fundamentals](https://developers.cloudflare.com/fundamentals/)

   As Cloudflare's platform has grown, so has the need for precise, role-based access control. We’ve redesigned the Member Management experience in the Dashboard to help administrators more easily discover, assign, and refine permissions for specific principals.

   #### What's New

   **Refreshed member invite flow**

   We overhauled the Invite Members UI to simplify inviting users and assigning permissions.

   ![Updated Invite Flow UX](https://developers.cloudflare.com/_astro/2025-10-30-invite-experience.B7F3VQ_y_d0KPF.webp)

   **Refreshed Members Overview Page**

   We've updated the Members Overview Page to clearly display:

   * Member 2FA status
   * Which members hold Super Admin privileges
   * API access settings per member
   * Member onboarding state (accepted vs pending invite)

   ![Updated Member Management Overview](https://developers.cloudflare.com/_astro/2025-10-30-member-management-screen.BLc2lx98_Z1KfRa0.webp)

   **New Member Permission Policies Details View**

   We've created a new member details screen that shows all permission policies associated with a member; including policies inherited from group associations to make it easier for members to understand the effective permissions they have.

   ![Updated Permission Policies Details Screen](https://developers.cloudflare.com/_astro/2025-10-30-permission-policies-screen.pMj53si2_1BWDYH.webp)

   **Improved Member Permission Workflow**

   We redesigned the permission management experience to make it faster and easier for administrators to review roles and grant access.

   ![Updated Member Permission Management UX](https://developers.cloudflare.com/_astro/2025-10-30-permission-policies-screen.pMj53si2_1BWDYH.webp)

   **Account-scoped Policies Restrictions Relaxed**

   Previously, customers could only associate a single account-scoped policy with a member. We've relaxed this restriction, and now Administrators can now assign multiple account-scoped policies to the same member; bringing policy assignment behavior in-line with user-groups and providing greater flexibility in managing member permissions.

Oct 30, 2025

1. ### [New TCP-based fields available in Rulesets](https://developers.cloudflare.com/changelog/2025-10-30-tcp-rtt-and-tcp-fields/)

   [Rules](https://developers.cloudflare.com/rules/)

   #### Build rules based on TCP transport and latency

   Cloudflare now provides two new request fields in the Ruleset engine that let you make decisions based on whether a request used TCP and the measured TCP round-trip time between the client and Cloudflare. These fields help you understand protocol usage across your traffic and build policies that respond to network performance. For example, you can distinguish TCP from QUIC traffic or route high latency requests to alternative origins when needed.

   ***

   #### New fields

   | Field | Type | Description |
   | - | - | - |
   | `cf.edge.client_tcp` | Boolean | Indicates whether the request used TCP. A value of true means the client connected using TCP instead of QUIC. |
   | `cf.timings.client_tcp_rtt_msec` | Number | Reports the smoothed TCP round-trip time between the client and Cloudflare in milliseconds. For example, a value of 20 indicates roughly twenty milliseconds of RTT. |

   Example filter expression:

   ```plaintext
   cf.edge.client_tcp && cf.timings.client_tcp_rtt_msec < 100
   ```

   More information can be found in the Rules language [fields reference](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/).

Oct 30, 2025

1. ### [Access Workers preview URLs from the Build details page](https://developers.cloudflare.com/changelog/2025-10-30-builds-preview/)

   [Workers](https://developers.cloudflare.com/workers/)

   You can now access [preview URLs](https://developers.cloudflare.com/workers/configuration/previews/) directly from the build details page, making it easier to test your changes when reviewing builds in the dashboard.

   ![preview button](https://developers.cloudflare.com/_astro/builds-preview-button.CjGnhkt7_Z1OW4G0.webp)

   **What's new**

   * A **Preview** button now appears in the top-right corner of the build details page for successful builds
   * Click it to instantly open the latest preview URL
   * Matches the same experience you're familiar with from Pages

Oct 28, 2025

1. ### [Access private hostname applications support all ports/protocols](https://developers.cloudflare.com/changelog/2025-10-28-access-application-support-for-all-ports-and-protocols/)

   [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

   [Cloudflare Access for private hostname applications](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/self-hosted-private-app/) can now secure traffic on all ports and protocols.

   Previously, applying Zero Trust policies to private applications required the application to use HTTPS on port `443` and support Server Name Indicator (SNI).

   This update removes that limitation. As long as the application is reachable via a Cloudflare off-ramp, you can now enforce your critical security controls — like single sign-on (SSO), MFA, device posture, and variable session lengths — to any private application. This allows you to extend Zero Trust security to services like SSH, RDP, internal databases, and other non-HTTPS applications.

   ![Example private application on non-443 port](https://developers.cloudflare.com/_astro/internal_private_app_any_port.DNXnEy0u_1ijFvb.webp)

   For example, you can now create a self-hosted application in Access for `ssh.testapp.local` running on port `22`. You can then build a policy that only allows engineers in your organization to connect after they pass an SSO/MFA check and are using a corporate device.

   This feature is generally available across all plans.

Oct 28, 2025

1. ### [Reranking and API-based system prompt configuration in AI Search](https://developers.cloudflare.com/changelog/2025-10-27-ai-search-reranking-system-prompt/)

   [AI Search](https://developers.cloudflare.com/ai-search/)

   [AI Search](https://developers.cloudflare.com/ai-search/) now supports reranking for improved retrieval quality and allows you to set the system prompt directly in your API requests.

   #### Rerank for more relevant results

   You can now enable [reranking](https://developers.cloudflare.com/ai-search/configuration/reranking/) to reorder retrieved documents based on their semantic relevance to the user’s query. Reranking helps improve accuracy, especially for large or noisy datasets where vector similarity alone may not produce the optimal ordering.

   You can enable and configure reranking in the dashboard or directly in your API requests:

   ```javascript
   const answer = await env.AI.autorag("my-autorag").aiSearch({
     query: "How do I train a llama to deliver coffee?",
     model: "@cf/meta/llama-3.3-70b-instruct-fp8-fast",
     reranking: {
       enabled: true,
       model: "@cf/baai/bge-reranker-base"
     }
   });
   ```

   #### Set system prompts in API

   Previously, [system prompts](https://developers.cloudflare.com/ai-search/configuration/system-prompt/) could only be configured in the dashboard. You can now define them directly in your API requests, giving you per-query control over behavior. For example:

   ```javascript
   // Dynamically set query and system prompt in AI Search
   async function getAnswer(query, tone) {
     const systemPrompt = `You are a ${tone} assistant.`;


     const response = await env.AI.autorag("my-autorag").aiSearch({
       query: query,
       system_prompt: systemPrompt
     });


     return response;
   }


   // Example usage
   const query = "What is Cloudflare?";
   const tone = "friendly";


   const answer = await getAnswer(query, tone);
   console.log(answer);
   ```

   Learn more about [Reranking](https://developers.cloudflare.com/ai-search/configuration/reranking/) and [System Prompt](https://developers.cloudflare.com/ai-search/configuration/system-prompt/) in AI Search.

Oct 28, 2025

1. ### [CASB introduces new granular roles](https://developers.cloudflare.com/changelog/2025-10-28-casb-roles/)

   [CASB](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)

   Cloudflare CASB (Cloud Access Security Broker) now supports two new granular roles to provide more precise access control for your security teams:

   * **Cloudflare CASB Read:** Provides read-only access to view CASB findings and dashboards. This role is ideal for security analysts, compliance auditors, or team members who need visibility without modification rights.
   * **Cloudflare CASB:** Provides full administrative access to configure and manage all aspects of the CASB product.

   These new roles help you better enforce the principle of least privilege. You can now grant specific members access to CASB security findings without assigning them broader permissions, such as the **Super Administrator** or **Administrator** roles.

   To enable [Data Loss Prevention (DLP)](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/), scans in CASB, account members will need the **Cloudflare Zero Trust** role.

   You can find these new roles when inviting members or creating API tokens in the Cloudflare dashboard under **Manage Account** > **Members**.

   To learn more about managing roles and permissions, refer to the [Manage account members and roles documentation](https://developers.cloudflare.com/fundamentals/manage-members/roles/).

Oct 28, 2025

1. ### [New Application Categories added for HTTP Traffic Management](https://developers.cloudflare.com/changelog/gateway-application-categories-added/)

   [Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

   To give you precision and flexibility while creating policies to block unwanted traffic, we are introducing new, more granular application categories in the Gateway product.

   We have added the following categories to provide more precise organization and allow for finer-grained policy creation, designed around how users interact with different types of applications:

   * Business
   * Education
   * Entertainment & Events
   * Food & Drink
   * Health & Fitness
   * Lifestyle
   * Navigation
   * Photography & Graphic Design
   * Travel

   The new categories are live now, but we are providing a transition period for existing applications to be fully remapped to these new categories.

   The full remapping will be completed by January 30, 2026.

   We encourage you to use this time to:

   * Review the new category structure.
   * Identify and adjust any existing HTTP policies that reference older categories to ensure a smooth transition.

   For more information on creating HTTP policies, refer to [Applications and app types](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/).

Oct 27, 2025

1. ### [Azure Sentinel Connector](https://developers.cloudflare.com/changelog/2025-10-27-sentinel-connector/)

   [Logs](https://developers.cloudflare.com/logs/)

   Logpush now supports integration with [Microsoft Sentinel](https://www.microsoft.com/en-us/security/business/siem-and-xdr/microsoft-sentinel).The new Azure Sentinel Connector built on Microsoft’s Codeless Connector Framework (CCF), is now avaialble. This solution replaces the previous Azure Functions-based connector, offering significant improvements in security, data control, and ease of use for customers. Logpush customers can send logs to Azure Blob Storage and configure this new Sentinel Connector to ingest those logs directly into Microsoft Sentinel.

   This upgrade significantly streamlines log ingestion, improves security, and provides greater control:

   * Simplified Implementation: Easier for engineering teams to set up and maintain.
   * Cost Control: New support for Data Collection Rules (DCRs) allows you to filter and transform logs at ingestion time, offering potential cost savings.
   * Enhanced Security: CCF provides a higher level of security compared to the older Azure Functions connector.
   * ata Lake Integration: Includes native integration with Data Lake.

   Find the new solution [here](https://marketplace.microsoft.com/en-us/product/azure-application/cloudflare.azure-sentinel-solution-cloudflare-ccf?tab=Overview) and refer to the [Cloudflare's developer documention](https://developers.cloudflare.com/analytics/analytics-integrations/sentinel/#supported-logs:~:text=WorkBook%20fields,-Analytic%20rules)for more information on the connector, including setup steps, supported logs and Microsfot's resources.

Oct 27, 2025

1. ### [TLD Insights in Cloudflare Radar](https://developers.cloudflare.com/changelog/2025-10-27-radar-tld-insights/)

   [Radar](https://developers.cloudflare.com/radar/)

   [**Radar**](https://developers.cloudflare.com/radar/) now introduces Top-Level Domain (TLD) insights, providing visibility into popularity based on the DNS magnitude metric, detailed TLD information including its type, manager, DNSSEC support, RDAP support, and WHOIS data, and trends such as DNS query volume and geographic distribution observed by the [1.1.1.1](https://developers.cloudflare.com/1.1.1.1/) DNS resolver.

   The following dimensions were added to the Radar DNS API, specifically, to the [`/dns/summary/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/dns/methods/summary_v2/) and [`/dns/timeseries_groups/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/dns/methods/timeseries_groups_v2/) endpoints:

   * `tld`: Top-level domain extracted from DNS queries; can also be used as a filter.
   * `tld_dns_magnitude`: Top-level domain ranking by [DNS magnitude](https://developers.cloudflare.com/radar/glossary#dns-magnitude).

   And the following endpoints were added:

   * [`/tlds`](https://developers.cloudflare.com/api/resources/radar/subresources/tlds/methods/list/) - Lists all TLDs.
   * [`/tlds/{tld}`](https://developers.cloudflare.com/api/resources/radar/subresources/tlds/methods/get/) - Retrieves information about a specific TLD.

   ![Screenshot of the TLD ranking by DNS magnitude](https://developers.cloudflare.com/_astro/tld-ranking-by-dns-magnitude.DbmrooPK_1qJ1Wh.webp)

   Learn more about the new Radar DNS insights in our [blog post](https://blog.cloudflare.com/introducing-tld-insights-on-cloudflare-radar/), and check out the [new Radar page](https://radar.cloudflare.com/tlds).

Oct 27, 2025

1. ### [Cloudforce One RFI tokens are now visible in the dashboard](https://developers.cloudflare.com/changelog/2025-10-27-rfi-tokens-in-dash/)

   [Security Center](https://developers.cloudflare.com/security-center/)

   The Requests for Information (RFI) dashboard now shows users the number of tokens used by each submitted RFI to better understand usage of tokens and how they relate to each request submitted.

   ![Cloudforce One RFI tokens](https://developers.cloudflare.com/_astro/2025-10-24RFITokens.DPm1e8uC_Z13Mwb9.webp)

   What’s new:

   * Users can now see the number of tokens used for a submitted request for information.
   * Users can see the remaining tokens allocated to their account for the quarter.
   * Users can only select the Routine priority for the `Strategic Threat Research` request type.

   Cloudforce One subscribers can try it now in [Application Security > Threat Intelligence > Requests for Information](https://dash.cloudflare.com/?to=/:account/security-center/threat-intelligence/requests).

Oct 24, 2025

1. ### [Automatic resource provisioning for KV, R2, and D1](https://developers.cloudflare.com/changelog/2025-10-24-automatic-resource-provisioning/)

   [Workers](https://developers.cloudflare.com/workers/)

   Previously, if you wanted to develop or deploy a worker with attached resources, you'd have to first manually create the desired resources. Now, if your Wrangler configuration file includes a KV namespace, D1 database, or R2 bucket that does not yet exist on your account, you can develop locally and deploy your application seamlessly, without having to run additional commands.

   Automatic provisioning is launching as an open beta, and we'd love to hear your feedback to help us make improvements! It currently works for KV, R2, and D1 bindings. You can disable the feature using the `--no-x-provision` flag.

   To use this feature, update to wrangler\@4.45.0 and add bindings to your config file *without* resource IDs e.g.:

   ```jsonc
   {
     "kv_namespaces": [{ "binding": "MY_KV" }],
     "d1_databases": [{ "binding": "MY_DB" }],
     "r2_buckets": [{ "binding": "MY_R2" }],
   }
   ```

   `wrangler dev` will then automatically create these resources for you locally, and on your next run of `wrangler deploy`, Wrangler will call the Cloudflare API to create the requested resources and link them to your Worker.

   Though resource IDs will be automatically written back to your Wrangler config file after resource creation, resources will stay linked across future deploys even without adding the resource IDs to the config file. This is especially useful for shared templates, which now no longer need to include account-specific resource IDs when adding a binding.

Oct 24, 2025

1. ### [Build TanStack Start apps with the Cloudflare Vite plugin](https://developers.cloudflare.com/changelog/2025-10-24-tanstack-start/)

   [Workers](https://developers.cloudflare.com/workers/)

   The [Cloudflare Vite plugin](https://developers.cloudflare.com/workers/vite-plugin/) now supports [TanStack Start](https://tanstack.com/start/) apps. Get started with new or existing projects.

   #### New projects

   Create a new TanStack Start project that uses the Cloudflare Vite plugin via the `create-cloudflare` CLI:

   * npm

     ```sh
     npm create cloudflare@latest -- my-tanstack-start-app --framework=tanstack-start
     ```

   * yarn

     ```sh
     yarn create cloudflare my-tanstack-start-app --framework=tanstack-start
     ```

   * pnpm

     ```sh
     pnpm create cloudflare@latest my-tanstack-start-app --framework=tanstack-start
     ```

   #### Existing projects

   Migrate an existing TanStack Start project to use the Cloudflare Vite plugin:

   1. Install `@cloudflare/vite-plugin` and `wrangler`

   * npm

     ```sh
     npm i -D @cloudflare/vite-plugin wrangler
     ```

   * yarn

     ```sh
     yarn add -D @cloudflare/vite-plugin wrangler
     ```

   * pnpm

     ```sh
     pnpm add -D @cloudflare/vite-plugin wrangler
     ```

   1. Add the Cloudflare plugin to your Vite config

   ```ts
   import { defineConfig } from "vite";
   import { tanstackStart } from "@tanstack/react-start/plugin/vite";
   import viteReact from "@vitejs/plugin-react";
   import { cloudflare } from "@cloudflare/vite-plugin";


   export default defineConfig({
     plugins: [
       cloudflare({ viteEnvironment: { name: "ssr" } }),
       tanstackStart(),
       viteReact(),
     ],
   });
   ```

   1. Add your Worker config file

   * wrangler.jsonc

     ```jsonc
     {
       "$schema": "./node_modules/wrangler/config-schema.json",
       "name": "my-tanstack-start-app",
       "compatibility_date": "2025-10-11",
       "compatibility_flags": [
         "nodejs_compat"
       ],
       "main": "@tanstack/react-start/server-entry"
     }
     ```

   * wrangler.toml

     ```toml
     name = "my-tanstack-start-app"
     compatibility_date = "2025-10-11"
     compatibility_flags = ["nodejs_compat"]
     main = "@tanstack/react-start/server-entry"
     ```

   1. Modify the scripts in your `package.json`

   ```json
   {
     "scripts": {
       "dev": "vite dev",
       "build": "vite build && tsc --noEmit",
       "start": "node .output/server/index.mjs",
       "preview": "vite preview",
       "deploy": "npm run build && wrangler deploy",
       "cf-typegen": "wrangler types"
     }
   }
   ```

   See the [TanStack Start framework guide](https://developers.cloudflare.com/workers/framework-guides/web-apps/tanstack-start/) for more info.

Oct 23, 2025

1. ### [Workers AI Markdown Conversion: New endpoint to list supported formats](https://developers.cloudflare.com/changelog/2025-10-23-new-markdown-conversion-endpoint/)

   [Workers AI](https://developers.cloudflare.com/workers-ai/)

   Developers can now programmatically retrieve a list of all file formats supported by the [Markdown Conversion utility](https://developers.cloudflare.com/workers-ai/features/markdown-conversion/) in Workers AI.

   You can use the [`env.AI`](https://developers.cloudflare.com/workers-ai/configuration/bindings/) binding:

   ```typescript
   await env.AI.toMarkdown().supported()
   ```

   Or call the REST API:

   ```bash
   curl https://api.cloudflare.com/client/v4/accounts/{ACCOUNT_ID}/ai/tomarkdown/supported \
     -H 'Authorization: Bearer {API_TOKEN}'
   ```

   Both return a list of file formats that users can convert into Markdown:

   ```json
   [
     {
       "extension": ".pdf",
       "mimeType": "application/pdf",
     },
     {
       "extension": ".jpeg",
       "mimeType": "image/jpeg",
     },
     ...
   ]
   ```

   Learn more about our [Markdown Conversion utility](https://developers.cloudflare.com/workers-ai/features/markdown-conversion/).

Oct 23, 2025

1. ### [Workers Preview URL default behavior now matches your workers.dev setting](https://developers.cloudflare.com/changelog/2025-10-23-preview-url-default-behavior/)

   [Workers](https://developers.cloudflare.com/workers/)

   We have updated the default behavior for Cloudflare Workers [Preview URLs](https://developers.cloudflare.com/workers/configuration/previews/). **Going forward, if a preview URL setting is not [explicitly configured](https://developers.cloudflare.com/workers/configuration/previews/#toggle-preview-urls-enable-or-disable) during deployment, its default behavior will automatically match the setting of your [`workers.dev` subdomain](https://developers.cloudflare.com/workers/configuration/routing/workers-dev/).**

   This change is intended to provide a more intuitive and secure experience by aligning your preview URL's default state with your `workers.dev` configuration to prevent cases where a preview URL might remain public even after you disabled your `workers.dev` route.

   **What this means for you:**

   * **If neither setting is configured:** both the workers.dev route and the preview URL will default to enabled
   * **If your workers.dev route is enabled and you do not explicitly set Preview URLs to enabled or disabled:** Preview URLs will default to enabled
   * **If your workers.dev route is disabled and you do not explicitly set Preview URLs to enabled or disabled:** Preview URLs will default to disabled

   You can override the default setting by explicitly enabling or disabling the preview URL in your Worker's configuration through the [API](https://developers.cloudflare.com/api/resources/workers/subresources/scripts/subresources/subdomain/), [Dashboard](https://developers.cloudflare.com/workers/configuration/previews/#from-the-dashboard), or [Wrangler](https://developers.cloudflare.com/workers/configuration/previews/#from-the-wrangler-configuration-file).

   **Wrangler Version Behavior**

   The default behavior depends on the version of Wrangler you are using. This new logic applies to the latest version. Here is a summary of the behavior across different versions:

   * **Before v4.34.0:** Preview URLs defaulted to enabled, regardless of the workers.dev setting.
   * **v4.34.0 up to (but not including) v4.44.0:** Preview URLs defaulted to disabled, regardless of the workers.dev setting.
   * **v4.44.0 or later:** Preview URLs now default to matching your workers.dev setting.

   **Why we’re making this change**

   In July, [we introduced preview URLs to Workers](https://developers.cloudflare.com/changelog/2025-07-23-workers-preview-urls/), which let you preview code changes before deploying to production. This made disabling your Worker’s workers.dev URL an ambiguous action — the preview URL, served as a subdomain of `workers.dev` (ex: `preview-id-worker-name.account-name.workers.dev`) would still be live even if you had disabled your Worker’s `workers.dev` route. If you misinterpreted what it meant to disable your `workers.dev` route, you might unintentionally leave preview URLs enabled when you didn’t mean to, and expose them to the public Internet.

   To address this, we made a [one-time update](https://developers.cloudflare.com/changelog/2025-09-17-update-preview-url-setting/) to disable preview URLs on existing Workers that had their workers.dev route disabled and changed the default behavior to be disabled for all new deployments where a preview URL setting was not explicitly configured.

   While this change helped secure many customers, it was disruptive for customers who keep their `workers.dev` route enabled and actively use the preview functionality, as it now required them to explicitly enable preview URLs on every redeployment.This new, more intuitive behavior ensures that your preview URL settings align with your `workers.dev` configuration by default, providing a more secure and predictable experience.

   **Securing access to `workers.dev` and preview URL endpoints**

   To further secure your `workers.dev` subdomain and preview URL, you can [enable Cloudflare Access with a single click](https://developers.cloudflare.com/changelog/2025-10-03-one-click-access-for-workers/) in your Worker's settings to limit access to specific users or groups.

Oct 21, 2025

1. ### [New Robots.txt tab for tracking crawler compliance](https://developers.cloudflare.com/changelog/2025-10-21-track-robots-txt/)

   [AI Crawl Control](https://developers.cloudflare.com/ai-crawl-control/)

   AI Crawl Control now includes a **Robots.txt** tab that provides insights into how AI crawlers interact with your `robots.txt` files.

   #### What's new

   The Robots.txt tab allows you to:

   * Monitor the health status of `robots.txt` files across all your hostnames, including HTTP status codes, and identify hostnames that need a `robots.txt` file.
   * Track the total number of requests to each `robots.txt` file, with breakdowns of successful versus unsuccessful requests.
   * Check whether your `robots.txt` files contain [Content Signals](https://contentsignals.org/) directives for AI training, search, and AI input.
   * Identify crawlers that request paths explicitly disallowed by your `robots.txt` directives, including the crawler name, operator, violated path, specific directive, and violation count.
   * Filter `robots.txt` request data by crawler, operator, category, and custom time ranges.

   #### Take action

   When you identify non-compliant crawlers, you can:

   * Block the crawler in the [Crawlers tab](https://developers.cloudflare.com/ai-crawl-control/features/manage-ai-crawlers/)
   * Create custom [WAF rules](https://developers.cloudflare.com/waf/) for path-specific security
   * Use [Redirect Rules](https://developers.cloudflare.com/rules/url-forwarding/) to guide crawlers to appropriate areas of your site

   To get started, go to **AI Crawl Control** > **Robots.txt** in the Cloudflare dashboard. Learn more in the [Track robots.txt documentation](https://developers.cloudflare.com/ai-crawl-control/features/track-robots-txt/).

Oct 20, 2025

1. ### [Schedule DNS policies from the UI](https://developers.cloudflare.com/changelog/2025-10-20-schedule-dns-policies-from-the-ui/)

   [Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

   Admins can now create [scheduled DNS policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/timed-policies/) directly from the Zero Trust dashboard, without using the API. You can configure policies to be active during specific, recurring times, such as blocking social media during business hours or gaming sites on school nights.

   * **Preset Schedules**: Use built-in templates for common scenarios like Business Hours, School Days, Weekends, and more.
   * **Custom Schedules**: Define your own schedule with specific days and up to three non-overlapping time ranges per day.
   * **Timezone Control**: Choose to enforce a schedule in a specific timezone (for example, US Eastern) or based on the local time of each user.
   * **Combined with Duration**: Policies can have both a schedule and a duration. If both are set, the duration's expiration takes precedence.

   You can see the flow in the demo GIF:

   ![Schedule DNS policies demo](https://developers.cloudflare.com/_astro/gateway-dns-scheduled-policies-ui.Cf4l1OTE_29xeRx.webp)

   This update makes time-based DNS policies accessible to all Gateway customers, removing the technical barrier of the API.

Oct 17, 2025

1. ### [On-Demand Security Report](https://developers.cloudflare.com/changelog/2025-10-16-on-demand-security-report/)

   [Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

   You can now generate on-demand security reports directly from the Cloudflare dashboard. This new feature provides a comprehensive overview of your email security posture, making it easier than ever to demonstrate the value of Cloudflare’s Email security to executives and other decision makers.

   These reports offer several key benefits:

   * **Executive Summary:** Quickly view the performance of Email security with a high-level executive summary.
   * **Actionable Insights:** Dive deep into trend data, breakdowns of threat types, and analysis of top targets to identify and address vulnerabilities.
   * **Configuration Transparency:** Gain a clear view of your policy, submission, and domain configurations to ensure optimal setup.

   ![Report](https://developers.cloudflare.com/_astro/report.CbkPa8Jt_BRc7y.webp)

   This feature is available across the following Email security packages:

   * **Advantage**
   * **Enterprise**
   * **Enterprise + PhishGuard**

Oct 17, 2025

1. ### [New Application Security reports (Closed Beta)](https://developers.cloudflare.com/changelog/2025-10-17-app-sec-reports/)

   [Security Center](https://developers.cloudflare.com/security-center/)

   Cloudflare's new **Application Security report**, currently in Closed Beta, is now available in the dashboard.

   [Go to **Security reports**](https://dash.cloudflare.com/?to=/:account/security-center/reports)

   The reports are generated monthly and provide cyber security insights trends for all of the Enterprise zones in your Cloudflare account.

   The reports also include an industry benchmark, comparing your cyber security landscape to peers in your industry.

   ![Application Security report mock data](https://developers.cloudflare.com/_astro/2025-10-17-application-security-report-mock-data.Cz0-WuoX_Z26AdSN.webp)

   Learn more about the reports by referring to the [Security Reports documentation](https://developers.cloudflare.com/security-center/app-security-reports/).

   Use the feedback survey link at the top of the page to help us improve the reports.

   ![Application Security report survey](https://developers.cloudflare.com/_astro/2025-10-17-report-feedback-survey.DPmUlWh2_U1d1e.webp)

Oct 16, 2025

1. ### [WARP client for Windows (version 2025.9.173.1)](https://developers.cloudflare.com/changelog/2025-10-16-warp-windows-beta/)

   [Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

   A new Beta release for the Windows WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

   This release contains minor fixes, improvements, and new features including Path Maximum Transmission Unit Discovery (PMTUD). With PMTUD enabled, the client will dynamically adjust packet sizing to optimize connection performance. There is also a new connection status message in the GUI to inform users that the local network connection may be unstable. This will make it easier to debug connectivity issues.

   **Changes and improvements**

   * Improvements for [Windows multi-user](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/windows-multiuser/) to maintain the [global WARP override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#global-warp-override) state when switching between users.
   * The GUI now displays the health of the tunnel and DNS connections by showing a connection status message when the network may be unstable. This will make it easier to debug connectivity issues.
   * Deleting registrations no longer returns an error when succeeding.
   * Path Maximum Transmission Unit Discovery (PMTUD) is now used to discover the effective MTU of the connection. This allows the client to improve connection performance optimized for the current network.

   **Known issues**

   * For Windows 11 24H2 users, Microsoft has confirmed a regression that may lead to performance issues like mouse lag, audio cracking, or other slowdowns. Cloudflare recommends users experiencing these issues upgrade to a minimum [Windows 11 24H2 KB5062553](https://support.microsoft.com/en-us/topic/july-8-2025-kb5062553-os-build-26100-4652-523e69cb-051b-43c6-8376-6a76d6caeefd) or higher for resolution.

   * Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

   * Devices with KB5055523 installed may receive a warning about `Win32/ClickFix.ABA` being present in the installer. To resolve this false positive, update Microsoft Security Intelligence to [version 1.429.19.0](https://www.microsoft.com/en-us/wdsi/definitions/antimalware-definition-release-notes?requestVersion=1.429.19.0) or later.

   * DNS resolution may be broken when the following conditions are all true:

     * WARP is in Secure Web Gateway without DNS filtering (tunnel-only) mode.
     * A custom DNS server address is configured on the primary network adapter.
     * The custom DNS server address on the primary network adapter is changed while WARP is connected.

     To work around this issue, reconnect the WARP client by toggling off and back on.

Oct 16, 2025

1. ### [WARP client for macOS (version 2025.9.173.1)](https://developers.cloudflare.com/changelog/2025-10-16-warp-macos-beta/)

   [Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

   A new Beta release for the macOS WARP client is now available on the [beta releases downloads page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/beta-releases/).

   This release contains minor fixes, improvements, and new features including Path Maximum Transmission Unit Discovery (PMTUD). With PMTUD enabled, the client will dynamically adjust packet sizing to optimize connection performance. There is also a new connection status message in the GUI to inform users that the local network connection may be unstable. This will make it easier to debug connectivity issues.

   **Changes and improvements**

   * The GUI now displays the health of the tunnel and DNS connections by showing a connection status message when the network may be unstable. This will make it easier to debug connectivity issues.
   * Deleting registrations no longer returns an error when succeeding.
   * Path Maximum Transmission Unit Discovery (PMTUD) is now used to discover the effective MTU of the connection. This allows the client to improve connection performance optimized for the current network.

   **Known issues**

   * macOS Sequoia: Due to changes Apple introduced in macOS 15.0.x, the WARP client may not behave as expected. Cloudflare recommends the use of macOS 15.4 or later.
   * Devices using WARP client 2025.4.929.0 and up may experience Local Domain Fallback failures if a fallback server has not been configured. To configure a fallback server, refer to [Route traffic to fallback server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#route-traffic-to-fallback-server).

Oct 16, 2025

1. ### [View and edit Durable Object data in UI with Data Studio (Beta)](https://developers.cloudflare.com/changelog/2025-10-16-durable-objects-data-studio/)

   [Durable Objects ](https://developers.cloudflare.com/durable-objects/)[Workers](https://developers.cloudflare.com/workers/)

   ![Screenshot of Durable Objects Data Studio](https://developers.cloudflare.com/_astro/do-data-studio.BfCcgtkq_1hF57J.webp)

   You can now view and write to each Durable Object's storage using a UI editor on the Cloudflare dashboard. Only Durable Objects using [SQLite storage](https://developers.cloudflare.com/durable-objects/best-practices/access-durable-objects-storage/#create-sqlite-backed-durable-object-class) can use Data Studio.

   [Go to **Durable Objects**](https://dash.cloudflare.com/?to=/:account/workers/durable-objects)

   Data Studio unlocks easier data access with Durable Objects for prototyping application data models to debugging production storage usage. Before, querying your Durable Objects data required deploying a Worker.

   To access a Durable Object, you can provide an object's unique name or ID generated by Cloudflare. Data Studio requires you to have at least the `Workers Platform Admin` role, and all queries are captured with audit logging for your security and compliance needs. Queries executed by Data Studio send requests to your remote, deployed objects and incur normal usage billing.

   To learn more, visit the Data Studio [documentation](https://developers.cloudflare.com/durable-objects/observability/data-studio/). If you have feedback or suggestions for the new Data Studio, please share your experience on [Discord](https://discord.com/channels/595317990191398933/773219443911819284)

Oct 16, 2025

1. ### [Increased HTTP header size limit to 128 KB](https://developers.cloudflare.com/changelog/2025-10-16-header-limit-increase/)

   [Cloudflare Fundamentals](https://developers.cloudflare.com/fundamentals/)

   #### CDN now supports 128 KB request and response headers 🚀

   We're excited to announce a significant increase in the maximum header size supported by Cloudflare's Content Delivery Network (CDN). Cloudflare now supports up to **128 KB** for both **request and response headers**.

   Previously, customers were limited to a total of 32 KB for request or response headers, with a maximum of 16 KB per individual header. Larger headers could cause requests to fail with `HTTP 413` (Request Header Fields Too Large) errors.

   ***

   #### What's new?

   * **Support for large headers:** You can now utilize much larger headers, whether as a single large header up to 128 KB or split over multiple headers.

   * **Reduces `413` and `520` HTTP errors:** This change drastically reduces the likelihood of customers encountering `HTTP 413` errors from large request headers or `HTTP 520` errors caused by oversized response headers, improving the overall reliability of your web applications.

   * **Enhanced functionality:** This is especially beneficial for applications that rely on:

     * A large number of cookies.
     * Large Content-Security-Policy (CSP) response headers.
     * Advanced use cases with Cloudflare Workers that generate large response headers.

   This enhancement improves compatibility with Cloudflare's CDN, enabling more use cases that previously failed due to header size limits.

   ***

   To learn more and get started, refer to the [Cloudflare Fundamentals documentation](https://developers.cloudflare.com/fundamentals/reference/connection-limits/#request-limits).

Oct 16, 2025

1. ### [Monitor Groups for Advanced Health Checking With Load Balancing](https://developers.cloudflare.com/changelog/2025-08-15-monitor-groups-for-load-balancing/)

   [Load Balancing](https://developers.cloudflare.com/load-balancing/)

   Cloudflare Load Balancing now supports Monitor Groups, a powerful new way to combine multiple health monitors into a single, logical group. This allows you to create sophisticated health checks that more accurately reflect the true availability of your applications by assessing multiple services at once.

   With Monitor Groups, you can ensure that all critical components of an application are healthy before sending traffic to an origin pool, enabling smarter failover decisions and greater resilience. This feature is now available via the API for customers with an Enterprise Load Balancing subscription.

   #### What you can do:

   * **Combine Multiple Monitors**: Group different health monitors (for example, HTTP, TCP) that check various application components, like a primary API gateway and a specific `/login` service.
   * **Isolate Monitors for Observation**: Mark a monitor as "monitoring only" to receive alerts and data without it affecting a pool's health status or traffic steering. This is perfect for testing new checks or observing non-critical dependencies.
   * **Improve Steering Intelligence**: Latency for Dynamic Steering is automatically averaged across all active monitors in a group, providing a more holistic view of an origin's performance.

   This enhancement is ideal for complex, multi-service applications where the health of one component depends on another. By aggregating health signals, Monitor Groups provide a more accurate and comprehensive assessment of your application's true status.

   For detailed information and API configuration guides, please visit our [developer documentation](https://developers.cloudflare.com/load-balancing/monitors/monitor-groups) for Monitor Groups.

Oct 14, 2025

1. ### [Enhanced AI Crawl Control metrics with new drilldowns and filters](https://developers.cloudflare.com/changelog/2025-10-14-enhanced-metrics-drilldowns/)

   [AI Crawl Control](https://developers.cloudflare.com/ai-crawl-control/)

   AI Crawl Control now provides enhanced metrics and CSV data exports to help you better understand AI crawler activity across your sites.

   #### What's new

   #### Track crawler requests over time

   Visualize crawler activity patterns over time, and group data by different dimensions:

   * **By Crawler** — Track activity from individual AI crawlers (GPTBot, ClaudeBot, Bytespider)
   * **By Category** — Analyze crawler purpose or type
   * **By Operator** — Discover which companies (OpenAI, Anthropic, ByteDance) are crawling your site
   * **By Host** — Break down activity across multiple subdomains
   * **By Status Code** — Monitor HTTP response codes to crawlers (200s, 300s, 400s, 500s)

   ![AI Crawl Control requests over time chart with grouping tabs](https://developers.cloudflare.com/_astro/ai-crawl-control-requests-over-time.BtRyz0OT_Z17gWIC.webp)

   #### Analyze referrer data (Paid plans)

   Identify traffic sources with referrer analytics:

   * View top referrers driving traffic to your site
   * Understand discovery patterns and content popularity from AI operators

   ![AI Crawl Control top referrers breakdown](https://developers.cloudflare.com/_astro/ai-crawl-control-top-referrers.CEUAwpd8_Ssmak.webp)

   #### Export data

   Download your filtered view as a CSV:

   * Includes all applied filters and groupings
   * Useful for custom reporting and deeper analysis

   #### Get started

   1. Log in to the Cloudflare dashboard, and select your account and domain.
   2. Go to **AI Crawl Control** > **Metrics**.
   3. Use the grouping tabs to explore different views of your data.
   4. Apply filters to focus on specific crawlers, time ranges, or response codes.
   5. Select **Download CSV** to export your filtered data for further analysis.

   Learn more about [AI Crawl Control](https://developers.cloudflare.com/ai-crawl-control).

Oct 14, 2025

1. ### [Single sign-on now manageable in the user experience](https://developers.cloudflare.com/changelog/2025-10-14-sso-self-service-ux/)

   [Cloudflare Fundamentals](https://developers.cloudflare.com/fundamentals/)

   ![Screenshot of new user experience for managing SSO](https://developers.cloudflare.com/_astro/2025-10-14-sso-configuration-ux.DLkIKSax_1Yk7hq.webp)

   During Birthday Week, we announced that [single sign-on (SSO) is available for free](https://blog.cloudflare.com/enterprise-grade-features-for-all/) to everyone who signs in with a custom email domain and maintains a compatible [identity provider](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/). SSO minimizes user friction around login and provides the strongest security posture available. At the time, this could only be configured using the API.

   Today, we are launching a new user experience which allows users to manage their SSO configuration from within the Cloudflare dashboard. You can access this by going to **Manage account** > **Members** > **Settings**.

   #### For more information

   * [Cloudflare dashboard SSO](https://developers.cloudflare.com/fundamentals/manage-members/dashboard-sso/)

Oct 10, 2025

1. ### [New domain categories added](https://developers.cloudflare.com/changelog/2025-10-10-new-domain-categories/)

   [Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

   We have added three new domain categories under the Technology parent category, to better reflect online content and improve DNS filtering.

   **New categories added**

   | Parent ID | Parent Name | Category ID | Category Name |
   | - | - | - | - |
   | 26 | Technology | 194 | Keep Awake Software |
   | 26 | Technology | 192 | Remote Access |
   | 26 | Technology | 193 | Shareware/Freeware |

   Refer to [Gateway domain categories](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/) to learn more.

Oct 09, 2025

1. ### [Expanded CT log activity insights on Cloudflare Radar](https://developers.cloudflare.com/changelog/2025-10-09-radar-ct-log-activity-insights/)

   [Radar](https://developers.cloudflare.com/radar/)

   [**Radar**](https://developers.cloudflare.com/radar/) has expanded its Certificate Transparency (CT) log insights with new stats that provide greater visibility into log activity:

   * **Log growth rate**: The average throughput of the CT log over the past 7 days, measured in certificates per hour.
   * **Included certificate count**: The total number of certificates already included in this CT log.
   * **Eligible-for-inclusion certificate count**: The number of certificates eligible for inclusion in this log but not yet included. This metric is based on certificates signed by trusted root CAs within the log’s accepted date range.
   * **Last update**: The timestamp of the most recent update to the CT log.

   These new statistics have been added to the response of the [Get Certificate Log Details](https://developers.cloudflare.com/api/resources/radar/subresources/ct/subresources/logs/methods/get/) API endpoint, and are displayed on the [CT log information page](https://radar.cloudflare.com/certificate-transparency/log/nimbus2025#log-activity).

   ![Screenshot of the CT log activity card on the CT log information page](https://developers.cloudflare.com/_astro/ct-log-activity.GHD-K7Mk_tJMmO.webp)

Oct 07, 2025

1. ### [Automated reminders for backup codes](https://developers.cloudflare.com/changelog/2025-10-07-recovery-codes/)

   [Cloudflare Fundamentals](https://developers.cloudflare.com/fundamentals/)

   The most common reason users contact Cloudflare support is lost two-factor authentication (2FA) credentials. Cloudflare supports both app-based and hardware keys for 2FA, but you could lose access to your account if you lose these. Over the past few weeks, we have been rolling out email and in-product reminders that remind you to also download backup codes (sometimes called recovery keys) that can get you back into your account in the event you lose your 2FA credentials. Download your backup codes now by logging into Cloudflare, then navigating to **Profile** > **Security & Authentication** > **Backup codes**.

   #### Sign-in security best practices

   Cloudflare is critical infrastructure, and you should protect it as such. Please review the following best practices and make sure you are doing your part to secure your account.

   * Use a unique password for every website, including Cloudflare, and store it in a password manager like 1Password or Keeper. These services are cross-platform and simplify the process of managing secure passwords.

   * Use 2FA to make it harder for an attacker to get into your account in the event your password is leaked

   * Store your backup codes securely. A password manager is the best place since it keeps the backup codes encrypted, but you can also print them and put them somewhere safe in your home.

   * If you use an app to manage your 2FA keys, enable cloud backup, so that you don't lose your keys in the event you lose your phone.

   * If you use a custom email domain to sign in, [configure SSO](https://developers.cloudflare.com/fundamentals/manage-members/dashboard-sso/).

   * If you use a public email domain like Gmail or Hotmail, you can also use social login with Apple, GitHub, or Google to sign in.

   * If you manage a Cloudflare account for work:

     * Have at least two administrators in case one of them unexpectedly leaves your company
     * Use SCIM to automate permissions management for members in your Cloudflare account

Oct 06, 2025

1. ### [R2 Data Catalog table-level compaction](https://developers.cloudflare.com/changelog/2025-10-06-data-catalog-table-compaction/)

   [R2](https://developers.cloudflare.com/r2/)

   You can now enable compaction for individual [Apache Iceberg](https://iceberg.apache.org/) tables in [R2 Data Catalog](https://developers.cloudflare.com/r2/data-catalog/), giving you fine-grained control over different workloads.

   ```bash
   # Enable compaction for a specific table (no token required)
   npx wrangler r2 bucket catalog compaction enable <BUCKET> <NAMESPACE> <TABLE> --target-size 256
   ```

   This allows you to:

   * Apply different target file sizes per table
   * Disable compaction for specific tables
   * Optimize based on table-specific access patterns

   Learn more at [Manage catalogs](https://developers.cloudflare.com/r2/data-catalog/manage-catalogs/).

Oct 06, 2025

1. ### [Browser Support Detection for PQ Encryption on Cloudflare Radar](https://developers.cloudflare.com/changelog/2025-10-06-radar-pq-encryption-test/)

   [Radar](https://developers.cloudflare.com/radar/)

   [**Radar**](https://developers.cloudflare.com/radar/) now includes browser detection for Post-quantum (PQ) encryption. The [Post-quantum encryption card](https://radar.cloudflare.com/adoption-and-usage#post-quantum-encryption) now checks whether a user’s browser supports post-quantum encryption. If support is detected, information about the key agreement in use is displayed.

   ![Screenshot of the PQ encryption browser support test on the Adoption & Usage page](https://developers.cloudflare.com/_astro/pq-encryption-test.gx_uoaMX_ZAaHap.webp)

Oct 02, 2025

1. ### [New Deepgram Flux model available on Workers AI](https://developers.cloudflare.com/changelog/2025-10-02-deepgram-flux/)

   [Workers AI](https://developers.cloudflare.com/workers-ai/)

   Deepgram's newest Flux model [`@cf/deepgram/flux`](https://developers.cloudflare.com/workers-ai/models/flux/) is now available on Workers AI, hosted directly on Cloudflare's infrastructure. We're excited to be a launch partner with Deepgram and offer their new Speech Recognition model built specifically for enabling voice agents. Check out [Deepgram's blog](https://deepgram.com/flux) for more details on the release.

   The Flux model can be used in conjunction with Deepgram's speech-to-text model [`@cf/deepgram/nova-3`](https://developers.cloudflare.com/workers-ai/models/nova-3/) and text-to-speech model [`@cf/deepgram/aura-1`](https://developers.cloudflare.com/workers-ai/models/aura-1/) to build end-to-end voice agents. Having Deepgram on Workers AI takes advantage of our edge GPU infrastructure, for ultra low latency voice AI applications.

   #### Promotional Pricing

   For the month of October 2025, Deepgram's Flux model will be free to use on Workers AI. Official pricing will be announced soon and charged after the promotional pricing period ends on October 31, 2025. Check out the [model page](https://developers.cloudflare.com/workers-ai/models/flux/) for pricing details in the future.

   #### Example Usage

   The new Flux model is WebSocket only as it requires live bi-directional streaming in order to recognize speech activity.

   1. Create a worker that establishes a websocket connection with `@cf/deepgram/flux`

   ```js
   export default {
     async fetch(request, env, ctx): Promise<Response> {
       const resp = await env.AI.run("@cf/deepgram/flux", {
         encoding: "linear16",
         sample_rate: "16000"
       }, {
         websocket: true
       });
       return resp;
     },
   } satisfies ExportedHandler<Env>;
   ```

   1. Deploy your worker

   ```bash
   npx wrangler deploy
   ```

   1. Write a client script to connect to your worker and start sending random audio bytes to it

   ```js
   const ws = new WebSocket('wss://<your-worker-url.com>');


   ws.onopen = () => {
     console.log('Connected to WebSocket');


     // Generate and send random audio bytes
     // You can replace this part with a function
     // that reads from your mic or other audio source
     const audioData = generateRandomAudio();
     ws.send(audioData);
     console.log('Audio data sent');
   };


   ws.onmessage = (event) => {
     // Transcription will be received here
     // Add your custom logic to parse the data
     console.log('Received:', event.data);
   };


   ws.onerror = (error) => {
     console.error('WebSocket error:', error);
   };


   ws.onclose = () => {
     console.log('WebSocket closed');
   };


   // Generate random audio data (1 second of noise at 44.1kHz, mono)
   function generateRandomAudio() {
     const sampleRate = 44100;
     const duration = 1;
     const numSamples = sampleRate * duration;
     const buffer = new ArrayBuffer(numSamples * 2);
     const view = new Int16Array(buffer);


     for (let i = 0; i < numSamples; i++) {
       view[i] = Math.floor(Math.random() * 65536 - 32768);
     }


     return buffer;
   }
   ```

Oct 02, 2025

1. ### [Workers Analytics Engine adds supports for new SQL functions](https://developers.cloudflare.com/changelog/2025-09-26-analytics-engine-sql-enhancements/)

   [Workers Analytics Engine ](https://developers.cloudflare.com/analytics/analytics-engine/)[Workers](https://developers.cloudflare.com/workers/)

   You can now perform more powerful queries directly in [Workers Analytics Engine](https://developers.cloudflare.com/analytics/analytics-engine/) with a major expansion of our SQL function library.

   Workers Analytics Engine allows you to ingest and store high-cardinality data at scale (such as custom analytics) and query your data through a simple SQL API.

   Today, we've expanded Workers Analytics Engine's SQL capabilities with several new functions:

   [**New aggregate functions:**](https://developers.cloudflare.com/analytics/analytics-engine/sql-reference/aggregate-functions/)

   * `argMin()` - Returns the value associated with the minimum in a group
   * `argMax()` - Returns the value associated with the maximum in a group
   * `topK()` - Returns an array of the most frequent values in a group
   * `topKWeighted()` - Returns an array of the most frequent values in a group using weights
   * `first_value()` - Returns the first value in an ordered set of values within a partition
   * `last_value()` - Returns the last value in an ordered set of values within a partition

   [**New bit functions:**](https://developers.cloudflare.com/analytics/analytics-engine/sql-reference/bit-functions/)

   * `bitAnd()` - Returns the bitwise AND of two expressions
   * `bitCount()` - Returns the number of bits set to one in the binary representation of a number
   * `bitHammingDistance()` - Returns the number of bits that differ between two numbers
   * `bitNot()` - Returns a number with all bits flipped
   * `bitOr()` - Returns the inclusive bitwise OR of two expressions
   * `bitRotateLeft()` - Rotates all bits in a number left by specified positions
   * `bitRotateRight()` - Rotates all bits in a number right by specified positions
   * `bitShiftLeft()` - Shifts all bits in a number left by specified positions
   * `bitShiftRight()` - Shifts all bits in a number right by specified positions
   * `bitTest()` - Returns the value of a specific bit in a number
   * `bitXor()` - Returns the bitwise exclusive-or of two expressions

   [**New mathematical functions:**](https://developers.cloudflare.com/analytics/analytics-engine/sql-reference/mathematical-functions/)

   * `abs()` - Returns the absolute value of a number
   * `log()` - Computes the natural logarithm of a number
   * `round()` - Rounds a number to a specified number of decimal places
   * `ceil()` - Rounds a number up to the nearest integer
   * `floor()` - Rounds a number down to the nearest integer
   * `pow()` - Returns a number raised to the power of another number

   [**New string functions:**](https://developers.cloudflare.com/analytics/analytics-engine/sql-reference/string-functions/)

   * `lowerUTF8()` - Converts a string to lowercase using UTF-8 encoding
   * `upperUTF8()` - Converts a string to uppercase using UTF-8 encoding

   [**New encoding functions:**](https://developers.cloudflare.com/analytics/analytics-engine/sql-reference/encoding-functions/)

   * `hex()` - Converts a number to its hexadecimal representation
   * `bin()` - Converts a string to its binary representation

   [**New type conversion functions:**](https://developers.cloudflare.com/analytics/analytics-engine/sql-reference/type-conversion-functions/)

   * `toUInt8()` - Converts any numeric expression, or expression resulting in a string representation of a decimal, into an unsigned 8 bit integer

   #### Ready to get started?

   Whether you're building usage-based billing systems, customer analytics dashboards, or other custom analytics, these functions let you get the most out of your data. [Get started ](https://developers.cloudflare.com/analytics/analytics-engine/get-started/)with Workers Analytics Engine and explore all available functions in our [SQL reference documentation](https://developers.cloudflare.com/analytics/analytics-engine/sql-reference/).

Oct 01, 2025

1. ### [New Confidence Intervals in GraphQL Analytics API](https://developers.cloudflare.com/changelog/2025-10-01-confidence-intervals/)

   [Analytics](https://developers.cloudflare.com/analytics/)

   The GraphQL Analytics API now supports confidence intervals for `sum` and `count` fields on adaptive (sampled) datasets. Confidence intervals provide a statistical range around sampled results, helping verify accuracy and quantify uncertainty.

   * **Supported datasets**: Adaptive (sampled) datasets only.
   * **Supported fields**: All `sum` and `count` fields.
   * **Usage**: The confidence `level` must be provided as a decimal between 0 and 1 (e.g. `0.90`, `0.95`, `0.99`).
   * **Default**: If no confidence level is specified, no intervals are returned.

   For examples and more details, see the [GraphQL Analytics API documentation](https://developers.cloudflare.com/analytics/graphql-api/features/confidence-intervals/).

Oct 01, 2025

1. ### [Larger Container instance types](https://developers.cloudflare.com/changelog/2025-10-01-new-container-instance-types/)

   [Containers](https://developers.cloudflare.com/containers/)

   New instance types provide up to 4 vCPU, 12 GiB of memory, and 20 GB of disk per container instance.

   | Instance Type | vCPU | Memory | Disk |
   | - | - | - | - |
   | lite | 1/16 | 256 MiB | 2 GB |
   | basic | 1/4 | 1 GiB | 4 GB |
   | standard-1 | 1/2 | 4 GiB | 8 GB |
   | standard-2 | 1 | 6 GiB | 12 GB |
   | standard-3 | 2 | 8 GiB | 16 GB |
   | standard-4 | 4 | 12 GiB | 20 GB |

   The `dev` and `standard` instance types are preserved for backward compatibility and are aliases for `lite` and `standard-1`, respectively. The `standard-1` instance type now provides up to 8 GB of disk instead of only 4 GB.

   See the [getting started guide](https://developers.cloudflare.com/containers/get-started/) to deploy your first Container, and the [limits documentation](https://developers.cloudflare.com/containers/platform-details/limits/) for more details on the available instance types and limits.

Oct 01, 2025

1. ### [Expanded File Type Controls for Executables and Disk Images](https://developers.cloudflare.com/changelog/2025-10-01-new-file-type-support/)

   [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

   You can now enhance your security posture by blocking additional application installer and disk image file types with Cloudflare Gateway. Preventing the download of unauthorized software packages is a critical step in securing endpoints from malware and unwanted applications.

   We have expanded Gateway's file type controls to include:

   * Apple Disk Image (dmg)
   * Microsoft Software Installer (msix, appx)
   * Apple Software Package (pkg)

   You can find these new options within the [*Upload File Types* and *Download File Types* selectors](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#download-and-upload-file-types) when creating or editing an HTTP policy. The file types are categorized as follows:

   * **System**: *Apple Disk Image (dmg)*
   * **Executable**: *Microsoft Software Installer (msix)*, *Microsoft Software Installer (appx)*, *Apple Software Package (pkg)*

   To ensure these file types are blocked effectively, please note the following behaviors:

   * DMG: Due to their file structure, DMG files are blocked at the very end of the transfer. A user's download may appear to progress but will fail at the last moment, preventing the browser from saving the file.
   * MSIX: To comprehensively block Microsoft Software Installers, you should also include the file type *Unscannable*. MSIX files larger than 100 MB are identified as Unscannable ZIP files during inspection.

   To get started, go to your HTTP policies in Zero Trust. For a full list of file types, refer to [supported file types](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#supported-file-types).

Sep 30, 2025

1. ### [Application granular controls for operations in SaaS applications](https://developers.cloudflare.com/changelog/2025-09-25-new-granular-controls-for-saas-applications/)

   [Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

   Gateway users can now apply granular controls to their file sharing and AI chat applications through [HTTP policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies).

   The new feature offers two methods of controlling SaaS applications:

   * **Application Controls** are curated groupings of Operations which provide an easy way for users to achieve a specific outcome. Application Controls may include *Upload*, *Download*, *Prompt*, *Voice*, and *Share* depending on the application.
   * **Operations** are controls aligned to the most granular action a user can take. This provides a fine-grained approach to enforcing policy and generally aligns to the SaaS providers API specifications in naming and function.

   Get started using [Application Granular Controls](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/granular-controls) and refer to the list of [supported applications](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/granular-controls/#compatible-applications).

Sep 29, 2025

1. ### [Regional Data in Cloudflare Radar](https://developers.cloudflare.com/changelog/2025-09-29-radar-regional-data/)

   [Radar](https://developers.cloudflare.com/radar/)

   [**Radar**](https://developers.cloudflare.com/radar/) now introduces Regional Data, providing traffic insights that bring a more localized perspective to the traffic trends shown on Radar.

   The following API endpoints are now available:

   * [`Get Geolocation`](https://developers.cloudflare.com/api/resources/radar/subresources/geolocations/methods/get/) - Retrieves geolocation by `geoId`.
   * [`List Geolocations`](https://developers.cloudflare.com/api/resources/radar/subresources/geolocations/methods/list/) - Lists geolocations.
   * [`NetFlows Summary By Dimension`](https://developers.cloudflare.com/api/resources/radar/subresources/netflows/methods/summary_v2/) - Retrieves NetFlows summary by dimension.

   All `summary` and `timeseries_groups` endpoints in [`HTTP`](https://developers.cloudflare.com/api/resources/radar/subresources/http/) and [`NetFlows`](https://developers.cloudflare.com/api/resources/radar/subresources/netflows/) now include an `adm1` dimension for grouping data by first level administrative division (for example, state, province, etc.)

   A new filter `geoId` was also added to all endpoints in [`HTTP`](https://developers.cloudflare.com/api/resources/radar/subresources/http/) and [`NetFlows`](https://developers.cloudflare.com/api/resources/radar/subresources/netflows/), allowing filtering by a specific administrative division.

   Check out the new Regional traffic insights on a country specific traffic page [new Radar page](https://radar.cloudflare.com/traffic/pt).

Sep 25, 2025

1. ### [Pipelines now supports SQL transformations and Apache Iceberg](https://developers.cloudflare.com/changelog/2025-09-25-pipelines-sql/)

   [Pipelines](https://developers.cloudflare.com/pipelines/)

   Today, we're launching the new [Cloudflare Pipelines](https://developers.cloudflare.com/pipelines/): a streaming data platform that ingests events, transforms them with [SQL](https://developers.cloudflare.com/pipelines/sql-reference/select-statements/), and writes to [R2](https://developers.cloudflare.com/r2/) as [Apache Iceberg](https://iceberg.apache.org/) tables or Parquet files.

   Pipelines can receive events via [HTTP endpoints](https://developers.cloudflare.com/pipelines/streams/writing-to-streams/#send-via-http) or [Worker bindings](https://developers.cloudflare.com/pipelines/streams/writing-to-streams/#send-via-workers), transform them with SQL, and deliver to R2 with exactly-once guarantees. This makes it easy to build analytics-ready warehouses for server logs, mobile application events, IoT telemetry, or clickstream data without managing streaming infrastructure.

   For example, here's a pipeline that ingests clickstream events and filters out bot traffic while extracting domain information:

   ```sql
   INSERT into events_table
   SELECT
     user_id,
     lower(event) AS event_type,
     to_timestamp_micros(ts_us) AS event_time,
     regexp_match(url, '^https?://([^/]+)')[1]  AS domain,
     url,
     referrer,
     user_agent
   FROM events_json
   WHERE event = 'page_view'
     AND NOT regexp_like(user_agent, '(?i)bot|spider');
   ```

   Get started by creating a pipeline in the dashboard or running a single command in [Wrangler](https://developers.cloudflare.com/workers/wrangler/):

   ```bash
   npx wrangler pipelines setup
   ```

   Check out our [getting started guide](https://developers.cloudflare.com/pipelines/getting-started/) to learn how to create a pipeline that delivers events to an [Iceberg table](https://developers.cloudflare.com/r2/data-catalog/) you can query with R2 SQL. Read more about today's announcement in our [blog post](https://blog.cloudflare.com/cloudflare-data-platform).

Sep 25, 2025

1. ### [R2 Data Catalog now supports compaction](https://developers.cloudflare.com/changelog/2025-09-25-data-catalog-compaction/)

   [R2](https://developers.cloudflare.com/r2/)

   You can now enable automatic compaction for [Apache Iceberg](https://iceberg.apache.org/) tables in [R2 Data Catalog](https://developers.cloudflare.com/r2/data-catalog/) to improve query performance.

   Compaction is the process of taking a group of small files and combining them into fewer larger files. This is an important maintenance operation as it helps ensure that query performance remains consistent by reducing the number of files that needs to be scanned.

   To enable automatic compaction in R2 Data Catalog, find it under **R2 Data Catalog** in your R2 bucket settings in the dashboard.

   ![compaction-dash](https://developers.cloudflare.com/_astro/compaction.MLojYuHL_wrmEO.webp)

   Or with [Wrangler](https://developers.cloudflare.com/workers/wrangler/), run:

   ```bash
   npx wrangler r2 bucket catalog compaction enable <BUCKET_NAME>  --target-size 128 --token <API_TOKEN>
   ```

   To get started with compaction, check out [manage catalogs](https://developers.cloudflare.com/r2/data-catalog/manage-catalogs/). For best practices and limitations, refer to [about compaction](https://developers.cloudflare.com/r2/data-catalog/about-compaction/).

Sep 25, 2025

1. ### [Announcing R2 SQL](https://developers.cloudflare.com/changelog/2025-09-25-announcing-r2-sql-open-beta/)

   [R2 SQL](https://developers.cloudflare.com/r2-sql/)

   Today, we're launching the **open beta** for [R2 SQL](https://developers.cloudflare.com/r2-sql/): A serverless, distributed query engine that can efficiently analyze petabytes of data in [Apache Iceberg](https://iceberg.apache.org/) tables managed by [R2 Data Catalog](https://developers.cloudflare.com/r2/data-catalog).

   R2 SQL is ideal for exploring analytical and time-series data stored in R2, such as logs, events from [Pipelines](https://developers.cloudflare.com/pipelines/), or clickstream and user behavior data.

   If you already have a table in R2 Data Catalog, running queries is as simple as:

   ```bash
   npx wrangler r2 sql query YOUR_WAREHOUSE "
   SELECT
       user_id,
       event_type,
       value
   FROM events.user_events
   WHERE event_type = 'CHANGELOG' or event_type = 'BLOG'
     AND __ingest_ts > '2025-09-24T00:00:00Z'
   ORDER BY __ingest_ts DESC
   LIMIT 100"
   ```

   To get started with R2 SQL, check out our [getting started guide](https://developers.cloudflare.com/r2-sql/get-started/) or learn more about supported features in the [SQL reference](https://developers.cloudflare.com/r2-sql/sql-reference/). For a technical deep dive into how we built R2 SQL, read our [blog post](https://blog.cloudflare.com/r2-sql-deep-dive/).

Sep 25, 2025

1. ### [Browser Rendering Playwright GA, Stagehand support (Beta), and higher limits](https://developers.cloudflare.com/changelog/2025-09-25-br-playwright-ga-stagehand-limits/)

   [Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

   We’re shipping three updates to Browser Rendering:

   * Playwright support is now Generally Available and synced with [Playwright v1.55](https://playwright.dev/docs/release-notes#version-155), giving you a stable foundation for critical automation and AI-agent workflows.
   * We’re also adding [Stagehand support (Beta)](https://developers.cloudflare.com/browser-rendering/stagehand/) so you can combine code with natural language instructions to build more resilient automations.
   * Finally, we’ve tripled [limits](https://developers.cloudflare.com/browser-rendering/limits/#workers-paid) for paid plans across both the [REST API](https://developers.cloudflare.com/browser-rendering/rest-api/) and [Workers Bindings](https://developers.cloudflare.com/browser-rendering/workers-bindings/) to help you scale.

   To get started with Stagehand, refer to the [Stagehand](https://developers.cloudflare.com/browser-rendering/stagehand/) example that uses Stagehand and [Workers AI](https://developers.cloudflare.com/workers-ai/) to search for a movie on this [example movie directory](https://demo.playwright.dev/movies), extract its details using natural language (title, year, rating, duration, and genre), and return the information along with a screenshot of the webpage.

   ```ts
   const stagehand = new Stagehand({
     env: "LOCAL",
     localBrowserLaunchOptions: { cdpUrl: endpointURLString(env.BROWSER) },
     llmClient: new WorkersAIClient(env.AI),
     verbose: 1,
   });


   await stagehand.init();
   const page = stagehand.page;


   await page.goto('https://demo.playwright.dev/movies');


   // if search is a multi-step action, stagehand will return an array of actions it needs to act on
   const actions = await page.observe('Search for "Furiosa"');
   for (const action of actions)
     await page.act(action);


   await page.act('Click the search result');


   // normal playwright functions work as expected
   await page.waitForSelector('.info-wrapper .cast');


   let movieInfo = await page.extract({
     instruction: 'Extract movie information',
     schema: z.object({
       title: z.string(),
       year: z.number(),
       rating: z.number(),
       genres: z.array(z.string()),
       duration: z.number().describe("Duration in minutes"),
     }),
   });


   await stagehand.close();
   ```

   ![Stagehand video](https://developers.cloudflare.com/images/browser-rendering/speedystagehand.gif)

Sep 25, 2025

1. ### [AI Search (formerly AutoRAG) now with More Models To Choose From](https://developers.cloudflare.com/changelog/2025-09-25-ai-search-more-models/)

   [AI Search](https://developers.cloudflare.com/ai-search/)

   AutoRAG is now AI Search! The new name marks a new and bigger mission: to make world-class search infrastructure available to every developer and business.

   With AI Search you can now use models from different providers like OpenAI and Anthropic. By attaching your provider keys to the AI Gateway linked to your AI Search instance, you can use many more models for both embedding and inference.

   To use AI Search with other [model providers](https://developers.cloudflare.com/ai-search/configuration/models/):

   1. **Add provider keys to AI Gateway**

      1. Go to AI > AI Gateway in the dashboard.
      2. Select or create an AI gateway.
      3. In Provider Keys, choose your provider, click Add, and enter the key.

   2. **Connect a gateway to AI Search**: When creating a new AI Search, select the AI Gateway with your provider keys. For an existing AI Search, go to Settings and switch to a gateway that has your keys under Resources.

   3. **Select models**: Embedding models are only available to be changed when creating a new AI Search. Generation model can be selected when creating a new AI Search and can be changed at any time in Settings.

   Once configured, your AI Search instance will be able to reference models available through your AI Gateway when making a `/ai-search` request:

   ```javascript
   export default {
     async fetch(request, env) {


       // Query your AI Search instance with a natural language question to an OpenAI model
       const result = await env.AI.autorag("my-ai-search").aiSearch({
         query: "What's new for Cloudflare Birthday Week?",
         model: "openai/gpt-5"
       });


       // Return only the generated answer as plain text
       return new Response(result.response, {
         headers: { "Content-Type": "text/plain" },
       });
     },
   };
   ```

   In the coming weeks we will also roll out updates to align the APIs with the new name. The existing APIs will continue to be supported for the time being. Stay tuned to the [AI Search Changelog](https://developers.cloudflare.com/changelog/?product=ai-search) and [Discord](https://discord.cloudflare.com/) for more updates!

Sep 25, 2025

1. ### [Run more Containers with higher resource limits](https://developers.cloudflare.com/changelog/2025-09-24-higher-container-resource-limits/)

   [Containers](https://developers.cloudflare.com/containers/)

   You can now run more Containers concurrently with higher limits on CPU, memory, and disk.

   | Limit | New Limit | Previous Limit |
   | - | - | - |
   | Memory for concurrent live Container instances | 400GiB | 40GiB |
   | vCPU for concurrent live Container instances | 100 | 20 |
   | Disk for concurrent live Container instances | 2TB | 100GB |

   You can now run 1000 instances of the `dev` instance type, 400 instances of `basic`, or 100 instances of `standard` concurrently.

   This opens up new possibilities for running larger-scale workloads on Containers.

   See the [getting started guide](https://developers.cloudflare.com/containers/get-started/) to deploy your first Container, and the [limits documentation](https://developers.cloudflare.com/containers/platform-details/limits/) for more details on the available instance types and limits.

Sep 25, 2025

1. ### [Refine DLP Scans with New Body Phase Selector](https://developers.cloudflare.com/changelog/2025-09-25-body-phase-selector/)

   [Gateway ](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)[Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

   You can now more precisely control your HTTP DLP policies by specifying whether to scan the request or response body, helping to reduce false positives and target specific data flows.

   In the Gateway HTTP policy builder, you will find a new selector called *Body Phase*. This allows you to define the direction of traffic the DLP engine will inspect:

   * *Request Body*: Scans data sent from a user's machine to an upstream service. This is ideal for monitoring data uploads, form submissions, or other user-initiated data exfiltration attempts.
   * *Response Body*: Scans data sent to a user's machine from an upstream service. Use this to inspect file downloads and website content for sensitive data.

   For example, consider a policy that blocks Social Security Numbers (SSNs). Previously, this policy might trigger when a user visits a website that contains example SSNs in its content (the response body). Now, by setting the **Body Phase** to *Request Body*, the policy will only trigger if the user attempts to upload or submit an SSN, ignoring the content of the web page itself.

   All policies without this selector will continue to scan both request and response bodies to ensure continued protection.

   For more information, refer to [Gateway HTTP policy selectors](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#body-phase/).

Sep 23, 2025

1. ### [Invalid Submissions Feedback](https://developers.cloudflare.com/changelog/2025-09-23-invalid-submissions/)

   [Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

   Email security relies on your submissions to continuously improve our detection models. However, we often receive submissions in formats that cannot be ingested, such as incomplete EMLs, screenshots, or text files.

   To ensure all customer feedback is actionable, we have launched two new features to manage invalid submissions sent to our team and user [submission aliases](https://developers.cloudflare.com/cloudflare-one/email-security/settings/phish-submissions/submission-addresses/):

   * **Email Notifications:** We now automatically notify users by email when they provide an invalid submission, educating them on the correct format. To disable notifications, go to **[Settings](https://one.dash.cloudflare.com/?to=/:account/email-security/settings)** > **Invalid submission emails** and turn the feature off.

   ![EmailSec-Invalid-Submissions-Toggle](https://developers.cloudflare.com/_astro/EmailSec-Invalid-Submissions-Toggle.DXjbR6aX_Z1aqqxR.webp)

   * **Invalid Submission dashboard:** You can quickly identify which users need education to provide valid submissions so Cloudflare can provide continuous protection.

   ![EmailSec-Invalid-Submissions-Dashboard](https://developers.cloudflare.com/_astro/EmailSec-Invalid-Submissions-Dashboard.zuf1on2n_Z1M2oP7.webp)

   Learn more about this feature on [invalid submissions](https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/invalid-submissions/).

   This feature is available across these Email security packages:

   * **Advantage**
   * **Enterprise**
   * **Enterprise + PhishGuard**

Sep 22, 2025

1. ### [Access Remote Desktop Protocol (RDP) destinations securely from your browser — now generally available!](https://developers.cloudflare.com/changelog/2025-09-22-browser-based-rdp-ga/)

   [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

   [Browser-based RDP](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-browser/) with [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) is now generally available for all Cloudflare customers. It enables secure, remote Windows server access without VPNs or RDP clients.

   Since we announced our [open beta](https://developers.cloudflare.com/changelog/access/#2025-06-30), we've made a few improvements:

   * Support for targets with IPv6.
   * Support for [Magic WAN](https://developers.cloudflare.com/magic-wan/) and [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/) as on-ramps.
   * More robust error messaging on the login page to help you if you encounter an issue.
   * Worldwide keyboard support. Whether your day-to-day is in Portuguese, Chinese, or something in between, your browser-based RDP experience will look and feel exactly like you are using a desktop RDP client.
   * Cleaned up some other miscellaneous issues, including but not limited to enhanced support for Entra ID accounts and support for usernames with spaces, quotes, and special characters.

   As a refresher, here are some benefits browser-based RDP provides:

   * **Control how users authenticate to internal RDP resources** with single sign-on (SSO), multi-factor authentication (MFA), and granular access policies.
   * **Record who is accessing which servers and when** to support regulatory compliance requirements and to gain greater visibility in the event of a security event.
   * **Eliminate the need to install and manage software on user devices**. You will only need a web browser.
   * **Reduce your attack surface** by keeping your RDP servers off the public Internet and protecting them from common threats like credential stuffing or brute-force attacks.

   ![Example of a browser-based RDP Access application](https://developers.cloudflare.com/_astro/browser-based-rdp-access-app.BNXce1JL_1NEtce.webp)

   To get started, refer to [Connect to RDP in a browser](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-browser/).

Sep 19, 2025

1. ### [New Metrics View in AutoRAG](https://developers.cloudflare.com/changelog/2025-09-19-autorag-metrics/)

   [AI Search](https://developers.cloudflare.com/ai-search/)

   [AutoRAG](https://developers.cloudflare.com/ai-search/) now includes a **Metrics** tab that shows how your data is indexed and searched. Get a clear view of the health of your indexing pipeline, compare usage between `ai-search` and `search`, and see which files are retrieved most often.

   ![Metrics](https://developers.cloudflare.com/_astro/metrics.BBUwKIos_Dog4W.webp)

   You can find these metrics within each AutoRAG instance:

   * Indexing: Track how files are ingested and see status changes over time.
   * Search breakdown: Compare usage between `ai-search` and `search` endpoints.
   * Top file retrievals: Identify which files are most frequently retrieved in a given period.

   Try it today in [AutoRAG](https://developers.cloudflare.com/ai-search/get-started/).

Sep 18, 2025

1. ### [Connect and secure any private or public app by hostname, not IP — with hostname routing for Cloudflare Tunnel](https://developers.cloudflare.com/changelog/2025-09-18-tunnel-hostname-routing/)

   [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

   You can now route private traffic to [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/) based on a hostname or domain, moving beyond the limitations of IP-based routing. This new capability is **free for all Cloudflare One customers**.

   Previously, Tunnel routes could only be defined by IP address or [CIDR range](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/connect-cidr/). This created a challenge for modern applications with dynamic or ephemeral IP addresses, often forcing administrators to maintain complex and brittle IP lists.

   ![Hostname-based routing in Cloudflare Tunnel](https://developers.cloudflare.com/_astro/tunnel-hostname-routing.DSi8MP_7_1xE3pm.webp)

   **What’s new:**

   * **Hostname & Domain Routing**: Create routes for individual hostnames (e.g., `payroll.acme.local`) or entire domains (e.g., `*.acme.local`) and direct their traffic to a specific Tunnel.
   * **Simplified Zero Trust Policies**: Build resilient policies in Cloudflare Access and Gateway using stable hostnames, making it dramatically easier to apply per-resource authorization for your private applications.
   * **Precise Egress Control**: Route traffic for public hostnames (e.g., `bank.example.com`) through a specific Tunnel to enforce a dedicated source IP, solving the IP allowlist problem for third-party services.
   * **No More IP Lists**: This feature makes the workaround of maintaining dynamic IP Lists for Tunnel connections obsolete.

   Get started in the Tunnels section of the Zero Trust dashboard with your first [private hostname](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/connect-private-hostname/) or [public hostname](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/egress-cloudflared/) route.

   Learn more in our [blog post](https://blog.cloudflare.com/tunnel-hostname-routing/).

Sep 16, 2025

1. ### [New AI-Enabled Search for Zero Trust Dashboard](https://developers.cloudflare.com/changelog/2025-09-16-new-ai-enabled-search-for-zero-trust-dashboard/)

   [Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

   Zero Trust Dashboard has a brand new, AI-powered search functionality. You can search your account by resources (applications, policies, device profiles, settings, etc.), pages, products, and more.

   ![Example search results in the Zero Trust dashboard](https://developers.cloudflare.com/_astro/searchexample.Di8yS8ju_Z1EfFaP.webp)

   **Ask Cloudy** — You can also ask Cloudy, our AI agent, questions about Cloudflare Zero Trust. Cloudy is trained on our developer documentation and implementation guides, so it can tell you how to configure functionality, best practices, and can make recommendations.

   Cloudy can then stay open with you as you move between pages to build configuration or answer more questions.

   **Find Recents** — Recent searches and Cloudy questions also have a new tab under Zero Trust Overview.

Sep 16, 2025

1. ### [DNS Firewall Analytics — now in the Cloudflare dashboard](https://developers.cloudflare.com/changelog/2025-09-16-dnsfw-analytics-ui/)

   [DNS](https://developers.cloudflare.com/dns/)

   #### What's New

   Access [GraphQL-powered DNS Firewall analytics](https://developers.cloudflare.com/dns/dns-firewall/analytics/) directly in the Cloudflare dashboard.

   ![DNS Firewall Analytics UI](https://developers.cloudflare.com/_astro/DNSFW_Analytics_UI.CgjmZFOO_1iMz6R.webp)

   #### Explore Four Interactive Panels

   * **Query summary**: Describes trends over time, segmented by dimensions.
   * **Query statistics**: Describes totals, cached/uncached queries, and processing/response times.
   * **DNS queries by data center**: Describes global view and the top 10 data centers.
   * **Top query statistics**: Shows a breakdown by key dimensions, with search and expand options (up to top 100 items).

   Additional features:

   * Apply filters and time ranges once. Changes reflect across all panels.
   * Filter by dimensions like query name, query type, cluster, data center, protocol (UDP/TCP), IP version, response code/reason, and more.
   * Access up to 62 days of historical data with flexible intervals.

   #### Availability

   Available to all DNS Firewall customers as part of their existing subscription.

   #### Where to Find It

   * In the Cloudflare dashboard, go to the **DNS Firewall** page.

     [Go to **Analytics**](https://dash.cloudflare.com/?to=/:account/dns-firewall/analytics)

   * Refer to the [DNS Firewall Analytics](https://developers.cloudflare.com/dns/dns-firewall/analytics/) to learn more.

Sep 11, 2025

1. ### [Regional Email Processing for Germany, India, or Australia](https://developers.cloudflare.com/changelog/2025-09-11-regional-email-processing-gia/)

   [Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

   We’re excited to announce that Email security customers can now choose their preferred mail processing location directly from the UI when onboarding a domain. This feature is available for the following onboarding methods: **MX**, **BCC**, and **Journaling**.

   #### What’s new

   Customers can now select where their email is processed. The following regions are supported:

   * **Germany**
   * **India**
   * **Australia**

   Global processing remains the default option, providing flexibility to meet both compliance requirements or operational preferences.

   #### How to use it

   When onboarding a domain with MX, BCC, or Journaling:

   1. Select the desired processing location (Germany, India, or Australia).
   2. The UI will display updated processing addresses specific to that region.
   3. For MX onboarding, if your domain is managed by Cloudflare, you can automatically update MX records directly from the UI.

   #### Availability

   This feature is available across these Email security packages:

   * **Advantage**
   * **Enterprise**
   * **Enterprise + PhishGuard**

   #### What’s next

   We’re expanding the list of processing locations to match our [Data Localization Suite (DLS)](https://developers.cloudflare.com/data-localization/) footprint, giving customers the broadest set of regional options in the market without the complexity of self-hosting.

Sep 11, 2025

1. ### [D1 automatically retries read-only queries](https://developers.cloudflare.com/changelog/2025-09-11-d1-automatic-read-retries/)

   [D1 ](https://developers.cloudflare.com/d1/)[Workers](https://developers.cloudflare.com/workers/)

   D1 now detects read-only queries and automatically attempts up to two retries to execute those queries in the event of failures with retryable errors. You can access the number of execution attempts in the returned [response metadata](https://developers.cloudflare.com/d1/worker-api/return-object/#d1result) property `total_attempts`.

   At the moment, only read-only queries are retried, that is, queries containing only the following SQLite keywords: `SELECT`, `EXPLAIN`, `WITH`. Queries containing any [SQLite keyword](https://sqlite.org/lang_keywords.html) that leads to database writes are not retried.

   The retry success ratio among read-only retryable errors varies from 5% all the way up to 95%, depending on the underlying error and its duration (like network errors or other internal errors).

   The retry success ratio among all retryable errors is lower, indicating that there are write-queries that could be retried. Therefore, we recommend D1 users to continue applying [retries in their own code](https://developers.cloudflare.com/d1/best-practices/retry-queries/) for queries that are not read-only but are idempotent according to the business logic of the application.

   ![D1 automatically query retries success ratio](https://developers.cloudflare.com/_astro/d1-auto-retry-success-ratio.yPw8B0tB_Z1kzKe0.webp)

   D1 ensures that any retry attempt does not cause database writes, making the automatic retries safe from side-effects, even if a query causing changes slips through the read-only detection. D1 achieves this by checking for modifications after every query execution, and if any write occurred due to a retry attempt, the query is rolled back.

   The read-only query detection heuristics are simple for now, and there is room for improvement to capture more cases of queries that can be retried, so this is just the beginning.

Sep 11, 2025

1. ### [DNS filtering for private network onramps](https://developers.cloudflare.com/changelog/2025-09-11-dns-filtering-for-private-network-onramps/)

   [Gateway ](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)[Magic WAN ](https://developers.cloudflare.com/magic-wan/)[Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

   [Magic WAN](https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-gateway/#dns-filtering) and [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/site-to-internet/#configure-dns-resolver-on-devices) users can now securely route their DNS traffic to the Gateway resolver without exposing traffic to the public Internet.

   Routing DNS traffic to the Gateway resolver allows DNS resolution and filtering for traffic coming from private networks while preserving source internal IP visibility. This ensures Magic WAN users have full integration with our Cloudflare One features, including [Internal DNS](https://developers.cloudflare.com/cloudflare-one/traffic-policies/resolver-policies/#internal-dns) and [hostname-based policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#selector-prerequisites).

   To configure DNS filtering, change your Magic WAN or WARP Connector DNS settings to use Cloudflare's shared resolver IPs, `172.64.36.1` and `172.64.36.2`. Once you configure DNS resolution and filtering, you can use *Source Internal IP* as a traffic selector in your [resolver policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/resolver-policies/) for routing private DNS traffic to your [Internal DNS](https://developers.cloudflare.com/dns/internal-dns/).

Sep 10, 2025

1. ### [Agents SDK v0.1.0 and workers-ai-provider v2.0.0 with AI SDK v5 support](https://developers.cloudflare.com/changelog/2025-09-03-agents-sdk-beta-v5/)

   [Agents ](https://developers.cloudflare.com/agents/)[Workers](https://developers.cloudflare.com/workers/)

   We've shipped a new release for the [Agents SDK](https://github.com/cloudflare/agents) bringing full compatibility with [AI SDK v5](https://ai-sdk.dev/docs/introduction) and introducing automatic message migration that handles all legacy formats transparently.

   This release includes improved streaming and tool support, tool confirmation detection (for "human in the loop" systems), enhanced React hooks with automatic tool resolution, improved error handling for streaming responses, and seamless migration utilities that work behind the scenes.

   This makes it ideal for building production AI chat interfaces with Cloudflare Workers AI models, agent workflows, human-in-the-loop systems, or any application requiring reliable message handling across SDK versions — all while maintaining backward compatibility.

   Additionally, we've updated workers-ai-provider v2.0.0, the official provider for Cloudflare Workers AI models, to be compatible with AI SDK v5.

   #### useAgentChat(options)

   Creates a new chat interface with enhanced v5 capabilities.

   ```ts
   // Basic chat setup
   const { messages, sendMessage, addToolResult } = useAgentChat({
     agent,
     experimental_automaticToolResolution: true,
     tools,
   });


   // With custom tool confirmation
   const chat = useAgentChat({
     agent,
     experimental_automaticToolResolution: true,
     toolsRequiringConfirmation: ["dangerousOperation"],
   });
   ```

   #### Automatic Tool Resolution

   Tools are automatically categorized based on their configuration:

   ```ts
   const tools = {
     // Auto-executes (has execute function)
     getLocalTime: {
       description: "Get current local time",
       inputSchema: z.object({}),
       execute: async () => new Date().toLocaleString(),
     },


     // Requires confirmation (no execute function)
     deleteFile: {
       description: "Delete a file from the system",
       inputSchema: z.object({
         filename: z.string(),
       }),
     },


     // Server-executed (no client confirmation)
     analyzeData: {
       description: "Analyze dataset on server",
       inputSchema: z.object({ data: z.array(z.number()) }),
       serverExecuted: true,
     },
   } satisfies Record<string, AITool>;
   ```

   #### Message Handling

   Send messages using the new v5 format with parts array:

   ```ts
   // Text message
   sendMessage({
     role: "user",
     parts: [{ type: "text", text: "Hello, assistant!" }],
   });


   // Multi-part message with file
   sendMessage({
     role: "user",
     parts: [
       { type: "text", text: "Analyze this image:" },
       { type: "image", image: imageData },
     ],
   });
   ```

   #### Tool Confirmation Detection

   Simplified logic for detecting pending tool confirmations:

   ```ts
   const pendingToolCallConfirmation = messages.some((m) =>
     m.parts?.some(
       (part) => isToolUIPart(part) && part.state === "input-available",
     ),
   );


   // Handle tool confirmation
   if (pendingToolCallConfirmation) {
     await addToolResult({
       toolCallId: part.toolCallId,
       tool: getToolName(part),
       output: "User approved the action",
     });
   }
   ```

   #### Automatic Message Migration

   Seamlessly handle legacy message formats without code changes.

   ```ts
   // All these formats are automatically converted:


   // Legacy v4 string content
   const legacyMessage = {
     role: "user",
     content: "Hello world",
   };


   // Legacy v4 with tool calls
   const legacyWithTools = {
     role: "assistant",
     content: "",
     toolInvocations: [
       {
         toolCallId: "123",
         toolName: "weather",
         args: { city: "SF" },
         state: "result",
         result: "Sunny, 72°F",
       },
     ],
   };


   // Automatically becomes v5 format:
   // {
   //   role: "assistant",
   //   parts: [{
   //     type: "tool-call",
   //     toolCallId: "123",
   //     toolName: "weather",
   //     args: { city: "SF" },
   //     state: "result",
   //     result: "Sunny, 72°F"
   //   }]
   // }
   ```

   #### Tool Definition Updates

   Migrate tool definitions to use the new `inputSchema` property.

   ```ts
   // Before (AI SDK v4)
   const tools = {
     weather: {
       description: "Get weather information",
       parameters: z.object({
         city: z.string(),
       }),
       execute: async (args) => {
         return await getWeather(args.city);
       },
     },
   };


   // After (AI SDK v5)
   const tools = {
     weather: {
       description: "Get weather information",
       inputSchema: z.object({
         city: z.string(),
       }),
       execute: async (args) => {
         return await getWeather(args.city);
       },
     },
   };
   ```

   #### Cloudflare Workers AI Integration

   Seamless integration with Cloudflare Workers AI models through the updated workers-ai-provider v2.0.0.

   #### Model Setup with Workers AI

   Use Cloudflare Workers AI models directly in your agent workflows:

   ```ts
   import { createWorkersAI } from "workers-ai-provider";
   import { useAgentChat } from "agents/ai-react";


   // Create Workers AI model (v2.0.0 - same API, enhanced v5 internals)
   const model = createWorkersAI({
     binding: env.AI,
   })("@cf/meta/llama-3.2-3b-instruct");
   ```

   #### Enhanced File and Image Support

   Workers AI models now support v5 file handling with automatic conversion:

   ```ts
   // Send images and files to Workers AI models
   sendMessage({
     role: "user",
     parts: [
       { type: "text", text: "Analyze this image:" },
       {
         type: "file",
         data: imageBuffer,
         mediaType: "image/jpeg",
       },
     ],
   });


   // Workers AI provider automatically converts to proper format
   ```

   #### Streaming with Workers AI

   Enhanced streaming support with automatic warning detection:

   ```ts
   // Streaming with Workers AI models
   const result = await streamText({
     model: createWorkersAI({ binding: env.AI })("@cf/meta/llama-3.2-3b-instruct"),
     messages,
     onChunk: (chunk) => {
       // Enhanced streaming with warning handling
       console.log(chunk);
     },
   });
   ```

   #### Import Updates

   Update your imports to use the new v5 types:

   ```ts
   // Before (AI SDK v4)
   import type { Message } from "ai";
   import { useChat } from "ai/react";


   // After (AI SDK v5)
   import type { UIMessage } from "ai";
   // or alias for compatibility
   import type { UIMessage as Message } from "ai";
   import { useChat } from "@ai-sdk/react";
   ```

   #### Resources

   * [Migration Guide](https://github.com/cloudflare/agents/blob/main/docs/migration-to-ai-sdk-v5.md) - Comprehensive migration documentation
   * [AI SDK v5 Documentation](https://ai-sdk.dev/docs/migration-guides/migration-guide-5-0) - Official AI SDK migration guide
   * [An Example PR showing the migration from AI SDK v4 to v5](https://github.com/cloudflare/agents-starter/pull/105)
   * [GitHub Issues](https://github.com/cloudflare/agents/issues) - Report bugs or request features

   #### Feedback Welcome

   We'd love your feedback! We're particularly interested in feedback on:

   * **Migration experience** - How smooth was the upgrade process?
   * **Tool confirmation workflow** - Does the new automatic detection work as expected?
   * **Message format handling** - Any edge cases with legacy message conversion?

Sep 08, 2025

1. ### [Custom IKE ID for IPsec Tunnels](https://developers.cloudflare.com/changelog/2025-09-08-custom-ike-id-ipsec-tunnels/)

   [Magic WAN](https://developers.cloudflare.com/magic-wan/)

   Now, Magic WAN customers can configure a custom IKE ID for their IPsec tunnels. Customers that are using Magic WAN and a VeloCloud SD-WAN device together can utilize this new feature to create a high availability configuration.

   This feature is available via API only. Customers can read the Magic WAN documentation to learn more about the [Custom IKE ID feature and the API call to configure it](https://developers.cloudflare.com/magic-wan/configuration/common-settings/custom-ike-id-ipsec/).

Sep 05, 2025

1. ### [Bidirectional tunnel health checks are compatible with all Magic on-ramps](https://developers.cloudflare.com/changelog/2025-09-05-bidirectional-health-check-any-on-ramp/)

   [Magic WAN](https://developers.cloudflare.com/magic-wan/)

   All bidirectional tunnel health check return packets are accepted by any Magic on-ramp.

   Previously, when a Magic tunnel had a bidirectional health check configured, the bidirectional health check would pass when the return packets came back to Cloudflare over the same tunnel that was traversed by the forward packets.

   There are SD-WAN devices, like VeloCloud, that do not offer controls to steer traffic over one tunnel versus another in a high availability tunnel configuration.

   Now, when a Magic tunnel has a bidirectional health check configured, the bidirectional health check will pass when the return packet traverses over any tunnel in a high availability configuration.

Sep 05, 2025

1. ### [Introducing EmbeddingGemma from Google on Workers AI](https://developers.cloudflare.com/changelog/2025-09-05-embeddinggemma/)

   [Workers AI](https://developers.cloudflare.com/workers-ai/)

   We're excited to be a launch partner alongside [Google](https://developers.googleblog.com/en/introducing-embeddinggemma/) to bring their newest embedding model, **EmbeddingGemma**, to Workers AI that delivers best-in-class performance for its size, enabling RAG and semantic search use cases.

   [`@cf/google/embeddinggemma-300m`](https://developers.cloudflare.com/workers-ai/models/embeddinggemma-300m/) is a 300M parameter embedding model from Google, built from Gemma 3 and the same research used to create Gemini models. This multilingual model supports 100+ languages, making it ideal for RAG systems, semantic search, content classification, and clustering tasks.

   **Using EmbeddingGemma in AI Search:** Now you can leverage EmbeddingGemma directly through AI Search for your RAG pipelines. EmbeddingGemma's multilingual capabilities make it perfect for global applications that need to understand and retrieve content across different languages with exceptional accuracy.

   To use EmbeddingGemma for your AI Search projects:

   1. Go to **Create** in the [AI Search dashboard](https://dash.cloudflare.com/?to=/:account/ai/ai-search)
   2. Follow the setup flow for your new RAG instance
   3. In the **Generate Index** step, open up **More embedding models** and select `@cf/google/embeddinggemma-300m` as your embedding model
   4. Complete the setup to create an AI Search

   Try it out and let us know what you think!

Sep 04, 2025

1. ### [Increased static asset limits for Workers](https://developers.cloudflare.com/changelog/2025-09-02-increased-static-asset-limits/)

   [Workers ](https://developers.cloudflare.com/workers/)[Workers for Platforms](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/)

   You can now upload up to **100,000 static assets** per Worker version

   * Paid and Workers for Platforms users can now upload up to **100,000 static assets** per Worker version, a 5x increase from the previous limit of 20,000.
   * Customers on the free plan still have the same limit as before — 20,000 static assets per version of your Worker
   * The individual file size limit of 25 MiB remains unchanged for all customers.

   This increase allows you to build larger applications with more static assets without hitting limits.

   #### Wrangler

   To take advantage of the increased limits, you must use **Wrangler version 4.34.0 or higher**. Earlier versions of Wrangler will continue to enforce the previous 20,000 file limit.

   #### Learn more

   For more information about Workers static assets, see the [Static Assets documentation](https://developers.cloudflare.com/workers/static-assets/) and [Platform Limits](https://developers.cloudflare.com/workers/platform/limits/#static-assets).

Sep 02, 2025

1. ### [Cloudflare Tunnel and Networks API will no longer return deleted resources by default starting December 1, 2025](https://developers.cloudflare.com/changelog/2025-09-02-tunnel-networks-list-endpoints-new-default/)

   [Cloudflare One ](https://developers.cloudflare.com/cloudflare-one/)[Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

   Starting **December 1, 2025**, list endpoints for the [Cloudflare Tunnel API](https://developers.cloudflare.com/api/resources/zero_trust/subresources/tunnels/) and [Zero Trust Networks API](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/) will no longer return deleted tunnels, routes, subnets and virtual networks by default. This change makes the API behavior more intuitive by only returning active resources unless otherwise specified.

   No action is required if you already explicitly set `is_deleted=false` or if you only need to list active resources.

   This change affects the following API endpoints:

   * List all tunnels: [`GET /accounts/{account_id}/tunnels`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/tunnels/methods/list/)
   * List [Cloudflare Tunnels](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/): [`GET /accounts/{account_id}/cfd_tunnel`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/tunnels/subresources/cloudflared/methods/list/)
   * List [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/) tunnels: [`GET /accounts/{account_id}/warp_connector`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/tunnels/subresources/warp_connector/methods/list/)
   * List tunnel routes: [`GET /accounts/{account_id}/teamnet/routes`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/subresources/routes/methods/list/)
   * List subnets: [`GET /accounts/{account_id}/zerotrust/subnets`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/subresources/subnets/methods/list/)
   * List virtual networks: [`GET /accounts/{account_id}/teamnet/virtual_networks`](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/subresources/virtual_networks/methods/list/)

   #### What is changing?

   The default behavior of the `is_deleted` query parameter will be updated.

   | Scenario | Previous behavior (before December 1, 2025) | New behavior (from December 1, 2025) |
   | - | - | - |
   | `is_deleted` parameter is omitted | Returns **active & deleted** tunnels, routes, subnets and virtual networks | Returns **only active** tunnels, routes, subnets and virtual networks |

   #### Action required

   If you need to retrieve deleted (or all) resources, please update your API calls to explicitly include the `is_deleted` parameter before **December 1, 2025**.

   To get a list of only deleted resources, you must now explicitly add the `is_deleted=true` query parameter to your request:

   ```bash
   # Example: Get ONLY deleted Tunnels
   curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/tunnels?is_deleted=true" \
        -H "Authorization: Bearer $API_TOKEN"


   # Example: Get ONLY deleted Virtual Networks
   curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/teamnet/virtual_networks?is_deleted=true" \
        -H "Authorization: Bearer $API_TOKEN"
   ```

   Following this change, retrieving a complete list of both active and deleted resources will require two separate API calls: one to get active items (by omitting the parameter or using `is_deleted=false`) and one to get deleted items (`is_deleted=true`).

   #### Why we’re making this change

   This update is based on user feedback and aims to:

   * **Create a more intuitive default:** Aligning with common API design principles where list operations return only active resources by default.
   * **Reduce unexpected results:** Prevents users from accidentally operating on deleted resources that were returned unexpectedly.
   * **Improve performance:** For most users, the default query result will now be smaller and more relevant.

   To learn more, please visit the [Cloudflare Tunnel API](https://developers.cloudflare.com/api/resources/zero_trust/subresources/tunnels/) and [Zero Trust Networks API](https://developers.cloudflare.com/api/resources/zero_trust/subresources/networks/) documentation.

Sep 01, 2025

1. ### [Updated Email security roles](https://developers.cloudflare.com/changelog/2025-09-01-updated-new-roles/)

   [Email security](https://developers.cloudflare.com/cloudflare-one/email-security/)

   To provide more granular controls, we refined the [existing roles](https://developers.cloudflare.com/cloudflare-one/roles-permissions/#email-security-roles) for Email security and launched a new Email security role as well.

   All Email security roles no longer have read or write access to any of the other Zero Trust products:

   * **Email Configuration Admin**
   * **Email Integration Admin**
   * **Email security Read Only**
   * **Email security Analyst**
   * **Email security Policy Admin**
   * **Email security Reporting**

   To configure [Data Loss Prevention (DLP)](https://developers.cloudflare.com/cloudflare-one/email-security/outbound-dlp/) or [Remote Browser Isolation (RBI)](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/#set-up-clientless-web-isolation), you now need to be an admin for the Zero Trust dashboard with the **Cloudflare Zero Trust** role.

   Also through customer feedback, we have created a new additive role to allow **Email security Analyst** to create, edit, and delete Email security policies, without needing to provide access via the **Email Configuration Admin** role. This role is called **Email security Policy Admin**, which can read all settings, but has write access to [allow policies](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/allow-policies/), [trusted domains](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/trusted-domains/), and [blocked senders](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/blocked-senders/).

   This feature is available across these Email security packages:

   * **Advantage**
   * **Enterprise**
   * **Enterprise + PhishGuard**

Aug 29, 2025

1. ### [DEX MCP Server](https://developers.cloudflare.com/changelog/2025-08-29-dex-mcp-server/)

   [Digital Experience Monitoring](https://developers.cloudflare.com/cloudflare-one/insights/dex/)

   [Digital Experience Monitoring (DEX)](https://developers.cloudflare.com/cloudflare-one/insights/dex/) provides visibility into device connectivity and performance across your Cloudflare SASE deployment.

   We've released an MCP server [(Model Context Protocol)](https://cloudflare.com/learning/ai/what-is-model-context-protocol-mcp/) for DEX.

   The DEX MCP server is an AI tool that allows customers to ask a question like, "Show me the connectivity and performance metrics for the device used by carly‌@acme.com", and receive an answer that contains data from the DEX API.

   Any Cloudflare One customer using a Free, PayGo, or Enterprise account can access the DEX MCP Server. This feature is available to everyone.

   Customers can test the new DEX MCP server in less than one minute. To learn more, read the [DEX MCP server documentation](https://developers.cloudflare.com/cloudflare-one/insights/dex/dex-mcp-server/).

Aug 29, 2025

1. ### [Terraform v5.9 now available](https://developers.cloudflare.com/changelog/2025-08-29-terrform-v59-provider/)

   [Cloudflare Fundamentals ](https://developers.cloudflare.com/fundamentals/)[Terraform](https://developers.cloudflare.com/terraform/)

   Earlier this year, we announced the launch of the new [Terraform v5 Provider](https://developers.cloudflare.com/changelog/2025-02-03-terraform-v5-provider/). We are aware of the high number of [issues](https://github.com/cloudflare/terraform-provider-cloudflare) reported by the Cloudflare community related to the v5 release. We have committed to releasing improvements on a 2 week cadence to ensure its stability and reliability, including the v5.9 release. We have also pivoted from an issue-to-issue approach to a resource-per-resource approach - we will be focusing on specific resources for every release, stabilizing the release, and closing all associated bugs with that resource before moving onto resolving migration issues.

   Thank you for continuing to raise issues. We triage them weekly and they help make our products stronger.

   This release includes a new resource, `cloudflare_snippet`, which replaces `cloudflare_snippets`. `cloudflare_snippet` is now considered deprecated but can still be used. Please utilize `cloudflare_snippet` as soon as possible.

   #### Changes

   * Resources stabilized:

     * `cloudfare_zone_setting`
     * `cloudflare_worker_script`
     * `cloudflare_worker_route`
     * `tiered_cache`

   * **NEW** resource `cloudflare_snippet` which should be used in place of `cloudflare_snippets`. `cloudflare_snippets` is now deprecated. This enables the management of Cloudflare's snippet functionality through Terraform.

   * DNS Record Improvements: Enhanced handling of DNS record drift detection

   * Load Balancer Fixes: Resolved `created_on` field inconsistencies and improved pool configuration handling

   * Bot Management: Enhanced auto-update model state consistency and fight mode configurations

   * Other bug fixes

   For a more detailed look at all of the changes, refer to the [changelog](https://github.com/cloudflare/terraform-provider-cloudflare/releases/tag/v5.9.0) in GitHub.

   #### Issues Closed

   * [#5921: In cloudflare\_ruleset removing an existing rule causes recreation of later rules](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5921)
   * [#5904: cloudflare\_zero\_trust\_access\_application is not idempotent](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5904)
   * [#5898: (cloudflare\_workers\_script) Durable Object migrations not applied](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5898)
   * [#5892: cloudflare\_workers\_script secret\_text environment variable gets replaced on every deploy](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5892)
   * [#5891: cloudflare\_zone suddenly started showing drift](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5891)
   * [#5882: cloudflare\_zero\_trust\_list always marked for change due to read only attributes](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5882)
   * [#5879: cloudflare\_zero\_trust\_gateway\_certificate unable to manage resource (cant mark as active/inactive)](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5879)
   * [#5858: cloudflare\_dns\_records is always updated in-place](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5858)
   * [#5839: Recurring change on cloudflare\_zero\_trust\_gateway\_policy after upgrade to V5 provider & also setting expiration fails](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5839)
   * [#5811: Reusable policies are imported as inline type for cloudflare\_zero\_trust\_access\_application](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5811)
   * [#5795: cloudflare\_zone\_setting inconsistent value of "editable" upon apply](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5795)
   * [#5789: Pagination issue fetching all policies in "cloudflare\_zero\_trust\_access\_policies" data source](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5789)
   * [#5770: cloudflare\_zero\_trust\_access\_application type warp diff on every apply](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5770)
   * [#5765: V5 / cloudflare\_zone\_dnssec fails with HTTP/400 "Malformed request body"](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5765)
   * [#5755: Unable to manage Cloudflare managed WAF rules via Terraform](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5755)
   * [#5738: v4 to v5 upgrade failing Error: no schema available AND Unable to Read Previously Saved State for UpgradeResourceState](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5738)
   * [#5727: cloudflare\_ruleset http\_request\_cache\_settings bypass mismatch between dashboard and terraform](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5727)
   * [#5700: cloudflare\_account\_member invalid type 'string' for field 'roles'](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5700)

   If you have an unaddressed issue with the provider, we encourage you to check the [open issues](https://github.com/cloudflare/terraform-provider-cloudflare/issues) and open a new issue if one does not already exist for what you are experiencing.

   #### Upgrading

   We suggest holding off on migration to v5 while we work on stabilization. This help will you avoid any blocking issues while the Terraform resources are actively being stabilized.

   If you'd like more information on migrating from v4 to v5, please make use of the [migration guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade). We have provided automated migration scripts using Grit which simplify the transition. These do not support implementations which use Terraform modules, so customers making use of modules need to migrate manually. Please make use of `terraform plan` to test your changes before applying, and let us know if you encounter any additional issues by reporting to our [GitHub repository](https://github.com/cloudflare/terraform-provider-cloudflare).

   #### For more info

   * [Terraform provider](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs)
   * [Documentation on using Terraform with Cloudflare](https://developers.cloudflare.com/terraform/)
   * [GitHub Repository](https://github.com/cloudflare/terraform-provider-cloudflare)

Aug 27, 2025

1. ### [Enhanced crawler insights and custom 402 responses](https://developers.cloudflare.com/changelog/2025-08-27-ai-crawl-control-launch/)

   [AI Crawl Control](https://developers.cloudflare.com/ai-crawl-control/)

   We improved AI crawler management with detailed analytics and introduced custom HTTP 402 responses for blocked crawlers. AI Audit has been renamed to AI Crawl Control and is now generally available.

   **Enhanced Crawlers tab:**

   * View total allowed and blocked requests for each AI crawler
   * Trend charts show crawler activity over your selected time range per crawler

   ![Updated AI Crawl Control table showing request counts and trend charts](https://developers.cloudflare.com/_astro/ai-crawl-control-table.BDr0Qd-5_Z28yWEm.webp)

   **Custom block responses (paid plans):** You can now return HTTP 402 "Payment Required" responses when blocking AI crawlers, enabling direct communication with crawler operators about licensing terms.

   For users on paid plans, when blocking AI crawlers you can configure:

   * **Response code:** Choose between 403 Forbidden or 402 Payment Required
   * **Response body:** Add a custom message with your licensing contact information

   ![AI Crawl Control block response configuration interface](https://developers.cloudflare.com/_astro/ai-crawl-control-block-response.L4duQj7-_ZjWQYT.webp)

   Example 402 response:

   ```http
   HTTP 402 Payment Required
   Date: Mon, 24 Aug 2025 12:56:49 GMT
   Content-type: application/json
   Server: cloudflare
   Cf-Ray: 967e8da599d0c3fa-EWR
   Cf-Team: 2902f6db750000c3fa1e2ef400000001


   {
     "message": "Please contact the site owner for access."
   }
   ```

Aug 27, 2025

1. ### [Shadow IT - SaaS analytics dashboard](https://developers.cloudflare.com/changelog/2025-08-27-shadow-it-analytics/)

   [Gateway ](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

   Zero Trust has significantly upgraded its **Shadow IT analytics**, providing you with unprecedented visibility into your organizations use of SaaS tools. With this dashboard, you can review who is using an application and volumes of data transfer to the application.

   You can review these metrics against application type, such as Artificial Intelligence or Social Media. You can also mark applications with an approval status, including **Unreviewed**, **In Review**, **Approved**, and **Unapproved** designating how they can be used in your organization.

   ![Cloudflare One Analytics Dashboards](https://developers.cloudflare.com/_astro/shadow-it-analytics.BLNnG72w_eGLA5.webp)

   These application statuses can also be used in Gateway HTTP policies, so you can block, isolate, limit uploads and downloads, and more based on the application status.

   Both the analytics and policies are accessible in the Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/), empowering organizations with better visibility and control.

Aug 27, 2025

1. ### [Deepgram and Leonardo partner models now available on Workers AI](https://developers.cloudflare.com/changelog/2025-08-27-partner-models/)

   [Workers AI](https://developers.cloudflare.com/workers-ai/)

   New state-of-the-art models have landed on Workers AI! This time, we're introducing new **partner models** trained by our friends at [Deepgram](https://deepgram.com) and [Leonardo](https://leonardo.ai), hosted on Workers AI infrastructure.

   As well, we're introuding a new turn detection model that enables you to detect when someone is done speaking — useful for building voice agents!

   Read the [blog](https://blog.cloudflare.com/workers-ai-partner-models) for more details and check out some of the new models on our platform:

   * [`@cf/deepgram/aura-1`](https://developers.cloudflare.com/workers-ai/models/aura-1) is a text-to-speech model that allows you to input text and have it come to life in a customizable voice
   * [`@cf/deepgram/nova-3`](https://developers.cloudflare.com/workers-ai/models/nova-3) is speech-to-text model that transcribes multilingual audio at a blazingly fast speed
   * [`@cf/pipecat-ai/smart-turn-v2`](https://developers.cloudflare.com/workers-ai/models/smart-turn-v2) helps you detect when someone is done speaking
   * [`@cf/leonardo/lucid-origin`](https://developers.cloudflare.com/workers-ai/models/lucid-origin) is a text-to-image model that generates images with sharp graphic design, stunning full-HD renders, or highly specific creative direction
   * [`@cf/leonardo/phoenix-1.0`](https://developers.cloudflare.com/workers-ai/models/phoenix-1.0) is a text-to-image model with exceptional prompt adherence and coherent text

   You can filter out new partner models with the `Partner` capability on our [Models](https://developers.cloudflare.com/workers-ai/models) page.

   As well, we're introducing WebSocket support for some of our audio models, which you can filter though the `Realtime` capability on our [Models](https://developers.cloudflare.com/workers-ai/models) page. WebSockets allows you to create a bi-directional connection to our inference server with low latency — perfect for those that are building voice agents.

   An example python snippet on how to use WebSockets with our new Aura model:

   ```plaintext
   import json
   import os
   import asyncio
   import websockets


   uri = f"wss://api.cloudflare.com/client/v4/accounts/{ACCOUNT_ID}/ai/run/@cf/deepgram/aura-1"


   input = [
       "Line one, out of three lines that will be provided to the aura model.",
       "Line two, out of three lines that will be provided to the aura model.",
       "Line three, out of three lines that will be provided to the aura model. This is a last line.",
   ]




   async def text_to_speech():
       async with websockets.connect(uri, additional_headers={"Authorization": os.getenv("CF_TOKEN")}) as websocket:
           print("connection established")
           for line in input:
               print(f"sending `{line}`")
               await websocket.send(json.dumps({"type": "Speak", "text": line}))


               print("line was sent, flushing")
               await websocket.send(json.dumps({"type": "Flush"}))
               print("flushed, recving")
               resp = await websocket.recv()
               print(f"response received {resp}")




   if __name__ == "__main__":
       asyncio.run(text_to_speech())
   ```

Aug 26, 2025

1. ### [New CASB integrations for ChatGPT, Claude, and Gemini](https://developers.cloudflare.com/changelog/2025-08-26-casb-ai-integrations/)

   [CASB](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)

   [Cloudflare CASB](https://www.cloudflare.com/zero-trust/products/casb/) now supports three of the most widely used GenAI platforms — **OpenAI ChatGPT**, **Anthropic Claude**, and **Google Gemini**. These API-based integrations give security teams agentless visibility into posture, data, and compliance risks across their organization’s use of generative AI.

   ![Cloudflare CASB showing selection of new findings for ChatGPT, Claude, and Gemini integrations.](https://developers.cloudflare.com/_astro/casb-ai-integrations-preview.B-zsSA1P_Z1CkbtH.webp)

   #### Key capabilities

   * **Agentless connections** — connect ChatGPT, Claude, and Gemini tenants via API; no endpoint software required
   * **Posture management** — detect insecure settings and misconfigurations that could lead to data exposure
   * **DLP detection** — identify sensitive data in uploaded chat attachments or files
   * **GenAI-specific insights** — surface risks unique to each provider’s capabilities

   #### Learn more

   * [ChatGPT integration docs](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/openai/)
   * [Claude integration docs](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/anthropic/)
   * [Gemini integration docs](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/google-workspace/gemini/)

   These integrations are available to all Cloudflare One customers today.

Aug 26, 2025

1. ### [Manage and restrict access to internal MCP servers with Cloudflare Access](https://developers.cloudflare.com/changelog/2025-08-26-access-mcp-oauth/)

   [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

   You can now control who within your organization has access to internal MCP servers, by putting internal MCP servers behind [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/).

   [Self-hosted applications](https://developers.cloudflare.com/cloudflare-one/access-controls/ai-controls/linked-apps/) in Cloudflare Access now support OAuth for MCP server authentication. This allows Cloudflare to delegate access from any self-hosted application to an MCP server via OAuth. The OAuth access token authorizes the MCP server to make requests to your self-hosted applications on behalf of the authorized user, using that user's specific permissions and scopes.

   For example, if you have an MCP server designed for internal use within your organization, you can configure Access policies to ensure that only authorized users can access it, regardless of which MCP client they use. Support for internal, self-hosted MCP servers also works with MCP server portals, allowing you to provide a single MCP endpoint for multiple MCP servers. For more on MCP server portals, read the [blog post](https://blog.cloudflare.com/zero-trust-mcp-server-portals/) on the Cloudflare Blog.

Aug 26, 2025

1. ### [MCP server portals](https://developers.cloudflare.com/changelog/2025-08-26-mcp-server-portals/)

   [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

   ![MCP server portal](https://developers.cloudflare.com/_astro/mcp-server-portal.BOKqTCoI_ZIxF0P.webp)

   An [MCP server portal](https://developers.cloudflare.com/cloudflare-one/access-controls/ai-controls/mcp-portals/) centralizes multiple Model Context Protocol (MCP) servers onto a single HTTP endpoint. Key benefits include:

   * **Streamlined access to multiple MCP servers**: MCP server portals support both unauthenticated MCP servers as well as MCP servers secured using any third-party or custom OAuth provider. Users log in to the portal URL through Cloudflare Access and are prompted to authenticate separately to each server that requires OAuth.
   * **Customized tools per portal**: Admins can tailor an MCP portal to a particular use case by choosing the specific tools and prompt templates that they want to make available to users through the portal. This allows users to access a curated set of tools and prompts — the less external context exposed to the AI model, the better the AI responses tend to be.
   * **Observability**: Once the user's AI agent is connected to the portal, Cloudflare Access logs the indiviudal requests made using the tools in the portal.

   This is available in an open beta for all customers across all plans! For more information check out our [blog](https://blog.cloudflare.com/zero-trust-mcp-server-portals/) for this release.

Aug 26, 2025

1. ### [List all vectors in a Vectorize index with the new list-vectors operation](https://developers.cloudflare.com/changelog/2025-08-26-vectorize-list-vectors/)

   [Vectorize](https://developers.cloudflare.com/vectorize/)

   You can now list all vector identifiers in a Vectorize index using the new `list-vectors` operation. This enables bulk operations, auditing, and data migration workflows through paginated requests that maintain snapshot consistency.

   The operation is available via Wrangler CLI and REST API. Refer to the [list-vectors best practices guide](https://developers.cloudflare.com/vectorize/best-practices/list-vectors/) for detailed usage guidance.

Aug 25, 2025

1. ### [Manage and deploy your AI provider keys through Bring Your Own Key (BYOK) with AI Gateway, now powered by Cloudflare Secrets Store](https://developers.cloudflare.com/changelog/2025-08-25-secrets-store-ai-gateway/)

   [Secrets Store ](https://developers.cloudflare.com/secrets-store/)[AI Gateway ](https://developers.cloudflare.com/ai-gateway/)[SSL/TLS](https://developers.cloudflare.com/ssl/)

   Cloudflare Secrets Store is now integrated with AI Gateway, allowing you to store, manage, and deploy your AI provider keys in a secure and seamless configuration through [Bring Your Own Key](https://developers.cloudflare.com/ai-gateway/configuration/bring-your-own-keys/). Instead of passing your AI provider keys directly in every request header, you can centrally manage each key with Secrets Store and deploy in your gateway configuration using only a reference, rather than passing the value in plain text.

   You can now create a secret directly from your AI Gateway [in the dashboard](http://dash.cloudflare.com/?to=/:account/ai-gateway) by navigating into your gateway -> **Provider Keys** -> **Add**.

   ![Import repo or choose template](https://developers.cloudflare.com/_astro/add-secret-ai-gateway.B-SIPr6s_Z1Q2xOA.webp)

   You can also create your secret with the newly available **ai\_gateway** scope via [wrangler](https://developers.cloudflare.com/workers/wrangler/commands/), the [Secrets Store dashboard](http://dash.cloudflare.com/?to=/:account/secrets-store), or the [API](https://developers.cloudflare.com/api/resources/secrets_store/).

   Then, pass the key in the request header using its Secrets Store reference:

   ```plaintext
   curl -X POST https://gateway.ai.cloudflare.com/v1/<ACCOUNT_ID>/my-gateway/anthropic/v1/messages \
    --header 'cf-aig-authorization: ANTHROPIC_KEY_1 \
    --header 'anthropic-version: 2023-06-01' \
    --header 'Content-Type: application/json' \
    --data  '{"model": "claude-3-opus-20240229", "messages": [{"role": "user", "content": "What is Cloudflare?"}]}'
   ```

   Or, using Javascript:

   ```plaintext
   import Anthropic from '@anthropic-ai/sdk';




   const anthropic = new Anthropic({
    apiKey: "ANTHROPIC_KEY_1",
    baseURL: "https://gateway.ai.cloudflare.com/v1/<ACCOUNT_ID>/my-gateway/anthropic",
   });




   const message = await anthropic.messages.create({
    model: 'claude-3-opus-20240229',
    messages: [{role: "user", content: "What is Cloudflare?"}],
    max_tokens: 1024
   });
   ```

   For more information, check out the [blog](https://blog.cloudflare.com/ai-gateway-aug-2025-refresh)!

Aug 25, 2025

1. ### [New DLP topic based detection entries for AI prompt protection](https://developers.cloudflare.com/changelog/2025-08-25-ai-prompt-protection/)

   [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

   You now have access to a comprehensive suite of capabilities to secure your organization's use of generative AI. AI prompt protection introduces four key features that work together to provide deep visibility and granular control.

   1. **Prompt Detection for AI Applications**

   DLP can now natively detect and inspect user prompts submitted to popular AI applications, including **Google Gemini**, **ChatGPT**, **Claude**, and **Perplexity**.

   1. **Prompt Analysis and Topic Classification**

   Our DLP engine performs deep analysis on each prompt, applying [topic classification](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#ai-prompt-topics). These topics are grouped into two evaluation categories:

   * **Content:** PII, Source Code, Credentials and Secrets, Financial Information, and Customer Data.

   * **Intent:** Jailbreak attempts, requests for malicious code, or attempts to extract PII.

   To help you apply these topics quickly, we have also released five new predefined profiles (for example, AI Prompt: AI Security, AI Prompt: PII) that bundle these new topics.

   ![DLP](https://developers.cloudflare.com/_astro/ai-prompt-detection-entry.4QmdkAuv_1OGLqX.webp)

   1. **Granular Guardrails**

      You can now build guardrails using Gateway HTTP policies with [application granular controls](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#application-granular-controls). Apply a DLP profile containing an [AI prompt topic detection](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#ai-prompt-topics) to individual AI applications (for example, `ChatGPT`) and specific user actions (for example, `SendPrompt`) to block sensitive prompts.

      ![DLP](https://developers.cloudflare.com/_astro/ai-prompt-policy.CF3H2rbK_Z1leRrd.webp)

   2. **Full Prompt Logging**

      To aid in incident investigation, an optional setting in your Gateway policy allows you to [capture prompt logs](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#log-generative-ai-prompt-content) to store the full interaction of prompts that trigger a policy match. To make investigations easier, logs can be filtered by `conversation_id`, allowing you to reconstruct the full context of an interaction that led to a policy violation.

      ![DLP](https://developers.cloudflare.com/_astro/ai-prompt-log.ywQDc5qN_285cvc.webp)

   AI prompt protection is now available in open beta. To learn more about it, read the [blog](https://blog.cloudflare.com/ai-prompt-protection/#closing-the-loop-logging) or refer to [AI prompt topics](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#ai-prompt-topics).

Aug 22, 2025

1. ### [Workers KV completes hybrid storage provider rollout for improved performance, fault-tolerance](https://developers.cloudflare.com/changelog/2025-08-22-kv-performance-improvements/)

   [KV](https://developers.cloudflare.com/kv/)

   Workers KV has completed rolling out performance improvements across all KV namespaces, providing a significant latency reduction on read operations for all KV users. This is due to architectural changes to KV's underlying storage infrastructure, which introduces a new metadata later and substantially improves redundancy.

   ![Workers KV latency improvements showing P95 and P99 performance gains in Europe, Asia, Africa and Middle East regions as measured within KV's internal storage gateway worker.](https://developers.cloudflare.com/_astro/kv-hybrid-providers-performance-improvements.D6MBO22S_2bAJJA.webp)

   #### Performance improvements

   The new hybrid architecture delivers substantial latency reductions throughout Europe, Asia, Middle East, Africa regions. Over the past 2 weeks, we have observed the following:

   * **p95 latency**: Reduced from \~150ms to \~50ms (67% decrease)
   * **p99 latency**: Reduced from \~350ms to \~250ms (29% decrease)

Aug 22, 2025

1. ### [Audit logs (version 2) - Logpush Beta Release](https://developers.cloudflare.com/changelog/2025-08-22-audit-logs-v2-logpush/)

   [Audit Logs](https://developers.cloudflare.com/fundamentals/account/account-security/review-audit-logs/)

   [Audit Logs v2 dataset](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/audit_logs_v2/) is now available via Logpush.

   This expands on earlier releases of Audit Logs v2 in the [API](https://developers.cloudflare.com/changelog/2025-03-27-automatic-audit-logs-beta-release/) and [Dashboard UI](https://developers.cloudflare.com/changelog/2025-07-29-audit-logs-v2-ui-beta/).

   We recommend creating a new Logpush job for the Audit Logs v2 dataset.

   Timelines for General Availability (GA) of Audit Logs v2 and the retirement of Audit Logs v1 will be shared in upcoming updates.

   For more details on Audit Logs v2, refer to the [Audit Logs documentation](https://developers.cloudflare.com/fundamentals/account/account-security/audit-logs/).

Aug 22, 2025

1. ### [Dedicated Egress IP for Logpush](https://developers.cloudflare.com/changelog/2025-08-22-dedicated-egress-ip-logpush/)

   [Logs](https://developers.cloudflare.com/logs/)

   Cloudflare Logpush can now deliver logs from using fixed, dedicated egress IPs. By routing Logpush traffic through a Cloudflare zone enabled with [Aegis IP](https://developers.cloudflare.com/smart-shield/configuration/dedicated-egress-ips/), your log destination only needs to allow Aegis IPs making setup more secure.

   Highlights:

   * Fixed egress IPs ensure your destination only accepts traffic from known addresses.
   * Works with any supported Logpush destination.
   * Recommended to use a dedicated zone as a proxy for easier management.

   To get started, work with your Cloudflare account team to provision Aegis IPs, then configure your Logpush job to deliver logs through the proxy zone. For full setup instructions, refer to the [Logpush documentation](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/egress-ip/).

Aug 22, 2025

1. ### [Build durable multi-step applications in Python with Workflows (now in beta)](https://developers.cloudflare.com/changelog/2025-08-22-workflows-python-beta/)

   [Workflows ](https://developers.cloudflare.com/workflows/)[Workers](https://developers.cloudflare.com/workers/)

   You can now build [Workflows](https://developers.cloudflare.com/workflows/) using Python. With Python Workflows, you get automatic retries, state persistence, and the ability to run multi-step operations that can span minutes, hours, or weeks using Python’s familiar syntax and the [Python Workers](https://developers.cloudflare.com/workers/languages/python/) runtime.

   Python Workflows use the same step-based execution model as JavaScript Workflows, but with Python syntax and access to Python’s ecosystem. Python Workflows also enable [DAG (Directed Acyclic Graph) workflows](https://developers.cloudflare.com/workflows/python/dag/), where you can define complex dependencies between steps using the depends parameter.

   Here’s a simple example:

   ```python
   from workers import Response, WorkflowEntrypoint


   class PythonWorkflowStarter(WorkflowEntrypoint):
       async def run(self, event, step):
           @step.do("my first step")
           async def my_first_step():
               # do some work
               return "Hello Python!"


           await my_first_step()


           await step.sleep("my-sleep-step", "10 seconds")


           @step.do("my second step")
           async def my_second_step():
               # do some more work
               return "Hello again!"


           await my_second_step()


   async def on_fetch(request, env):
       await env.MY_WORKFLOW.create()
       return Response("Hello Workflow creation!")
   ```

   Note

   Python Workflows requires a `compatibility_date = "2025-08-01"`, or lower, in your wrangler toml file.

   Python Workflows support the same core capabilities as JavaScript Workflows, including sleep scheduling, event-driven workflows, and built-in error handling with configurable retry policies.

   To learn more and get started, refer to [Python Workflows documentation](https://developers.cloudflare.com/workflows/python/).

Aug 21, 2025

1. ### [New getByName() API to access Durable Objects](https://developers.cloudflare.com/changelog/2025-08-21-durable-objects-get-by-name/)

   [Durable Objects ](https://developers.cloudflare.com/durable-objects/)[Workers](https://developers.cloudflare.com/workers/)

   You can now create a client (a [Durable Object stub](https://developers.cloudflare.com/durable-objects/api/stub/)) to a Durable Object with the new `getByName` method, removing the need to convert Durable Object names to IDs and then create a stub.

   ```js
   // Before: (1) translate name to ID then (2) get a client
   const objectId = env.MY_DURABLE_OBJECT.idFromName("foo"); // or .newUniqueId()
   const stub = env.MY_DURABLE_OBJECT.get(objectId);


   // Now: retrieve client to Durable Object directly via its name
   const stub = env.MY_DURABLE_OBJECT.getByName("foo");


   // Use client to send request to the remote Durable Object
   const rpcResponse = await stub.sayHello();
   ```

   Each Durable Object has a globally-unique name, which allows you to send requests to a specific object from anywhere in the world. Thus, a Durable Object can be used to coordinate between multiple clients who need to work together. You can have billions of Durable Objects, providing isolation between application tenants.

   To learn more, visit the Durable Objects [API Documentation](https://developers.cloudflare.com/durable-objects/api/namespace/#getbyname) or the [getting started guide](https://developers.cloudflare.com/durable-objects/get-started/).

Aug 19, 2025

1. ### [Subscribe to events from Cloudflare services with Queues](https://developers.cloudflare.com/changelog/2025-08-19-event-subscriptions/)

   [Queues](https://developers.cloudflare.com/queues/)

   You can now subscribe to events from other Cloudflare services (for example, [Workers KV](https://developers.cloudflare.com/kv/), [Workers AI](https://developers.cloudflare.com/workers-ai), [Workers](https://developers.cloudflare.com/workers)) and consume those events via [Queues](https://developers.cloudflare.com/queues/), allowing you to build custom workflows, integrations, and logic in response to account activity.

   ![Event subscriptions architecture](https://developers.cloudflare.com/_astro/queues-event-subscriptions.3aVidnXJ_1iozIn.webp)

   Event subscriptions allow you to receive messages when events occur across your Cloudflare account. Cloudflare products can publish structured events to a queue, which you can then consume with [Workers](https://developers.cloudflare.com/workers/) or [pull via HTTP from anywhere](https://developers.cloudflare.com/queues/configuration/pull-consumers/).

   To create a subscription, use the dashboard or [Wrangler](https://developers.cloudflare.com/workers/wrangler/commands/#subscription-create):

   ```bash
   npx wrangler queues subscription create my-queue --source r2 --events bucket.created
   ```

   An event is a structured record of something happening in your Cloudflare account – like a Workers AI batch request being queued, a Worker build completing, or an R2 bucket being created. Events follow a consistent structure:

   ```json
   {
     "type": "cf.r2.bucket.created",
     "source": {
       "type": "r2"
     },
     "payload": {
       "name": "my-bucket",
       "location": "WNAM"
     },
     "metadata": {
       "accountId": "f9f79265f388666de8122cfb508d7776",
       "eventTimestamp": "2025-07-28T10:30:00Z"
     }
   }
   ```

   Current [event sources](https://developers.cloudflare.com/queues/event-subscriptions/events-schemas/) include [R2](https://developers.cloudflare.com/r2/), [Workers KV](https://developers.cloudflare.com/kv/), [Workers AI](https://developers.cloudflare.com/workers-ai/), [Workers Builds](https://developers.cloudflare.com/workers/ci-cd/builds/), [Vectorize](https://developers.cloudflare.com/vectorize/), [Super Slurper](https://developers.cloudflare.com/r2/data-migration/super-slurper/), and [Workflows](https://developers.cloudflare.com/workflows/). More sources and events are on the way.

   For more information on event subscriptions, available events, and how to get started, refer to our [documentation](https://developers.cloudflare.com/queues/event-subscriptions/).

Aug 15, 2025

1. ### [SFTP support for SSH with Cloudflare Access for Infrastructure](https://developers.cloudflare.com/changelog/2025-08-15-sftp/)

   [Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)

   [SSH with Cloudflare Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/) now supports SFTP. It is compatible with SFTP clients, such as Cyberduck.

Aug 15, 2025

1. ### [Steer Traffic by AS Number in Load Balancing Custom Rules](https://developers.cloudflare.com/changelog/2025-08-15-asnum-support-in-custom-rules/)

   [Load Balancing](https://developers.cloudflare.com/load-balancing/)

   You can now create more granular, network-aware Custom Rules in Cloudflare Load Balancing using the Autonomous System Number (ASN) of an incoming request.

   This allows you to steer traffic with greater precision based on the network source of a request. For example, you can route traffic from specific Internet Service Providers (ISPs) or enterprise customers to dedicated infrastructure, optimize performance, or enforce compliance by directing certain networks to preferred data centers.

   ![Create a Load Balancing Custom Rule using AS Num](https://developers.cloudflare.com/_astro/asnum-custom-rule.CtcHu_zj_2bK7ax.webp)

   To get started, create a [Custom Rule](https://developers.cloudflare.com/load-balancing/additional-options/load-balancing-rules/) in your Load Balancer and select **AS Num** from the **Field** dropdown.

Aug 15, 2025

1. ### [Save time with bulk query creation in Brand Protection](https://developers.cloudflare.com/changelog/2025-08-15-brand-protection-bulk-endpoint/)

   [Security Center](https://developers.cloudflare.com/security-center/)

   [Brand Protection](https://developers.cloudflare.com/security-center/brand-protection/) detects domains that may be impersonating your brand — from common misspellings (`cloudfalre.com`) to malicious concatenations (`cloudflare-okta.com`). Saved search queries run continuously and alert you when suspicious domains appear.

   You can now create and save multiple queries in a single step, streamlining setup and management. Available now via the [Brand Protection bulk query creation API](https://developers.cloudflare.com/api/resources/brand_protection/subresources/queries/methods/bulk/).

Aug 15, 2025

1. ### [Terraform v5.8.4 now available](https://developers.cloudflare.com/changelog/2025-08-15-terraform-v584-provider/)

   [Cloudflare Fundamentals ](https://developers.cloudflare.com/fundamentals/)[Terraform](https://developers.cloudflare.com/terraform/)

   Earlier this year, we announced the launch of the new [Terraform v5 Provider](https://developers.cloudflare.com/changelog/2025-02-03-terraform-v5-provider/). We are aware of the high number of [issues](https://github.com/cloudflare/terraform-provider-cloudflare) reported by the Cloudflare Community related to the v5 release. We have committed to releasing improvements on a two week cadence to ensure stability and reliability.

   One key change we adopted in recent weeks is a pivot to more comprehensive, test-driven development. We are still evaluating individual issues, but are also investing in much deeper testing to drive our stabilization efforts. We will subsequently be investing in comprehensive migration scripts. As a result, you will see several of the highest traffic APIs have been stabilized in the most recent release, and are supported by comprehensive acceptance tests.

   Thank you for continuing to raise issues. We triage them weekly and they help make our products stronger.

   #### Changes

   * Resources stabilized:

     * `cloudflare_argo_smart_routing`
     * `cloudflare_bot_management`
     * `cloudflare_list`
     * `cloudflare_list_item`
     * `cloudflare_load_balancer`
     * `cloudflare_load_balancer_monitor`
     * `cloudflare_load_balancer_pool`
     * `cloudflare_spectrum_application`
     * `cloudflare_managed_transforms`
     * `cloudflare_url_normalization_settings`
     * `cloudflare_snippet`
     * `cloudflare_snippet_rules`
     * `cloudflare_zero_trust_access_application`
     * `cloudflare_zero_trust_access_group`
     * `cloudflare_zero_trust_access_identity_provider`
     * `cloudflare_zero_trust_access_mtls_certificate`
     * `cloudflare_zero_trust_access_mtls_hostname_settings`
     * `cloudflare_zero_trust_access_policy`
     * `cloudflare_zone`

   * Multipart handling restored for `cloudflare_snippet`

   * `cloudflare_bot_management` diff issues resolves when running `terraform plan` and `terraform apply`

   * Other bug fixes

   For a more detailed look at all of the changes, refer to the [changelog](https://github.com/cloudflare/terraform-provider-cloudflare/releases/tag/v5.8.4) in GitHub.

   #### Issues Closed

   * [#5017: 'Uncaught Error: No such module' using cloudflare\_snippets](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5017)
   * [#5701: cloudflare\_workers\_script migrations for Durable Objects not recorded in tfstate; cannot be upgraded between versions](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5701)
   * [#5640: cloudflare\_argo\_smart\_routing importing doesn't read the actual value](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5640)

   If you have an unaddressed issue with the provider, we encourage you to check the [open issues](https://github.com/cloudflare/terraform-provider-cloudflare/issues) and open a new one if one does not already exist for what you are experiencing.

   #### Upgrading

   We suggest holding off on migration to v5 while we work on stablization. This help will you avoid any blocking issues while the Terraform resources are actively being stablized.

   If you'd like more information on migrating to v5, please make use of the [migration guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade). We have provided automated migration scripts using Grit which simplify the transition. These migration scripts do not support implementations which use Terraform modules, so customers making use of modules need to migrate manually. Please make use of `terraform plan` to test your changes before applying, and let us know if you encounter any additional issues by reporting to our [GitHub repository](https://github.com/cloudflare/terraform-provider-cloudflare).

   #### For more info

   * [Terraform provider](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs)
   * [Documentation on using Terraform with Cloudflare](https://developers.cloudflare.com/terraform/)

Aug 13, 2025

1. ### [IBM Cloud Logs as Logpush destination](https://developers.cloudflare.com/changelog/2025-08-13-ibm-cloud-logs-destination/)

   [Logs](https://developers.cloudflare.com/logs/)

   Cloudflare Logpush now supports IBM Cloud Logs as a native destination.

   Logs from Cloudflare can be sent to [IBM Cloud Logs](https://www.ibm.com/products/cloud-logs) via [Logpush](https://developers.cloudflare.com/logs/logpush/). The setup can be done through the Logpush UI in the Cloudflare Dashboard or by using the [Logpush API](https://developers.cloudflare.com/api/resources/logpush/subresources/jobs/). The integration requires IBM Cloud Logs HTTP Source Address and an IBM API Key. The feature also allows for filtering events and selecting specific log fields.

   For more information, refer to [Destination Configuration](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/ibm-cloud-logs/) documentation.

Aug 08, 2025

1. ### [Introducing observability and metrics for Stream Live Inputs](https://developers.cloudflare.com/changelog/2025-08-08-stream-live-observability/)

   [Stream](https://developers.cloudflare.com/stream/)

   New information about broadcast metrics and events is now available in [Cloudflare Stream](https://developers.cloudflare.com/stream/) in the Live Input details of the Dashboard.

   ![Live Input details showing metrics](https://developers.cloudflare.com/_astro/2025-08-05-live-input-metrics.B31Z3RGB_Z1cAx2K.webp)

   You can now easily understand broadcast-side health and performance with new observability, which can help when troubleshooting common issues, particularly for new customers who are just getting started, and platform customers who may have limited visibility into how their end-users configure their encoders.

   To get started, start a live stream ([just getting started?](https://developers.cloudflare.com/stream/examples/obs-from-scratch/)), then visit the Live Input details page in Dash.

   See our new live [Troubleshooting](https://developers.cloudflare.com/stream/stream-live/troubleshooting/) guide to learn what these metrics mean and how to use them to address common broadcast issues.

Aug 06, 2025

1. ### [Improvements to Monitoring Using Zone Settings](https://developers.cloudflare.com/changelog/2025-08-06-zone-monitoring-improvements/)

   [Load Balancing](https://developers.cloudflare.com/load-balancing/)

   Cloudflare Load Balancing Monitors support loading and applying settings for a specific zone to monitoring requests to origin endpoints. This feature has been migrated to new infrastructure to improve reliability, performance, and accuracy.

   All zone monitors have been tested against the new infrastructure. There should be no change to health monitoring results of currently healthy and active pools. Newly created or re-enabled pools may need validation of their monitor zone settings before being introduced to service, especially regarding correct application of mTLS.

   #### What you can expect:

   * More reliable application of zone settings to monitoring requests, including

     * Authenticated Origin Pulls
     * Aegis Egress IP Pools
     * Argo Smart Routing
     * HTTP/2 to Origin

   * Improved support and bug fixes for retries, redirects, and proxied origin resolution

   * Improved performance and reliability of monitoring requests withing the Cloudflare network

   * Unrelated CDN or WAF configuration changes should have no risk of impact to pool health

Aug 06, 2025

1. ### [Certificate Transparency Insights in Cloudflare Radar](https://developers.cloudflare.com/changelog/2025-08-04-radar-ct-insights/)

   [Radar](https://developers.cloudflare.com/radar/)

   [**Radar**](https://developers.cloudflare.com/radar/) now introduces Certificate Transparency (CT) insights, providing visibility into certificate issuance trends based on Certificate Transparency logs currently monitored by Cloudflare.

   The following API endpoints are now available:

   * [`/ct/timeseries`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/methods/timeseries/): Retrieves certificate issuance time series.
   * [`/ct/summary/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/methods/summary/): Retrieves certificate distribution by dimension.
   * [`/ct/timeseries_groups/{dimension}`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/methods/timeseries_groups/): Retrieves time series of certificate distribution by dimension.
   * [`/ct/authorities`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/subresources/authorities/methods/list/): Lists certification authorities.
   * [`/ct/authorities/{ca_slug}`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/subresources/authorities/methods/get/): Retrieves details about a Certification Authority (CA). CA information is derived from the [Common CA Database (CCADB)](https://www.ccadb.org/).
   * [`/ct/logs`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/subresources/logs/methods/list/): Lists CT logs.
   * [`/ct/logs/{log_slug}`](https://developers.cloudflare.com/api/resources/radar/subresources/ct/subresources/logs/methods/get/): Retrieves details about a CT log. CT log information is derived from the [Google Chrome log list](https://googlechrome.github.io/CertificateTransparency/log_lists.html).

   For the `summary` and `timeseries_groups` endpoints, the following dimensions are available (and also usable as filters):

   * `ca`: Certification Authority (certificate issuer)
   * `ca_owner`: Certification Authority Owner
   * `duration`: Certificate validity duration (between NotBefore and NotAfter dates)
   * `entry_type`: Entry type (certificate vs. pre-certificate)
   * `expiration_status`: Expiration status (valid vs. expired)
   * `has_ips`: Presence of IP addresses in certificate [Subject Alternative Names (SANs)](https://developers.cloudflare.com/ssl/origin-configuration/origin-ca/#hostname-and-wildcard-coverage)
   * `has_wildcards`: Presence of wildcard DNS names in certificate SANs
   * `log`: CT log name
   * `log_api`: CT log API ([RFC6962](https://datatracker.ietf.org/doc/html/rfc6962) vs. [Static](https://c2sp.org/static-ct-api))
   * `log_operator`: CT log operator
   * `public_key_algorithm`: Public key algorithm of certificate's key
   * `signature_algorithm`: Signature algorithm used by CA to sign certificate
   * `tld`: Top-level domain for DNS names found in certificates SANs
   * `validation_level`: [Validation level](https://www.cloudflare.com/learning/ssl/types-of-ssl-certificates/)

   Check out the new Certificate Transparency insights in the [new Radar page](https://radar.cloudflare.com/certificate-transparency).

Aug 05, 2025

1. ### [Agents SDK adds MCP Elicitation support, http-streamable suppport, task queues, email integration and more](https://developers.cloudflare.com/changelog/2025-08-05-agents-mcp-update/)

   [Agents ](https://developers.cloudflare.com/agents/)[Workers](https://developers.cloudflare.com/workers/)

   The latest releases of [@cloudflare/agents](https://github.com/cloudflare/agents) brings major improvements to MCP transport protocols support and agents connectivity. Key updates include:

   #### MCP elicitation support

   MCP servers can now request user input during tool execution, enabling interactive workflows like confirmations, forms, and multi-step processes. This feature uses durable storage to preserve elicitation state even during agent hibernation, ensuring seamless user interactions across agent lifecycle events.

   ```ts
   // Request user confirmation via elicitation
   const confirmation = await this.elicitInput({
     message: `Are you sure you want to increment the counter by ${amount}?`,
     requestedSchema: {
       type: "object",
       properties: {
         confirmed: {
           type: "boolean",
           title: "Confirm increment",
           description: "Check to confirm the increment",
         },
       },
       required: ["confirmed"],
     },
   });
   ```

   Check out our [demo](https://github.com/whoiskatrin/agents/tree/main/examples/mcp-elicitation-demo) to see elicitation in action.

   #### HTTP streamable transport for MCP

   MCP now supports HTTP streamable transport which is recommended over SSE. This transport type offers:

   * **Better performance**: More efficient data streaming and reduced overhead
   * **Improved reliability**: Enhanced connection stability and error recover- **Automatic fallback**: If streamable transport is not available, it gracefully falls back to SSE

   ```ts
   export default MyMCP.serve("/mcp", {
     binding: "MyMCP",
   });
   ```

   The SDK automatically selects the best available transport method, gracefully falling back from streamable-http to SSE when needed.

   #### Enhanced MCP connectivity

   Significant improvements to MCP server connections and transport reliability:

   * **Auto transport selection**: Automatically determines the best transport method, falling back from streamable-http to SSE as needed
   * **Improved error handling**: Better connection state management and error reporting for MCP servers
   * **Reliable prop updates**: Centralized agent property updates ensure consistency across different contexts

   #### Lightweight .queue for fast task deferral

   You can use `.queue()` to enqueue background work — ideal for tasks like processing user messages, sending notifications etc.

   ```ts
   class MyAgent extends Agent {
     doSomethingExpensive(payload) {
       // a long running process that you want to run in the background
     }


     queueSomething() {
       await this.queue("doSomethingExpensive", somePayload); // this will NOT block further execution, and runs in the background
       await this.queue("doSomethingExpensive", someOtherPayload); // the callback will NOT run until the previous callback is complete
       // ... call as many times as you want
     }
   }
   ```

   Want to try it yourself? Just define a method like processMessage in your agent, and you’re ready to scale.

   #### New email adapter

   Want to build an AI agent that can receive and respond to emails automatically? With the new email adapter and onEmail lifecycle method, now you can.

   ```ts
   export class EmailAgent extends Agent {
     async onEmail(email: AgentEmail) {
       const raw = await email.getRaw();
       const parsed = await PostalMime.parse(raw);


       // create a response based on the email contents
       // and then send a reply


       await this.replyToEmail(email, {
         fromName: "Email Agent",
         body: `Thanks for your email! You've sent us "${parsed.subject}". We'll process it shortly.`,
       });
     }
   }
   ```

   You route incoming mail like this:

   ```ts
   export default {
     async email(email, env) {
       await routeAgentEmail(email, env, {
         resolver: createAddressBasedEmailResolver("EmailAgent"),
       });
     },
   };
   ```

   You can find a full example [here](https://github.com/cloudflare/agents/tree/main/examples/email-agent).

   #### Automatic context wrapping for custom methods

   Custom methods are now automatically wrapped with the agent's context, so calling `getCurrentAgent()` should work regardless of where in an agent's lifecycle it's called. Previously this would not work on RPC calls, but now just works out of the box.

   ```ts
   export class MyAgent extends Agent {
     async suggestReply(message) {
       // getCurrentAgent() now correctly works, even when called inside an RPC method
       const { agent } = getCurrentAgent()!;
       return generateText({
         prompt: `Suggest a reply to: "${message}" from "${agent.name}"`,
         tools: [replyWithEmoji],
       });
     }
   }
   ```

   Try it out and tell us what you build!

Aug 05, 2025

1. ### [Cloudflare Sandbox SDK adds streaming, code interpreter, Git support, process control and more](https://developers.cloudflare.com/changelog/2025-08-05-sandbox-sdk-major-update/)

   [Agents ](https://developers.cloudflare.com/agents/)[Workers](https://developers.cloudflare.com/workers/)

   We’ve shipped a major release for the [@cloudflare/sandbox](https://github.com/cloudflare/sandbox-sdk) SDK, turning it into a full-featured, container-based execution platform that runs securely on Cloudflare Workers.

   This update adds live streaming of output, persistent Python and JavaScript code interpreters with rich output support (charts, tables, HTML, JSON), file system access, Git operations, full background process control, and the ability to expose running services via public URLs.

   This makes it ideal for building AI agents, CI runners, cloud REPLs, data analysis pipelines, or full developer tools — all without managing infrastructure.

   #### Code interpreter (Python, JS, TS)

   Create persistent code contexts with support for rich visual + structured outputs.

   #### createCodeContext(options)

   Creates a new code execution context with persistent state.

   ```ts
   // Create a Python context
   const pythonCtx = await sandbox.createCodeContext({ language: "python" });


   // Create a JavaScript context
   const jsCtx = await sandbox.createCodeContext({ language: "javascript" });
   ```

   Options:

   * language: Programming language ('python' | 'javascript' | 'typescript')
   * cwd: Working directory (default: /workspace)
   * envVars: Environment variables for the context

   #### runCode(code, options)

   Executes code with optional streaming callbacks.

   ```ts
   // Simple execution
   const execution = await sandbox.runCode('print("Hello World")', {
     context: pythonCtx,
   });


   // With streaming callbacks
   await sandbox.runCode(
     `
   for i in range(5):
       print(f"Step {i}")
       time.sleep(1)
   `,
     {
       context: pythonCtx,
       onStdout: (output) => console.log("Real-time:", output.text),
       onResult: (result) => console.log("Result:", result),
     },
   );
   ```

   Options:

   * language: Programming language ('python' | 'javascript' | 'typescript')
   * cwd: Working directory (default: /workspace)
   * envVars: Environment variables for the context

   #### Real-time streaming output

   Returns a streaming response for real-time processing.

   ```ts
   const stream = await sandbox.runCodeStream(
     "import time; [print(i) for i in range(10)]",
   );
   // Process the stream as needed
   ```

   #### Rich output handling

   Interpreter outputs are auto-formatted and returned in multiple formats:

   * text
   * html (e.g., Pandas tables)
   * png, svg (e.g., Matplotlib charts)
   * json (structured data)
   * chart (parsed visualizations)

   ```ts
   const result = await sandbox.runCode(
     `
   import seaborn as sns
   import matplotlib.pyplot as plt


   data = sns.load_dataset("flights")
   pivot = data.pivot("month", "year", "passengers")
   sns.heatmap(pivot, annot=True, fmt="d")
   plt.title("Flight Passengers")
   plt.show()


   pivot.to_dict()
   `,
     { context: pythonCtx },
   );


   if (result.png) {
     console.log("Chart output:", result.png);
   }
   ```

   #### Preview URLs from Exposed Ports

   Start background processes and expose them with live URLs.

   ```ts
   await sandbox.startProcess("python -m http.server 8000");
   const preview = await sandbox.exposePort(8000);


   console.log("Live preview at:", preview.url);
   ```

   #### Full process lifecycle control

   Start, inspect, and terminate long-running background processes.

   ```ts
   const process = await sandbox.startProcess("node server.js");
   console.log(`Started process ${process.id} with PID ${process.pid}`);


   // Monitor the process
   const logStream = await sandbox.streamProcessLogs(process.id);
   for await (const log of parseSSEStream<LogEvent>(logStream)) {
     console.log(`Server: ${log.data}`);
   }
   ```

   * listProcesses() - List all running processes
   * getProcess(id) - Get detailed process status
   * killProcess(id, signal) - Terminate specific processes
   * killAllProcesses() - Kill all processes
   * streamProcessLogs(id, options) - Stream logs from running processes
   * getProcessLogs(id) - Get accumulated process output

   #### Git integration

   Clone Git repositories directly into the sandbox.

   ```ts
   await sandbox.gitCheckout("https://github.com/user/repo", {
     branch: "main",
     targetDir: "my-project",
   });
   ```

   Sandboxes are still experimental. We're using them to explore how isolated, container-like workloads might scale on Cloudflare — and to help define the developer experience around them.

Aug 05, 2025

1. ### [OpenAI open models now available on Workers AI](https://developers.cloudflare.com/changelog/2025-08-05-openai-open-models/)

   [Agents ](https://developers.cloudflare.com/agents/)[Workers AI](https://developers.cloudflare.com/workers-ai/)

   We're thrilled to be a Day 0 partner with [OpenAI](http://openai.com/index/introducing-gpt-oss) to bring their [latest open models](https://openai.com/index/gpt-oss-model-card/) to Workers AI, including support for Responses API, Code Interpreter, and Web Search (coming soon).

   Get started with the new models at `@cf/openai/gpt-oss-120b` and `@cf/openai/gpt-oss-20b`. Check out the [blog](https://blog.cloudflare.com/openai-gpt-oss-on-workers-ai) for more details about the new models, and the [`gpt-oss-120b`](https://developers.cloudflare.com/workers-ai/models/gpt-oss-120b) and [`gpt-oss-20b`](https://developers.cloudflare.com/workers-ai/models/gpt-oss-20b) model pages for more information about pricing and context windows.

   #### Responses API

   If you call the model through:

   * Workers Binding, it will accept/return Responses API – `env.AI.run(“@cf/openai/gpt-oss-120b”)`
   * REST API on `/run` endpoint, it will accept/return Responses API – `https://api.cloudflare.com/client/v4/accounts/<account_id>/ai/run/@cf/openai/gpt-oss-120b`
   * REST API on new `/responses` endpoint, it will accept/return Responses API – `https://api.cloudflare.com/client/v4/accounts/<account_id>/ai/v1/responses`
   * REST API for OpenAI Compatible endpoint, it will return Chat Completions (coming soon) – `https://api.cloudflare.com/client/v4/accounts/<account_id>/ai/v1/chat/completions`

   ```plaintext
   curl https://api.cloudflare.com/client/v4/accounts/<account_id>/ai/v1/responses \
     -H "Content-Type: application/json" \
     -H "Authorization: Bearer $CLOUDFLARE_API_KEY" \
     -d '{
       "model": "@cf/openai/gpt-oss-120b",
       "reasoning": {"effort": "medium"},
       "input": [
         {
           "role": "user",
           "content": "What are the benefits of open-source models?"
         }
       ]
     }'
   ```

   #### Code Interpreter

   The model is natively trained to support stateful code execution, and we've implemented support for this feature using our [Sandbox SDK](https://github.com/cloudflare/sandbox-sdk) and [Containers](https://blog.cloudflare.com/containers-are-available-in-public-beta-for-simple-global-and-programmable/). Cloudflare's Developer Platform is uniquely positioned to support this feature, so we're very excited to bring our products together to support this new use case.

   #### Web Search (coming soon)

   We are working to implement Web Search for the model, where users can bring their own Exa API Key so the model can browse the Internet.

Aug 01, 2025

1. ### [Terraform v5.8.2 now available](https://developers.cloudflare.com/changelog/2025-08-01-terraform-v582-provider/)

   [Cloudflare Fundamentals ](https://developers.cloudflare.com/fundamentals/)[Terraform](https://developers.cloudflare.com/terraform/)

   Earlier this year, we announced the launch of the new [Terraform v5 Provider](https://developers.cloudflare.com/changelog/2025-02-03-terraform-v5-provider/). We are aware of the high mumber of [issues](https://github.com/cloudflare/terraform-provider-cloudflare) reported by the Cloudflare community related to the v5 release. We have committed to releasing improvements on a 2 week cadeance to ensure it's stability and reliability. We have also pivoted from an issue-to-issue approach to a resource-per-resource approach - we will be focusing on specific resources for every release, stablizing the release and closing all associated bugs with that resource before moving onto resolving migration issues.

   Thank you for continuing to raise issues. We triage them weekly and they help make our products stronger.

   #### Changes

   * Resources stablized:

     * `cloudflare_custom_pages`
     * `cloudflare_page_rule`
     * `cloudflare_dns_record`
     * `cloudflare_argo_tiered_caching`

   * Addressed chronic drift issues in `cloudflare_logpush_job`, `cloudflare_zero_trust_dns_location`, `cloudflare_ruleset` & `cloudflare_api_token`

   * `cloudflare_zone_subscripton` returns expected values `rate_plan.id` from former versions

   * `cloudflare_workers_script` can now successfully be destroyed with bindings & migration for Durable Objects now recorded in tfstate

   * Ability to configure `add_headers` under `cloudflare_zero_trust_gateway_policy`

   * Other bug fixes

   For a more detailed look at all of the changes, see the [changelog](https://github.com/cloudflare/terraform-provider-cloudflare/releases/tag/v5.8.2) in GitHub.

   #### Issues Closed

   * [#5666: cloudflare\_ruleset example lists id which is a read-only field](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5666)
   * [#5578: cloudflare\_logpush\_job plan always suggests changes](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5578)
   * [#5552: 5.4.0: Since provider update, existing cloudflare\_list\_item would be recreated "created" state](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5552)
   * [#5670: cloudflare\_zone\_subscription: uses wrong ID field in Read/Update](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5670)
   * [#5548: cloudflare\_api\_token resource always shows changes (drift)](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5548)
   * [#5634: cloudflare\_workers\_script with bindings fails to be destroyed](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5634)
   * [#5616: cloudflare\_workers\_script Unable to deploy worker assets](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5616)
   * [#5331: cloudflare\_workers\_script 500 internal server error when uploading python](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5331)
   * [#5701: cloudflare\_workers\_script migrations for Durable Objects not recorded in tfstate; cannot be upgraded between versions](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5701)
   * [#5704: cloudflare\_workers\_script randomly fails to deploy when changing compatibility\_date](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5704)
   * [#5439: cloudflare\_workers\_script (v5.2.0) ignoring content and bindings properties](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5439)
   * [#5522: cloudflare\_workers\_script always detects changes after apply](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5522)
   * [#5693: cloudflare\_zero\_trust\_access\_identity\_provider gives recurring change on OTP pin login](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5693)
   * [#5567: cloudflare\_r2\_custom\_domain doesn't roundtrip jurisdiction properly](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5567)
   * [#5179: Bad request with when creating cloudflare\_api\_shield\_schema resource](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5179)

   If you have an unaddressed issue with the provider, we encourage you to check the [open issues](https://github.com/cloudflare/terraform-provider-cloudflare/issues) and open a new one if one does not already exist for what you are experiencing.

   #### Upgrading

   We suggest holding off on migration to v5 while we work on stablization. This help will you avoid any blocking issues while the Terraform resources are actively being stablized.

   If you'd like more information on migrating from v4 to v5, please make use of the [migration guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade). We have provided automated migration scripts using Grit which simplify the transition, although these do not support implementations which use Terraform modules, so customers making use of modules need to migrate manually. Please make use of `terraform plan` to test your changes before applying, and let us know if you encounter any additional issues by reporting to our [GitHub repository](https://github.com/cloudflare/terraform-provider-cloudflare).

   #### For more info

   * [Terraform provider](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs)
   * [Documentation on using Terraform with Cloudflare](https://developers.cloudflare.com/terraform/)

Jul 30, 2025

1. ### [Magic Transit and Magic WAN health check data is fully compatible with the CMB EU setting.](https://developers.cloudflare.com/changelog/2025-07-30-mt-mwan-health-check-cmb-eu/)

   [Magic Transit ](https://developers.cloudflare.com/magic-transit/)[Magic WAN](https://developers.cloudflare.com/magic-wan/)

   Today, we are excited to announce that all Magic Transit and Magic WAN customers with CMB EU ([Customer Metadata Boundary - Europe](https://developers.cloudflare.com/data-localization/metadata-boundary/)) enabled in their account will be able to access GRE, IPsec, and CNI health check and traffic volume data in the Cloudflare dashboard and via API.

   This ensures that all Magic Transit and Magic WAN customers with CMB EU enabled will be able to access all Magic Transit and Magic WAN features.

   Specifically, these two GraphQL endpoints are now compatible with CMB EU:

   * `magicTransitTunnelHealthChecksAdaptiveGroups`
   * `magicTransitTunnelTrafficAdaptiveGroups`

Jul 29, 2025

1. ### [Deploy to Cloudflare buttons now support Worker environment variables, secrets, and Secrets Store secrets](https://developers.cloudflare.com/changelog/2025-07-01-workers-deploy-button-supports-environment-variables-and-secrets/)

   [Workers ](https://developers.cloudflare.com/workers/)[Secrets Store](https://developers.cloudflare.com/secrets-store/)

   Any template which uses [Worker environment variables](https://developers.cloudflare.com/workers/configuration/environment-variables/), [secrets](https://developers.cloudflare.com/workers/configuration/secrets/), or [Secrets Store secrets](https://developers.cloudflare.com/secrets-store/) can now be deployed using a [Deploy to Cloudflare button](https://developers.cloudflare.com/workers/platform/deploy-buttons/).

   Define environment variables and secrets store bindings in your Wrangler configuration file as normal:

   * wrangler.jsonc

     ```jsonc
     {
       "name": "my-worker",
       "main": "./src/index.ts",
       "compatibility_date": "2025-11-20",
       "vars": {
         "API_HOST": "https://example.com",
       },
       "secrets_store_secrets": [
         {
           "binding": "API_KEY",
           "store_id": "demo",
           "secret_name": "api-key"
         }
       ]
     }
     ```

   * wrangler.toml

     ```toml
     name = "my-worker"
     main = "./src/index.ts"
     compatibility_date = "2025-11-20"


     [vars]
     API_HOST = "https://example.com"


     [[secrets_store_secrets]]
     binding = "API_KEY"
     store_id = "demo"
     secret_name = "api-key"
     ```

   Add secrets to a `.dev.vars.example` or `.env.example` file:

   ```ini
   COOKIE_SIGNING_KEY=my-secret # comment
   ```

   And optionally, you can add a description for these bindings in your template's `package.json` to help users understand how to configure each value:

   ```json
   {
     "name": "my-worker",
     "private": true,
     "cloudflare": {
       "bindings": {
         "API_KEY": {
           "description": "Select your company's API key for connecting to the example service."
         },
         "COOKIE_SIGNING_KEY": {
           "description": "Generate a random string using `openssl rand -hex 32`."
         }
       }
     }
   }
   ```

   These secrets and environment variables will be presented to users in the dashboard as they deploy this template, allowing them to configure each value. Additional information about creating templates and Deploy to Cloudflare buttons can be found in [our documentation](https://developers.cloudflare.com/workers/platform/deploy-buttons/).

Jul 29, 2025

1. ### [Audit logs (version 2) - UI Beta Release](https://developers.cloudflare.com/changelog/2025-07-29-audit-logs-v2-ui-beta/)

   [Audit Logs](https://developers.cloudflare.com/fundamentals/account/account-security/review-audit-logs/)

   The Audit Logs v2 UI is now available to all Cloudflare customers in Beta. This release builds on the public [Beta of the Audit Logs v2 API](https://developers.cloudflare.com/changelog/?product=audit-logs) and introduces a redesigned user interface with powerful new capabilities to make it easier to investigate account activity.

   **Enabling the new UI**

   To try the new user interface, go to **Manage Account > Audit Logs**. The previous version of Audit Logs remains available and can be re-enabled at any time using the **Switch back to old Audit Logs** link in the banner at the top of the page.

   **New Features:**

   * **Advanced Filtering**: Filter logs by actor, resource, method, and more for faster insights.
   * **On-hover filter controls**: Easily include or exclude values in queries by hovering over fields within a log entry.
   * **Detailed Log Sidebar**: View rich context for each log entry without leaving the main view.
   * **JSON Log View**: Inspect the raw log data in a structured JSON format.
   * **Custom Time Ranges**: Define your own time windows to view historical activity.
   * **Infinite Scroll**: Seamlessly browse logs without clicking through pages.

   ![Audit Logs v2 new UI](https://developers.cloudflare.com/_astro/Audit_logs_v2_filters.Bacd1IHg_20lzIj.webp)

   For more details on Audit Logs v2, see the [Audit Logs documentation](https://developers.cloudflare.com/fundamentals/account/account-security/audit-logs/).

   **Known issues**

   * A small number of audit logs may currently be unavailable in Audit Logs v2. In some cases, certain fields such as actor information may be missing in certain audit logs. We are actively working to improve coverage and completeness for General Availability.
   * Export to CSV is not supported in the new UI.

   We are actively refining the Audit Logs v2 experience and welcome your feedback. You can share overall feedback by clicking the thumbs up or thumbs down icons at the top of the page, or provide feedback on specific audit log entries using the thumbs icons next to each audit log line or by filling out our [feedback form](https://docs.google.com/forms/d/e/1FAIpQLSfXGkJpOG1jUPEh-flJy9B13icmcdBhveFwe-X0EzQjJQnQfQ/viewform?usp=sharing).

Jul 28, 2025

1. ### [Introducing pricing for the Browser Rendering API — $0.09 per browser hour](https://developers.cloudflare.com/changelog/2025-07-28-br-pricing/)

   [Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

   We’ve launched pricing for [Browser Rendering](https://developers.cloudflare.com/browser-rendering/), including a free tier and a pay-as-you-go model that scales with your needs. Starting **August 20, 2025**, Cloudflare will begin billing for Browser Rendering.

   There are two ways to use Browser Rendering. Depending on the method you use, here’s how billing will work:

   * [**REST API**](https://developers.cloudflare.com/browser-rendering/rest-api/): Charged for **Duration** only ($/browser hour)
   * [**Workers Bindings**](https://developers.cloudflare.com/browser-rendering/workers-bindings/): Charged for both **Duration** and **Concurrency** ($/browser hour and # of concurrent browsers)

   Included usage and pricing by plan

   | Plan | Included duration | Included concurrency | Price (beyond included) |
   | - | - | - | - |
   | **Workers Free** | 10 minutes per day | 3 concurrent browsers | N/A |
   | **Workers Paid** | 10 hours per month | 10 concurrent browsers (averaged monthly) | **1. REST API**: $0.09 per additional browser hour **2. Workers Bindings**: $0.09 per additional browser hour $2.00 per additional concurrent browser |

   What you need to know:

   * **Workers Free Plan:** 10 minutes of browser usage per day with 3 concurrent browsers at no charge.
   * **Workers Paid Plan:** 10 hours of browser usage per month with 10 concurrent browsers (averaged monthly) at no charge. Additional usage is charged as shown above.

   You can monitor usage via the [Cloudflare dashboard](https://dash.cloudflare.com/?to=/:account/workers/browser-rendering). Go to **Compute (Workers)** > **Browser Rendering**.

   ![Browser Rendering dashboard](https://developers.cloudflare.com/_astro/dashboard.BQnX87lT_ZjQt3r.webp)

   If you've been using Browser Rendering and do not wish to incur charges, ensure your usage stays within your plan's [included usage](https://developers.cloudflare.com/browser-rendering/pricing/). To estimate costs, take a look at these [example pricing scenarios](https://developers.cloudflare.com/browser-rendering/pricing/#examples-of-workers-paid-pricing).

Jul 22, 2025

1. ### [Browser Rendering now supports local development](https://developers.cloudflare.com/changelog/2025-07-22-br-local-dev/)

   [Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

   You can now run your Browser Rendering locally using `npx wrangler dev`, which spins up a browser directly on your machine before deploying to Cloudflare's global network. By running tests locally, you can quickly develop, debug, and test changes without needing to deploy or worry about usage costs.

   ![Local Dev video](https://developers.cloudflare.com/_astro/localshorterbrowserrendering.B16sERWO_f5h3J.webp)

   Get started with this [example guide](https://developers.cloudflare.com/browser-rendering/workers-bindings/screenshots/) that shows how to use Cloudflare's [fork of Puppeteer](https://developers.cloudflare.com/browser-rendering/puppeteer/) (you can also use [Playwright](https://developers.cloudflare.com/browser-rendering/playwright/)) to take screenshots of webpages and store the results in [Workers KV](https://developers.cloudflare.com/kv/).

Jul 22, 2025

1. ### [Audio mode for Media Transformations](https://developers.cloudflare.com/changelog/2025-07-22-media-transformations-audio-mode/)

   [Stream](https://developers.cloudflare.com/stream/)

   We now support `audio` mode! Use this feature to extract audio from a source video, outputting an M4A file to use in downstream workflows like [AI inference](https://developers.cloudflare.com/workers-ai/), content moderation, or transcription.

   For example,

   ```text
   https://example.com/cdn-cgi/media/<OPTIONS>/<SOURCE-VIDEO>
   https://example.com/cdn-cgi/media/mode=audio,time=3s,duration=60s/<input video with diction>
   ```

   For more information, learn about [Transforming Videos](https://developers.cloudflare.com/stream/transform-videos/).

Jul 21, 2025

1. ### [Subaddressing support in Email Routing](https://developers.cloudflare.com/changelog/2025-07-21-subaddressing/)

   [Email Routing](https://developers.cloudflare.com/email-routing/)

   Subaddressing, as defined in [RFC 5233](https://www.rfc-editor.org/rfc/rfc5233), also known as plus addressing, is now supported in Email Routing. This enables using the "+" separator to augment your custom addresses with arbitrary detail information.

   Now you can send an email to `user+detail@example.com` and it will be captured by the `user@example.com` custom address. The `+detail` part is ignored by Email Routing, but it can be captured next in the processing chain in the logs, an [Email Worker](https://developers.cloudflare.com/email-routing/email-workers/) or an [Agent application](https://github.com/cloudflare/agents/tree/main/examples/email-agent).

   Customers can use this feature to dynamically add context to their emails, such as tracking the source of an email or categorizing emails without needing to create multiple custom addresses.

   ![Subaddressing](https://developers.cloudflare.com/_astro/subaddressing.x65bljxx_Z1DjNfi.webp)

   Check our [Developer Docs](https://developers.cloudflare.com/email-routing/setup/email-routing-addresses/#subaddressing) to learn on to enable subaddressing in Email Routing.

Jul 18, 2025

1. ### [New APIs for Brand Protection setup](https://developers.cloudflare.com/changelog/2025-07-18-brand-protection-api/)

   [Security Center](https://developers.cloudflare.com/security-center/)

   The Brand Protection API is now available, allowing users to create new queries and delete existing ones, fetch matches and more!

   What you can do:

   * **create new string or logo query**
   * **delete string or logo queries**
   * **download matches for both logo and string queries**
   * **read matches for both logo and string queries**

   Ready to start? Check out the [Brand Protection API](https://developers.cloudflare.com/api/resources/brand_protection/) in our documentation.

Jul 17, 2025

1. ### [New detection entry type: Document Matching for DLP](https://developers.cloudflare.com/changelog/2025-07-17-document-matching/)

   [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

   You can now create [document-based](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#documents) detection entries in DLP by uploading example documents. Cloudflare will encrypt your documents and create a unique fingerprint of the file. This fingerprint is then used to identify similar documents or snippets within your organization's traffic and stored files.

   ![DLP](https://developers.cloudflare.com/_astro/document-match.CcN8pGgR_8o13J.webp)

   **Key features and benefits:**

   * **Upload documents, forms, or templates:** Easily upload .docx and .txt files (up to 10 MB) that contain sensitive information you want to protect.

   * **Granular control with similarity percentage:** Define a minimum similarity percentage (0-100%) that a document must meet to trigger a detection, reducing false positives.

   * **Comprehensive coverage:** Apply these document-based detection entries in:

     * **Gateway policies:** To inspect network traffic for sensitive documents as they are uploaded or shared.

     * **CASB (Cloud Access Security Broker):** To scan files stored in cloud applications for sensitive documents at rest.

   * **Identify sensitive data:** This new detection entry type is ideal for identifying sensitive data within completed forms, templates, or even small snippets of a larger document, helping you prevent data exfiltration and ensure compliance.

   Once uploaded and processed, you can add this new document entry into a DLP profile and policies to enhance your data protection strategy.

Jul 15, 2025

1. ### [Faster, more reliable UDP traffic for Cloudflare Tunnel](https://developers.cloudflare.com/changelog/2025-07-15-udp-improvements/)

   [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

   Your real-time applications running over [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/) are now faster and more reliable. We've completely re-architected the way `cloudflared` proxies UDP traffic in order to isolate it from other traffic, ensuring latency-sensitive applications like private DNS are no longer slowed down by heavy TCP traffic (like file transfers) on the same Tunnel.

   This is a foundational improvement to Cloudflare Tunnel, delivered automatically to all customers. There are no settings to configure — your UDP traffic is already flowing faster and more reliably.

   **What’s new:**

   * **Faster UDP performance**: We've significantly reduced the latency for establishing new UDP sessions, making applications like private DNS much more responsive.
   * **Greater reliability for mixed traffic**: UDP packets are no longer affected by heavy TCP traffic, preventing timeouts and connection drops for your real-time services.

   Learn more about running [TCP or UDP applications](https://developers.cloudflare.com/reference-architecture/architectures/sase/#connecting-applications) and [private networks](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/) through [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/).

Jul 14, 2025

1. ### [Terraform v5.7.0 now available](https://developers.cloudflare.com/changelog/2025-07-11-terraform-v570-provider/)

   [Cloudflare Fundamentals ](https://developers.cloudflare.com/fundamentals/)[Terraform](https://developers.cloudflare.com/terraform/)

   Earlier this year, we announced the launch of the new [Terraform v5 Provider](https://developers.cloudflare.com/changelog/2025-02-03-terraform-v5-provider/). We are aware of the high mumber of [issues](https://github.com/cloudflare/terraform-provider-cloudflare) reported by the Cloudflare community related to the v5 release, with 13.5% of resources impacted. We have committed to releasing improvements on a 2 week cadeance to ensure it's stability and relability, including the v5.7 release.

   Thank you for continuing to raise issues and please keep an eye on this changelog for more information about upcoming releases.

   #### Changes

   * Addressed permanent diff bug on Cloudflare Tunnel config
   * State is now saved correctly for Zero Trust Access applications
   * Exact match is now working as expected within `data.cloudflare_zero_trust_access_applications`
   * `cloudflare_zero_trust_access_policy` now supports OIDC claims & diff issues resolved
   * Self hosted applications with private IPs no longer require a public domain for `cloudflare_zero_trust_access_application`.
   * New resource:
     * `cloudflare_zero_trust_tunnel_warp_connector`
   * Other bug fixes

   For a more detailed look at all of the changes, see the [changelog](https://github.com/cloudflare/terraform-provider-cloudflare/releases/tag/v5.7.0) in GitHub.

   #### Issues Closed

   * [#5563: cloudflare\_logpull\_retention is missing import](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5563)
   * [#5608: cloudflare\_zero\_trust\_access\_policy in 5.5.0 provider gives error upon apply unexpected new value: .app\_count: was cty.NumberIntVal(0), but now cty.NumberIntVal(1)](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5608)
   * [#5612: data.cloudflare\_zero\_trust\_access\_applications does not exact match](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5612)
   * [#5532: cloudflare\_zero\_trust\_access\_identity\_provider detects changes on every plan](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5532)
   * [#5662: cloudflare\_zero\_trust\_access\_policy does not support OIDC claims](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5662)
   * [#5565: Running Terraform with the cloudflare\_zero\_trust\_access\_policy resource results in updates on every apply, even when no changes are made - breaks idempotency](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5565)
   * [#5529: cloudflare\_zero\_trust\_access\_application: self hosted applications with private ips require public domain](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5529)

   If you have an unaddressed issue with the provider, we encourage you to check the [open issues](https://github.com/cloudflare/terraform-provider-cloudflare/issues) and open a new one if one does not already exist for what you are experiencing.

   #### Upgrading

   We suggest holding on migration to v5 while we work on stablization of the v5 provider. This will ensure Cloudflare can work ahead and avoid any blocking issues.

   If you'd like more information on migrating from v4 to v5, please make use of the [migration guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade). We have provided automated migration scripts using Grit which simplify the transition, although these do not support implementations which use Terraform modules, so customers making use of modules need to migrate manually. Please make use of `terraform plan` to test your changes before applying, and let us know if you encounter any additional issues by reporting to our [GitHub repository](https://github.com/cloudflare/terraform-provider-cloudflare).

   #### For more info

   * [Terraform provider](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs)
   * [Documentation on using Terraform with Cloudflare](https://developers.cloudflare.com/terraform/)

Jul 10, 2025

1. ### [New onboarding guides for Zero Trust](https://developers.cloudflare.com/changelog/2025-07-09-onboarding-resources/)

   [Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

   Use our brand new onboarding experience for Cloudflare Zero Trust. New and returning users can now engage with a **Get Started** tab with walkthroughs for setting up common use cases end-to-end.

   ![Zero Trust onboarding guides](https://developers.cloudflare.com/_astro/zt-onboarding-guides._18EfPbe_R7PNC.webp)

   There are eight brand new onboarding guides in total:

   * Securely access a private network (sets up device client and Tunnel)
   * Device-to-device / mesh networking (sets up and connects multiple device clients)
   * Network to network connectivity (sets up and connects multiple WARP Connectors, makes reference to Magic WAN availability for Enterprise)
   * Secure web traffic (sets up device client, Gateway, pre-reqs, and initial policies)
   * Secure DNS for networks (sets up a new DNS location and Gateway policies)
   * Clientless web access (sets up Access to a web app, Tunnel, and public hostname)
   * Clientless SSH access (all the same + the web SSH experience)
   * Clientless RDP access (all the same + RDP-in-browser)

   Each flow walks the user through the steps to configure the essential elements, and provides a “more details” panel with additional contextual information about what the user will accomplish at the end, along with why the steps they take are important.

   Try them out now in the [Zero Trust dashboard](https://one.dash.cloudflare.com/?to=/:account/home)!

Jul 08, 2025

1. ### [Faster indexing and new Jobs view in AutoRAG](https://developers.cloudflare.com/changelog/2025-07-08-autorag-jobs-view/)

   [AI Search](https://developers.cloudflare.com/ai-search/)

   You can now expect **3-5× faster indexing** in AutoRAG, and with it, a brand new **Jobs view** to help you monitor indexing progress.

   With each AutoRAG, indexing jobs are automatically triggered to sync your data source (i.e. R2 bucket) with your Vectorize index, ensuring new or updated files are reflected in your query results. You can also trigger jobs manually via the [Sync API](https://developers.cloudflare.com/api/resources/ai-search/subresources/rags/) or by clicking “Sync index” in the dashboard.

   With the new jobs observability, you can now:

   * View the status, job ID, source, start time, duration and last sync time for each indexing job
   * Inspect real-time logs of job events (e.g. `Starting indexing data source...`)
   * See a history of past indexing jobs under the Jobs tab of your AutoRAG

   ![AutoRAG jobs](https://developers.cloudflare.com/_astro/autorag-jobs-view.Cq4qqJI6_JbjV1.webp)

   This makes it easier to understand what’s happening behind the scenes.

   **Coming soon:** We’re adding APIs to programmatically check indexing status, making it even easier to integrate AutoRAG into your workflows.

   Try it out today on the [Cloudflare dashboard](https://dash.cloudflare.com/?to=/:account/ai/autorag).

Jul 08, 2025

1. ### [HEIC support in Cloudflare Images](https://developers.cloudflare.com/changelog/heic-support/)

   [Cloudflare Images](https://developers.cloudflare.com/images/)

   You can use Images to ingest HEIC images and serve them in supported output formats like AVIF, WebP, JPEG, and PNG.

   When inputting a HEIC image, dimension and sizing limits may still apply. Refer to our documentation to see limits for [uploading to Images](https://developers.cloudflare.com/images/upload-images/) or [transforming a remote image](https://developers.cloudflare.com/images/transform-images/).

Jul 07, 2025

1. ### [Cloudy summaries for Access and Gateway Logs](https://developers.cloudflare.com/changelog/2025-07-07-cloudy-summaries-access-gateway/)

   [Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

   Cloudy, Cloudflare's AI Agent, will now automatically summarize your [Access](https://developers.cloudflare.com/cloudflare-one/insights/logs/audit-logs/) and [Gateway](https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/) block logs.

   In the log itself, Cloudy will summarize what occurred and why. This will be helpful for quick troubleshooting and issue correlation.

   ![Cloudy AI summarizes a log](https://developers.cloudflare.com/_astro/cloudy-explanation.oFZR6cXa_yzahz.webp)

   If you have feedback about the Cloudy summary - good or bad - you can provide that right from the summary itself.

Jul 07, 2025

1. ### [New App Library for Zero Trust Dashboard](https://developers.cloudflare.com/changelog/2025-07-07-dashboard-app-library/)

   [Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

   Cloudflare Zero Trust customers can use the App Library to get full visibility over the SaaS applications that they use in their Gateway policies, CASB integrations, and Access for SaaS applications.

   **App Library**, found under **My Team**, makes information available about all Applications that can be used across the Zero Trust product suite.

   ![Zero Trust App Library](https://developers.cloudflare.com/_astro/app-library.D403GJ9j_1veBBu.webp)

   You can use the App Library to see:

   * How Applications are defined
   * Where they are referenced in policies
   * Whether they have Access for SaaS configured
   * Review their CASB findings and integration status.

   Within individual Applications, you can also track their usage across your organization, and better understand user behavior.

Jul 03, 2025

1. ### [Hyperdrive now supports configuring the amount of database connections](https://developers.cloudflare.com/changelog/2025-07-02-hyperdrive-configurable-connection-count/)

   [Hyperdrive](https://developers.cloudflare.com/hyperdrive/)

   You can now specify the number of connections your Hyperdrive configuration uses to connect to your origin database.

   All configurations have a minimum of 5 connections. The maximum connection count for a Hyperdrive configuration depends on the [Hyperdrive limits of your Workers plan](https://developers.cloudflare.com/hyperdrive/platform/limits/).

   This feature allows you to right-size your connection pool based on your database capacity and application requirements. You can configure connection counts through the Cloudflare dashboard or API.

   Refer to the [Hyperdrive configuration documentation](https://developers.cloudflare.com/hyperdrive/concepts/connection-pooling/) for more information.

Jul 01, 2025

1. ### [Introducing Pay Per Crawl (private beta)](https://developers.cloudflare.com/changelog/2025-07-01-pay-per-crawl/)

   [AI Crawl Control](https://developers.cloudflare.com/ai-crawl-control/)

   We are introducing a new feature of [AI Crawl Control](https://developers.cloudflare.com/ai-crawl-control/) — Pay Per Crawl. [Pay Per Crawl](https://developers.cloudflare.com/ai-crawl-control/features/pay-per-crawl/what-is-pay-per-crawl/) enables site owners to require payment from AI crawlers every time the crawlers access their content, thereby fostering a fairer Internet by enabling site owners to control and monetize how their content gets used by AI.

   ![Pay per crawl](https://developers.cloudflare.com/_astro/pay-per-crawl.B5bv2nwT_Z1qUoVQ.webp)

   **For Site Owners:**

   * Set pricing and select which crawlers to charge for content access
   * Manage payments via Stripe
   * Monitor analytics on successful content deliveries

   **For AI Crawler Owners:**

   * Use HTTP headers to request and accept pricing
   * Receive clear confirmations on charges for accessed content

   Learn more in the [Pay Per Crawl documentation](https://developers.cloudflare.com/ai-crawl-control/features/pay-per-crawl/what-is-pay-per-crawl/).

Jun 30, 2025

1. ### [Mail authentication requirements for Email Routing](https://developers.cloudflare.com/changelog/2025-06-30-mail-authentication/)

   [Email Routing](https://developers.cloudflare.com/email-routing/)

   The Email Routing platform supports [SPF](https://datatracker.ietf.org/doc/html/rfc7208) records and [DKIM (DomainKeys Identified Mail)](https://en.wikipedia.org/wiki/DomainKeys_Identified_Mail) signatures and honors these protocols when the sending domain has them configured. However, if the sending domain doesn't implement them, we still forward the emails to upstream mailbox providers.

   Starting on July 3, 2025, we will require all emails to be authenticated using at least one of the protocols, SPF or DKIM, to forward them. We also strongly recommend that all senders implement the DMARC protocol.

   If you are using a Worker with an Email trigger to receive email messages and forward them upstream, you will need to handle the case where the forward action may fail due to missing authentication on the incoming email.

   SPAM has been a long-standing issue with email. By enforcing mail authentication, we will increase the efficiency of identifying abusive senders and blocking bad emails. If you're an email server delivering emails to large mailbox providers, it's likely you already use these protocols; otherwise, please ensure you have them properly configured.

Jun 25, 2025

1. ### [Run AI-generated code on-demand with Code Sandboxes (new)](https://developers.cloudflare.com/changelog/2025-06-24-announcing-sandboxes/)

   [Agents ](https://developers.cloudflare.com/agents/)[Workers ](https://developers.cloudflare.com/workers/)[Workflows](https://developers.cloudflare.com/workflows/)

   AI is supercharging app development for everyone, but we need a safe way to run untrusted, LLM-written code. We’re introducing [Sandboxes](https://www.npmjs.com/package/@cloudflare/sandbox), which let your Worker run actual processes in a secure, container-based environment.

   ```ts
   import { getSandbox } from "@cloudflare/sandbox";
   export { Sandbox } from "@cloudflare/sandbox";


   export default {
     async fetch(request: Request, env: Env) {
       const sandbox = getSandbox(env.Sandbox, "my-sandbox");
       return sandbox.exec("ls", ["-la"]);
     },
   };
   ```

   #### Methods

   * `exec(command: string, args: string[], options?: { stream?: boolean })`:Execute a command in the sandbox.
   * `gitCheckout(repoUrl: string, options: { branch?: string; targetDir?: string; stream?: boolean })`: Checkout a git repository in the sandbox.
   * `mkdir(path: string, options: { recursive?: boolean; stream?: boolean })`: Create a directory in the sandbox.
   * `writeFile(path: string, content: string, options: { encoding?: string; stream?: boolean })`: Write content to a file in the sandbox.
   * `readFile(path: string, options: { encoding?: string; stream?: boolean })`: Read content from a file in the sandbox.
   * `deleteFile(path: string, options?: { stream?: boolean })`: Delete a file from the sandbox.
   * `renameFile(oldPath: string, newPath: string, options?: { stream?: boolean })`: Rename a file in the sandbox.
   * `moveFile(sourcePath: string, destinationPath: string, options?: { stream?: boolean })`: Move a file from one location to another in the sandbox.
   * `ping()`: Ping the sandbox.

   Sandboxes are still experimental. We're using them to explore how isolated, container-like workloads might scale on Cloudflare — and to help define the developer experience around them.

   You can try it today from your Worker, with just a few lines of code. Let us know what you build.

Jun 25, 2025

1. ### [@cloudflare/actors library - SDK for Durable Objects in beta](https://developers.cloudflare.com/changelog/2025-06-25-actors-package-alpha/)

   [Durable Objects ](https://developers.cloudflare.com/durable-objects/)[Workers](https://developers.cloudflare.com/workers/)

   The new [@cloudflare/actors](https://www.npmjs.com/package/@cloudflare/actors) library is now in beta!

   The `@cloudflare/actors` library is a new SDK for Durable Objects and provides a powerful set of abstractions for building real-time, interactive, and multiplayer applications on top of Durable Objects. With beta usage and feedback, `@cloudflare/actors` will become the recommended way to build on Durable Objects and draws upon Cloudflare's experience building products/features on Durable Objects.

   The name "actors" originates from the [actor programming model](https://developers.cloudflare.com/durable-objects/concepts/what-are-durable-objects/#actor-programming-model), which closely ties to how Durable Objects are modelled.

   The `@cloudflare/actors` library includes:

   * Storage helpers for querying embeddeded, per-object SQLite storage
   * Storage helpers for managing SQL schema migrations
   * Alarm helpers for scheduling multiple alarms provided a date, delay in seconds, or cron expression
   * `Actor` class for using Durable Objects with a defined pattern
   * Durable Objects [Workers API](https://developers.cloudflare.com/durable-objects/api/base/) is always available for your application as needed

   Storage and alarm helper methods can be combined with [any Javascript class](https://github.com/cloudflare/actors?tab=readme-ov-file#storage--alarms-with-durableobject-class) that defines your Durable Object, i.e, ones that extend `DurableObject` including the `Actor` class.

   ```js
   import { Storage } from "@cloudflare/actors/storage";


   export class ChatRoom extends DurableObject<Env> {
       storage: Storage;


       constructor(ctx: DurableObjectState, env: Env) {
           super(ctx, env)
           this.storage = new Storage(ctx.storage);
           this.storage.migrations = [{
               idMonotonicInc: 1,
               description: "Create users table",
               sql: "CREATE TABLE IF NOT EXISTS users (id INTEGER PRIMARY KEY)"
           }]
       }
       async fetch(request: Request): Promise<Response> {
           // Run migrations before executing SQL query
           await this.storage.runMigrations();


           // Query with SQL template
           let userId = new URL(request.url).searchParams.get("userId");
           const query = this.storage.sql`SELECT * FROM users WHERE id = ${userId};`
           return new Response(`${JSON.stringify(query)}`);
       }
   }
   ```

   `@cloudflare/actors` library introduces the `Actor` class pattern. `Actor` lets you access Durable Objects without writing the Worker that communicates with your Durable Object (the Worker is created for you). By default, requests are routed to a Durable Object named "default".

   ```js
   export class MyActor extends Actor<Env> {
       async fetch(request: Request): Promise<Response> {
           return new Response('Hello, World!')
       }
   }


   export default handler(MyActor);
   ```

   You can [route](https://developers.cloudflare.com/durable-objects/get-started/#3-instantiate-and-communicate-with-a-durable-object) to different Durable Objects by name within your `Actor` class using [`nameFromRequest`](https://github.com/cloudflare/actors?tab=readme-ov-file#actor-with-custom-name).

   ```js
   export class MyActor extends Actor<Env> {
       static nameFromRequest(request: Request): string {
           let url = new URL(request.url);
           return url.searchParams.get("userId") ?? "foo";
       }


       async fetch(request: Request): Promise<Response> {
           return new Response(`Actor identifier (Durable Object name): ${this.identifier}`);
       }
   }


   export default handler(MyActor);
   ```

   For more examples, check out the library [README](https://github.com/cloudflare/actors?tab=readme-ov-file#getting-started). `@cloudflare/actors` library is a place for more helpers and built-in patterns, like retry handling and Websocket-based applications, to reduce development overhead for common Durable Objects functionality. Please share feedback and what more you would like to see on our [Discord channel](https://discord.com/channels/595317990191398933/773219443911819284).

Jun 23, 2025

1. ### [Data Security Analytics in the Zero Trust dashboard](https://developers.cloudflare.com/changelog/cf1-data-security-analytics-v1/)

   [Data Loss Prevention ](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)[CASB ](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

   Zero Trust now includes **Data security analytics**, providing you with unprecedented visibility into your organization sensitive data.

   The new dashboard includes:

   * **Sensitive Data Movement Over Time:**

     * See patterns and trends in how sensitive data moves across your environment. This helps understand where data is flowing and identify common paths.

   * **Sensitive Data at Rest in SaaS & Cloud:**

     * View an inventory of sensitive data stored within your corporate SaaS applications (for example, Google Drive, Microsoft 365) and cloud accounts (such as AWS S3).

   * **DLP Policy Activity:**

     * Identify which of your Data Loss Prevention (DLP) policies are being triggered most often.
     * See which specific users are responsible for triggering DLP policies.

   ![Data Security Analytics](https://developers.cloudflare.com/_astro/cf1-data-security-analytics-v1.BGl6fYXl_Z20un3h.webp)

   To access the new dashboard, log in to [Zero Trust](https://one.dash.cloudflare.com/) and go to **Analytics** on the sidebar.

Jun 19, 2025

1. ### [Account-level DNS analytics now available via GraphQL Analytics API](https://developers.cloudflare.com/changelog/2025-06-23-account-level-dns-analytics-api/)

   [DNS](https://developers.cloudflare.com/dns/)

   Authoritative DNS analytics are now available on the **account level** via the [Cloudflare GraphQL Analytics API](https://developers.cloudflare.com/analytics/graphql-api/).

   This allows users to query DNS analytics across multiple zones in their account, by using the `accounts` filter.

   Here is an example to retrieve the most recent DNS queries across all zones in your account that resulted in an `NXDOMAIN` response over a given time frame. Please replace `a30f822fcd7c401984bf85d8f2a5111c` with your actual account ID.

   ```graphql
   query GetLatestNXDOMAINResponses {
     viewer {
       accounts(filter: { accountTag: "a30f822fcd7c401984bf85d8f2a5111c" }) {
         dnsAnalyticsAdaptive(
           filter: {
             date_geq: "2025-06-16"
             date_leq: "2025-06-18"
             responseCode: "NXDOMAIN"
           }
           limit: 10000
           orderBy: [datetime_DESC]
         ) {
           zoneTag
           queryName
           responseCode
           queryType
           datetime
         }
       }
     }
   }
   ```

   [Run in GraphQL API Explorer](https://graphql.cloudflare.com/explorer?query=I4VwpgTgngBA4mALgGQIaLAZ0QOQBoAiA8gLICCAkjgEpYAOA9gHaZYwDeAUDDAG4CWYAO6QO3HjFQBjKQxBNEmABQAzfgBsMEAFwdJMuQoAqqAOa6ARKgDMABhUAOAExOVUgCYB2KQBZbARgBOBx8AI0cAVncHFSdUCP9EqQsYAF8ASjEJCXcWMiZUdShEfilMMndUOhLeMCVxbJ41TUhdLkbGyowAfVMwYEsnWycIgFpbADZR-wmLBo6YLrBu9X7B4bHJ6Yc5hYkIemZWAGEGdzBLfGJyKl2F1Pns9X4AW35EXX9bb9tHiQYIOcIAAhKC6ADaSxKL2WBAAogBlY4AXT+mXaCwAXswwCZTH8eKBIFAcKgYQSYAdMIwWGBTucKUToEYoHQwBSoa92R0HtleWlOKkgA\&variables=N4XyA)

   To learn more and get started, refer to the [DNS Analytics documentation](https://developers.cloudflare.com/dns/additional-options/analytics/#analytics).

Jun 19, 2025

1. ### [Automate Worker deployments with a simplified SDK and more reliable Terraform provider](https://developers.cloudflare.com/changelog/2025-06-17-workers-terraform-sdk-api-fixes/)

   [D1 ](https://developers.cloudflare.com/d1/)[Workers ](https://developers.cloudflare.com/workers/)[Workers for Platforms](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/)

   #### Simplified Worker Deployments with our SDKs

   We've simplified the programmatic deployment of Workers via our [Cloudflare SDKs](https://developers.cloudflare.com/fundamentals/api/reference/sdks/). This update abstracts away the low-level complexities of the `multipart/form-data` upload process, allowing you to focus on your code while we handle the deployment mechanics.

   This new interface is available in:

   * [cloudflare-typescript](https://github.com/cloudflare/cloudflare-typescript) (4.4.1)
   * [cloudflare-python](https://github.com/cloudflare/cloudflare-python) (4.3.1)

   For complete examples, see our guide on [programmatic Worker deployments](https://developers.cloudflare.com/workers/platform/infrastructure-as-code).

   #### The Old way: Manual API calls

   Previously, deploying a Worker programmatically required manually constructing a `multipart/form-data` HTTP request, packaging your code and a separate `metadata.json` file. This was more complicated and verbose, and prone to formatting errors.

   For example, here's how you would upload a Worker script previously with cURL:

   ```bash
   curl https://api.cloudflare.com/client/v4/accounts/<account_id>/workers/scripts/my-hello-world-script \
     -X PUT \
     -H 'Authorization: Bearer <api_token>' \
     -F 'metadata={
           "main_module": "my-hello-world-script.mjs",
           "bindings": [
             {
               "type": "plain_text",
               "name": "MESSAGE",
               "text": "Hello World!"
             }
           ],
           "compatibility_date": "$today"
         };type=application/json' \
     -F 'my-hello-world-script.mjs=@-;filename=my-hello-world-script.mjs;type=application/javascript+module' <<EOF
   export default {
     async fetch(request, env, ctx) {
       return new Response(env.MESSAGE, { status: 200 });
     }
   };
   EOF
   ```

   #### After: SDK interface

   With the new SDK interface, you can now define your entire Worker configuration using a single, structured object.

   This approach allows you to specify metadata like `main_module`, `bindings`, and `compatibility_date` as clearer properties directly alongside your script content. Our SDK takes this logical object and automatically constructs the complex multipart/form-data API request behind the scenes.

   Here's how you can now programmatically deploy a Worker via the [`cloudflare-typescript` SDK](https://github.com/cloudflare/cloudflare-typescript)

   * JavaScript

     ```js
     import Cloudflare from "cloudflare";
     import { toFile } from "cloudflare/index";


     // ... client setup, script content, etc.


     const script = await client.workers.scripts.update(scriptName, {
       account_id: accountID,
       metadata: {
         main_module: scriptFileName,
         bindings: [],
       },
       files: {
         [scriptFileName]: await toFile(Buffer.from(scriptContent), scriptFileName, {
           type: "application/javascript+module",
         }),
       },
     });
     ```

   * TypeScript

     ```ts
     import Cloudflare from 'cloudflare';
     import { toFile } from 'cloudflare/index';


     // ... client setup, script content, etc.


     const script = await client.workers.scripts.update(scriptName, {
       account_id: accountID,
       metadata: {
         main_module: scriptFileName,
         bindings: [],
       },
       files: {
         [scriptFileName]: await toFile(Buffer.from(scriptContent), scriptFileName, {
           type: 'application/javascript+module',
         }),
       },
     });
     ```

   View the complete example here: <https://github.com/cloudflare/cloudflare-typescript/blob/main/examples/workers/script-upload.ts>

   #### Terraform provider improvements

   We've also made several fixes and enhancements to the [Cloudflare Terraform provider](https://github.com/cloudflare/terraform-provider-cloudflare):

   * Fixed the [`cloudflare_workers_script`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/workers_script) resource in Terraform, which previously was producing a diff even when there were no changes. Now, your `terraform plan` outputs will be cleaner and more reliable.
   * Fixed the [`cloudflare_workers_for_platforms_dispatch_namespace`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/workers_for_platforms_dispatch_namespace), where the provider would attempt to recreate the namespace on a `terraform apply`. The resource now correctly reads its remote state, ensuring stability for production environments and CI/CD workflows.
   * The [`cloudflare_workers_route`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/workers_route) resource now allows for the `script` property to be empty, null, or omitted to indicate that pattern should be negated for all scripts (see routes [docs](https://developers.cloudflare.com/workers/configuration/routing/routes)). You can now reserve a pattern or temporarily disable a Worker on a route without deleting the route definition itself.
   * Using `primary_location_hint` in the [`cloudflare_d1_database`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/d1_database) resource will no longer always try to recreate. You can now safely change the location hint for a D1 database without causing a destructive operation.

   #### API improvements

   We've also properly documented the [Workers Script And Version Settings](https://developers.cloudflare.com/api/resources/workers/subresources/scripts/subresources/script_and_version_settings) in our public OpenAPI spec and SDKs.

Jun 17, 2025

1. ### [Terraform v5.6.0 now available](https://developers.cloudflare.com/changelog/2025-06-17-terraform-v560-provider/)

   [Cloudflare Fundamentals ](https://developers.cloudflare.com/fundamentals/)[Terraform](https://developers.cloudflare.com/terraform/)

   Earlier this year, we announced the launch of the new [Terraform v5 Provider](https://developers.cloudflare.com/changelog/2025-02-03-terraform-v5-provider/). Unlike the earlier Terraform providers, v5 is automatically generated based on the OpenAPI Schemas for our REST APIs. Since launch, we have seen an unexpectedly high number of [issues](https://github.com/cloudflare/terraform-provider-cloudflare) reported by customers. These issues currently impact about 15% of resources. We have been working diligently to address these issues across the company, and have released the v5.6.0 release which includes a number of bug fixes. Please keep an eye on this changelog for more information about upcoming releases.

   #### Changes

   * Broad fixes across resources with recurring diffs, including, but not limited to:
     * `cloudflare_zero_trust_access_identity_provider`
       * `cloudflare_zone`

   * `cloudflare_page_rules` runtime panic when setting `cache_level` to `cache_ttl_by_status`

   * Failure to serialize requests in `cloudflare_zero_trust_tunnel_cloudflared_config`

   * Undocumented field 'priority' on `zone_lockdown` resource

   * Missing importability for `cloudflare_zero_trust_device_default_profile_local_domain_fallback` and `cloudflare_account_subscription`

   * New resources:

     * `cloudflare_schema_validation_operation_settings`
     * `cloudflare_schema_validation_schemas`
     * `cloudflare_schema_validation_settings`
     * `cloudflare_zero_trust_device_settings`

   * Other bug fixes

   For a more detailed look at all of the changes, see the [changelog](https://github.com/cloudflare/terraform-provider-cloudflare/releases/tag/v5.6.0) in GitHub.

   #### Issues Closed

   * [#5098: 500 Server Error on updating 'zero\_trust\_tunnel\_cloudflared\_virtual\_network' Terraform resource](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5098)
   * [#5148: cloudflare\_user\_agent\_blocking\_rule doesn’t actually support user agents](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5148)
   * [#5472: cloudflare\_zone showing changes in plan after following upgrade steps](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5472)
   * [#5508: cloudflare\_zero\_trust\_tunnel\_cloudflared\_config failed to serialize http request](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5508)
   * [#5509: cloudflare\_zone: Problematic Terraform behaviour with paused zones](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5509)
   * [#5520: Resource 'cloudflare\_magic\_wan\_static\_route' is not working](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5520)
   * [#5524: Optional fields cause crash in cloudflare\_zero\_trust\_tunnel\_cloudflared(s) when left null](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5524)
   * [#5526: Provider v5 migration issue: no import method for cloudflare\_zero\_trust\_device\_default\_profile\_local\_domain\_fallback](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5526)
   * [#5532: cloudflare\_zero\_trust\_access\_identity\_provider detects changes on every plan](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5532)
   * [#5561: cloudflare\_zero\_trust\_tunnel\_cloudflared: cannot rotate tunnel secret](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5561)
   * [#5569: cloudflare\_zero\_trust\_device\_custom\_profile\_local\_domain\_fallback not allowing multiple DNS Server entries](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5569)
   * [#5577: Panic modifying page\_rule resource](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5577)
   * [#5653: cloudflare\_zone\_setting resource schema confusion in 5.5.0: value vs enabled](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5653)

   If you have an unaddressed issue with the provider, we encourage you to check the [open issues](https://github.com/cloudflare/terraform-provider-cloudflare/issues) and open a new one if one does not already exist for what you are experiencing.

   #### Upgrading

   If you are evaluating a move from v4 to v5, please make use of the [migration guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade). We have provided automated migration scripts using Grit which simplify the transition, although these do not support implementations which use Terraform modules, so customers making use of modules need to migrate manually. Please make use of `terraform plan` to test your changes before applying, and let us know if you encounter any additional issues by reporting to our [GitHub repository](https://github.com/cloudflare/terraform-provider-cloudflare).

   #### For more info

   * [Terraform provider](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs)
   * [Documentation on using Terraform with Cloudflare](https://developers.cloudflare.com/terraform/)

Jun 16, 2025

1. ### [Internal DNS (beta) now manageable in the Cloudflare dashboard](https://developers.cloudflare.com/changelog/2025-06-16-internal-dns-beta-ui/)

   [DNS](https://developers.cloudflare.com/dns/)

   Participating beta testers can now fully configure [Internal DNS](https://developers.cloudflare.com/dns/internal-dns/) directly in the [Cloudflare dashboard](https://dash.cloudflare.com/?to=/:account/internal-dns).

   #### Internal DNS enables customers to:

   * Map internal hostnames to private IPs for services, devices, and applications not exposed to the public Internet

   * Resolve internal DNS queries securely through [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

   * Use split-horizon DNS to return different responses based on network context

   * Consolidate internal and public DNS zones within a single management platform

   #### What’s new in this release:

   * Beta participants can now create and manage internal zones and views in the Cloudflare dashboard

   ![Internal DNS UI](https://developers.cloudflare.com/_astro/internal-dns-beta-ui.B5uCVZ9o_ZNodcM.webp)

   Note

   The Internal DNS beta is currently only available to Enterprise customers.

   To learn more and get started, refer to the [Internal DNS documentation](https://developers.cloudflare.com/dns/internal-dns/).

Jun 11, 2025

1. ### [NSEC3 support for DNSSEC](https://developers.cloudflare.com/changelog/2025-06-11-nsec3-support/)

   [DNS](https://developers.cloudflare.com/dns/)

   Enterprise customers can now select NSEC3 as method for proof of non-existence on their zones.

   What's new:

   * **NSEC3 support for live-signed zones** – For both primary and secondary zones that are configured to be live-signed (also known as "on-the-fly signing"), NSEC3 can now be selected as proof of non-existence.

   * **NSEC3 support for pre-signed zones** – Secondary zones that are transferred to Cloudflare in a [pre-signed setup](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/dnssec-for-secondary/#set-up-pre-signed-dnssec) now also support NSEC3 as proof of non-existence.

   For more information and how to enable NSEC3, refer to the [NSEC3 documentation](https://developers.cloudflare.com/dns/dnssec/enable-nsec3/).

Jun 10, 2025

1. ### [Increased limits for Media Transformations](https://developers.cloudflare.com/changelog/2025-06-10-media-transformations-limits-increase/)

   [Stream](https://developers.cloudflare.com/stream/)

   We have increased the limits for [Media Transformations](https://developers.cloudflare.com/stream/transform-videos/):

   * Input file size limit is now 100MB (was 40MB)
   * Output video duration limit is now 1 minute (was 30 seconds)

   Additionally, we have improved caching of the input asset, resulting in fewer requests to origin storage even when transformation options may differ.

   For more information, learn about [Transforming Videos](https://developers.cloudflare.com/stream/transform-videos/).

Jun 09, 2025

1. ### [More flexible fallback handling — Custom Errors now support fetching assets returned with 4xx or 5xx status codes](https://developers.cloudflare.com/changelog/2025-06-09-custom-errors-fetch-4xx-5xx-assets/)

   [Rules](https://developers.cloudflare.com/rules/)

   [Custom Errors](https://developers.cloudflare.com/rules/custom-errors/) can now fetch and store [assets](https://developers.cloudflare.com/rules/custom-errors/create-rules/#create-a-custom-error-asset-dashboard) and [error pages](https://developers.cloudflare.com/rules/custom-errors/#error-pages) from your origin even if they are served with a 4xx or 5xx HTTP status code — previously, only 200 OK responses were allowed.

   **What’s new:**

   * You can now upload error pages and error assets that return error status codes (for example, 403, 500, 502, 503, 504) when fetched.
   * These assets are stored and minified at the edge, so they can be reused across multiple Custom Error rules without triggering requests to the origin.

   This is especially useful for retrieving error content or downtime banners from your backend when you can’t override the origin status code.

   Learn more in the [Custom Errors](https://developers.cloudflare.com/rules/custom-errors/) documentation.

Jun 09, 2025

1. ### [Match Workers subrequests by upstream zone — cf.worker.upstream\_zone now supported in Transform Rules](https://developers.cloudflare.com/changelog/2025-06-09-transform-rule-subrequest-matching/)

   [Rules](https://developers.cloudflare.com/rules/)

   You can now use the [`cf.worker.upstream_zone`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.worker.upstream_zone/) field in [Transform Rules](https://developers.cloudflare.com/rules/transform/) to control rule execution based on whether a request originates from [Workers](https://developers.cloudflare.com/workers/), including subrequests issued by Workers in other zones.

   ![Match Workers subrequests by upstream zone in Transform Rules](https://developers.cloudflare.com/_astro/transform-rule-subrequest-matching.BeUBEN67_10A2ms.webp)

   **What's new:**

   * `cf.worker.upstream_zone` is now supported in Transform Rules expressions.
   * Skip or apply logic conditionally when handling [Workers subrequests](https://developers.cloudflare.com/workers/platform/limits/#subrequests).

   For example, to add a header when the subrequest comes from another zone:

   Text in **Expression Editor** (replace `myappexample.com` with your domain):

   ```txt
   (cf.worker.upstream_zone != "" and cf.worker.upstream_zone != "myappexample.com")
   ```

   Selected operation under **Modify request header**: *Set static*

   **Header name**: `X-External-Workers-Subrequest`

   **Value**: `1`

   This gives you more granular control in how you handle incoming requests for your zone.

   Learn more in the [Transform Rules](https://developers.cloudflare.com/rules/transform/) documentation and [Rules language fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/) reference.

Jun 05, 2025

1. ### [Cloudflare One Analytics Dashboards and Exportable Access Report](https://developers.cloudflare.com/changelog/dashboards-access-report/)

   [Access ](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

   Cloudflare One now offers powerful new analytics dashboards to help customers easily discover available insights into their application access and network activity. These dashboards provide a centralized, intuitive view for understanding user behavior, application usage, and security posture.

   !\[Cloudflare One Analytics Dashboards]\(\~/assets/images/changelog/cloudflare-one/Analytics Dashboards.png)

   Additionally, a new exportable access report is available, allowing customers to quickly view high-level metrics and trends in their application access. A **preview** of the report is shown below, with more to be found in the report:

   ![Cloudflare One Analytics Dashboards](https://developers.cloudflare.com/_astro/access-report.C744W7JR_Td5Jj.webp)

   Both features are accessible in the Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/), empowering organizations with better visibility and control.

Jun 04, 2025

1. ### [New Account-Level Load Balancing UI and Private Load Balancers](https://developers.cloudflare.com/changelog/2025-06-04-account-load-balancing-ui/)

   [Load Balancing](https://developers.cloudflare.com/load-balancing/)

   We've made two large changes to load balancing:

   * Redesigned the user interface, now centralized at the **account level**.
   * Introduced [**Private Load Balancers**](https://developers.cloudflare.com/load-balancing/private-network/) to the UI, enabling you to manage traffic for all of your external and internal applications in a single spot.

   This update streamlines how you manage load balancers across multiple zones and extends robust traffic management to your private network infrastructure.

   ![Load Balancing UI](https://developers.cloudflare.com/_astro/account-load-balancing-ui.CoCi7gPb_K7D8r.webp)

   **Key Enhancements:**

   * **Account-Level UI Consolidation:**

     * **Unified Management:** Say goodbye to navigating individual zones for load balancing tasks. You can now view, configure, and monitor all your load balancers across every zone in your account from a single, intuitive interface at the account level.

     * **Improved Efficiency:** This centralized approach provides a more streamlined workflow, making it faster and easier to manage both your public-facing and internal traffic distribution.

   * **Private Network Load Balancing:**

     * **Secure Internal Application Access:** Create [**Private Load Balancers**](https://developers.cloudflare.com/load-balancing/private-network/) to distribute traffic to applications hosted within your private network, ensuring they are not exposed to the public Internet.

     * **WARP & Magic WAN Integration:** Effortlessly direct internal traffic from users connected via Cloudflare WARP or through your Magic WAN infrastructure to the appropriate internal endpoint pools.

     * **Enhanced Security for Internal Resources:** Combine reliable Load Balancing with Zero Trust access controls to ensure your internal services are both performant and only accessible by verified users.

   ![Private Load Balancers](https://developers.cloudflare.com/_astro/private-load-balancer.yti20m_p_2bqVH4.webp)

Jun 03, 2025

1. ### [AI Gateway adds OpenAI compatible endpoint](https://developers.cloudflare.com/changelog/2025-06-03-aig-openai-compatible-endpoint/)

   [AI Gateway](https://developers.cloudflare.com/ai-gateway/)

   Users can now use an [OpenAI Compatible endpoint](https://developers.cloudflare.com/ai-gateway/usage/chat-completion/) in AI Gateway to easily switch between providers, while keeping the exact same request and response formats. We're launching now with the chat completions endpoint, with the embeddings endpoint coming up next.

   To get started, use the OpenAI compatible chat completions endpoint URL with your own account id and gateway id and switch between providers by changing the `model` and `apiKey` parameters.

   ```js
   import OpenAI from "openai";
   const client = new OpenAI({
     apiKey: "YOUR_PROVIDER_API_KEY", // Provider API key
     baseURL:
       "https://gateway.ai.cloudflare.com/v1/{account_id}/{gateway_id}/compat",
   });


   const response = await client.chat.completions.create({
     model: "google-ai-studio/gemini-2.0-flash",
     messages: [{ role: "user", content: "What is Cloudflare?" }],
   });


   console.log(response.choices[0].message.content);
   ```

   Additionally, the [OpenAI Compatible endpoint](https://developers.cloudflare.com/ai-gateway/usage/chat-completion/) can be combined with our [Universal Endpoint](https://developers.cloudflare.com/ai-gateway/usage/universal/) to add fallbacks across multiple providers. That means AI Gateway will return every response in the same standardized format, no extra parsing logic required!

   Learn more in the [OpenAI Compatibility](https://developers.cloudflare.com/ai-gateway/usage/chat-completion/) documentation.

Jun 03, 2025

1. ### [Improved onboarding for Shopify merchants](https://developers.cloudflare.com/changelog/2025-06-03-shopify-o2o-improvements/)

   [DNS](https://developers.cloudflare.com/dns/)

   Shopify merchants can now onboard to **Orange-to-Orange (O2O)** automatically, without needing to contact support or community members.

   What's new:

   * **Automatic enablement** – O2O is available for all mutual Cloudflare and Shopify customers.

   * **Branded record display** – Merchants see a Shopify logo in DNS records, complete with helpful tooltips.

     ![Shopify O2O logo](https://developers.cloudflare.com/_astro/shop-dns-icon-o2o.Ca5DAZHL_Z1Oo7a7.webp)

   * **Checkout protection** – Workers and Snippets are blocked from running on the checkout path to reduce risk and improve security.

   For more information, refer to the [provider guide](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/saas-customers/provider-guides/shopify/).

May 30, 2025

1. ### [Cloudflare Pages builds now provide Node.js v22 by default](https://developers.cloudflare.com/changelog/2025-05-30-pages-build-image-v3/)

   [Pages](https://developers.cloudflare.com/pages/)

   When you use the built-in build system that is part of [Cloudflare Pages](https://developers.cloudflare.com/pages/), the [Build Image](https://developers.cloudflare.com/pages/configuration/build-image/) now includes Node.js v22. Previously, Node.js v18 was provided by default, and Node.js v18 is now end-of-life (EOL).

   If you are creating a new Pages project, the new V3 build image that includes Node.js v22 will be used by default. If you have an existing Pages project, you can update to the latest build image by navigating to Settings > Build & deployments > Build system version in the Cloudflare dashboard for a specific Pages project.

   Note that you can always specify a particular version of Node.js or other built-in dependencies by [setting an environment variable](https://developers.cloudflare.com/pages/configuration/build-image/#override-default-versions).

   For more, refer to the [developer docs for Cloudflare Pages builds](https://developers.cloudflare.com/pages/configuration/build-image)

May 30, 2025

1. ### [Fine-tune image optimization — WebP now supported in Configuration Rules](https://developers.cloudflare.com/changelog/2025-05-30-configuration-rules-webp/)

   [Rules](https://developers.cloudflare.com/rules/)

   You can now enable [Polish](https://developers.cloudflare.com/images/polish/activate-polish/) with the `webp` format directly in [Configuration Rules](https://developers.cloudflare.com/rules/configuration-rules/), allowing you to optimize image delivery for specific routes, user agents, or A/B tests — without applying changes zone-wide.

   **What’s new:**

   * [WebP](https://developers.cloudflare.com/images/polish/compression/#webp) is now a supported [value](https://developers.cloudflare.com/rules/configuration-rules/settings/#polish) in the **Polish** setting for Configuration Rules.

   ![New webp option in Polish setting of Configuration Rules](https://developers.cloudflare.com/_astro/configuration-rules-webp.Yn1cpqht_Z1nxJDI.webp)

   This gives you more precise control over how images are compressed and delivered, whether you're targeting modern browsers, running experiments, or tailoring performance by geography or device type.

   Learn more in the [Polish](https://developers.cloudflare.com/images/polish/) and [Configuration Rules](https://developers.cloudflare.com/rules/configuration-rules/) documentation.

May 29, 2025

1. ### [New Gateway Analytics in the Cloudflare One Dashboard](https://developers.cloudflare.com/changelog/gateway-analytics-v2/)

   [Gateway ](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

   Users can now access significant enhancements to Cloudflare Gateway analytics, providing you with unprecedented visibility into your organization's DNS queries, HTTP requests, and Network sessions. These powerful new dashboards enable you to go beyond raw logs and gain actionable insights into how your users are interacting with the Internet and your protected resources.

   You can now visualize and explore:

   * Patterns Over Time: Understand trends in traffic volume and blocked requests, helping you identify anomalies and plan for future capacity.
   * Top Users & Destinations: Quickly pinpoint the most active users, enabling better policy enforcement and resource allocation.
   * Actions Taken: See a clear breakdown of security actions applied by Gateway policies, such as blocks and allows, offering a comprehensive view of your security posture.
   * Geographic Regions: Gain insight into the global distribution of your traffic.

   ![Gateway Analytics](https://developers.cloudflare.com/_astro/gateway-analytics.BdSwbIBb_18Yc2n.webp)

   To access the new overview, log in to your Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/) and go to Analytics in the side navigation bar.

May 29, 2025

1. ### [50-500ms Faster D1 REST API Requests](https://developers.cloudflare.com/changelog/2025-05-30-d1-rest-api-latency/)

   [D1 ](https://developers.cloudflare.com/d1/)[Workers](https://developers.cloudflare.com/workers/)

   Users using Cloudflare's [REST API](https://developers.cloudflare.com/api/resources/d1/) to query their D1 database can see lower end-to-end request latency now that D1 authentication is performed at the closest Cloudflare network data center that received the request. Previously, authentication required D1 REST API requests to proxy to Cloudflare's core, centralized data centers, which added network round trips and latency.

   Latency improvements range from 50-500 ms depending on request location and [database location](https://developers.cloudflare.com/d1/configuration/data-location/) and only apply to the REST API. REST API requests and databases outside the United States see a bigger benefit since Cloudflare's primary core data centers reside in the United States.

   D1 query endpoints like `/query` and `/raw` have the most noticeable improvements since they no longer access Cloudflare's core data centers. D1 control plane endpoints such as those to create and delete databases see smaller improvements, since they still require access to Cloudflare's core data centers for other control plane metadata.

May 28, 2025

1. ### [Playwright MCP server is now compatible with Browser Rendering](https://developers.cloudflare.com/changelog/2025-05-28-playwright-mcp/)

   [Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

   We're excited to share that you can now use the [Playwright MCP](https://github.com/cloudflare/playwright-mcp) server with Browser Rendering.

   Once you [deploy the server](https://developers.cloudflare.com/browser-rendering/playwright/playwright-mcp/#deploying), you can use any MCP client with it to interact with Browser Rendering. This allows you to run AI models that can automate browser tasks, such as taking screenshots, filling out forms, or scraping data.

   ![Access Analytics](https://developers.cloudflare.com/_astro/playground-ai-screenshot.v44jFMBu_2abDuJ.webp)

   Playwright MCP is available as an npm package at [`@cloudflare/playwright-mcp`](https://www.npmjs.com/package/@cloudflare/playwright-mcp). To install it, type:

   * npm

     ```sh
     npm i -D @cloudflare/playwright-mcp
     ```

   * yarn

     ```sh
     yarn add -D @cloudflare/playwright-mcp
     ```

   * pnpm

     ```sh
     pnpm add -D @cloudflare/playwright-mcp
     ```

   Deploying the server is then as easy as:

   ```ts
   import { env } from "cloudflare:workers";
   import { createMcpAgent } from "@cloudflare/playwright-mcp";


   export const PlaywrightMCP = createMcpAgent(env.BROWSER);
   export default PlaywrightMCP.mount("/sse");
   ```

   Check out the full code at [GitHub](https://github.com/cloudflare/playwright-mcp).

   Learn more about Playwright MCP in our [documentation](https://developers.cloudflare.com/browser-rendering/playwright/playwright-mcp/).

May 27, 2025

1. ### [Increased limits for Cloudflare for SaaS and Secrets Store free and pay-as-you-go plans](https://developers.cloudflare.com/changelog/2025-05-19-paygo-updates/)

   [SSL/TLS ](https://developers.cloudflare.com/ssl/)[Cloudflare for SaaS ](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/)[Secrets Store](https://developers.cloudflare.com/secrets-store/)

   With upgraded limits to [all free and paid plans](https://www.cloudflare.com/plans/), you can now scale more easily with [Cloudflare for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/) and [Secrets Store](https://developers.cloudflare.com/secrets-store/).

   [Cloudflare for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/) allows you to extend the benefits of Cloudflare to your customers via their own custom or vanity domains. Now, the [limit for custom hostnames](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/plans/) on a Cloudflare for SaaS pay-as-you-go plan has been **raised from 5,000 custom hostnames to 50,000 custom hostnames.**

   With custom origin server -- previously an enterprise-only feature -- you can route traffic from one or more custom hostnames somewhere other than your default proxy fallback. [Custom origin server](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/custom-origin/) is now available to Cloudflare for SaaS customers on Free, Pro, and Business plans.

   You can enable custom origin server on a per-custom hostname basis [via the API](https://developers.cloudflare.com/api/resources/custom_hostnames/methods/edit/) or the UI:

   ![Import repo or choose template](https://developers.cloudflare.com/_astro/custom-origin-server.B-BXcG-1_Z2ixyVv.webp)

   Currently [in beta with a Workers integration](https://blog.cloudflare.com/secrets-store-beta/), [Cloudflare Secrets Store](https://developers.cloudflare.com/secrets-store/) allows you to store, manage, and deploy account level secrets from a secure, centralized platform your [Cloudflare Workers](https://developers.cloudflare.com/workers/). Now, you can create and deploy **100 secrets per account**. Try it out [in the dashboard](http://dash.cloudflare.com/?to=/:account/secrets-store), with [Wrangler](https://developers.cloudflare.com/secrets-store/integrations/workers/), or [via the API](https://developers.cloudflare.com/api/resources/secrets_store/) today.

May 23, 2025

1. ### [New GraphQL Analytics API Explorer and MCP Server](https://developers.cloudflare.com/changelog/2025-05-23-graphql-api-explorer/)

   [Analytics](https://developers.cloudflare.com/analytics/)

   We’ve launched two powerful new tools to make the GraphQL Analytics API more accessible:

   #### GraphQL API Explorer

   The new [GraphQL API Explorer](https://graphql.cloudflare.com/explorer) helps you build, test, and run queries directly in your browser. Features include:

   * In-browser schema documentation to browse available datasets and fields
   * Interactive query editor with autocomplete and inline documentation
   * A "Run in GraphQL API Explorer" button to execute example queries from our docs
   * Seamless OAuth authentication — no manual setup required

   ![GraphQL API Explorer](https://developers.cloudflare.com/_astro/graphql-api-explorer.CPUNZZ5B_1VqGH8.webp)

   #### GraphQL Model Context Protocol (MCP) Server

   MCP Servers let you use natural language tools like Claude to generate structured queries against your data. See our [blog post](https://blog.cloudflare.com/thirteen-new-mcp-servers-from-cloudflare/) for details on how they work and which servers are available. The new [GraphQL MCP server](https://github.com/cloudflare/mcp-server-cloudflare/tree/main/apps/graphql) helps you discover and generate useful queries for the GraphQL Analytics API. With this server, you can:

   * Explore what data is available to query
   * Generate and refine queries using natural language, with one-click links to run them in the API Explorer
   * Build dashboards and visualizations from structured query outputs

   Example prompts include:

   * “Show me HTTP traffic for the last 7 days for example.com”
   * “What GraphQL node returns firewall events?”
   * “Can you generate a link to the Cloudflare GraphQL API Explorer with a pre-populated query and variables?”

   We’re continuing to expand these tools, and your feedback helps shape what’s next. [Explore the documentation](https://developers.cloudflare.com/analytics/graphql-api/) to learn more and get started.

May 19, 2025

1. ### [Terraform v5.5.0 now available](https://developers.cloudflare.com/changelog/2025-05-19-terraform-v550-provider/)

   [Cloudflare Fundamentals ](https://developers.cloudflare.com/fundamentals/)[Terraform](https://developers.cloudflare.com/terraform/)

   Earlier this year, we announced the launch of the new [Terraform v5 Provider](https://developers.cloudflare.com/changelog/2025-02-03-terraform-v5-provider/). Unlike the earlier Terraform providers, v5 is automatically generated based on the OpenAPI Schemas for our REST APIs. Since launch, we have seen an unexpectedly high number of [issues](https://github.com/cloudflare/terraform-provider-cloudflare) reported by customers. These issues currently impact about 15% of resources. We have been working diligently to address these issues across the company, and have released the v5.5.0 release which includes a number of bug fixes. Please keep an eye on this changelog for more information about upcoming releases.

   #### Changes

   * Broad fixes across resources with recurring diffs, including, but not limited to:

     * `cloudflare_zero_trust_gateway_policy`
     * `cloudflare_zero_trust_access_application`
     * `cloudflare_zero_trust_tunnel_cloudflared_route`
     * `cloudflare_zone_setting`
     * `cloudflare_ruleset`
     * `cloudflare_page_rule`

   * Zone settings can be re-applied without client errors

   * Page rules conversion errors are fixed

   * Failure to apply changes to `cloudflare_zero_trust_tunnel_cloudflared_route`

   * Other bug fixes

   For a more detailed look at all of the changes, see the [changelog](https://github.com/cloudflare/terraform-provider-cloudflare/releases/tag/v5.5.0) in GitHub.

   #### Issues Closed

   * [#5304: Importing cloudflare\_zero\_trust\_gateway\_policy invalid attribute filter value](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5304)
   * [#5303: cloudflare\_page\_rule import does not set values for all of the fields in terraform state](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5303)
   * [#5178: cloudflare\_page\_rule Page rule creation with redirect fails](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5178)
   * [#5336: cloudflare\_turnstile\_wwidget not able to udpate](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5336)
   * [#5418: cloudflare\_cloud\_connector\_rules: Provider returned invalid result object after apply](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5418)
   * [#5423: cloudflare\_zone\_setting: "Invalid value for zone setting always\_use\_https"](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5423)

   If you have an unaddressed issue with the provider, we encourage you to check the [open issues](https://github.com/cloudflare/terraform-provider-cloudflare/issues) and open a new one if one does not already exist for what you are experiencing.

   #### Upgrading

   If you are evaluating a move from v4 to v5, please make use of the [migration guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade). We have provided automated migration scripts using Grit which simplify the transition, although these do not support implementations which use Terraform modules, so customers making use of modules need to migrate manually. Please make use of `terraform plan` to test your changes before applying, and let us know if you encounter any additional issues by reporting to our [GitHub repository](https://github.com/cloudflare/terraform-provider-cloudflare).

   #### For more info

   * [Terraform provider](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs)
   * [Documentation on using Terraform with Cloudflare](https://developers.cloudflare.com/terraform/)

May 16, 2025

1. ### [New Access Analytics in the Cloudflare One Dashboard](https://developers.cloudflare.com/changelog/access-analytics-v2/)

   [Access ](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)[Cloudflare One](https://developers.cloudflare.com/cloudflare-one/)

   A new Access Analytics dashboard is now available to all Cloudflare One customers. Customers can apply and combine multiple filters to dive into specific slices of their Access metrics. These filters include:

   * Logins granted and denied
   * Access events by type (SSO, Login, Logout)
   * Application name (Salesforce, Jira, Slack, etc.)
   * Identity provider (Okta, Google, Microsoft, onetimepin, etc.)
   * Users (`chris@cloudflare.com`, `sally@cloudflare.com`, `rachel@cloudflare.com`, etc.)
   * Countries (US, CA, UK, FR, BR, CN, etc.)
   * Source IP address
   * App type (self-hosted, Infrastructure, RDP, etc.)

   ![Access Analytics](https://developers.cloudflare.com/_astro/accessanalytics.DYXgwZCl_cA6SI.webp)

   To access the new overview, log in to your Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/) and find Analytics in the side navigation bar.

May 16, 2025

1. ### [Durable Objects are now supported in Python Workers](https://developers.cloudflare.com/changelog/2025-05-14-python-worker-durable-object/)

   [Workers ](https://developers.cloudflare.com/workers/)[Durable Objects](https://developers.cloudflare.com/durable-objects/)

   You can now create [Durable Objects](https://developers.cloudflare.com/durable-objects/) using [Python Workers](https://developers.cloudflare.com/workers/languages/python/). A Durable Object is a special kind of Cloudflare Worker which uniquely combines compute with storage, enabling stateful long-running applications which run close to your users. For more info see [here](https://developers.cloudflare.com/durable-objects/concepts/what-are-durable-objects/).

   You can define a Durable Object in Python in a similar way to JavaScript:

   ```python
   from workers import DurableObject, Response, WorkerEntrypoint


   from urllib.parse import urlparse


   class MyDurableObject(DurableObject):
       def __init__(self, ctx, env):
           self.ctx = ctx
           self.env = env


       def fetch(self, request):
           result = self.ctx.storage.sql.exec("SELECT 'Hello, World!' as greeting").one()
           return Response(result.greeting)


   class Default(WorkerEntrypoint):
       async def fetch(self, request):
           url = urlparse(request.url)
           id = env.MY_DURABLE_OBJECT.idFromName(url.path)
           stub = env.MY_DURABLE_OBJECT.get(id)
           greeting = await stub.fetch(request.url)
           return greeting
   ```

   Define the Durable Object in your Wrangler configuration file:

   * wrangler.jsonc

     ```jsonc
     {
       "$schema": "./node_modules/wrangler/config-schema.json",
       "durable_objects": {
         "bindings": [
           {
             "name": "MY_DURABLE_OBJECT",
             "class_name": "MyDurableObject"
           }
         ]
       }
     }
     ```

   * wrangler.toml

     ```toml
     [[durable_objects.bindings]]
     name = "MY_DURABLE_OBJECT"
     class_name = "MyDurableObject"
     ```

   Then define the storage backend for your Durable Object:

   * wrangler.jsonc

     ```jsonc
     {
       "$schema": "./node_modules/wrangler/config-schema.json",
       "migrations": [
         {
           "tag": "v1",
           "new_sqlite_classes": [
             "MyDurableObject"
           ]
         }
       ]
     }
     ```

   * wrangler.toml

     ```toml
     [[migrations]]
     tag = "v1" # Should be unique for each entry
     new_sqlite_classes = ["MyDurableObject"] # Array of new classes
     ```

   Then test your new Durable Object locally by running `wrangler dev`:

   ```plaintext
   npx wrangler dev
   ```

   Consult the [Durable Objects documentation](https://developers.cloudflare.com/durable-objects/) for more details.

May 14, 2025

1. ### [Hyperdrive achieves FedRAMP Moderate-Impact Authorization](https://developers.cloudflare.com/changelog/2025-05-14-hyperdrive-fedramp/)

   [Hyperdrive](https://developers.cloudflare.com/hyperdrive/)

   Hyperdrive has been approved for FedRAMP Authorization and is now available in the [FedRAMP Marketplace](https://marketplace.fedramp.gov/products/FR2000863987).

   FedRAMP is a U.S. government program that provides standardized assessment and authorization for cloud products and services. As a result of this product update, Hyperdrive has been approved as an authorized service to be used by U.S. federal agencies at the Moderate Impact level.

   For detailed information regarding FedRAMP and its implications, please refer to the [official FedRAMP documentation for Cloudflare](https://marketplace.fedramp.gov/products/FR2000863987).

May 14, 2025

1. ### [Introducing Origin Restrictions for Media Transformations](https://developers.cloudflare.com/changelog/2025-05-14-media-transformations-origin-restrictions/)

   [Stream](https://developers.cloudflare.com/stream/)

   We are adding [source origin restrictions](https://developers.cloudflare.com/stream/transform-videos/sources/) to the Media Transformations beta. This allows customers to restrict what sources can be used to fetch images and video for transformations. This feature is the same as --- and uses the same settings as --- [Image Transformations sources](https://developers.cloudflare.com/images/transform-images/sources/).

   When transformations is first enabled, the default setting only allows transformations on images and media from the same website or domain being used to make the transformation request. In other words, by default, requests to `example.com/cdn-cgi/media` can only reference originals on `example.com`.

   ![Enable allowed origins from the Cloudflare dashboard](https://developers.cloudflare.com/_astro/allowed-origins.4hu5lHws_1geX4Q.webp)

   Adding access to other sources, or allowing any source, [is easy to do](https://developers.cloudflare.com/images/transform-images/sources/) in the **Transformations** tab under **Stream**. Click each domain enabled for Transformations and set its sources list to match the needs of your content. The user making this change will need permission to edit zone settings.

   For more information, learn about [Transforming Videos](https://developers.cloudflare.com/stream/transform-videos/).

May 13, 2025

1. ### [SAML HTTP-POST bindings support for RBI](https://developers.cloudflare.com/changelog/2025-05-13-rbi-saml-post-support/)

   [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)

   Remote Browser Isolation (RBI) now supports SAML HTTP-POST bindings, enabling seamless authentication for SSO-enabled applications that rely on POST-based SAML responses from Identity Providers (IdPs) within a Remote Browser Isolation session. This update resolves a previous limitation that caused `405` errors during login and improves compatibility with multi-factor authentication (MFA) flows.

   With expanded support for major IdPs like Okta and Azure AD, this enhancement delivers a more consistent and user-friendly experience across authentication workflows. Learn how to [set up Remote Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/).

May 12, 2025

1. ### [Case Sensitive Custom Word Lists](https://developers.cloudflare.com/changelog/2025-05-12-case-sensitive-cwl/)

   [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

   You can now configure [custom word lists](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/#custom-wordlist) to enforce case sensitivity. This setting supports flexibility where needed and aims to reduce false positives where letter casing is critical.

   ![dlp](https://developers.cloudflare.com/_astro/case-sesitive-cwl.MPuOc_3r_2hrao0.webp)

May 09, 2025

1. ### [Publish messages to Queues directly via HTTP](https://developers.cloudflare.com/changelog/2025-05-09-publish-to-queues-via-http/)

   [Queues](https://developers.cloudflare.com/queues/)

   You can now publish messages to [Cloudflare Queues](https://developers.cloudflare.com/queues/) directly via HTTP from any service or programming language that supports sending HTTP requests. Previously, publishing to queues was only possible from within [Cloudflare Workers](https://developers.cloudflare.com/workers/). You can already consume from queues via Workers or [HTTP pull consumers](https://developers.cloudflare.com/queues/configuration/pull-consumers/), and now publishing is just as flexible.

   Publishing via HTTP requires a [Cloudflare API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) with `Queues Edit` permissions for authentication. Here's a simple example:

   ```bash
   curl "https://api.cloudflare.com/client/v4/accounts/<account_id>/queues/<queue_id>/messages" \
     -X POST \
     -H 'Authorization: Bearer <api_token>' \
     --data '{ "body": { "greeting": "hello", "timestamp":  "2025-07-24T12:00:00Z"} }'
   ```

   You can also use our [SDKs](https://developers.cloudflare.com/fundamentals/api/reference/sdks/) for TypeScript, Python, and Go.

   To get started with HTTP publishing, check out our [step-by-step example](https://developers.cloudflare.com/queues/examples/publish-to-a-queue-via-http/) and the full API documentation in our [API reference](https://developers.cloudflare.com/api/resources/queues/subresources/messages/methods/push/).

May 09, 2025

1. ### [More ways to match — Snippets now support Custom Lists, Bot Score, and WAF Attack Score](https://developers.cloudflare.com/changelog/2025-05-09-snippets-cloud-connector-lists-waf-bot-scores/)

   [Rules](https://developers.cloudflare.com/rules/)

   You can now use IP, Autonomous System (AS), and Hostname [custom lists](https://developers.cloudflare.com/waf/tools/lists/custom-lists/) to route traffic to [Snippets](https://developers.cloudflare.com/rules/snippets/) and [Cloud Connector](https://developers.cloudflare.com/rules/cloud-connector/), giving you greater precision and control over how you match and process requests at the edge.

   In Snippets, you can now also match on [Bot Score](https://developers.cloudflare.com/bots/concepts/bot-score/) and [WAF Attack Score](https://developers.cloudflare.com/waf/detections/attack-score/), unlocking smarter edge logic for everything from request filtering and mitigation to [tarpitting](https://developers.cloudflare.com/rules/snippets/examples/slow-suspicious-requests/) and logging.

   **What’s new:**

   * [Custom lists](https://developers.cloudflare.com/waf/tools/lists/custom-lists/) matching – Snippets and Cloud Connector now support user-created IP, AS, and Hostname lists via dashboard or [Lists API](https://developers.cloudflare.com/api/resources/rules/subresources/lists/methods/list/). Great for shared logic across zones.
   * [Bot Score](https://developers.cloudflare.com/bots/concepts/bot-score/) and [WAF Attack Score](https://developers.cloudflare.com/waf/detections/attack-score/) – Use Cloudflare’s intelligent traffic signals to detect bots or attacks and take advanced, tailored actions with just a few lines of code.

   ![New fields in Snippets](https://developers.cloudflare.com/_astro/snippets-lists-scores.D05l6zgc_2dknVs.webp)

   These enhancements unlock new possibilities for building smarter traffic workflows with minimal code and maximum efficiency.

   Learn more in the [Snippets](https://developers.cloudflare.com/rules/snippets/) and [Cloud Connector](https://developers.cloudflare.com/rules/cloud-connector/) documentation.

May 07, 2025

1. ### [Send forensic copies to storage without DLP profiles](https://developers.cloudflare.com/changelog/2025-05-07-forensic-copy-update/)

   [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)

   You can now [send DLP forensic copies](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#send-http-requests-to-logpush-destination/) to third-party storage for any HTTP policy with an `Allow` or `Block` action, without needing to include a DLP profile. This change increases flexibility for data handling and forensic investigation use cases.

   By default, Gateway will send all matched HTTP requests to your configured DLP Forensic Copy jobs.

   ![DLP](https://developers.cloudflare.com/_astro/forensic-copies-for-all.fxeFrCY4_1rLkLy.webp)

May 06, 2025

1. ### [UDP and ICMP Monitor Support for Private Load Balancing Endpoints](https://developers.cloudflare.com/changelog/2025-05-06-private-health-monitoring-methods/)

   [Load Balancing](https://developers.cloudflare.com/load-balancing/)

   Cloudflare Load Balancing now supports **UDP (Layer 4)** and **ICMP (Layer 3)** health monitors for **private endpoints**. This makes it simple to track the health and availability of internal services that don’t respond to HTTP, TCP, or other protocol probes.

   #### What you can do:

   * Set up **ICMP ping monitors** to check if your private endpoints are reachable.
   * Use **UDP monitors** for lightweight health checks on non-TCP workloads, such as DNS, VoIP, or custom UDP-based services.
   * Gain better visibility and uptime guarantees for services running behind **Private Network Load Balancing**, without requiring public IP addresses.

   This enhancement is ideal for internal applications that rely on low-level protocols, especially when used in conjunction with [**Cloudflare Tunnel**](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/), [**WARP**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/), and [**Magic WAN**](https://developers.cloudflare.com/magic-wan/) to create a secure and observable private network.

   Learn more about [Private Network Load Balancing](https://developers.cloudflare.com/load-balancing/private-network/) or view the full list of [supported health monitor protocols](https://developers.cloudflare.com/load-balancing/monitors/#supported-protocols).

May 06, 2025

1. ### [Terraform v5.4.0 now available](https://developers.cloudflare.com/changelog/2025-05-06-terraform-v540-provider/)

   [Cloudflare Fundamentals ](https://developers.cloudflare.com/fundamentals/)[Terraform](https://developers.cloudflare.com/terraform/)

   Earlier this year, we announced the launch of the new [Terraform v5 Provider](https://developers.cloudflare.com/changelog/2025-02-03-terraform-v5-provider/). Unlike the earlier Terraform providers, v5 is automatically generated based on the OpenAPI Schemas for our REST APIs. Since launch, we have seen an unexpectedly high number of [issues](https://github.com/cloudflare/terraform-provider-cloudflare) reported by customers. These issues currently impact about 15% of resources. We have been working diligently to address these issues across the company, and have released the v5.4.0 release which includes a number of bug fixes. Please keep an eye on this changelog for more information about upcoming releases.

   #### Changes

   * Removes the `worker_platforms_script_secret` resource from the provider (see [migration guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade#cloudflare_worker_secret) for alternatives—applicable to both Workers and Workers for Platforms)

   * Removes duplicated fields in `cloudflare_cloud_connector_rules` resource

   * Fixes `cloudflare_workers_route` id issues [#5134](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5134) [#5501](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5501)

   * Fixes issue around refreshing resources that have unsupported response types

     Affected resources

     * `cloudflare_certificate_pack`
     * `cloudflare_registrar_domain`
     * `cloudflare_stream_download`
     * `cloudflare_stream_webhook`
     * `cloudflare_user`
     * `cloudflare_workers_kv`
     * `cloudflare_workers_script`

   * Fixes `cloudflare_workers_kv` state refresh issues

   * Fixes issues around configurability of nested properties without computed values for the following resources

     Affected resources

     * `cloudflare_account`
     * `cloudflare_account_dns_settings`
     * `cloudflare_account_token`
     * `cloudflare_api_token`
     * `cloudflare_cloud_connector_rules`
     * `cloudflare_custom_ssl`
     * `cloudflare_d1_database`
     * `cloudflare_dns_record`
     * `email_security_trusted_domains`
     * `cloudflare_hyperdrive_config`
     * `cloudflare_keyless_certificate`
     * `cloudflare_list_item`
     * `cloudflare_load_balancer`
     * `cloudflare_logpush_dataset_job`
     * `cloudflare_magic_network_monitoring_configuration`
     * `cloudflare_magic_transit_site`
     * `cloudflare_magic_transit_site_lan`
     * `cloudflare_magic_transit_site_wan`
     * `cloudflare_magic_wan_static_route`
     * `cloudflare_notification_policy`
     * `cloudflare_pages_project`
     * `cloudflare_queue`
     * `cloudflare_queue_consumer`
     * `cloudflare_r2_bucket_cors`
     * `cloudflare_r2_bucket_event_notification`
     * `cloudflare_r2_bucket_lifecycle`
     * `cloudflare_r2_bucket_lock`
     * `cloudflare_r2_bucket_sippy`
     * `cloudflare_ruleset`
     * `cloudflare_snippet_rules`
     * `cloudflare_snippets`
     * `cloudflare_spectrum_application`
     * `cloudflare_workers_deployment`
     * `cloudflare_zero_trust_access_application`
     * `cloudflare_zero_trust_access_group`

   * Fixed defaults that made `cloudflare_workers_script` fail when using Assets

   * Fixed Workers Logpush setting in `cloudflare_workers_script` mistakenly being readonly

   * Fixed `cloudflare_pages_project` broken when using "source"

   The detailed [changelog](https://github.com/cloudflare/terraform-provider-cloudflare/releases/tag/v5.4.0) is available on GitHub.

   #### Upgrading

   If you are evaluating a move from v4 to v5, please make use of the [migration guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade). We have provided automated migration scripts using Grit which simplify the transition, although these do not support implementations which use Terraform modules, so customers making use of modules need to migrate manually. Please make use of `terraform plan` to test your changes before applying, and let us know if you encounter any additional issues either by reporting to our [GitHub repository](https://github.com/cloudflare/terraform-provider-cloudflare), or by opening a [support ticket](https://www.support.cloudflare.com/s/?language=en_US).

   #### For more info

   * [Terraform provider](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs)
   * [Documentation on using Terraform with Cloudflare](https://developers.cloudflare.com/terraform/)

May 01, 2025

1. ### [Browser Isolation Overview page for Zero Trust](https://developers.cloudflare.com/changelog/2025-05-01-browser-isolation-overview-page/)

   [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)

   A new **Browser Isolation Overview** page is now available in the Cloudflare Zero Trust dashboard. This centralized view simplifies the management of [Remote Browser Isolation (RBI)](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/) deployments, providing:

   * **Streamlined Onboarding:** Easily set up and manage isolation policies from one location.
   * **Quick Testing:** Validate [clientless web application isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/) with ease.
   * **Simplified Configuration:** Configure [isolated access applications](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/isolate-application/) and policies efficiently.
   * **Centralized Monitoring:** Track aggregate usage and blocked actions.

   This update consolidates previously disparate settings, accelerating deployment, improving visibility into isolation activity, and making it easier to ensure your protections are working effectively.

   ![Browser Isolation Overview](https://developers.cloudflare.com/_astro/browser-isolation-overview.Ljd5ax_O_PTyT8.webp)

   To access the new overview, log in to your Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/) and find Browser Isolation in the side navigation bar.

May 01, 2025

1. ### [R2 Dashboard experience gets new updates](https://developers.cloudflare.com/changelog/2025-05-01-r2-dashboard-updates/)

   [R2](https://developers.cloudflare.com/r2/)

   We're excited to announce several improvements to the [Cloudflare R2](https://developers.cloudflare.com/r2/) dashboard experience that make managing your object storage easier and more intuitive:

   ![Cloudflare R2 Dashboard](https://developers.cloudflare.com/_astro/r2-dashboard-updates.B7WXxzMk_1bB1F3.webp)

   #### All-new settings page

   We've redesigned the bucket settings page, giving you a centralized location to manage all your bucket configurations in one place.

   #### Improved navigation and sharing

   * Deeplink support for prefix directories: Navigate through your bucket hierarchy without losing your state. Your browser's back button now works as expected, and you can share direct links to specific prefix directories with teammates.
   * Objects as clickable links: Objects are now proper links that you can copy or `CMD + Click` to open in a new tab.

   #### Clearer public access controls

   * Renamed "r2.dev domain" to "Public Development URL" for better clarity when exposing bucket contents for non-production workloads.
   * Public Access status now clearly displays "Enabled" when your bucket is exposed to the internet (via Public Development URL or Custom Domains).

   We've also made numerous other usability improvements across the board to make your R2 experience smoother and more productive.

Apr 17, 2025

1. ### [Increased limits for Queues pull consumers](https://developers.cloudflare.com/changelog/2025-04-17-pull-consumer-limits/)

   [Queues](https://developers.cloudflare.com/queues/)

   [Queues pull consumers](https://developers.cloudflare.com/queues/configuration/pull-consumers/) can now pull and acknowledge up to **5,000 messages / second per queue**. Previously, pull consumers were rate limited to 1,200 requests / 5 minutes, aggregated across all queues.

   Pull consumers allow you to consume messages over HTTP from any environment—including outside of [Cloudflare Workers](https://developers.cloudflare.com/workers). They’re also useful when you need fine-grained control over how quickly messages are consumed.

   To setup a new queue with a pull based consumer using [Wrangler](https://developers.cloudflare.com/workers/wrangler/), run:

   ```sh
   npx wrangler queues create my-queue
   npx wrangler queues consumer http add my-queue
   ```

   You can also configure a pull consumer using the [REST API](https://developers.cloudflare.com/api/resources/queues/subresources/consumers/methods/create/) or the Queues dashboard.

   Once configured, you can pull messages from the queue using any HTTP client. You'll need a [Cloudflare API Token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) with `queues_read` and `queues_write` permissions. For example:

   ```bash
   curl "https://api.cloudflare.com/client/v4/accounts/${CF_ACCOUNT_ID}/queues/${QUEUE_ID}/messages/pull" \
   --header "Authorization: Bearer ${API_TOKEN}" \
   --header "Content-Type: application/json" \
   --data '{ "visibility_timeout": 10000, "batch_size": 2 }'
   ```

   To learn more about how to acknowledge messages, pull batches at once, and setup multiple consumers, refer to the [pull consumer documentation](https://developers.cloudflare.com/queues/configuration/pull-consumers).

   As always, Queues doesn't charge for data egress. Pull operations continue to be billed at the [existing rate](https://developers.cloudflare.com/queues/platform/pricing), of $0.40 / million operations. The increased limits are available now, on all new and existing queues. If you're new to Queues, [get started with the Cloudflare Queues guide](https://developers.cloudflare.com/queues/get-started).

Apr 17, 2025

1. ### [Read multiple keys from Workers KV with bulk reads](https://developers.cloudflare.com/changelog/2025-04-10-kv-bulk-reads/)

   [KV](https://developers.cloudflare.com/kv/)

   You can now retrieve up to 100 keys in a single bulk read request made to Workers KV using the binding.

   This makes it easier to request multiple KV pairs within a single Worker invocation. Retrieving many key-value pairs using the bulk read operation is more performant than making individual requests since bulk read operations are not affected by [Workers simultaneous connection limits](https://developers.cloudflare.com/workers/platform/limits/#simultaneous-open-connections).

   ```js
   // Read single key
   const key = "key-a";
   const value = await env.NAMESPACE.get(key);


   // Read multiple keys
   const keys = ["key-a", "key-b", "key-c", ...] // up to 100 keys
   const values : Map<string, string?> = await env.NAMESPACE.get(keys);


   // Print the value of "key-a" to the console.
   console.log(`The first key is ${values.get("key-a")}.`)
   ```

   Consult the [Workers KV Read key-value pairs API](https://developers.cloudflare.com/kv/api/read-key-value-pairs/) for full details on Workers KV's new bulk reads support.

Apr 15, 2025

1. ### [Fixed and documented Workers Routes and Secrets API](https://developers.cloudflare.com/changelog/2025-04-15-workers-api-fixes/)

   [Workers ](https://developers.cloudflare.com/workers/)[Workers for Platforms](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/)

   #### Workers Routes API

   Previously, a request to the Workers [Create Route API](https://developers.cloudflare.com/api/resources/workers/subresources/routes/methods/create/) always returned `null` for "script" and an empty string for "pattern" even if the request was successful.

   ```bash
   curl https://api.cloudflare.com/client/v4/zones/$CF_ACCOUNT_ID/workers/routes \
   -X PUT \
   -H "Authorization: Bearer $CF_API_TOKEN" \
   -H 'Content-Type: application/json' \
   --data '{ "pattern": "example.com/*", "script": "hello-world-script" }'
   ```

   ```json
   {
     "result": {
       "id": "bf153a27ba2b464bb9f04dcf75de1ef9",
       "pattern": "",
       "script": null,
       "request_limit_fail_open": false
     },
     "success": true,
     "errors": [],
     "messages": []
   }
   ```

   Now, it properly returns all values!

   ```json
   {
     "result": {
       "id": "bf153a27ba2b464bb9f04dcf75de1ef9",
       "pattern": "example.com/*",
       "script": "hello-world-script",
       "request_limit_fail_open": false
     },
     "success": true,
     "errors": [],
     "messages": []
   }
   ```

   #### Workers Secrets API

   The [Workers](https://developers.cloudflare.com/api/resources/workers/subresources/scripts/subresources/secrets/) and [Workers for Platforms](https://developers.cloudflare.com/api/resources/workers_for_platforms/subresources/dispatch/subresources/namespaces/subresources/scripts/subresources/secrets/) secrets APIs are now properly documented in the Cloudflare OpenAPI docs. Previously, these endpoints were not publicly documented, leaving users confused on how to directly manage their secrets via the API. Now, you can find the proper endpoints in our public documentation, as well as in our API Library SDKs such as [cloudflare-typescript](https://github.com/cloudflare/cloudflare-typescript) (>4.2.0) and [cloudflare-python](https://github.com/cloudflare/cloudflare-python) (>4.1.0).

   Note the `cloudflare_workers_secret` and `cloudflare_workers_for_platforms_script_secret` [Terraform resources](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs) are being removed in a future release. This resource is not recommended for managing secrets. Users should instead use the:

   * [Secrets Store](https://developers.cloudflare.com/api/resources/secrets_store/) with the "Secrets Store Secret" binding on Workers and Workers for Platforms Script Upload
   * "Secret Text" Binding on [Workers Script Upload](https://developers.cloudflare.com/api/resources/workers/subresources/scripts/methods/update/) and [Workers for Platforms Script Upload](https://developers.cloudflare.com/api/resources/workers_for_platforms/subresources/dispatch/subresources/namespaces/subresources/scripts/methods/update/)
   * Workers (and WFP) Secrets API

Apr 11, 2025

1. ### [Signed URLs and Infrastructure Improvements on Stream Live WebRTC Beta](https://developers.cloudflare.com/changelog/2025-04-14-webrtc-beta-signed-urls/)

   [Stream](https://developers.cloudflare.com/stream/)

   Cloudflare [Stream](https://developers.cloudflare.com/stream/) has completed an infrastructure upgrade for our [Live WebRTC beta](https://developers.cloudflare.com/stream/webrtc-beta/) support which brings increased scalability and improved playback performance to all customers. WebRTC allows broadcasting directly from a browser (or supported WHIP client) with ultra-low latency to tens of thousands of concurrent viewers across the globe.

   Additionally, as part of this upgrade, the WebRTC beta now supports Signed URLs to protect playback, just like our standard live stream options (HLS/DASH).

   For more information, learn about the [Stream Live WebRTC beta](https://developers.cloudflare.com/stream/webrtc-beta/).

Apr 11, 2025

1. ### [Workers AI for Developer Week - faster inference, new models, async batch API, expanded LoRA support](https://developers.cloudflare.com/changelog/2025-04-11-new-models-faster-inference/)

   [Workers AI](https://developers.cloudflare.com/workers-ai/)

   Happy Developer Week 2025! Workers AI is excited to announce a couple of new features and improvements available today. Check out our [blog](https://blog.cloudflare.com/workers-ai-improvements) for all the announcement details.

   #### Faster inference + New models

   We’re rolling out some in-place improvements to our models that can help speed up inference by 2-4x! Users of the models below will enjoy an automatic speed boost starting today:

   * [`@cf/meta/llama-3.3-70b-instruct-fp8-fast`](https://developers.cloudflare.com/workers-ai/models/llama-3.3-70b-instruct-fp8-fast/) gets a speed boost of 2-4x, leveraging techniques like speculative decoding, prefix caching, and an updated inference backend.
   * [`@cf/baai/bge-small-en-v1.5`](https://developers.cloudflare.com/workers-ai/models/bge-small-en-v1.5/), [`@cf/baai/bge-base-en-v1.5`](https://developers.cloudflare.com/workers-ai/models/bge-base-en-v1.5/), [`@cf/baai/bge-large-en-v1.5`](https://developers.cloudflare.com/workers-ai/models/bge-large-en-v1.5/) get an updated back end, which should improve inference times by 2x.
     * With the `bge` models, we’re also announcing a new parameter called `pooling` which can take `cls` or `mean` as options. We highly recommend using `pooling: cls` which will help generate more accurate embeddings. However, embeddings generated with cls pooling are not backwards compatible with mean pooling. For this to not be a breaking change, the default remains as mean pooling. Please specify `pooling: cls` to enjoy more accurate embeddings going forward.

   We’re also excited to launch a few new models in our catalog to help round out your experience with Workers AI. We’ll be deprecating some older models in the future, so stay tuned for a deprecation announcement. Today’s new models include:

   * [`@cf/mistralai/mistral-small-3.1-24b-instruct`](https://developers.cloudflare.com/workers-ai/models/mistral-small-3.1-24b-instruct/): a 24B parameter model achieving state-of-the-art capabilities comparable to larger models, with support for vision and tool calling.
   * [`@cf/google/gemma-3-12b-it`](https://developers.cloudflare.com/workers-ai/models/gemma-3-12b-it/): well-suited for a variety of text generation and image understanding tasks, including question answering, summarization and reasoning, with a 128K context window, and multilingual support in over 140 languages.
   * [`@cf/qwen/qwq-32b`](https://developers.cloudflare.com/workers-ai/models/qwq-32b/): a medium-sized reasoning model, which is capable of achieving competitive performance against state-of-the-art reasoning models, e.g., DeepSeek-R1, o1-mini.
   * [`@cf/qwen/qwen2.5-coder-32b-instruct`](https://developers.cloudflare.com/workers-ai/models/qwen2.5-coder-32b-instruct/): the current state-of-the-art open-source code LLM, with its coding abilities matching those of GPT-4o.

   #### Batch Inference

   Introducing a new batch inference feature that allows you to send us an array of requests, which we will fulfill as fast as possible and send them back as an array. This is really helpful for large workloads such as summarization, embeddings, etc. where you don’t have a human-in-the-loop. Using the batch API will guarantee that your requests are fulfilled eventually, rather than erroring out if we don’t have enough capacity at a given time.

   Check out the [tutorial](https://developers.cloudflare.com/workers-ai/features/batch-api/) to get started! Models that support batch inference today include:

   * [`@cf/meta/llama-3.3-70b-instruct-fp8-fast`](https://developers.cloudflare.com/workers-ai/models/llama-3.3-70b-instruct-fp8-fast/)
   * [`@cf/baai/bge-small-en-v1.5`](https://developers.cloudflare.com/workers-ai/models/bge-small-en-v1.5/)
   * [`@cf/baai/bge-base-en-v1.5`](https://developers.cloudflare.com/workers-ai/models/bge-base-en-v1.5/)
   * [`@cf/baai/bge-large-en-v1.5`](https://developers.cloudflare.com/workers-ai/models/bge-large-en-v1.5/)
   * [`@cf/baai/bge-m3`](https://developers.cloudflare.com/workers-ai/models/bge-m3/)
   * [`@cf/meta/m2m100-1.2b`](https://developers.cloudflare.com/workers-ai/models/m2m100-1.2b/)

   #### Expanded LoRA support

   We’ve upgraded our LoRA experience to include 8 newer models, and can support ranks of up to 32 with a 300MB safetensors file limit (previously limited to rank of 8 and 100MB safetensors) Check out our [LoRAs page](https://developers.cloudflare.com/workers-ai/features/fine-tunes/loras/) to get started. Models that support LoRAs now include:

   * [`@cf/meta/llama-3.2-11b-vision-instruct`](https://developers.cloudflare.com/workers-ai/models/llama-3.2-11b-vision-instruct/)
   * [`@cf/meta/llama-3.3-70b-instruct-fp8-fast`](https://developers.cloudflare.com/workers-ai/models/llama-3.3-70b-instruct-fp8-fast/)
   * [`@cf/meta/llama-guard-3-8b`](https://developers.cloudflare.com/workers-ai/models/llama-guard-3-8b/)
   * [`@cf/meta/llama-3.1-8b-instruct-fast`](https://developers.cloudflare.com/workers-ai/models/llama-3.1-8b-instruct-fast/) (coming soon)
   * [`@cf/deepseek-ai/deepseek-r1-distill-qwen-32b`](https://developers.cloudflare.com/workers-ai/models/deepseek-r1-distill-qwen-32b/) (coming soon)
   * [`@cf/qwen/qwen2.5-coder-32b-instruct`](https://developers.cloudflare.com/workers-ai/models/qwen2.5-coder-32b-instruct/)
   * [`@cf/qwen/qwq-32b`](https://developers.cloudflare.com/workers-ai/models/qwq-32b/)
   * [`@cf/mistralai/mistral-small-3.1-24b-instruct`](https://developers.cloudflare.com/workers-ai/models/mistral-small-3.1-24b-instruct/)
   * [`@cf/google/gemma-3-12b-it`](https://developers.cloudflare.com/workers-ai/models/gemma-3-12b-it/)

Apr 10, 2025

1. ### [D1 Read Replication Public Beta](https://developers.cloudflare.com/changelog/2025-04-10-d1-read-replication-beta/)

   [D1 ](https://developers.cloudflare.com/d1/)[Workers](https://developers.cloudflare.com/workers/)

   D1 read replication is available in public beta to help lower average latency and increase overall throughput for read-heavy applications like e-commerce websites or content management tools.

   Workers can leverage read-only database copies, called read replicas, by using D1 [Sessions API](https://developers.cloudflare.com/d1/best-practices/read-replication). A session encapsulates all the queries from one logical session for your application. For example, a session may correspond to all queries coming from a particular web browser session. With Sessions API, D1 queries in a session are guaranteed to be [sequentially consistent](https://developers.cloudflare.com/d1/best-practices/read-replication/#replica-lag-and-consistency-model) to avoid data consistency pitfalls. D1 [bookmarks](https://developers.cloudflare.com/d1/reference/time-travel/#bookmarks) can be used from a previous session to ensure logical consistency between sessions.

   ```ts
   // retrieve bookmark from previous session stored in HTTP header
   const bookmark = request.headers.get("x-d1-bookmark") ?? "first-unconstrained";


   const session = env.DB.withSession(bookmark);
   const result = await session
     .prepare(`SELECT * FROM Customers WHERE CompanyName = 'Bs Beverages'`)
     .run();
   // store bookmark for a future session
   response.headers.set("x-d1-bookmark", session.getBookmark() ?? "");
   ```

   Read replicas are automatically created by Cloudflare (currently one in each supported [D1 region](https://developers.cloudflare.com/d1/best-practices/read-replication/#read-replica-locations)), are active/inactive based on query traffic, and are transparently routed to by Cloudflare at no additional cost.

   To checkout D1 read replication, deploy the following Worker code using Sessions API, which will prompt you to create a D1 database and enable read replication on said database.

   [![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/d1-starter-sessions-api)

   To learn more about how read replication was implemented, go to our [blog post](https://blog.cloudflare.com/d1-read-replication-beta).

Apr 10, 2025

1. ### [Cloudflare Pipelines now available in beta](https://developers.cloudflare.com/changelog/2025-04-10-launching-pipelines/)

   [Pipelines ](https://developers.cloudflare.com/pipelines/)[R2 ](https://developers.cloudflare.com/r2/)[Workers](https://developers.cloudflare.com/workers/)

   [Cloudflare Pipelines](https://developers.cloudflare.com/pipelines) is now available in beta, to all users with a [Workers Paid](https://developers.cloudflare.com/workers/platform/pricing) plan.

   Pipelines let you ingest high volumes of real time data, without managing the underlying infrastructure. A single pipeline can ingest up to 100 MB of data per second, via HTTP or from a [Worker](https://developers.cloudflare.com/workers). Ingested data is automatically batched, written to output files, and delivered to an [R2 bucket](https://developers.cloudflare.com/r2) in your account. You can use Pipelines to build a data lake of clickstream data, or to store events from a Worker.

   Create your first pipeline with a single command:

   ```bash
   $ npx wrangler@latest pipelines create my-clickstream-pipeline --r2-bucket my-bucket


   🌀 Authorizing R2 bucket "my-bucket"
   🌀 Creating pipeline named "my-clickstream-pipeline"
   ✅ Successfully created pipeline my-clickstream-pipeline


   Id:    0e00c5ff09b34d018152af98d06f5a1xvc
   Name:  my-clickstream-pipeline
   Sources:
     HTTP:
       Endpoint:        https://0e00c5ff09b34d018152af98d06f5a1xvc.pipelines.cloudflare.com/
       Authentication:  off
       Format:          JSON
     Worker:
       Format:  JSON
   Destination:
     Type:         R2
     Bucket:       my-bucket
     Format:       newline-delimited JSON
     Compression:  GZIP
   Batch hints:
     Max bytes:     100 MB
     Max duration:  300 seconds
     Max records:   100,000


   🎉 You can now send data to your pipeline!


   Send data to your pipeline's HTTP endpoint:
   curl "https://0e00c5ff09b34d018152af98d06f5a1xvc.pipelines.cloudflare.com/" -d '[{ ...JSON_DATA... }]'


   To send data to your pipeline from a Worker, add the following configuration to your config file:
   {
     "pipelines": [
       {
         "pipeline": "my-clickstream-pipeline",
         "binding": "PIPELINE"
       }
     ]
   }
   ```

   Head over to our [getting started guide](https://developers.cloudflare.com/pipelines/getting-started) for an in-depth tutorial to building with Pipelines.

Apr 10, 2025

1. ### [R2 Data Catalog is a managed Apache Iceberg data catalog built directly into R2 buckets](https://developers.cloudflare.com/changelog/2025-04-10-r2-data-catalog-beta/)

   [R2](https://developers.cloudflare.com/r2/)

   Today, we're launching [R2 Data Catalog](https://developers.cloudflare.com/r2/data-catalog/) in open beta, a managed Apache Iceberg catalog built directly into your [Cloudflare R2](https://developers.cloudflare.com/r2/) bucket.

   If you're not already familiar with it, [Apache Iceberg](https://iceberg.apache.org/) is an open table format designed to handle large-scale analytics datasets stored in object storage, offering ACID transactions and schema evolution. R2 Data Catalog exposes a standard Iceberg REST catalog interface, so you can connect engines like [Spark](https://developers.cloudflare.com/r2/data-catalog/config-examples/spark-scala/), [Snowflake](https://developers.cloudflare.com/r2/data-catalog/config-examples/snowflake/), and [PyIceberg](https://developers.cloudflare.com/r2/data-catalog/config-examples/pyiceberg/) to start querying your tables using the tools you already know.

   To enable a data catalog on your R2 bucket, find **R2 Data Catalog** in your buckets settings in the dashboard, or run:

   ```bash
   npx wrangler r2 bucket catalog enable my-bucket
   ```

   And that's it. You'll get a catalog URI and warehouse you can plug into your favorite Iceberg engines.

   Visit our [getting started guide](https://developers.cloudflare.com/r2/data-catalog/get-started/) for step-by-step instructions on enabling R2 Data Catalog, creating tables, and running your first queries.

Apr 09, 2025

1. ### [Hyperdrive now supports custom TLS/SSL certificates](https://developers.cloudflare.com/changelog/2025-04-09-hyperdrive-custom-certificate-support/)

   [Hyperdrive](https://developers.cloudflare.com/hyperdrive/)

   Hyperdrive now supports more SSL/TLS security options for your database connections:

   * Configure Hyperdrive to verify server certificates with `verify-ca` or `verify-full` SSL modes and protect against man-in-the-middle attacks
   * Configure Hyperdrive to provide client certificates to the database server to authenticate itself (mTLS) for stronger security beyond username and password

   Use the new `wrangler cert` commands to create certificate authority (CA) certificate bundles or client certificate pairs:

   ```bash
   # Create CA certificate bundle
   npx wrangler cert upload certificate-authority --ca-cert your-ca-cert.pem --name your-custom-ca-name


   # Create client certificate pair
   npx wrangler cert upload mtls-certificate --cert client-cert.pem --key client-key.pem --name your-client-cert-name
   ```

   Then create a Hyperdrive configuration with the certificates and desired SSL mode:

   ```bash
   npx wrangler hyperdrive create your-hyperdrive-config \
     --connection-string="postgres://user:password@hostname:port/database" \
     --ca-certificate-id <CA_CERT_ID> \
     --mtls-certificate-id <CLIENT_CERT_ID>
     --sslmode verify-full
   ```

   Learn more about [configuring SSL/TLS certificates for Hyperdrive](https://developers.cloudflare.com/hyperdrive/configuration/tls-ssl-certificates-for-hyperdrive/) to enhance your database security posture.

Apr 09, 2025

1. ### [Cloudflare Secrets Store now available in Beta](https://developers.cloudflare.com/changelog/2025-04-09-secrets-store-beta/)

   [Secrets Store ](https://developers.cloudflare.com/secrets-store/)[SSL/TLS](https://developers.cloudflare.com/ssl/)

   Cloudflare Secrets Store is available today in Beta. You can now store, manage, and deploy account level secrets from a secure, centralized platform to your Workers.

   ![Import repo or choose template](https://developers.cloudflare.com/_astro/secrets-store-landing-page.BQoEWsq8_1OnK0D.webp)

   To spin up your Cloudflare Secrets Store, simply click the new Secrets Store tab [in the dashboard](http://dash.cloudflare.com/?to=/:account/secrets-store) or use this Wrangler command:

   ```sh
   wrangler secrets-store store create <name> --remote
   ```

   The following are supported in the Secrets Store beta:

   * Secrets Store UI & API: create your store & create, duplicate, update, scope, and delete a secret
   * Workers UI: bind a new or existing account level secret to a Worker and deploy in code
   * Wrangler: create your store & create, duplicate, update, scope, and delete a secret
   * Account Management UI & API: assign Secrets Store permissions roles & view audit logs for actions taken in Secrets Store core platform

   For instructions on how to get started, visit our [developer documentation](https://developers.cloudflare.com/secrets-store/).

Apr 08, 2025

1. ### [Local development support for Email Workers](https://developers.cloudflare.com/changelog/2025-04-08-local-development/)

   [Email Routing](https://developers.cloudflare.com/email-routing/)

   Email Workers enables developers to programmatically take action on anything that hits their email inbox. If you're building with Email Workers, you can now test the behavior of an Email Worker script, receiving, replying and sending emails in your local environment using `wrangler dev`.

   Below is an example that shows you how you can receive messages using the `email()` handler and parse them using [postal-mime](https://www.npmjs.com/package/postal-mime):

   ```ts
   import * as PostalMime from "postal-mime";


   export default {
     async email(message, env, ctx) {
       const parser = new PostalMime.default();
       const rawEmail = new Response(message.raw);
       const email = await parser.parse(await rawEmail.arrayBuffer());
       console.log(email);
     },
   };
   ```

   Now when you run `npx wrangler dev`, wrangler will expose a local `/cdn-cgi/handler/email` endpoint that you can `POST` email messages to and trigger your Worker's `email()` handler:

   ```bash
   curl -X POST 'http://localhost:8787/cdn-cgi/handler/email' \
     --url-query 'from=sender@example.com' \
     --url-query 'to=recipient@example.com' \
     --header 'Content-Type: application/json' \
     --data-raw 'Received: from smtp.example.com (127.0.0.1)
           by cloudflare-email.com (unknown) id 4fwwffRXOpyR
           for <recipient@example.com>; Tue, 27 Aug 2024 15:50:20 +0000
   From: "John" <sender@example.com>
   Reply-To: sender@example.com
   To: recipient@example.com
   Subject: Testing Email Workers Local Dev
   Content-Type: text/html; charset="windows-1252"
   X-Mailer: Curl
   Date: Tue, 27 Aug 2024 08:49:44 -0700
   Message-ID: <6114391943504294873000@ZSH-GHOSTTY>


   Hi there'
   ```

   This is what you get in the console:

   ```json
   {
     "headers": [
       {
         "key": "received",
         "value": "from smtp.example.com (127.0.0.1) by cloudflare-email.com (unknown) id 4fwwffRXOpyR for <recipient@example.com>; Tue, 27 Aug 2024 15:50:20 +0000"
       },
       { "key": "from", "value": "\"John\" <sender@example.com>" },
       { "key": "reply-to", "value": "sender@example.com" },
       { "key": "to", "value": "recipient@example.com" },
       { "key": "subject", "value": "Testing Email Workers Local Dev" },
       { "key": "content-type", "value": "text/html; charset=\"windows-1252\"" },
       { "key": "x-mailer", "value": "Curl" },
       { "key": "date", "value": "Tue, 27 Aug 2024 08:49:44 -0700" },
       {
         "key": "message-id",
         "value": "<6114391943504294873000@ZSH-GHOSTTY>"
       }
     ],
     "from": { "address": "sender@example.com", "name": "John" },
     "to": [{ "address": "recipient@example.com", "name": "" }],
     "replyTo": [{ "address": "sender@example.com", "name": "" }],
     "subject": "Testing Email Workers Local Dev",
     "messageId": "<6114391943504294873000@ZSH-GHOSTTY>",
     "date": "2024-08-27T15:49:44.000Z",
     "html": "Hi there\n",
     "attachments": []
   }
   ```

   Local development is a critical part of the development flow, and also works for sending, replying and forwarding emails. See [our documentation](https://developers.cloudflare.com/email-routing/email-workers/local-development/) for more information.

Apr 08, 2025

1. ### [Hyperdrive introduces support for MySQL and MySQL-compatible databases](https://developers.cloudflare.com/changelog/2025-04-08-hyperdrive-mysql-support/)

   [Hyperdrive](https://developers.cloudflare.com/hyperdrive/)

   Hyperdrive now supports connecting to MySQL and MySQL-compatible databases, including Amazon RDS and Aurora MySQL, Google Cloud SQL for MySQL, Azure Database for MySQL, PlanetScale and MariaDB.

   Hyperdrive makes your regional, MySQL databases fast when connecting from Cloudflare Workers. It eliminates unnecessary network roundtrips during connection setup, pools database connections globally, and can cache query results to provide the fastest possible response times.

   Best of all, you can connect using your existing drivers, ORMs, and query builders with Hyperdrive's secure credentials, no code changes required.

   ```ts
   import { createConnection } from "mysql2/promise";


   export interface Env {
     HYPERDRIVE: Hyperdrive;
   }


   export default {
     async fetch(request, env, ctx): Promise<Response> {
       const connection = await createConnection({
         host: env.HYPERDRIVE.host,
         user: env.HYPERDRIVE.user,
         password: env.HYPERDRIVE.password,
         database: env.HYPERDRIVE.database,
         port: env.HYPERDRIVE.port,
         disableEval: true, // Required for Workers compatibility
       });


       const [results, fields] = await connection.query("SHOW tables;");


       ctx.waitUntil(connection.end());


       return new Response(JSON.stringify({ results, fields }), {
         headers: {
           "Content-Type": "application/json",
           "Access-Control-Allow-Origin": "*",
         },
       });
     },
   } satisfies ExportedHandler<Env>;
   ```

   Learn more about [how Hyperdrive works](https://developers.cloudflare.com/hyperdrive/concepts/how-hyperdrive-works/) and [get started building Workers that connect to MySQL with Hyperdrive](https://developers.cloudflare.com/hyperdrive/get-started/).

Apr 08, 2025

1. ### [Hyperdrive Free plan makes fast, global database access available to all](https://developers.cloudflare.com/changelog/2025-04-08-hyperdrive-free-plan/)

   [Hyperdrive](https://developers.cloudflare.com/hyperdrive/)

   Hyperdrive is now available on the Free plan of Cloudflare Workers, enabling you to build Workers that connect to PostgreSQL or MySQL databases without compromise.

   Low-latency access to SQL databases is critical to building full-stack Workers applications. We want you to be able to build on fast, global apps on Workers, regardless of the tools you use. So we made Hyperdrive available for all, to make it easier to build Workers that connect to PostgreSQL and MySQL.

   If you want to learn more about how Hyperdrive works, read the [deep dive](https://blog.cloudflare.com/how-hyperdrive-speeds-up-database-access) on how Hyperdrive can make your database queries up to 4x faster.

   ![Hyperdrive provides edge connection setup and global connection pooling for optimal latencies.](https://developers.cloudflare.com/_astro/hyperdrive-global-placement.DHxlaFbz_Dz7Bd.webp)

   Visit the docs to [get started](https://developers.cloudflare.com/hyperdrive/get-started/) with Hyperdrive for PostgreSQL or MySQL.

Apr 08, 2025

1. ### [Full-stack frameworks are now Generally Available on Cloudflare Workers](https://developers.cloudflare.com/changelog/2025-04-08-fullstack-on-workers/)

   [Workers ](https://developers.cloudflare.com/workers/)[Workers for Platforms](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/)

   ![Full-stack on Cloudflare Workers](https://developers.cloudflare.com/_astro/fullstack-on-workers.D7fotYu2_ZJ4pgL.webp)

   The following full-stack frameworks now have Generally Available ("GA") adapters for Cloudflare Workers, and are ready for you to use in production:

   * [React Router v7 (Remix)](https://developers.cloudflare.com/workers/framework-guides/web-apps/react-router/)
   * [Astro](https://developers.cloudflare.com/workers/framework-guides/web-apps/astro/)
   * [Hono](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/hono/)
   * [Vue.js](https://developers.cloudflare.com/workers/framework-guides/web-apps/vue/)
   * [Nuxt](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/nuxt/)
   * [Svelte (SvelteKit)](https://developers.cloudflare.com/workers/framework-guides/web-apps/svelte/)
   * And [more](https://developers.cloudflare.com/workers/framework-guides/).

   The following frameworks are now in **beta**, with GA support coming very soon:

   * [Next.js](https://developers.cloudflare.com/workers/framework-guides/web-apps/nextjs/), supported through [@opennextjs/cloudflare](https://opennext.js.org/cloudflare) is now `v1.0-beta`.
   * [Angular](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/angular/)
   * [SolidJS (SolidStart)](https://developers.cloudflare.com/workers/framework-guides/web-apps/more-web-frameworks/solid/)

   You can also build complete full-stack apps on Workers **without a framework**:

   * You can [“just use Vite"](https://blog.cloudflare.com/introducing-the-cloudflare-vite-plugin) and React together, and build a back-end API in the same Worker. Follow our [React SPA with an API tutorial](https://developers.cloudflare.com/workers/vite-plugin/tutorial/) to learn how.

   **Get started building today with our [framework guides](https://developers.cloudflare.com/workers/framework-guides/)**, or read our [Developer Week 2025 blog post](https://blog.cloudflare.com/full-stack-development-on-cloudflare-workers) about all the updates to building full-stack applications on Workers.

Apr 07, 2025

1. ### [Build MCP servers with the Agents SDK](https://developers.cloudflare.com/changelog/2025-04-07-mcp-servers-agents-sdk-updates/)

   [Agents ](https://developers.cloudflare.com/agents/)[Workers](https://developers.cloudflare.com/workers/)

   The Agents SDK now includes built-in support for building remote MCP (Model Context Protocol) servers directly as part of your Agent. This allows you to easily create and manage MCP servers, without the need for additional infrastructure or configuration.

   The SDK includes a new `MCPAgent` class that extends the `Agent` class and allows you to expose resources and tools over the MCP protocol, as well as authorization and authentication to enable remote MCP servers.

   * JavaScript

     ```js
     export class MyMCP extends McpAgent {
       server = new McpServer({
         name: "Demo",
         version: "1.0.0",
       });


       async init() {
         this.server.resource(`counter`, `mcp://resource/counter`, (uri) => {
           // ...
         });


         this.server.tool(
           "add",
           "Add two numbers together",
           { a: z.number(), b: z.number() },
           async ({ a, b }) => {
             // ...
           },
         );
       }
     }
     ```

   * TypeScript

     ```ts
     export class MyMCP extends McpAgent<Env> {
       server = new McpServer({
         name: "Demo",
         version: "1.0.0",
       });


       async init() {
         this.server.resource(`counter`, `mcp://resource/counter`, (uri) => {
           // ...
         });


         this.server.tool(
           "add",
           "Add two numbers together",
           { a: z.number(), b: z.number() },
           async ({ a, b }) => {
             // ...
           },
         );
       }
     }
     ```

   See [the example](https://github.com/cloudflare/agents/tree/main/examples/mcp) for the full code and as the basis for building your own MCP servers, and the [client example](https://github.com/cloudflare/agents/tree/main/examples/mcp-client) for how to build an Agent that acts as an MCP client.

   To learn more, review the [announcement blog](https://blog.cloudflare.com/building-ai-agents-with-mcp-authn-authz-and-durable-objects) as part of Developer Week 2025.

   #### Agents SDK updates

   We've made a number of improvements to the [Agents SDK](https://developers.cloudflare.com/agents/), including:

   * Support for building MCP servers with the new `MCPAgent` class.
   * The ability to export the current agent, request and WebSocket connection context using `import { context } from "agents"`, allowing you to minimize or avoid direct dependency injection when calling tools.
   * Fixed a bug that prevented query parameters from being sent to the Agent server from the `useAgent` React hook.
   * Automatically converting the `agent` name in `useAgent` or `useAgentChat` to kebab-case to ensure it matches the naming convention expected by [`routeAgentRequest`](https://developers.cloudflare.com/agents/api-reference/calling-agents/#calling-your-agent).

   To install or update the Agents SDK, run `npm i agents@latest` in an existing project, or explore the `agents-starter` project:

   ```sh
   npm create cloudflare@latest -- --template cloudflare/agents-starter
   ```

   See the full release notes and changelog [on the Agents SDK repository](https://github.com/cloudflare/agents/blob/main/packages/agents/CHANGELOG.md) and

Apr 07, 2025

1. ### [Create fully-managed RAG pipelines for your AI applications with AutoRAG](https://developers.cloudflare.com/changelog/2025-04-07-autorag-open-beta/)

   [AI Search ](https://developers.cloudflare.com/ai-search/)[Vectorize](https://developers.cloudflare.com/vectorize/)

   [AutoRAG](https://developers.cloudflare.com/ai-search/) is now in open beta, making it easy for you to build fully-managed retrieval-augmented generation (RAG) pipelines without managing infrastructure. Just upload your docs to [R2](https://developers.cloudflare.com/r2/get-started/), and AutoRAG handles the rest: embeddings, indexing, retrieval, and response generation via API.

   ![AutoRAG open beta demo](https://developers.cloudflare.com/_astro/autorag-open-beta.Zs40SNMl_Zy2pju.webp)

   With AutoRAG, you can:

   * **Customize your pipeline:** Choose from [Workers AI](https://developers.cloudflare.com/workers-ai) models, configure chunking strategies, edit system prompts, and more.
   * **Instant setup:** AutoRAG provisions everything you need from [Vectorize](https://developers.cloudflare.com/vectorize), [AI gateway](https://developers.cloudflare.com/ai-gateway), to pipeline logic for you, so you can go from zero to a working RAG pipeline in seconds.
   * **Keep your index fresh:** AutoRAG continuously syncs your index with your data source to ensure responses stay accurate and up to date.
   * **Ask questions:** Query your data and receive grounded responses via a [Workers binding](https://developers.cloudflare.com/ai-search/usage/workers-binding/) or [API](https://developers.cloudflare.com/ai-search/usage/rest-api/).

   Whether you're building internal tools, AI-powered search, or a support assistant, AutoRAG gets you from idea to deployment in minutes.

   Get started in the [Cloudflare dashboard](https://dash.cloudflare.com/?to=/:account/ai/autorag) or check out the [guide](https://developers.cloudflare.com/ai-search/get-started/) for instructions on how to build your RAG pipeline today.

Apr 07, 2025

1. ### [Browser Rendering REST API is Generally Available, with new endpoints and a free tier](https://developers.cloudflare.com/changelog/2025-04-07-br-free-ga-playwright/)

   [Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

   We’re excited to announce Browser Rendering is now available on the [Workers Free plan](https://www.cloudflare.com/plans/developer-platform/), making it even easier to prototype and experiment with web search and headless browser use-cases when building applications on Workers.

   The Browser Rendering **[REST API](https://developers.cloudflare.com/browser-rendering/rest-api/) is now Generally Available**, allowing you to control browser instances from outside of Workers applications. We've added three new endpoints to help automate more browser tasks:

   * **Extract structured data** – Use `/json` to retrieve structured data from a webpage.
   * **Retrieve links** – Use `/links` to pull all links from a webpage.
   * **Convert to Markdown** – Use `/markdown` to convert webpage content into Markdown format.

   For example, to fetch the Markdown representation of a webpage:

   ```bash
   curl -X 'POST' 'https://api.cloudflare.com/client/v4/accounts/<accountId>/browser-rendering/markdown' \
     -H 'Content-Type: application/json' \
     -H 'Authorization: Bearer <apiToken>' \
     -d '{
       "url": "https://example.com"
     }'
   ```

   For the full list of endpoints, check out our [REST API documentation](https://developers.cloudflare.com/browser-rendering/rest-api/). You can also interact with Browser Rendering via the [Cloudflare TypeScript SDK](https://github.com/cloudflare/cloudflare-typescript).

   We also recently landed support for [Playwright](https://developers.cloudflare.com/browser-rendering/playwright/) in Browser Rendering for browser automation from Cloudflare [Workers](https://developers.cloudflare.com/workers/), in addition to [Puppeteer](https://developers.cloudflare.com/browser-rendering/puppeteer/), giving you more flexibility to test across different browser environments.

   Visit the [Browser Rendering docs](https://developers.cloudflare.com/browser-rendering/) to learn more about how to use headless browsers in your applications.

Apr 07, 2025

1. ### [Durable Objects on Workers Free plan](https://developers.cloudflare.com/changelog/2025-04-07-durable-objects-free-tier/)

   [Durable Objects ](https://developers.cloudflare.com/durable-objects/)[Workers](https://developers.cloudflare.com/workers/)

   Durable Objects can now be used with zero commitment on the [Workers Free plan](https://developers.cloudflare.com/workers/platform/pricing/) allowing you to build AI agents with [Agents SDK](https://developers.cloudflare.com/agents/), collaboration tools, and real-time applications like chat or multiplayer games.

   Durable Objects let you build stateful, serverless applications with millions of tiny coordination instances that run your application code alongside (in the same thread!) your durable storage. Each Durable Object can access its own SQLite database through a [Storage API](https://developers.cloudflare.com/durable-objects/best-practices/access-durable-objects-storage/). A Durable Object class is defined in a Worker script encapsulating the Durable Object's behavior when accessed from a Worker. To try the code below, click the button:

   [![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/templates/tree/main/hello-world-do-template)

   ```js
   import { DurableObject } from "cloudflare:workers";


   // Durable Object
   export class MyDurableObject extends DurableObject {
     ...
     async sayHello(name) {
       return `Hello, ${name}!`;
     }
   }


   // Worker
   export default {
     async fetch(request, env) {
       // Every unique ID refers to an individual instance of the Durable Object class
       const id = env.MY_DURABLE_OBJECT.idFromName("foo");


       // A stub is a client used to invoke methods on the Durable Object
       const stub = env.MY_DURABLE_OBJECT.get(id);


       // Methods on the Durable Object are invoked via the stub
       const response = await stub.sayHello("world");


       return response;
     },
   };
   ```

   Free plan [limits](https://developers.cloudflare.com/durable-objects/platform/pricing/) apply to Durable Objects compute and storage usage. Limits allow developers to build real-world applications, with every Worker request able to call a Durable Object on the free plan.

   For more information, checkout:

   * [Documentation](https://developers.cloudflare.com/durable-objects/concepts/what-are-durable-objects/)
   * [Zero-latency SQLite storage in every Durable Object blog](https://blog.cloudflare.com/sqlite-in-durable-objects/)

Apr 07, 2025

1. ### [SQLite in Durable Objects GA with 10GB storage per object](https://developers.cloudflare.com/changelog/2025-04-07-sqlite-in-durable-objects-ga/)

   [Durable Objects ](https://developers.cloudflare.com/durable-objects/)[Workers](https://developers.cloudflare.com/workers/)

   SQLite in Durable Objects is now generally available (GA) with 10GB SQLite database per Durable Object. Since the [public beta](https://blog.cloudflare.com/sqlite-in-durable-objects/) in September 2024, we've added feature parity and robustness for the SQLite storage backend compared to the preexisting key-value (KV) storage backend for Durable Objects.

   SQLite-backed Durable Objects are recommended for all new Durable Object classes, using `new_sqlite_classes` [Wrangler configuration](https://developers.cloudflare.com/durable-objects/best-practices/access-durable-objects-storage/#create-sqlite-backed-durable-object-class). Only SQLite-backed Durable Objects have access to Storage API's [SQL](https://developers.cloudflare.com/durable-objects/api/sqlite-storage-api/#sql-api) and [point-in-time recovery](https://developers.cloudflare.com/durable-objects/api/sqlite-storage-api/#pitr-point-in-time-recovery-api) methods, which provide relational data modeling, SQL querying, and better data management.

   ```js
   export class MyDurableObject extends DurableObject {
     sql: SqlStorage
     constructor(ctx: DurableObjectState, env: Env) {
       super(ctx, env);
       this.sql = ctx.storage.sql;
     }


     async sayHello() {
       let result = this.sql
         .exec("SELECT 'Hello, World!' AS greeting")
         .one();
       return result.greeting;
     }
   }
   ```

   KV-backed Durable Objects remain for backwards compatibility, and a migration path from key-value storage to SQL storage for existing Durable Object classes will be offered in the future.

   For more details on SQLite storage, checkout [Zero-latency SQLite storage in every Durable Object blog](https://blog.cloudflare.com/sqlite-in-durable-objects/).

Apr 07, 2025

1. ### [Workflows is now Generally Available](https://developers.cloudflare.com/changelog/2025-04-07-workflows-ga/)

   [Workflows ](https://developers.cloudflare.com/workflows/)[Workers](https://developers.cloudflare.com/workers/)

   [Workflows](https://developers.cloudflare.com/workflows/) is now *Generally Available* (or "GA"): in short, it's ready for production workloads. Alongside marking Workflows as GA, we've introduced a number of changes during the beta period, including:

   * A new `waitForEvent` API that allows a Workflow to wait for an event to occur before continuing execution.
   * Increased concurrency: you can [run up to 4,500 Workflow instances](https://developers.cloudflare.com/changelog/2025-02-25-workflows-concurrency-increased/) concurrently — and this will continue to grow.
   * Improved observability, including new CPU time metrics that allow you to better understand which Workflow instances are consuming the most resources and/or contributing to your bill.
   * Support for `vitest` for testing Workflows locally and in CI/CD pipelines.

   Workflows also supports the new [increased CPU limits](https://developers.cloudflare.com/changelog/2025-03-25-higher-cpu-limits/) that apply to Workers, allowing you to run more CPU-intensive tasks (up to 5 minutes of CPU time per instance), not including the time spent waiting on network calls, AI models, or other I/O bound tasks.

   #### Human-in-the-loop

   The new `step.waitForEvent` API allows a Workflow instance to wait on events and data, enabling human-in-the-the-loop interactions, such as approving or rejecting a request, directly handling webhooks from other systems, or pushing event data to a Workflow while it's running.

   Because Workflows are just code, you can conditionally execute code based on the result of a `waitForEvent` call, and/or call `waitForEvent` multiple times in a single Workflow based on what the Workflow needs.

   For example, if you wanted to implement a human-in-the-loop approval process, you could use `waitForEvent` to wait for a user to approve or reject a request, and then conditionally execute code based on the result.

   * JavaScript

     ```js
     import { Workflow, WorkflowEvent } from "cloudflare:workflows";


     export class MyWorkflow extends WorkflowEntrypoint {
       async run(event, step) {
         // Other steps in your Workflow
         let event = await step.waitForEvent(
           "receive invoice paid webhook from Stripe",
           { type: "stripe-webhook", timeout: "1 hour" },
         );
         // Rest of your Workflow
       }
     }
     ```

   * TypeScript

     ```ts
     import { Workflow, WorkflowEvent } from "cloudflare:workflows";


     export class MyWorkflow extends WorkflowEntrypoint<Env, Params> {
       async run(event: WorkflowEvent<Params>, step: WorkflowStep) {
         // Other steps in your Workflow
         let event = await step.waitForEvent<IncomingStripeWebhook>("receive invoice paid webhook from Stripe", { type: "stripe-webhook", timeout: "1 hour" })
         // Rest of your Workflow
       }
     }
     ```

   You can then send a Workflow an event from an external service via HTTP or from within a Worker using the [Workers API](https://developers.cloudflare.com/workflows/build/workers-api/) for Workflows:

   * JavaScript

     ```js
     export default {
       async fetch(req, env) {
         const instanceId = new URL(req.url).searchParams.get("instanceId");
         const webhookPayload = await req.json();


         let instance = await env.MY_WORKFLOW.get(instanceId);
         // Send our event, with `type` matching the event type defined in
         // our step.waitForEvent call
         await instance.sendEvent({
           type: "stripe-webhook",
           payload: webhookPayload,
         });


         return Response.json({
           status: await instance.status(),
         });
       },
     };
     ```

   * TypeScript

     ```ts
     export default {
       async fetch(req: Request, env: Env) {
         const instanceId = new URL(req.url).searchParams.get("instanceId")
         const webhookPayload = await req.json<Payload>()


         let instance = await env.MY_WORKFLOW.get(instanceId);
         // Send our event, with `type` matching the event type defined in
         // our step.waitForEvent call
         await instance.sendEvent({type: "stripe-webhook", payload: webhookPayload})


         return Response.json({
           status: await instance.status(),
         });
       },
     };
     ```

   Read the [GA announcement blog](https://blog.cloudflare.com/workflows-is-now-generally-available/) to learn more about what landed as part of the Workflows GA.

Apr 03, 2025

1. ### [All cache purge methods now available for all plans](https://developers.cloudflare.com/changelog/2025-04-01-purge-for-all/)

   [Cache / CDN](https://developers.cloudflare.com/cache/)

   You can now access all Cloudflare cache purge methods — no matter which plan you’re on. Whether you need to update a single asset or instantly invalidate large portions of your site’s content, you now have the same powerful tools previously reserved for Enterprise customers.

   **Anyone on Cloudflare can now:**

   1. [Purge Everything](https://developers.cloudflare.com/cache/how-to/purge-cache/purge-everything/): Clears all cached content associated with a website.
   2. [Purge by Prefix](https://developers.cloudflare.com/cache/how-to/purge-cache/purge_by_prefix/): Targets URLs sharing a common prefix.
   3. [Purge by Hostname](https://developers.cloudflare.com/cache/how-to/purge-cache/purge-by-hostname/): Invalidates content by specific hostnames.
   4. [Purge by URL (single-file purge)](https://developers.cloudflare.com/cache/how-to/purge-cache/purge-by-single-file/): Precisely targets individual URLs.
   5. [Purge by Tag](https://developers.cloudflare.com/cache/how-to/purge-cache/purge-by-tags/): Uses Cache-Tag response headers to invalidate grouped assets, offering flexibility for complex cache management scenarios.

   Want to learn how each purge method works, when to use them, or what limits apply to your plan? Dive into our [purge cache documentation](https://developers.cloudflare.com/cache/how-to/purge-cache/) and [API reference](https://developers.cloudflare.com/api/resources/cache/methods/purge/) for all the details.

Mar 27, 2025

1. ### [New Pause & Purge APIs for Queues](https://developers.cloudflare.com/changelog/2025-03-25-pause-purge-queues/)

   [Queues](https://developers.cloudflare.com/queues/)

   [Queues](https://developers.cloudflare.com/queues/) now supports the ability to pause message delivery and/or purge (delete) messages on a queue. These operations can be useful when:

   * Your consumer has a bug or downtime, and you want to temporarily stop messages from being processed while you fix the bug
   * You have pushed invalid messages to a queue due to a code change during development, and you want to clean up the backlog
   * Your queue has a backlog that is stale and you want to clean it up to allow new messages to be consumed

   To pause a queue using [Wrangler](https://developers.cloudflare.com/workers/wrangler/), run the `pause-delivery` command. Paused queues continue to receive messages. And you can easily unpause a queue using the `resume-delivery` command.

   ```bash
   $ wrangler queues pause-delivery my-queue
   Pausing message delivery for queue my-queue.
   Paused message delivery for queue my-queue.


   $ wrangler queues resume-delivery my-queue
   Resuming message delivery for queue my-queue.
   Resumed message delivery for queue my-queue.
   ```

   Purging a queue permanently deletes all messages in the queue. Unlike pausing, purging is an irreversible operation:

   ```bash
   $ wrangler queues purge my-queue
   ✔ This operation will permanently delete all the messages in queue my-queue. Type my-queue to proceed. … my-queue
   Purged queue 'my-queue'
   ```

   You can also do these operations using the [Queues REST API](https://developers.cloudflare.com/api/resources/queues/), or the dashboard page for a queue.

   ![Pause and purge using the dashboard](https://developers.cloudflare.com/_astro/pause-purge.SQ7B3RCF_1PpJqp.webp)

   This feature is available on all new and existing queues. Head over to the [pause and purge documentation](https://developers.cloudflare.com/queues/configuration/pause-purge) to learn more. And if you haven't used Cloudflare Queues before, [get started with the Cloudflare Queues guide](https://developers.cloudflare.com/queues/get-started).

Mar 27, 2025

1. ### [Register and renew .ai and .shop domains at cost](https://developers.cloudflare.com/changelog/2025-03-27-ai-domains-available/)

   [Registrar](https://developers.cloudflare.com/registrar/)

   ![Example search for .ai domains](https://developers.cloudflare.com/_astro/2025-03-27-ai-domains-available.D96eztke_Lpgh9.webp)

   Cloudflare Registrar now supports `.ai` and `.shop` domains. These are two of our most highly-requested top-level domains (TLDs) and are great additions to the [300+ other TLDs we support](https://domains.cloudflare.com/tlds).

   Starting today, customers can:

   * Register and renew these domains *at cost* without any markups or add-on fees
   * Enjoy best-in-class security and performance with native integrations with Cloudflare DNS, CDN, and SSL services like one-click DNSSEC
   * Combat domain hijacking with [Custom Domain Protection](https://www.cloudflare.com/products/registrar/custom-domain-protection/) (available on enterprise plans)

   We can't wait to see what AI and e-commerce projects you deploy on Cloudflare. To get started, transfer your domains to Cloudflare or [search for new ones to register](https://domains.cloudflare.com/).

Mar 27, 2025

1. ### [Audit logs (version 2) - Beta Release](https://developers.cloudflare.com/changelog/2025-03-27-automatic-audit-logs-beta-release/)

   [Audit Logs](https://developers.cloudflare.com/fundamentals/account/account-security/review-audit-logs/)

   The latest version of audit logs streamlines audit logging by automatically capturing all user and system actions performed through the Cloudflare Dashboard or public APIs. This update leverages Cloudflare’s existing API Shield to generate audit logs based on OpenAPI schemas, ensuring a more consistent and automated logging process.

   Availability: Audit logs (version 2) is now in Beta, with support limited to **API access**.

   Use the following API endpoint to retrieve audit logs:

   ```js
   GET https://api.cloudflare.com/client/v4/accounts/<account_id>/logs/audit?since=<date>&before=<date>
   ```

   You can access detailed documentation for audit logs (version 2) Beta API release [here](https://developers.cloudflare.com/api/resources/accounts/subresources/logs/subresources/audit/methods/list/).

   **Key Improvements in the Beta Release:**

   * **Automated & standardized logging**: Logs are now generated automatically using a standardized system, replacing manual, team-dependent logging. This ensures consistency across all Cloudflare services.

   * **Expanded product coverage**: Increased audit log coverage from 75% to 95%. Key API endpoints such as `/accounts`, `/zones`, and `/organizations` are now included.

   * **Granular filtering**: Logs now follow a uniform format, enabling precise filtering by actions, users, methods, and resources—allowing for faster and more efficient investigations.

   * **Enhanced context and traceability**: Each log entry now includes detailed context, such as the authentication method used, the interface (API or Dashboard) through which the action was performed, and mappings to Cloudflare Ray IDs for better traceability.

   * **Comprehensive activity capture**: Expanded logging to include GET requests and failed attempts, ensuring that all critical activities are recorded.

   **Known Limitations in Beta**

   * Error handling for the API is not implemented.
   * There may be gaps or missing entries in the available audit logs.
   * UI is unavailable in this Beta release.
   * System-level logs and User-Activity logs are not included.

   Support for these features is coming as part of the GA release later this year. For more details, including a sample audit log, check out our blog post: [Introducing Automatic Audit Logs](https://blog.cloudflare.com/introducing-automatic-audit-logs/)

Mar 22, 2025

1. ### [New Managed WAF rule for Next.js CVE-2025-29927.](https://developers.cloudflare.com/changelog/2025-03-22-next-js-vulnerability-waf/)

   [Workers ](https://developers.cloudflare.com/workers/)[Pages ](https://developers.cloudflare.com/pages/)[WAF](https://developers.cloudflare.com/waf/)

   **Update: Mon Mar 24th, 11PM UTC**: Next.js has made further changes to address a smaller vulnerability introduced in the patches made to its middleware handling. Users should upgrade to Next.js versions `15.2.4`, `14.2.26`, `13.5.10` or `12.3.6`. **If you are unable to immediately upgrade or are running an older version of Next.js, you can enable the WAF rule described in this changelog as a mitigation**.

   **Update: Mon Mar 24th, 8PM UTC**: Next.js has now [backported the patch for this vulnerability](https://github.com/advisories/GHSA-f82v-jwr5-mffw) to cover Next.js v12 and v13. Users on those versions will need to patch to `13.5.9` and `12.3.5` (respectively) to mitigate the vulnerability.

   **Update: Sat Mar 22nd, 4PM UTC**: We have changed this WAF rule to opt-in only, as sites that use auth middleware with third-party auth vendors were observing failing requests.

   **We strongly recommend updating your version of Next.js (if eligible)** to the patched versions, as your app will otherwise be vulnerable to an authentication bypass attack regardless of auth provider.

   #### Enable the Managed Rule (strongly recommended)

   This rule is opt-in only for sites on the Pro plan or above in the [WAF managed ruleset](https://developers.cloudflare.com/waf/managed-rules/).

   To enable the rule:

   1. Head to Security > WAF > Managed rules in the Cloudflare dashboard for the zone (website) you want to protect.
   2. Click the three dots next to **Cloudflare Managed Ruleset** and choose **Edit**
   3. Scroll down and choose **Browse Rules**
   4. Search for **CVE-2025-29927** (ruleId: `34583778093748cc83ff7b38f472013e`)
   5. Change the **Status** to **Enabled** and the **Action** to **Block**. You can optionally set the rule to Log, to validate potential impact before enabling it. Log will not block requests.
   6. Click **Next**
   7. Scroll down and choose **Save**

   ![Enable the CVE-2025-29927 rule](https://developers.cloudflare.com/_astro/high-res-CVE-2025-29927.CeSIx2jl_2JJrN.webp)

   This will enable the WAF rule and block requests with the `x-middleware-subrequest` header regardless of Next.js version.

   #### Create a WAF rule (manual)

   For users on the Free plan, or who want to define a more specific rule, you can create a [Custom WAF rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) to block requests with the `x-middleware-subrequest` header regardless of Next.js version.

   To create a custom rule:

   1. Head to Security > WAF > Custom rules in the Cloudflare dashboard for the zone (website) you want to protect.
   2. Give the rule a name - e.g. `next-js-CVE-2025-29927`
   3. Set the matching parameters for the rule match any request where the `x-middleware-subrequest` header `exists` per the rule expression below.

   ```sh
   (len(http.request.headers["x-middleware-subrequest"]) > 0)
   ```

   1. Set the action to 'block'. If you want to observe the impact before blocking requests, set the action to 'log' (and edit the rule later).
   2. **Deploy** the rule.

   ![Next.js CVE-2025-29927 WAF rule](https://developers.cloudflare.com/_astro/waf-rule-cve-2025-29927.0i0XiweZ_Z20MrB2.webp)

   #### Next.js CVE-2025-29927

   We've made a WAF (Web Application Firewall) rule available to all sites on Cloudflare to protect against the [Next.js authentication bypass vulnerability](https://github.com/advisories/GHSA-f82v-jwr5-mffw) (`CVE-2025-29927`) published on March 21st, 2025.

   **Note**: This rule is not enabled by default as it blocked requests across sites for specific authentication middleware.

   * This managed rule protects sites using Next.js on Workers and Pages, as well as sites using Cloudflare to protect Next.js applications hosted elsewhere.
   * This rule has been made available (but not enabled by default) to all sites as part of our [WAF Managed Ruleset](https://developers.cloudflare.com/waf/managed-rules/reference/cloudflare-managed-ruleset/) and blocks requests that attempt to bypass authentication in Next.js applications.
   * The vulnerability affects almost all Next.js versions, and has been fully patched in Next.js `14.2.26` and `15.2.4`. Earlier, interim releases did not fully patch this vulnerability.
   * **Users on older versions of Next.js (`11.1.4` to `13.5.6`) did not originally have a patch available**, but this the patch for this vulnerability and a subsequent additional patch have been backported to Next.js versions `12.3.6` and `13.5.10` as of Monday, March 24th. Users on Next.js v11 will need to deploy the stated workaround or enable the WAF rule.

   The managed WAF rule mitigates this by blocking *external* user requests with the `x-middleware-subrequest` header regardless of Next.js version, but we recommend users using Next.js 14 and 15 upgrade to the patched versions of Next.js as an additional mitigation.

Mar 22, 2025

1. ### [Smart Placement is smarter about running Workers and Pages Functions in the best locations](https://developers.cloudflare.com/changelog/2025-03-22-smart-placement-stablization/)

   [Workers ](https://developers.cloudflare.com/workers/)[Pages](https://developers.cloudflare.com/pages/)

   [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement/) is a unique Cloudflare feature that can make decisions to move your Worker to run in a more optimal location (such as closer to a database). Instead of always running in the default location (the one closest to where the request is received), Smart Placement uses certain “heuristics” (rules and thresholds) to decide if a different location might be faster or more efficient.

   Previously, if these heuristics weren't consistently met, your Worker would revert to running in the default location—even after it had been optimally placed. This meant that if your Worker received minimal traffic for a period of time, the system would reset to the default location, rather than remaining in the optimal one.

   Now, once Smart Placement has identified and assigned an optimal location, temporarily dropping below the heuristic thresholds will not force a return to default locations. For example in the previous algorithm, a drop in requests for a few days might return to default locations and heuristics would have to be met again. This was problematic for workloads that made requests to a geographically located resource every few days or longer. In this scenario, your Worker would never get placed optimally. This is no longer the case.

Mar 21, 2025

1. ### [AI Gateway launches Realtime WebSockets API](https://developers.cloudflare.com/changelog/2025-03-20-websockets/)

   [AI Gateway](https://developers.cloudflare.com/ai-gateway/)

   We are excited to announce that [AI Gateway](https://developers.cloudflare.com/ai-gateway/) now supports real-time AI interactions with the new [Realtime WebSockets API](https://developers.cloudflare.com/ai-gateway/usage/websockets-api/realtime-api/).

   This new capability allows developers to establish persistent, low-latency connections between their applications and AI models, enabling natural, real-time conversational AI experiences, including speech-to-speech interactions.

   The Realtime WebSockets API works with the [OpenAI Realtime API](https://platform.openai.com/docs/guides/realtime#connect-with-websockets), [Google Gemini Live API](https://ai.google.dev/gemini-api/docs/multimodal-live), and supports real-time text and speech interactions with models from [Cartesia](https://docs.cartesia.ai/api-reference/tts/tts), and [ElevenLabs](https://elevenlabs.io/docs/conversational-ai/api-reference/conversational-ai/websocket).

   Here's how you can connect AI Gateway to [OpenAI's Realtime API](https://platform.openai.com/docs/guides/realtime#connect-with-websockets) using WebSockets:

   ```javascript
   import WebSocket from "ws";


   const url =
     "wss://gateway.ai.cloudflare.com/v1/<account_id>/<gateway>/openai?model=gpt-4o-realtime-preview-2024-12-17";
   const ws = new WebSocket(url, {
     headers: {
       "cf-aig-authorization": process.env.CLOUDFLARE_API_KEY,
       Authorization: "Bearer " + process.env.OPENAI_API_KEY,
       "OpenAI-Beta": "realtime=v1",
     },
   });


   ws.on("open", () => console.log("Connected to server."));
   ws.on("message", (message) => console.log(JSON.parse(message.toString())));


   ws.send(
     JSON.stringify({
       type: "response.create",
       response: { modalities: ["text"], instructions: "Tell me a joke" },
     }),
   );
   ```

   Get started by checking out the [Realtime WebSockets API](https://developers.cloudflare.com/ai-gateway/usage/websockets-api/realtime-api/) documentation.

Mar 21, 2025

1. ### [Dozens of Cloudflare Terraform Provider resources now have proper drift detection](https://developers.cloudflare.com/changelog/2025-03-21-resource-force-replacement-bug/)

   [Cloudflare Fundamentals ](https://developers.cloudflare.com/fundamentals/)[Terraform](https://developers.cloudflare.com/terraform/)

   In [Cloudflare Terraform Provider](https://github.com/cloudflare/terraform-provider-cloudflare) versions 5.2.0 and above, dozens of resources now have proper drift detection. Before this fix, these resources would indicate they needed to be updated or replaced — even if there was no real change. Now, you can rely on your `terraform plan` to only show what resources are expected to change.

   This issue affected [resources](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs) related to these products and features:

   * API Shield
   * Argo Smart Routing
   * Argo Tiered Caching
   * Bot Management
   * BYOIP
   * D1
   * DNS
   * Email Routing
   * Hyperdrive
   * Observatory
   * Pages
   * R2
   * Rules
   * SSL/TLS
   * Waiting Room
   * Workers
   * Zero Trust

Mar 21, 2025

1. ### [Cloudflare Terraform Provider now properly redacts sensitive values](https://developers.cloudflare.com/changelog/2025-03-21-sensitive-values-redacted/)

   [Cloudflare Fundamentals ](https://developers.cloudflare.com/fundamentals/)[Terraform](https://developers.cloudflare.com/terraform/)

   In the [Cloudflare Terraform Provider](https://github.com/cloudflare/terraform-provider-cloudflare) versions 5.2.0 and above, sensitive properties of resources are redacted in logs. Sensitive properties in [Cloudflare's OpenAPI Schema](https://raw.githubusercontent.com/cloudflare/api-schemas/refs/heads/main/openapi.yaml) are now annotated with `x-sensitive: true`. This results in proper auto-generation of the corresponding Terraform resources, and prevents sensitive values from being shown when you run Terraform commands.

   This issue affected [resources](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs) related to these products and features:

   * Alerts and Audit Logs
   * Device API
   * DLP
   * DNS
   * Magic Visibility
   * Magic WAN
   * TLS Certs and Hostnames
   * Tunnels
   * Turnstile
   * Workers
   * Zaraz

Mar 18, 2025

1. ### [npm i agents](https://developers.cloudflare.com/changelog/2025-03-18-npm-i-agents/)

   [Agents ](https://developers.cloudflare.com/agents/)[Workers](https://developers.cloudflare.com/workers/)

   ![npm i agents](https://developers.cloudflare.com/_astro/npm-i-agents.CXCpJ1-7.apng)

   #### `agents-sdk` -> `agents` Updated

   📝 **We've renamed the Agents package to `agents`**!

   If you've already been building with the Agents SDK, you can update your dependencies to use the new package name, and replace references to `agents-sdk` with `agents`:

   ```sh
   # Install the new package
   npm i agents
   ```

   ```sh
   # Remove the old (deprecated) package
   npm uninstall agents-sdk


   # Find instances of the old package name in your codebase
   grep -r 'agents-sdk' .
   # Replace instances of the old package name with the new one
   # (or use find-replace in your editor)
   sed -i 's/agents-sdk/agents/g' $(grep -rl 'agents-sdk' .)
   ```

   All future updates will be pushed to the new `agents` package, and the older package has been marked as deprecated.

   #### Agents SDK updates New

   We've added a number of big new features to the Agents SDK over the past few weeks, including:

   * You can now set `cors: true` when using `routeAgentRequest` to return permissive default CORS headers to Agent responses.
   * The regular client now syncs state on the agent (just like the React version).
   * `useAgentChat` bug fixes for passing headers/credentials, including properly clearing cache on unmount.
   * Experimental `/schedule` module with a prompt/schema for adding scheduling to your app (with evals!).
   * Changed the internal `zod` schema to be compatible with the limitations of Google's Gemini models by removing the discriminated union, allowing you to use Gemini models with the scheduling API.

   We've also fixed a number of bugs with state synchronization and the React hooks.

   * JavaScript

     ```js
     // via https://github.com/cloudflare/agents/tree/main/examples/cross-domain
     export default {
       async fetch(request, env) {
         return (
           // Set { cors: true } to enable CORS headers.
           (await routeAgentRequest(request, env, { cors: true })) ||
           new Response("Not found", { status: 404 })
         );
       },
     };
     ```

   * TypeScript

     ```ts
     // via https://github.com/cloudflare/agents/tree/main/examples/cross-domain
     export default {
       async fetch(request: Request, env: Env) {
         return (
           // Set { cors: true } to enable CORS headers.
           (await routeAgentRequest(request, env, { cors: true })) ||
           new Response("Not found", { status: 404 })
         );
       },
     } satisfies ExportedHandler<Env>;
     ```

   #### Call Agent methods from your client code New

   We've added a new [`@unstable_callable()`](https://developers.cloudflare.com/agents/api-reference/agents-api/) decorator for defining methods that can be called directly from clients. This allows you call methods from within your client code: you can call methods (with arguments) and get native JavaScript objects back.

   * JavaScript

     ```js
     // server.ts
     import { unstable_callable, Agent } from "agents";
     export class Rpc extends Agent {
       // Use the decorator to define a callable method
       @unstable_callable({
         description: "rpc test",
       })
       async getHistory() {
         return this.sql`SELECT * FROM history ORDER BY created_at DESC LIMIT 10`;
       }
     }
     ```

   * TypeScript

     ```ts
     // server.ts
     import { unstable_callable, Agent, type StreamingResponse } from "agents";
     import type { Env } from "../server";


      export class Rpc extends Agent<Env> {
        // Use the decorator to define a callable method
        @unstable_callable({
          description: "rpc test",
        })
        async getHistory() {
          return this.sql`SELECT * FROM history ORDER BY created_at DESC LIMIT 10`;
        }
     }
     ```

   #### agents-starter Updated

   We've fixed a number of small bugs in the [`agents-starter`](https://github.com/cloudflare/agents-starter) project — a real-time, chat-based example application with tool-calling & human-in-the-loop built using the Agents SDK. The starter has also been upgraded to use the latest [wrangler v4](https://developers.cloudflare.com/changelog/2025-03-13-wrangler-v4/) release.

   If you're new to Agents, you can install and run the `agents-starter` project in two commands:

   ```sh
   # Install it
   $ npm create cloudflare@latest agents-starter -- --template="cloudflare/agents-starter"
   # Run it
   $ npm run start
   ```

   You can use the starter as a template for your own Agents projects: open up `src/server.ts` and `src/client.tsx` to see how the Agents SDK is used.

   #### More documentation Updated

   We've heard your feedback on the Agents SDK documentation, and we're shipping more API reference material and usage examples, including:

   * Expanded [API reference documentation](https://developers.cloudflare.com/agents/api-reference/), covering the methods and properties exposed by the Agents SDK, as well as more usage examples.
   * More [Client API](https://developers.cloudflare.com/agents/api-reference/agents-api/#client-api) documentation that documents `useAgent`, `useAgentChat` and the new `@unstable_callable` RPC decorator exposed by the SDK.
   * New documentation on how to [call agents](https://developers.cloudflare.com/agents/api-reference/calling-agents/) and (optionally) authenticate clients before they connect to your Agents.

   Note that the Agents SDK is continually growing: the type definitions included in the SDK will always include the latest APIs exposed by the `agents` package.

   If you're still wondering what Agents are, [read our blog on building AI Agents on Cloudflare](https://blog.cloudflare.com/build-ai-agents-on-cloudflare/) and/or visit the [Agents documentation](https://developers.cloudflare.com/agents/) to learn more.

Mar 18, 2025

1. ### [New API Posture Management for API Shield](https://developers.cloudflare.com/changelog/2025-03-18-api-posture-management/)

   [API Shield](https://developers.cloudflare.com/api-shield/)

   Now, API Shield **automatically** labels your API inventory with API-specific risks so that you can track and manage risks to your APIs.

   View these risks in [Endpoint Management](https://developers.cloudflare.com/api-shield/management-and-monitoring/) by label:

   ![A list of endpoint management labels](https://developers.cloudflare.com/_astro/endpoint-management-label.BDmf8Ai1_2pFFuv.webp)

   ...or in [Security Center Insights](https://developers.cloudflare.com/security-center/security-insights/):

   ![An example security center insight](https://developers.cloudflare.com/_astro/posture-management-insight.7vB7mzGI_1252uQ.webp)

   API Shield will scan for risks on your API inventory daily. Here are the new risks we're scanning for and automatically labelling:

   * **cf-risk-sensitive**: applied if the customer is subscribed to the [sensitive data detection ruleset](https://developers.cloudflare.com/waf/managed-rules/reference/sensitive-data-detection/) and the WAF detects sensitive data returned on an endpoint in the last seven days.
   * **cf-risk-missing-auth**: applied if the customer has configured a session ID and no successful requests to the endpoint contain the session ID.
   * **cf-risk-mixed-auth**: applied if the customer has configured a session ID and some successful requests to the endpoint contain the session ID while some lack the session ID.
   * **cf-risk-missing-schema**: added when a learned schema is available for an endpoint that has no active schema.
   * **cf-risk-error-anomaly**: added when an endpoint experiences a recent increase in response errors over the last 24 hours.
   * **cf-risk-latency-anomaly**: added when an endpoint experiences a recent increase in response latency over the last 24 hours.
   * **cf-risk-size-anomaly**: added when an endpoint experiences a spike in response body size over the last 24 hours.

   In addition, API Shield has two new 'beta' scans for **Broken Object Level Authorization (BOLA) attacks**. If you're in the beta, you will see the following two labels when API Shield suspects an endpoint is suffering from a BOLA vulnerability:

   * **cf-risk-bola-enumeration**: added when an endpoint experiences successful responses with drastic differences in the number of unique elements requested by different user sessions.
   * **cf-risk-bola-pollution**: added when an endpoint experiences successful responses where parameters are found in multiple places in the request.

   We are currently accepting more customers into our beta. Contact your account team if you are interested in BOLA attack detection for your API.

   Refer to the [blog post](https://blog.cloudflare.com/cloudflare-security-posture-management/) for more information about Cloudflare's expanded posture management capabilities.

Mar 17, 2025

1. ### [Retry Pages & Workers Builds Directly from GitHub](https://developers.cloudflare.com/changelog/2025-03-17-rerun-build/)

   [Workers ](https://developers.cloudflare.com/workers/)[Pages](https://developers.cloudflare.com/pages/)

   You can now retry your Cloudflare Pages and Workers builds directly from GitHub. No need to switch to the Cloudflare Dashboard for a simple retry!

   ![Workers Builds GitHub Reruns](https://developers.cloudflare.com/_astro/builds-rerun.DxYGWslQ_Z12h0CL.webp)

   Let’s say you push a commit, but your build fails due to a spurious error like a network timeout. Instead of going to the Cloudflare Dashboard to manually retry, you can now rerun the build with just a few clicks inside GitHub, keeping you inside your workflow.

   For Pages and Workers projects connected to a GitHub repository:

   1. When a build fails, go to your GitHub repository or pull request
   2. Select the failed Check Run for the build
   3. Select "Details" on the Check Run
   4. Select "Rerun" to trigger a retry build for that commit

   Learn more about [Pages Builds](https://developers.cloudflare.com/pages/configuration/git-integration/github-integration/) and [Workers Builds](https://developers.cloudflare.com/workers/ci-cd/builds/git-integration/github-integration/).

Mar 12, 2025

1. ### [Threaded replies now possible in Email Workers](https://developers.cloudflare.com/changelog/2025-03-12-reply-limits/)

   [Email Routing](https://developers.cloudflare.com/email-routing/)

   We’re removing some of the restrictions in Email Routing so that AI Agents and task automation can better handle email workflows, including how Workers can [reply](https://developers.cloudflare.com/email-routing/email-workers/reply-email-workers/) to incoming emails.

   It's now possible to keep a threaded email conversation with an [Email Worker](https://developers.cloudflare.com/email-routing/email-workers/) script as long as:

   * The incoming email has to have valid [DMARC](https://www.cloudflare.com/learning/dns/dns-records/dns-dmarc-record/).
   * The email can only be replied to once in the same `EmailMessage` event.
   * The recipient in the reply must match the incoming sender.
   * The outgoing sender domain must match the same domain that received the email.
   * Every time an email passes through Email Routing or another MTA, an entry is added to the `References` list. We stop accepting replies to emails with more than 100 `References` entries to prevent abuse or accidental loops.

   Here's an example of a Worker responding to Emails using a Workers AI model:

   ```ts
   import PostalMime from "postal-mime";
   import { createMimeMessage } from "mimetext";
   import { EmailMessage } from "cloudflare:email";


   export default {
     async email(message, env, ctx) {
       const email = await PostalMime.parse(message.raw);
       const res = await env.AI.run("@cf/meta/llama-2-7b-chat-fp16", {
         messages: [
           {
             role: "user",
             content: email.text ?? "",
           },
         ],
       });


       // message-id is generated by mimetext
       const response = createMimeMessage();
       response.setHeader("In-Reply-To", message.headers.get("Message-ID")!);
       response.setSender("agent@example.com");
       response.setRecipient(message.from);
       response.setSubject("Llama response");
       response.addMessage({
         contentType: "text/plain",
         data:
           res instanceof ReadableStream
             ? await new Response(res).text()
             : res.response!,
       });


       const replyMessage = new EmailMessage(
         "<email>",
         message.from,
         response.asRaw(),
       );
       await message.reply(replyMessage);
     },
   } satisfies ExportedHandler<Env>;
   ```

   See [Reply to emails from Workers](https://developers.cloudflare.com/email-routing/email-workers/reply-email-workers/) for more information.

Mar 07, 2025

1. ### [Cloudflare One Agent now supports Endpoint Monitoring](https://developers.cloudflare.com/changelog/2025-03-07-cloudflare-one-device-health-monitoring/)

   [Digital Experience Monitoring](https://developers.cloudflare.com/cloudflare-one/insights/dex/)

   [Digital Experience Monitoring (DEX)](https://developers.cloudflare.com/cloudflare-one/insights/dex/) provides visibility into device, network, and application performance across your Cloudflare SASE deployment. The latest release of the Cloudflare One agent (v2025.1.861) now includes device endpoint monitoring capabilities to provide deeper visibility into end-user device performance which can be analyzed directly from the dashboard.

   Device health metrics are now automatically collected, allowing administrators to:

   * View the last network a user was connected to
   * Monitor CPU and RAM utilization on devices
   * Identify resource-intensive processes running on endpoints

   ![Device endpoint monitoring dashboard](https://developers.cloudflare.com/_astro/cloudflare-one-agent-health-monitoring.XXtiRuOp_Z144rRU.webp)

   This feature complements existing DEX features like [synthetic application monitoring](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/) and [network path visualization](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/traceroute/), creating a comprehensive troubleshooting workflow that connects application performance with device state.

   For more details refer to our [DEX](https://developers.cloudflare.com/cloudflare-one/insights/dex/) documentation.

Mar 06, 2025

1. ### [Set retention polices for your R2 bucket with bucket locks](https://developers.cloudflare.com/changelog/2025-03-06-r2-bucket-locks/)

   [R2](https://developers.cloudflare.com/r2/)

   You can now use [bucket locks](https://developers.cloudflare.com/r2/buckets/bucket-locks/) to set retention policies on your [R2 buckets](https://developers.cloudflare.com/r2/buckets/) (or specific prefixes within your buckets) for a specified period — or indefinitely. This can help ensure compliance by protecting important data from accidental or malicious deletion.

   Locks give you a few ways to ensure your objects are retained (not deleted or overwritten). You can:

   * Lock objects for a specific duration, for example 90 days.
   * Lock objects until a certain date, for example January 1, 2030.
   * Lock objects indefinitely, until the lock is explicitly removed.

   Buckets can have up to 1,000 [bucket lock rules](https://developers.cloudflare.com/r2/buckets/). Each rule specifies which objects it covers (via prefix) and how long those objects must remain retained.

   Here are a couple of examples showing how you can configure bucket lock rules using [Wrangler](https://developers.cloudflare.com/workers/wrangler/):

   #### Ensure all objects in a bucket are retained for at least 180 days

   ```sh
   npx wrangler r2 bucket lock add <bucket> --name 180-days-all --retention-days 180
   ```

   #### Prevent deletion or overwriting of all logs indefinitely (via prefix)

   ```sh
   npx wrangler r2 bucket lock add <bucket> --name indefinite-logs --prefix logs/ --retention-indefinite
   ```

   For more information on bucket locks and how to set retention policies for objects in your R2 buckets, refer to our [documentation](https://developers.cloudflare.com/r2/buckets/bucket-locks/).

Mar 04, 2025

1. ### [Gain visibility into user actions in Zero Trust Browser Isolation sessions](https://developers.cloudflare.com/changelog/2025-03-03-user-action-logging/)

   [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)

   We're excited to announce that new logging capabilities for [Remote Browser Isolation (RBI)](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/) through [Logpush](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/) are available in Beta starting today!

   With these enhanced logs, administrators can gain visibility into end user behavior in the remote browser and track blocked data extraction attempts, along with the websites that triggered them, in an isolated session.

   ```json
   {
     "AccountID": "$ACCOUNT_ID",
     "Decision": "block",
     "DomainName": "www.example.com",
     "Timestamp": "2025-02-27T23:15:06Z",
     "Type": "copy",
     "UserID": "$USER_ID"
   }
   ```

   User Actions available:

   * **Copy & Paste**
   * **Downloads & Uploads**
   * **Printing**

   Learn more about how to get started with Logpush in our [documentation](https://developers.cloudflare.com/logs/logpush/).

Feb 26, 2025

1. ### [Introducing Guardrails in AI Gateway](https://developers.cloudflare.com/changelog/2025-02-26-guardrails/)

   [AI Gateway](https://developers.cloudflare.com/ai-gateway/)

   [AI Gateway](https://developers.cloudflare.com/ai-gateway/) now includes [Guardrails](https://developers.cloudflare.com/ai-gateway/features/guardrails/), to help you monitor your AI apps for harmful or inappropriate content and deploy safely.

   Within the AI Gateway settings, you can configure:

   * **Guardrails**: Enable or disable content moderation as needed.
   * **Evaluation scope**: Select whether to moderate user prompts, model responses, or both.
   * **Hazard categories**: Specify which categories to monitor and determine whether detected inappropriate content should be blocked or flagged.

   ![Guardrails in AI Gateway](https://developers.cloudflare.com/_astro/Guardrails.BTNc0qeC_4GXNi.webp)

   Learn more in the [blog](https://blog.cloudflare.com/guardrails-in-ai-gateway/) or our [documentation](https://developers.cloudflare.com/ai-gateway/features/guardrails/).

Feb 25, 2025

1. ### [Introducing the Agents SDK](https://developers.cloudflare.com/changelog/2025-02-25-agents-sdk/)

   [Agents ](https://developers.cloudflare.com/agents/)[Workers](https://developers.cloudflare.com/workers/)

   We've released the [Agents SDK](http://blog.cloudflare.com/build-ai-agents-on-cloudflare/), a package and set of tools that help you build and ship AI Agents.

   You can get up and running with a [chat-based AI Agent](https://github.com/cloudflare/agents-starter) (and deploy it to Workers) that uses the Agents SDK, tool calling, and state syncing with a React-based front-end by running the following command:

   ```sh
   npm create cloudflare@latest agents-starter -- --template="cloudflare/agents-starter"
   # open up README.md and follow the instructions
   ```

   You can also add an Agent to any existing Workers application by installing the `agents` package directly

   ```sh
   npm i agents
   ```

   ... and then define your first Agent:

   ```ts
   import { Agent } from "agents";


   export class YourAgent extends Agent<Env> {
     // Build it out
     // Access state on this.state or query the Agent's database via this.sql
     // Handle WebSocket events with onConnect and onMessage
     // Run tasks on a schedule with this.schedule
     // Call AI models
     // ... and/or call other Agents.
   }
   ```

   Head over to the [Agents documentation](https://developers.cloudflare.com/agents/) to learn more about the Agents SDK, the SDK APIs, as well as how to test and deploying agents to production.

Feb 25, 2025

1. ### [Concurrent Workflow instances limits increased.](https://developers.cloudflare.com/changelog/2025-02-25-workflows-concurrency-increased/)

   [Workflows](https://developers.cloudflare.com/workflows/)

   [Workflows](https://developers.cloudflare.com/workflows/) now supports up to 4,500 concurrent (running) instances, up from the previous limit of 100. This limit will continue to increase during the Workflows open beta. This increase applies to all users on the Workers Paid plan, and takes effect immediately.

   Review the Workflows [limits documentation](https://developers.cloudflare.com/workflows/reference/limits) and/or dive into the [get started guide](https://developers.cloudflare.com/workflows/get-started/guide/) to start building on Workflows.

Feb 24, 2025

1. ### [Bind the Images API to your Worker](https://developers.cloudflare.com/changelog/2025-02-21-images-bindings-in-workers/)

   [Cloudflare Images](https://developers.cloudflare.com/images/)

   You can now [interact with the Images API](https://developers.cloudflare.com/images/transform-images/bindings/) directly in your Worker.

   This allows more fine-grained control over transformation request flows and cache behavior. For example, you can resize, manipulate, and overlay images without requiring them to be accessible through a URL.

   The Images binding can be configured in the Cloudflare dashboard for your Worker or in the `wrangler.toml` file in your project's directory:

   * wrangler.jsonc

     ```jsonc
     {
       "images": {
         "binding": "IMAGES", // i.e. available in your Worker on env.IMAGES
       },
     }
     ```

   * wrangler.toml

     ```toml
     [images]
     binding = "IMAGES"
     ```

   Within your Worker code, you can interact with this binding by using `env.IMAGES`.

   Here's how you can rotate, resize, and blur an image, then output the image as AVIF:

   ```ts
   const info = await env.IMAGES.info(stream);
   // stream contains a valid image, and width/height is available on the info object


   const response = (
     await env.IMAGES.input(stream)
       .transform({ rotate: 90 })
       .transform({ width: 128 })
       .transform({ blur: 20 })
       .output({ format: "image/avif" })
   ).response();


   return response;
   ```

   For more information, refer to [Images Bindings](https://developers.cloudflare.com/images/transform-images/bindings/).

Feb 24, 2025

1. ### [Zaraz moves to the “Tag Management” category in the Cloudflare dashboard](https://developers.cloudflare.com/changelog/2025-02-24-zaraz-dash-placement/)

   [Zaraz](https://developers.cloudflare.com/zaraz/)

   ![Zaraz at zone level to Tag management at account level](https://developers.cloudflare.com/_astro/zaraz-account-level.L5Bz9oN0_g6g04.webp)

   Previously, you could only configure Zaraz by going to each individual zone under your Cloudflare account. Now, if you’d like to get started with Zaraz or manage your existing configuration, you can navigate to the [Tag Management](https://dash.cloudflare.com/?to=/:account/tag-management/zaraz) section on the Cloudflare dashboard – this will make it easier to compare and configure the same settings across multiple zones.

   These changes will not alter any existing configuration or entitlements for zones you already have Zaraz enabled on. If you’d like to edit existing configurations, you can go to the [Tag Setup](https://dash.cloudflare.com/?to=/:account/tag-management/zaraz) section of the dashboard, and select the zone you'd like to edit.

Feb 20, 2025

1. ### [Workers for Platforms - Instant dispatch for newly created User Workers](https://developers.cloudflare.com/changelog/2025-02-20-synchronous-uploads/)

   [Workers for Platforms](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/)

   [Workers for Platforms](https://developers.cloudflare.com/cloudflare-for-platforms/) is an architecture wherein a centralized [dispatch Worker](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/reference/how-workers-for-platforms-works/#dynamic-dispatch-worker) processes incoming requests and routes them to isolated sub-Workers, called [User Workers](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/reference/how-workers-for-platforms-works/#user-workers).

   ![Workers for Platforms Requests](https://developers.cloudflare.com/_astro/wfp-request.CZmZLaYf_2j2Mo8.webp)

   Previously, when a new User Worker was uploaded, there was a short delay before it became available for dispatch. This meant that even though an API request could return a 200 OK response, the script might not yet be ready to handle requests, causing unexpected failures for platforms that immediately dispatch to new Workers.

   **With this update, first-time uploads of User Workers are now deployed synchronously**. A 200 OK response guarantees the script is fully provisioned and ready to handle traffic immediately, ensuring more predictable deployments and reducing errors.

Feb 14, 2025

1. ### [Customize queue message retention periods](https://developers.cloudflare.com/changelog/2025-02-14-customize-queue-retention-period/)

   [Queues](https://developers.cloudflare.com/queues/)

   You can now customize a queue's message retention period, from a minimum of 60 seconds to a maximum of 14 days. Previously, it was fixed to the default of 4 days.

   ![Customize a queue's message retention period](https://developers.cloudflare.com/_astro/customize-retention-period.CpK7s10q_Z13Q6wc.webp)

   You can customize the retention period on the settings page for your queue, or using Wrangler:

   ```bash
   $ wrangler queues update my-queue --message-retention-period-secs 600
   ```

   This feature is available on all new and existing queues. If you haven't used Cloudflare Queues before, [get started with the Cloudflare Queues guide](https://developers.cloudflare.com/queues/get-started).

Feb 14, 2025

1. ### [Build AI Agents with Example Prompts](https://developers.cloudflare.com/changelog/2025-02-14-example-ai-prompts/)

   [Agents ](https://developers.cloudflare.com/agents/)[Workers ](https://developers.cloudflare.com/workers/)[Workflows](https://developers.cloudflare.com/workflows/)

   We've added an [example prompt](https://developers.cloudflare.com/workers/get-started/prompting/) to help you get started with building AI agents and applications on Cloudflare [Workers](https://developers.cloudflare.com/workers/), including [Workflows](https://developers.cloudflare.com/workflows/), [Durable Objects](https://developers.cloudflare.com/durable-objects/), and [Workers KV](https://developers.cloudflare.com/kv/).

   You can use this prompt with your favorite AI model, including Claude 3.5 Sonnet, OpenAI's o3-mini, Gemini 2.0 Flash, or Llama 3.3 on Workers AI. Models with large context windows will allow you to paste the prompt directly: provide your own prompt within the `<user_prompt></user_prompt>` tags.

   ```sh
   {paste_prompt_here}
   <user_prompt>
   user: Build an AI agent using Cloudflare Workflows. The Workflow should run when a new GitHub issue is opened on a specific project with the label 'help' or 'bug', and attempt to help the user troubleshoot the issue by calling the OpenAI API with the issue title and description, and a clear, structured prompt that asks the model to suggest 1-3 possible solutions to the issue. Any code snippets should be formatted in Markdown code blocks. Documentation and sources should be referenced at the bottom of the response. The agent should then post the response to the GitHub issue. The agent should run as the provided GitHub bot account.
   </user_prompt>
   ```

   This prompt is still experimental, but we encourage you to try it out and [provide feedback](https://github.com/cloudflare/cloudflare-docs/issues/new?template=content.edit.yml).

Feb 14, 2025

1. ### [Configure your Magic WAN Connector to connect via static IP assigment](https://developers.cloudflare.com/changelog/2025-02-14-local-console-access/)

   [Magic WAN](https://developers.cloudflare.com/magic-wan/)

   You can now locally configure your [Magic WAN Connector](https://developers.cloudflare.com/magic-wan/configuration/connector/) to work in a static IP configuration.

   This local method does not require having access to a DHCP Internet connection. However, it does require being comfortable with using tools to access the serial port on Magic WAN Connector as well as using a serial terminal client to access the Connector's environment.

   For more details, refer to [WAN with a static IP address](https://developers.cloudflare.com/magic-wan/configuration/connector/configure-hardware-connector/#bootstrap-via-serial-console).

Feb 14, 2025

1. ### [Upload a certificate bundle with an RSA and ECDSA certificate per custom hostname](https://developers.cloudflare.com/changelog/2025-02-14-cert-bundling-for-custom-hostnames/)

   [SSL/TLS](https://developers.cloudflare.com/ssl/)

   Cloudflare has supported both RSA and ECDSA certificates across our platform for a number of years. Both certificates offer the same security, but ECDSA is more performant due to a smaller key size. However, RSA is more widely adopted and ensures compatibility with legacy clients. Instead of choosing between them, you may want both – that way, ECDSA is used when clients support it, but RSA is available if not.

   Now, you can upload both an RSA and ECDSA certificate on a custom hostname via the API.

   ```plaintext
   curl -X POST https://api.cloudflare.com/client/v4/zones/$ZONE_ID/custom_hostnames \
       -H 'Content-Type: application/json' \
       -H "X-Auth-Email: $CLOUDFLARE_EMAIL" \
       -H "X-Auth-Key: $CLOUDFLARE_API_KEY" \
       -d '{
       "hostname": "hostname",
       "ssl": {
           "custom_cert_bundle": [
               {
                   "custom_certificate": "RSA Cert",
                   "custom_key": "RSA Key"
               },
               {
                   "custom_certificate": "ECDSA Cert",
                   "custom_key": "ECDSA Key"
               }
           ],
           "bundle_method": "force",
           "wildcard": false,
           "settings": {
               "min_tls_version": "1.0"
           }
       }
   }’
   ```

   You can also:

   * [Upload](https://developers.cloudflare.com/api/resources/custom_hostnames/methods/create/) an RSA or ECDSA certificate to a custom hostname with an existing ECDSA or RSA certificate, respectively.

   * [Replace](https://developers.cloudflare.com/api/resources/custom_hostnames/subresources/certificate_pack/subresources/certificates/methods/update/) the RSA or ECDSA certificate with a certificate of its same type.

   * [Delete](https://developers.cloudflare.com/api/resources/custom_hostnames/subresources/certificate_pack/subresources/certificates/methods/delete/) the RSA or ECDSA certificate (if the custom hostname has both an RSA and ECDSA uploaded).

   This feature is available for Business and Enterprise customers who have purchased custom certificates.

Feb 06, 2025

1. ### [Request timeouts and retries with AI Gateway](https://developers.cloudflare.com/changelog/2025-02-05-aig-request-handling/)

   [AI Gateway](https://developers.cloudflare.com/ai-gateway/)

   AI Gateway adds additional ways to handle requests - [Request Timeouts](https://developers.cloudflare.com/ai-gateway/configuration/request-handling/#request-timeouts) and [Request Retries](https://developers.cloudflare.com/ai-gateway/configuration/request-handling/#request-retries), making it easier to keep your applications responsive and reliable.

   Timeouts and retries can be used on both the [Universal Endpoint](https://developers.cloudflare.com/ai-gateway/usage/universal/) or directly to a [supported provider](https://developers.cloudflare.com/ai-gateway/usage/providers/).

   **Request timeouts** A [request timeout](https://developers.cloudflare.com/ai-gateway/configuration/request-handling/#request-timeouts) allows you to trigger [fallbacks](https://developers.cloudflare.com/ai-gateway/configuration/fallbacks/) or a retry if a provider takes too long to respond.

   To set a request timeout directly to a provider, add a `cf-aig-request-timeout` header.

   ```bash
   curl https://gateway.ai.cloudflare.com/v1/{account_id}/{gateway_id}/workers-ai/@cf/meta/llama-3.1-8b-instruct \
    --header 'Authorization: Bearer {cf_api_token}' \
    --header 'Content-Type: application/json' \
    --header 'cf-aig-request-timeout: 5000'
    --data '{"prompt": "What is Cloudflare?"}'
   ```

   **Request retries** A [request retry](https://developers.cloudflare.com/ai-gateway/configuration/request-handling/#request-retries) automatically retries failed requests, so you can recover from temporary issues without intervening.

   To set up request retries directly to a provider, add the following headers:

   * cf-aig-max-attempts (number)
   * cf-aig-retry-delay (number)
   * cf-aig-backoff ("constant" | "linear" | "exponential)

Feb 05, 2025

1. ### [AI Gateway adds Cerebras, ElevenLabs, and Cartesia as new providers](https://developers.cloudflare.com/changelog/2025-02-04-aig-provider-cartesia-eleven-cerebras/)

   [AI Gateway](https://developers.cloudflare.com/ai-gateway/)

   [AI Gateway](https://developers.cloudflare.com/ai-gateway/) has added three new providers: [Cartesia](https://developers.cloudflare.com/ai-gateway/usage/providers/cartesia/), [Cerebras](https://developers.cloudflare.com/ai-gateway/usage/providers/cerebras/), and [ElevenLabs](https://developers.cloudflare.com/ai-gateway/usage/providers/elevenlabs/), giving you more even more options for providers you can use through AI Gateway. Here's a brief overview of each:

   * [Cartesia](https://developers.cloudflare.com/ai-gateway/usage/providers/cartesia/) provides text-to-speech models that produce natural-sounding speech with low latency.
   * [Cerebras](https://developers.cloudflare.com/ai-gateway/usage/providers/cerebras/) delivers low-latency AI inference to Meta's Llama 3.1 8B and Llama 3.3 70B models.
   * [ElevenLabs](https://developers.cloudflare.com/ai-gateway/usage/providers/elevenlabs/) offers text-to-speech models with human-like voices in 32 languages.

   ![Example of Cerebras log in AI Gateway](https://developers.cloudflare.com/_astro/cerebras2.qHYP0ZnF_ALiIc.webp)

   To get started with AI Gateway, just update the base URL. Here's how you can send a request to [Cerebras](https://developers.cloudflare.com/ai-gateway/usage/providers/cerebras/) using cURL:

   ```bash
   curl -X POST https://gateway.ai.cloudflare.com/v1/ACCOUNT_TAG/GATEWAY/cerebras/chat/completions \
    --header 'content-type: application/json' \
    --header 'Authorization: Bearer CEREBRAS_TOKEN' \
    --data '{
       "model": "llama-3.3-70b",
       "messages": [
           {
               "role": "user",
               "content": "What is Cloudflare?"
           }
       ]
   }'
   ```

Feb 04, 2025

1. ### [Fight CSAM More Easily Than Ever](https://developers.cloudflare.com/changelog/2025-02-04-easier-onboarding-for-csam-scanning-tool/)

   [Cache / CDN](https://developers.cloudflare.com/cache/)

   You can now implement our **child safety tooling**, the **[CSAM Scanning Tool](https://developers.cloudflare.com/cache/reference/csam-scanning/)**, more easily. Instead of requiring external reporting credentials, you only need a verified email address for notifications to onboard. This change makes the tool more accessible to a wider range of customers.

   **How It Works**

   When enabled, the tool automatically [hashes images for enabled websites as they enter the Cloudflare cache](https://blog.cloudflare.com/the-csam-scanning-tool/). These hashes are then checked against a database of **known abusive images**.

   * **Potential match detected?**

     * The **content URL is blocked**, and
     * **Cloudflare will notify you** about the found matches via the provided email address.

   **Updated Service-Specific Terms**

   We have also made updates to our **[Service-Specific Terms](https://www.cloudflare.com/service-specific-terms-application-services/#csam-scanning-tool-terms)** to reflect these changes.

Feb 03, 2025

1. ### [Block files that are password-protected, compressed, or otherwise unscannable.](https://developers.cloudflare.com/changelog/2025-02-13-improvements-unscannable-files/)

   [Data Loss Prevention ](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)[Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)

   Gateway HTTP policies can now block files that are password-protected, compressed, or otherwise unscannable.

   These unscannable files are now matched with the [Download and Upload File Types traffic selectors](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#download-and-upload-file-types) for HTTP policies:

   * Password-protected Microsoft Office document
   * Password-protected PDF
   * Password-protected ZIP archive
   * Unscannable ZIP archive

   To get started inspecting and modifying behavior based on these and other rules, refer to [HTTP filtering](https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/http/).

Feb 03, 2025

1. ### [Terraform v5 Provider is now generally available](https://developers.cloudflare.com/changelog/2025-02-03-terraform-v5-provider/)

   [Cloudflare Fundamentals ](https://developers.cloudflare.com/fundamentals/)[Terraform](https://developers.cloudflare.com/terraform/)

   ![Screenshot of Terraform defining a Zone](https://developers.cloudflare.com/_astro/2024-02-03-terraform-v5-screenshot.mW8OaFoS_Z1VSkul.webp)

   Cloudflare's v5 Terraform Provider is now generally available. With this release, Terraform resources are now automatically generated based on OpenAPI Schemas. This change brings alignment across our SDKs, API documentation, and now Terraform Provider. The new provider boosts coverage by increasing support for API properties to 100%, adding 25% more resources, and more than 200 additional data sources. Going forward, this will also reduce the barriers to bringing more resources into Terraform across the broader Cloudflare API. This is a small, but important step to making more of our platform manageable through GitOps, making it easier for you to manage Cloudflare just like you do your other infrastructure.

   The Cloudflare Terraform Provider v5 is a ground-up rewrite of the provider and introduces breaking changes for some resource types. Please refer to the [upgrade guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade) for best practices, or the [blog post on automatically generating Cloudflare's Terraform Provider](https://blog.cloudflare.com/automatically-generating-cloudflares-terraform-provider/) for more information about the approach.

   For more info

   * [Terraform provider](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs)
   * [Documentation on using Terraform with Cloudflare](https://developers.cloudflare.com/terraform/)

Jan 31, 2025

1. ### [Workers for Platforms now supports Static Assets](https://developers.cloudflare.com/changelog/2025-01-31-workers-platforms-static-assets/)

   [Workers for Platforms](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/)

   Workers for Platforms customers can now attach static assets (HTML, CSS, JavaScript, images) directly to User Workers, removing the need to host separate infrastructure to serve the assets.

   This allows your platform to serve entire front-end applications from Cloudflare's global edge, utilizing caching for fast load times, while supporting dynamic logic within the same Worker. Cloudflare automatically scales its infrastructure to handle high traffic volumes, enabling you to focus on building features without managing servers.

   #### What you can build

   **Static Sites:** Host and serve HTML, CSS, JavaScript, and media files directly from Cloudflare's network, ensuring fast loading times worldwide. This is ideal for blogs, landing pages, and documentation sites because static assets can be efficiently cached and delivered closer to the user, reducing latency and enhancing the overall user experience.

   **Full-Stack Applications:** Combine asset hosting with Cloudflare Workers to power dynamic, interactive applications. If you're an e-commerce platform, you can serve your customers' product pages and run inventory checks from within the same Worker.

   * JavaScript

     ```js
     export default {
       async fetch(request, env) {
         const url = new URL(request.url);


         // Check real-time inventory
         if (url.pathname === "/api/inventory/check") {
           const product = url.searchParams.get("product");
           const inventory = await env.INVENTORY_KV.get(product);
           return new Response(inventory);
         }


         // Serve static assets (HTML, CSS, images)
         return env.ASSETS.fetch(request);
       },
     };
     ```

   * TypeScript

     ```ts
     export default {
       async fetch(request, env) {
         const url = new URL(request.url);


         // Check real-time inventory
         if (url.pathname === '/api/inventory/check') {
           const product = url.searchParams.get('product');
           const inventory = await env.INVENTORY_KV.get(product);
           return new Response(inventory);
         }


         // Serve static assets (HTML, CSS, images)
         return env.ASSETS.fetch(request);
       }
     };
     ```

   **Get Started:** Upload static assets using the Workers for Platforms API or Wrangler. For more information, visit our [Workers for Platforms documentation.](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/configuration/static-assets/)

Jan 30, 2025

1. ### [Increased Browser Rendering limits!](https://developers.cloudflare.com/changelog/2025-01-30-browser-rendering-more-instances/)

   [Workers ](https://developers.cloudflare.com/workers/)[Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

   [Browser Rendering](https://developers.cloudflare.com/browser-rendering/) now supports 10 concurrent browser instances per account *and* 10 new instances per minute, up from the previous limits of 2.

   This allows you to launch more browser tasks from [Cloudflare Workers](https://developers.cloudflare.com/workers).

   To manage concurrent browser sessions, you can use [Queues](https://developers.cloudflare.com/queues/) or [Workflows](https://developers.cloudflare.com/workflows/):

   * JavaScript

     ```js
     export default {
       async queue(batch, env) {
         for (const message of batch.messages) {
           const browser = await puppeteer.launch(env.BROWSER);
           const page = await browser.newPage();


           try {
             await page.goto(message.url, {
               waitUntil: message.waitUntil,
             });
             // Process page...
           } finally {
             await browser.close();
           }
         }
       },
     };
     ```

   * TypeScript

     ```ts
     interface QueueMessage {
       url: string;
       waitUntil: number;
     }


     export interface Env {
       BROWSER_QUEUE: Queue<QueueMessage>;
       BROWSER: Fetcher;
     }


     export default {
       async queue(batch: MessageBatch<QueueMessage>, env: Env): Promise<void> {
         for (const message of batch.messages) {
           const browser = await puppeteer.launch(env.BROWSER);
           const page = await browser.newPage();


           try {
             await page.goto(message.url, {
               waitUntil: message.waitUntil
             });
             // Process page...
           } finally {
             await browser.close();
           }
         }
       }
     };
     ```

Jan 28, 2025

1. ### [Workers KV namespace limits increased to 1000](https://developers.cloudflare.com/changelog/2025-01-27-kv-increased-namespaces-limits/)

   [KV](https://developers.cloudflare.com/kv/)

   You can now have up to 1000 Workers KV namespaces per account.

   Workers KV namespace limits were increased from 200 to 1000 for all accounts. Higher limits for Workers KV namespaces enable better organization of key-value data, such as by category, tenant, or environment.

   Consult the [Workers KV limits documentation](https://developers.cloudflare.com/kv/platform/limits/) for the rest of the limits. This increased limit is available for both the Free and Paid [Workers plans](https://developers.cloudflare.com/workers/platform/pricing/).

Jan 15, 2025

1. ### [Increased Workflows limits and improved instance queueing.](https://developers.cloudflare.com/changelog/2025-01-15-workflows-more-steps/)

   [Workflows](https://developers.cloudflare.com/workflows/)

   [Workflows](https://developers.cloudflare.com/workflows/) (beta) now allows you to define up to 1024 [steps](https://developers.cloudflare.com/workflows/build/workers-api/#workflowstep). `sleep` steps do not count against this limit.

   We've also added:

   * `instanceId` as property to the [`WorkflowEvent`](https://developers.cloudflare.com/workflows/build/workers-api/#workflowevent) type, allowing you to retrieve the current instance ID from within a running Workflow instance
   * Improved queueing logic for Workflow instances beyond the current maximum concurrent instances, reducing the cases where instances are stuck in the queued state.
   * Support for [`pause` and `resume`](https://developers.cloudflare.com/workflows/build/workers-api/#pause) for Workflow instances in a queued state.

   We're continuing to work on increases to the number of concurrent Workflow instances, steps, and support for a new `waitForEvent` API over the coming weeks.

Jan 07, 2025

1. ### [40-60% Faster D1 Worker API Requests](https://developers.cloudflare.com/changelog/2025-01-07-d1-faster-query/)

   [D1](https://developers.cloudflare.com/d1/)

   Users making [D1](https://developers.cloudflare.com/d1/) requests via the [Workers API](https://developers.cloudflare.com/d1/worker-api/) can see up to a 60% end-to-end latency improvement due to the removal of redundant network round trips needed for each request to a D1 database.

   ![D1 Worker API latency](https://developers.cloudflare.com/_astro/faster-d1-worker-api.4S7VSUdP_o2jsC.webp)

   *p50, p90, and p95 request latency aggregated across entire D1 service. These latencies are a reference point and should not be viewed as your exact workload improvement.*

   This performance improvement benefits all D1 Worker API traffic, especially cross-region requests where network latency is an outsized latency factor. For example, a user in Europe talking to a database in North America. D1 [location hints](https://developers.cloudflare.com/d1/configuration/data-location/#provide-a-location-hint) can be used to influence the geographic location of a database.

   For more details on how D1 removed redundant round trips, see the D1 specific release note [entry](https://developers.cloudflare.com/d1/platform/release-notes/#2025-01-07).

Dec 19, 2024

1. ### [Troubleshoot tunnels with diagnostic logs](https://developers.cloudflare.com/changelog/2024-12-19-diagnostic-logs/)

   [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)

   The latest `cloudflared` build [2024.12.2](https://github.com/cloudflare/cloudflared/releases/tag/2024.12.2) introduces the ability to collect all the diagnostic logs needed to troubleshoot a `cloudflared` instance.

   A diagnostic report collects data from a single instance of `cloudflared` running on the local machine and outputs it to a `cloudflared-diag` file.

   The `cloudflared-diag-YYYY-MM-DDThh-mm-ss.zip` archive contains the files listed below. The data in a file either applies to the `cloudflared` instance being diagnosed (`diagnosee`) or the instance that triggered the diagnosis (`diagnoser`). For example, if your tunnel is running in a Docker container, the diagnosee is the Docker instance and the diagnoser is the host instance.

   | File name | Description | Instance |
   | - | - | - |
   | `cli-configuration.json` | [Tunnel run parameters](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cloudflared-parameters/run-parameters/) used when starting the tunnel | diagnosee |
   | `cloudflared_logs.txt` | [Tunnel log file](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/monitor-tunnels/logs/)[1](#user-content-fn-1) | diagnosee |
   | `configuration.json` | Tunnel configuration parameters | diagnosee |
   | `goroutine.pprof` | goroutine profile made available by `pprof` | diagnosee |
   | `heap.pprof` | heap profile made available by `pprof` | diagnosee |
   | `metrics.txt` | Snapshot of [Tunnel metrics](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/monitor-tunnels/metrics/#available-metrics) at the time of diagnosis | diagnosee |
   | `network.txt` | JSON traceroutes to Cloudflare's global network using IPv4 and IPv6 | diagnoser |
   | `raw-network.txt` | Raw traceroutes to Cloudflare's global network using IPv4 and IPv6 | diagnoser |
   | `systeminformation.json` | Operating system information and resource usage | diagnosee |
   | `task-result.json` | Result of each diagnostic task | diagnoser |
   | `tunnelstate.json` | Tunnel connections at the time of diagnosis | diagnosee |

   ## Footnotes

   1. If the log file is blank, you may need to [set `--loglevel` to `debug`](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/monitor-tunnels/logs/#view-logs-on-the-server) when you start the tunnel. The `--loglevel` parameter is only required if you ran the tunnel from the CLI using a `cloudflared tunnel run` command. It is not necessary if the tunnel runs as a Linux/macOS service or runs in Docker/Kubernetes. [↩](#user-content-fnref-1)

   For more information, refer to [Diagnostic logs](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/troubleshoot-tunnels/diag-logs/).

Dec 17, 2024

1. ### [Establish BGP peering over Direct CNI circuits](https://developers.cloudflare.com/changelog/2024-12-17-bgp-support-cni/)

   [Magic Transit ](https://developers.cloudflare.com/magic-transit/)[Magic WAN ](https://developers.cloudflare.com/magic-wan/)[Network Interconnect](https://developers.cloudflare.com/network-interconnect/)

   Magic WAN and Magic Transit customers can use the Cloudflare dashboard to configure and manage BGP peering between their networks and their Magic routing table when using a Direct CNI on-ramp.

   Using BGP peering with a CNI allows customers to:

   * Automate the process of adding or removing networks and subnets.
   * Take advantage of failure detection and session recovery features.

   With this functionality, customers can:

   * Establish an eBGP session between their devices and the Magic WAN / Magic Transit service when connected via CNI.
   * Secure the session by MD5 authentication to prevent misconfigurations.
   * Exchange routes dynamically between their devices and their Magic routing table.

   Refer to [Magic WAN BGP peering](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-routes/#configure-bgp-routes) or [Magic Transit BGP peering](https://developers.cloudflare.com/magic-transit/how-to/configure-routes/#configure-bgp-routes) to learn more about this feature and how to set it up.

Dec 05, 2024

1. ### [Generate customized terraform files for building cloud network on-ramps](https://developers.cloudflare.com/changelog/2024-12-05-cloud-onramp-terraform/)

   [Magic Cloud Networking](https://developers.cloudflare.com/magic-cloud-networking/)

   You can now generate customized terraform files for building cloud network on-ramps to [Magic WAN](https://developers.cloudflare.com/magic-wan/).

   [Magic Cloud](https://developers.cloudflare.com/magic-cloud-networking/) can scan and discover existing network resources and generate the required terraform files to automate cloud resource deployment using their existing infrastructure-as-code workflows for cloud automation.

   You might want to do this to:

   * Review the proposed configuration for an on-ramp before deploying it with Cloudflare.
   * Deploy the on-ramp using your own infrastructure-as-code pipeline instead of deploying it with Cloudflare.

   For more details, refer to [Set up with Terraform](https://developers.cloudflare.com/magic-cloud-networking/cloud-on-ramps/#set-up-with-terraform).

Nov 22, 2024

1. ### [Find security misconfigurations in your AWS cloud environment](https://developers.cloudflare.com/changelog/2024-11-22-cloud-data-extraction-aws/)

   [CASB](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)

   You can now use CASB to find security misconfigurations in your AWS cloud environment using [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/).

   You can also [connect your AWS compute account](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/aws-s3/#compute-account) to extract and scan your S3 buckets for sensitive data while avoiding egress fees. CASB will scan any objects that exist in the bucket at the time of configuration.

   To connect a compute account to your AWS integration:

   1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Cloud & SaaS findings** > **Integrations**.
   2. Find and select your AWS integration.
   3. Select **Open connection instructions**.
   4. Follow the instructions provided to connect a new compute account.
   5. Select **Refresh**.

Nov 21, 2024

1. ### [Improved non-English keyboard support](https://developers.cloudflare.com/changelog/2024-11-21-non-english-keyboard/)

   [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)

   You can now type in languages that use diacritics (like á or ç) and character-based scripts (such as Chinese, Japanese, and Korean) directly within the remote browser. The isolated browser now properly recognizes non-English keyboard input, eliminating the need to copy and paste content from a local browser or device.

Oct 24, 2024

1. ### [Workflows is now in open beta](https://developers.cloudflare.com/changelog/2024-10-24-workflows-beta/)

   [Workers ](https://developers.cloudflare.com/workers/)[Workflows](https://developers.cloudflare.com/workflows/)

   Workflows is now in open beta, and available to any developer a free or paid Workers plan.

   Workflows allow you to build multi-step applications that can automatically retry, persist state and run for minutes, hours, days, or weeks. Workflows introduces a programming model that makes it easier to build reliable, long-running tasks, observe as they progress, and programmatically trigger instances based on events across your services.

   #### Get started

   You can get started with Workflows by [following our get started guide](https://developers.cloudflare.com/workflows/get-started/guide/) and/or using `npm create cloudflare` to pull down the starter project:

   ```sh
   npm create cloudflare@latest workflows-starter -- --template "cloudflare/workflows-starter"
   ```

   You can open the `src/index.ts` file, extend it, and use `wrangler deploy` to deploy your first Workflow. From there, you can:

   * Learn the [Workflows API](https://developers.cloudflare.com/workflows/build/workers-api/)
   * [Trigger Workflows](https://developers.cloudflare.com/workflows/build/trigger-workflows/) via your Workers apps.
   * Understand the [Rules of Workflows](https://developers.cloudflare.com/workflows/build/rules-of-workflows/) and how to adopt best practices

Oct 02, 2024

1. ### [Search for custom rules using rule name and/or ID](https://developers.cloudflare.com/changelog/2024-10-02-custom-rule-search/)

   [Magic Firewall](https://developers.cloudflare.com/magic-firewall/)

   The Magic Firewall dashboard now allows you to search custom rules using the rule name and/or ID.

   1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account.
   2. Go to **Analytics & Logs** > **Network Analytics**.
   3. Select **Magic Firewall**.
   4. Add a filter for **Rule ID**.

   ![Search for firewall rules with rule IDs](https://developers.cloudflare.com/_astro/search-with-rule-id.DJgzqgKk_1uO0HJ.webp)

   Additionally, the rule ID URL link has been added to Network Analytics.

   For more details about rules, refer to [Add rules](https://developers.cloudflare.com/cloudflare-one/traffic-policies/packet-filtering/add-rules/).

Sep 24, 2024

1. ### [Try out Magic Network Monitoring](https://developers.cloudflare.com/changelog/2024-09-24-magic-network-monitoring/)

   [Magic Network Monitoring](https://developers.cloudflare.com/magic-network-monitoring/)

   The free version of Magic Network Monitoring (MNM) is now available to everyone with a Cloudflare account by default.

   1. Log in to your [Cloudflare dashboard](https://dash.cloudflare.com), and select your account.
   2. Go to **Analytics & Logs** > **Magic Monitoring**.

   ![Try out the free version of Magic Network Monitoring](https://developers.cloudflare.com/_astro/get-started.D7KXWcs4_Z1HiIxS.webp)

   For more details, refer to the [Get started guide](https://developers.cloudflare.com/magic-network-monitoring/get-started/).

Jun 17, 2024

1. ### [Exchange user risk scores with Okta](https://developers.cloudflare.com/changelog/2024-06-17-okta-risk-exchange/)

   [Risk Score](https://developers.cloudflare.com/cloudflare-one/insights/risk-score/)

   Beyond the controls in [Zero Trust](https://developers.cloudflare.com/cloudflare-one/), you can now [exchange user risk scores](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/risk-score/#send-risk-score-to-okta) with Okta to inform SSO-level policies.

   First, configure Cloudflare One to send user risk scores to Okta.

   1. Set up the [Okta SSO integration](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/okta/).
   2. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Integrations** > **Identity providers**.
   3. In **Your identity providers**, locate your Okta integration and select **Edit**.
   4. Turn on **Send risk score to Okta**.
   5. Select **Save**.
   6. Upon saving, Cloudflare One will display the well-known URL for your organization. Copy the value.

   Next, configure Okta to receive your risk scores.

   1. On your Okta admin dashboard, go to **Security** > **Device Integrations**.
   2. Go to **Receive shared signals**, then select **Create stream**.
   3. Name your integration. In **Set up integration with**, choose *Well-known URL*.
   4. In **Well-known URL**, enter the well-known URL value provided by Cloudflare One.
   5. Select **Create**.

Jun 16, 2024

1. ### [Explore product updates for Cloudflare One](https://developers.cloudflare.com/changelog/2024-06-16-cloudflare-one/)

   [Access ](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/)[Browser Isolation ](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/)[CASB ](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/)[Cloudflare Tunnel ](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/)[Digital Experience Monitoring ](https://developers.cloudflare.com/cloudflare-one/insights/dex/)[Data Loss Prevention ](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/)[Email security ](https://developers.cloudflare.com/cloudflare-one/email-security/)[Gateway ](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)[Magic Cloud Networking ](https://developers.cloudflare.com/magic-cloud-networking/)[Magic Firewall ](https://developers.cloudflare.com/magic-firewall/)[Magic Network Monitoring ](https://developers.cloudflare.com/magic-network-monitoring/)[Magic Transit ](https://developers.cloudflare.com/magic-transit/)[Magic WAN ](https://developers.cloudflare.com/magic-wan/)[Network Interconnect ](https://developers.cloudflare.com/network-interconnect/)[Risk Score ](https://developers.cloudflare.com/cloudflare-one/insights/risk-score/)[Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/)

   Welcome to your new home for product updates on [Cloudflare One](https://developers.cloudflare.com/cloudflare-one/).

   Our [new changelog](https://developers.cloudflare.com/changelog/) lets you read about changes in much more depth, offering in-depth examples, images, code samples, and even gifs.

   If you are looking for older product updates, refer to the following locations.

   Older product updates

   * [Access](https://developers.cloudflare.com/cloudflare-one/changelog/access/)
   * [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/changelog/browser-isolation/)
   * [CASB](https://developers.cloudflare.com/cloudflare-one/changelog/casb/)
   * [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/changelog/tunnel/)
   * [Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/changelog/dlp/)
   * [Digital Experience Monitoring](https://developers.cloudflare.com/cloudflare-one/changelog/dex/)
   * [Email security](https://developers.cloudflare.com/cloudflare-one/changelog/email-security/)
   * [Gateway](https://developers.cloudflare.com/cloudflare-one/changelog/gateway/)
   * [Magic Cloud Networking](https://developers.cloudflare.com/magic-cloud-networking/changelog/)
   * [Magic Firewall](https://developers.cloudflare.com/magic-firewall/changelog/)
   * [Magic Network Monitoring](https://developers.cloudflare.com/magic-network-monitoring/changelog/)
   * [Magic Transit](https://developers.cloudflare.com/magic-transit/changelog/)
   * [Magic WAN](https://developers.cloudflare.com/magic-wan/changelog/)
   * [Network Interconnect](https://developers.cloudflare.com/network-interconnect/changelog/)
   * [Risk score](https://developers.cloudflare.com/cloudflare-one/changelog/risk-score/)
   * [Zero Trust WARP Client](https://developers.cloudflare.com/cloudflare-one/changelog/warp/)

Feb 26, 2024

1. ### [Easily Exclude EU Visitors from RUM](https://developers.cloudflare.com/changelog/2025-02-25-rum-exclude-eu/)

   [Cloudflare Web Analytics](https://developers.cloudflare.com/web-analytics/)

   You can now easily enable Real User Monitoring (RUM) monitoring for your hostnames, while safely dropping requests from visitors in the European Union to comply with GDPR and CCPA.

   ![RUM Enablement UI](https://developers.cloudflare.com/_astro/2025-02-26-rum-eu.X0ZtbXWA_ZzJK54.webp)

   Our Web Analytics product has always been centered on giving you insights into your users' experience that you need to provide the best quality experience, without sacrificing user privacy in the process.

   To help with that aim, you can now selectively enable RUM monitoring for your hostname and exclude EU visitor data in a single click. If you opt for this option, we will drop all metrics collected by our EU data centeres automatically.

   You can learn more about what metrics are reported by Web Analytics and how it is collected [in the Web Analytics documentation](https://developers.cloudflare.com/web-analytics/data-metrics/). You can enable Web Analytics on any hostname by going to the [Web Analytics](https://dash.cloudflare.com/?to=/:account/web-analytics/sites) section of the dashboard, selecting "Manage Site" for the hostname you want to monitor, and choosing the appropriate enablement option.

[Search for historical entries](https://developers.cloudflare.com/search/?contentType=Changelog+entry)
