---
title: View test results · Cloudflare One docs
description: Use the results of a DEX test to monitor availability and
  performance for a specific application. DEX will store test results according
  to our log retention policy.
lastUpdated: 2025-11-19T00:38:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/view-results/
  md: https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/view-results/index.md
---

Use the results of a DEX test to monitor availability and performance for a specific application. DEX will store test results according to our [log retention policy](https://developers.cloudflare.com/cloudflare-one/insights/logs/#log-retention).

## Prerequisites

* At least one [test](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/) has been created under **DEX** > **Tests**.
* Admins must have at least the [Cloudflare Zero Trust Reporting role](https://developers.cloudflare.com/cloudflare-one/roles-permissions/#zero-trust-roles).

## View results for all devices

To view an overview of test results for all devices:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **DEX** > **Monitoring**.
2. Select the **Tests** tab.
3. Under **Application tests**, select a test to view detailed results.

## View results for an individual device

To view analytics on a per-device level:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **My Team** > **Devices**.
2. Select the device you want to view, and then select **View details**.
3. Select the **Tests** tab.
4. Select a test to view detailed results.

## Export DEX application test logs

The log data for all [DEX application tests](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/dex_application_tests/) (including HTTP tests) can be exported to [R2](https://developers.cloudflare.com/r2/), a cloud bucket, or a SIEM via [Logpush](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/).

## Related resources

* [DEX HTTP test](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/http/) - Assess the accessibility of a web application.
* [DEX Traceroute test](https://developers.cloudflare.com/cloudflare-one/insights/dex/tests/traceroute/) - Measure the network path of an IP packet from an end-user device to a server.
* [DEX rules](https://developers.cloudflare.com/cloudflare-one/insights/dex/rules/) - Specify the target group of a test.
