---
title: Access audit logs · Cloudflare One docs
description: Use Access audit logs to review authentication events and requests
  to protected URI paths and infrastructure targets.
lastUpdated: 2025-10-23T19:01:53.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/logs/audit-logs/
  md: https://developers.cloudflare.com/cloudflare-one/insights/logs/audit-logs/index.md
---

Cloudflare Access generates two types of audit logs:

* **[Authentication audit logs](#authentication-audit-logs)** maintain a record of authentication events.
* **[Per-request audit logs](#per-request-audit-logs)** record requests to protected URI paths and infrastructure targets.

## Authentication logs

Cloudflare Access logs an authentication event whenever a user or service attempts to log in to an application, whether the attempt succeeds or not.

[Identity-based authentication](#identity-based-authentication) refers to login attempts that matched on user email, IdP group, SAML group, or OIDC claim.

[Non-identity authentication](#non-identity-authentication) refers to login attempts that matched a non-identity policy such as IP address, device posture, country, valid certificate, or service token.

Note

Authentication logs do not capture the user's actions during a self-hosted or SaaS application session.

### Identity-based authentication

#### View Access authentication logs

* Dashboard

  To view logs for identity-based authentication events:

  1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Logs** > **Access**.
  2. Select a row to view details such as the login method, the IP address of the user, and more.

* API

  The [Access authentication logs](https://developers.cloudflare.com/api/resources/zero_trust/subresources/access/subresources/logs/subresources/access_requests/methods/list/) API endpoint provides a custom URL to export audit log events for your account.

  Required API token permissions

  At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

  * `Access: Audit Logs Read`

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/access/logs/access_requests?limit=25&direction=desc&since=2020-07-01T05%3A20%3A00Z&until=2020-10-01T05%3A20%3A00Z" \
    --request GET \
    --header "X-Auth-Email: $CLOUDFLARE_EMAIL" \
    --header "X-Auth-Key: $CLOUDFLARE_API_KEY"
  ```

  ```json
  {
    "success": true,
    "errors": [],
    "messages": [],
    "result": [
      {
        "user_email": "michelle@example.com",
        "ip_address": "198.41.129.166",
        "app_uid": "df7e2w5f-02b7-4d9d-af26-8d1988fca630",
        "app_domain": "test.example.com/admin",
        "action": "login",
        "connection": "saml",
        "allowed": false,
        "created_at": "2014-01-01T05:20:00.12345Z",
        "ray_id": "187d944c61940c77"
      }
    ]
  }
  ```

#### Explanation of the fields

Identity-based authentication logs contain the following fields:

##### Basic information

| Field | Description |
| - | - |
| **App** | Name of the Access application. |
| **User email** | Email address of the authenticating user. |
| **User ID** | UUID of the authenticating user. |
| **IP address** | IP address of the authenticating user. |
| **App UID** | UUID of the Access application. |
| **App domain** | URL of the Access application. |
| **App type** | Specifies the type of Access application: self-hosted, browser SSH, browser VNC, browser RDP, SaaS, or infrastructure. |
| **Event** | Type of authentication event, such as a login attempt. |
| **Connection** | IdP used to authenticate. |
| **Allow** | Result of the authentication event. |
| **Request time** | Timestamp of the authentication event. |
| **Ray ID** | A unique identifier for every request through Cloudflare. |
| **Country** | Country associated with the user's IP address. |

##### Infrastructure applications

Cloudflare Access logs the following information when the user authenticates to an [infrastructure application](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/infrastructure-apps/):

| Field | Description |
| - | - |
| **Hostname** | Hostname of the infrastructure target. |
| **Target ID** | UUID of the infrastructure target. |
| **SSH user** | The UNIX user, such as `root`, that the authenticating user specified when connecting to the infrastructure target. |
| **SSH logs** | SSH commands that the user ran on the target. Requires configuring an [SSH encryption key](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/#ssh-command-logs) before the session begins. |

### Non-identity authentication

To retrieve logs for non-identity authentication events, use the [GraphQL Analytics API](https://developers.cloudflare.com/analytics/graphql-api/tutorials/querying-access-login-events/). These logs are not available in Zero Trust.

## Per-request logs

Users who have authenticated through Access have access to authorized URL paths for the duration of their session. Cloudflare provides several ways to audit these requests.

### Using Cloudflare Logs

Enterprise customers have access to detailed logs of requests on their Cloudflare dashboard. Enterprise customers also have access to Cloudflare's Logpush service, which can be configured from the Cloudflare dashboard or API. For more information about Cloudflare HTTP and infrastructure logging, refer to [Cloudflare Logs](https://developers.cloudflare.com/logs/).

Once a member of your team authenticates to reach an HTTP resource behind Access, Cloudflare generates a token for that user that contains their SSO identity. The token is structured as a JSON Web Token (JWT). Cloudflare relies on an RSA Signature with SHA-256, or RS256, an asymmetric algorithm, to perform that signature. Cloudflare also makes the public key available, so that you can validate their authenticity, as well.

When a user requests a given URL, Access appends the user identity from that token as a request header, which we then log as the request passes through our network. Your team can collect these logs in your preferred third-party Security information and event management (SIEM) software or storage destination by using [Cloudflare Logpush](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/). When enabled with the Access user identity field, the logs will export to your systems as JSON similar to the logs below.

```json
{
   "ClientIP": "198.51.100.206",
   "ClientRequestHost": "jira.widgetcorp.tech",
   "ClientRequestMethod": "GET",
   "ClientRequestURI": "/secure/Dashboard/jspa",
   "ClientRequestUserAgent":"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36",
   "EdgeEndTimestamp": "2019-11-10T09:51:07Z",
   "EdgeResponseBytes": 4600,
   "EdgeResponseStatus": 200,
   "EdgeStartTimestamp": "2019-11-10T09:51:07Z",
   "RayID": "5y1250bcjd621y99",
   "RequestHeaders":{"cf-access-user":"srhea"}
},
{
   "ClientIP": "198.51.100.206",
   "ClientRequestHost": "jira.widgetcorp.tech",
   "ClientRequestMethod": "GET",
   "ClientRequestURI": "/browse/EXP-12",
   "ClientRequestUserAgent":"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36",
   "EdgeEndTimestamp": "2019-11-10T09:51:27Z",
   "EdgeResponseBytes": 4570,
   "EdgeResponseStatus": 200,
   "EdgeStartTimestamp": "2019-11-10T09:51:27Z",
   "RayID": "yzrCqUhRd6DVz72a",
   "RequestHeaders":{"cf-access-user":"srhea"}
}
```

### Using the `cf-access-user` field

In addition to the HTTP request fields available in Cloudflare Enterprise logging, requests made to applications behind Access include the `cf-access-user` field, which contains the user identity string. This offers another tool for auditing user behavior. To add the `cf-access-user` field to your HTTP request logs, you must add it as a custom field. Refer to [Custom fields](https://developers.cloudflare.com/logs/logpush/logpush-job/custom-fields/) for instructions.

Keep in mind that Access does not log all interactions. For example, per-request audit logs can indicate that a specific user visited `domain.com/admin` and then `domain.com/admin/panel`, but the logs can only identify user interactions that result in a new HTTP request.
