---
title: Logpush integration · Cloudflare One docs
description: With Cloudflare's Logpush service, you can configure the automatic
  export of Zero Trust logs to third-party storage destinations or to
  third-party security information and event management (SIEM) solutions. Once
  exported, your team can analyze and audit the data as needed.
lastUpdated: 2025-11-19T00:38:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/
  md: https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/index.md
---

Note

Only available on Enterprise plans.

With Cloudflare's [Logpush](https://developers.cloudflare.com/logs/logpush/) service, you can configure the automatic export of Zero Trust logs to third-party storage destinations or to third-party security information and event management (SIEM) solutions. Once exported, your team can analyze and audit the data as needed.

## Export Zero Trust logs with Logpush

Dashboard limitation

Zero Trust does not support configuring [Cloudflare R2](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/r2/) as a Logpush destination in the dashboard. To use R2 as a destination for Zero Trust logs, configure your Logpush jobs [with the API](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/r2/#manage-via-api).

To configure Logpush for Zero Trust logs:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Logs** > **Logpush**.
2. If this is your first Logpush job, select **Add a Logpush job**. Otherwise, select **Go to logpush configurations**.
3. In Logpush, select **Create a Logpush job**.
4. Choose a [Logpush destination](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/).
5. Follow the service-specific instructions to configure and validate your destination.
6. Choose the [Zero Trust datasets](#zero-trust-datasets) to export.
7. Enter a **Job name**, any [filters](https://developers.cloudflare.com/logs/logpush/logpush-job/filters/) you would like to add, and the data fields you want to include in the logs.
8. (Optional) In **Advanced settings**, choose the timestamp format you prefer and whether you want to enable log sampling.
9. Select **Submit**.

The setup of your Logpush integration is now complete. Logpush will send updated logs every five minutes to your selected destination. You can configure multiple destinations and add additional fields to your logs by returning to the **Logpush** page.

For more information on supported destinations, refer to [Enable destinations](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/).

## Zero Trust datasets

Refer to [Logpush datasets](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/) for a list of all available fields.

| Dataset | Description |
| - | - |
| [Access Requests](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/access_requests/) | HTTP requests to sites protected by Cloudflare Access |
| [Audit Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/audit_logs/) | Authentication events through Cloudflare Access |
| [Browser Isolation User Actions](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/biso_user_actions/) | Data transfer actions performed by a user in the remote browser |
| [CASB Findings](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/casb_findings/) | Security issues detected by Cloudflare CASB |
| [Device Posture Results](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/device_posture_results/) | Device posture status from the WARP client |
| [DEX Application Tests](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/dex_application_tests/) | Device application synthetic test results from the WARP client |
| [DEX Device State Events](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/dex_device_state_events/) | Device event data like connectivity, CPU usage, and Disk I/O from the WARP client |
| [Gateway DNS](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/gateway_dns/) | DNS queries inspected by Cloudflare Gateway |
| [Gateway HTTP](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/gateway_http/) | HTTP requests inspected by Cloudflare Gateway |
| [Gateway Network](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/gateway_network/) | Network packets inspected by Cloudflare Gateway |
| [SSH Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/ssh_logs/) | SSH command logs for [Access for Infrastructure targets](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/) |
| [WARP Config Changes](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/warp_config_changes/) | Event logs that are generated whenever a WARP device changes [profiles](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/) |
| [WARP Toggle Events](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/warp_toggle_changes/) | Event logs that are generated whenever a WARP device toggles WARP on or off |
| [Zero Trust Network Session Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/zero_trust_network_sessions/) | Network session logs for traffic proxied by Cloudflare Gateway |

## Parse DNS logs

Logpush logs the following fields for each DNS query:

* Query name
* Query type
* Query class
* Response TTL
* Response data

DNS query resource records are available in [Base64-encoded binary format](https://datatracker.ietf.org/doc/html/rfc1035#section-4.1.3) and JSON. For example:

```json
{
  "ResourceRecords": [
    {
      "type": "5",
      "data": "d3d3LmV4YW1wbGUuY29tAAABAAUAAABleGFtcGxlLmNvbQ=="
    },
    {
      "type": "1",
      "data": "ZXhhbXBsZS5jb20AAAEAAQAAAQIDBAUGBwgJ"
    }
  ],
  "ResourceRecordsJSON": "[{\"name\":\"www.example.com\",\"type\":\"CNAME\",\"class\":\"IN\",\"ttl\":300,\"rdata\":\"example.com.\"},{\"name\":\"example.com\",\"type\":\"A\",\"class\":\"IN\",\"ttl\":300,\"rdata\":\"203.0.113.0\"}]"
}
```
