---
title: Domain joined · Cloudflare One docs
description: The Domain Joined device posture attribute ensures that a user is a
  member of a specific Windows Active Directory domain.
lastUpdated: 2025-10-27T17:49:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/domain-joined/
  md: https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/domain-joined/index.md
---

The Domain Joined device posture attribute ensures that a user is a member of a specific Windows Active Directory domain.

## Prerequisites

* Cloudflare WARP client is [deployed](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on the device. For a list of supported modes and operating systems, refer to [WARP Client Checks](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/).

## Enable the Domain Joined check

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Reusable components** > **Posture checks**.

2. Go to **WARP client checks** and select **Add a check**.

3. Select **Domain Joined**.

4. Enter a descriptive name for the check.

5. Select your operating system.

6. Enter the domain you want to check for, such as `example.com`.

   Note

   The **Domain** field is case-sensitive. If your domain is `example.com`, entering `Example.com` will fail the posture check.

7. Select **Save**.

Next, go to **Insights** > **Logs** > **Posture logs** and verify that the Domain Joined check is returning the expected results.

## Validate the domain value

To check the domain value on your Windows device:

1. Open a PowerShell window.

2. Run the following command:

   ```powershell
   (Get-WmiObject Win32_ComputerSystem).Domain
   ```

The command will return the Active Directory domain to which your device belongs.
