---
title: Dynamic threshold rule · Cloudflare Magic Network Monitoring docs
description: A dynamic threshold rule (beta) will analyze a network's traffic
  patterns over time and automatically adjust the rule's DDoS threshold, in
  terms of bits or packets, based on traffic history. The total traffic across
  all IP prefixes and IP addresses in the rule is compared to the current value
  of the dynamic threshold. If the total traffic exceeds the dynamic threshold,
  then an alert is sent.
lastUpdated: 2025-11-19T16:38:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-network-monitoring/rules/dynamic-threshold/
  md: https://developers.cloudflare.com/magic-network-monitoring/rules/dynamic-threshold/index.md
---

A dynamic threshold rule (beta) will analyze a network's traffic patterns over time and automatically adjust the rule's DDoS threshold, in terms of bits or packets, based on traffic history. The total traffic across all IP prefixes and IP addresses in the rule is compared to the current value of the dynamic threshold. If the total traffic exceeds the dynamic threshold, then an alert is sent.

Dynamic thresholds are calculated using a statistical measure called [Z-score](https://en.wikipedia.org/wiki/Standard_score) (also referred to as standard score). Review [How the dynamic rule threshold is calculated](#how-the-dynamic-rule-threshold-is-calculated) to learn more.

Customers that send NetFlow and/or sFlow data to Cloudflare can configure dynamic threshold rules.

A dynamic threshold rule can only be configured via [Cloudflare's Magic Network Monitoring Rules API](https://developers.cloudflare.com/api/resources/magic_network_monitoring/subresources/rules/). Today, customers are unable to configure dynamic threshold rules in the Cloudflare dashboard.

## Rule configuration fields

| Field | Description |
| - | - |
| **Rule name** | Must be unique and cannot contain spaces. Supports characters `A-Z`, `a-z`, `0-9`, underscore (`_`), dash (`-`), period (`.`), and tilde (`~`). Maximum of 256 characters. |
| **Rule type** | zscore |
| **Target** | Can be defined in either bits per second or packets per second. |
| **Sensitivity** | Z-Score sensitivity has three values: low, medium, and high. |
| **Auto-advertisement** | If you are a [Magic Transit On Demand](https://developers.cloudflare.com/magic-transit/on-demand) customer, you can enable this feature to automatically enable Magic Transit if the rule's dynamic threshold is triggered. Magic Network Monitoring supports Magic Transit's supernet capability. To learn more refer to [Auto-Advertisement section](https://developers.cloudflare.com/magic-network-monitoring/rules/#rule-auto-advertisement). |
| **Rule IP prefix** | The IP prefix associated with the rule for monitoring traffic volume. Must be a CIDR range such as `160.168.0.1/24`. The maximum is 5,000 unique CIDR entries. To learn more and review an example, refer to the [Rule IP prefixes](https://developers.cloudflare.com/magic-network-monitoring/rules/#rule-ip-prefixes) section. |

## API documentation

To review an example API configuration call using CURL and the expected output for a successful response, go to the [Rules](https://developers.cloudflare.com/api/resources/magic_network_monitoring/subresources/rules/) section in the Magic Network Monitoring API documentation.

## How the dynamic rule threshold is calculated

Dynamic thresholds for this rule type are calculated using a statistical measure called Z-Score. The dynamic threshold for this rule will automatically adjust based on your traffic history as this rule uses statistical analysis to detect traffic anomalies. Z-Score is calculated by comparing short-term traffic patterns (five-minute time window) against long-term baselines (four-hour time window) .

Z-Score is calculated by using the following formula:

```txt
Z = (X - μ) / σ
```

* `X` = Current traffic value.
* `μ` = Mean traffic value over the long window.
* `σ` = Standard deviation over the long window.
