---
title: Add a request header for subrequests from other zones · Cloudflare Rules docs
description: Create a request header transform rule to add an HTTP header when
  the Workers subrequest comes from a different zone.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Request modification
source_url:
  html: https://developers.cloudflare.com/rules/transform/examples/add-request-header-subrequest-other-zone/
  md: https://developers.cloudflare.com/rules/transform/examples/add-request-header-subrequest-other-zone/index.md
---

The following request header transform rule adds an HTTP header to Workers subrequests coming from a different zone:

Text in **Expression Editor** (replace `myappexample.com` with your domain):

```txt
(cf.worker.upstream_zone != "" and cf.worker.upstream_zone != "myappexample.com")
```

Selected operation under **Modify request header**: *Set static*

**Header name**: `X-External-Workers-Subrequest`

**Value**: `1`

The [`cf.worker.upstream_zone`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.worker.upstream_zone/) field used in the rule expression is set to empty if the current request is not a Workers subrequest.
