---
title: Static IP · Cloudflare Spectrum docs
description: When you create a Spectrum application, you are assigned an IP.
  These IPs are normally dynamic, meaning that they will change over time. But,
  for instance, if you want to set up WAF custom rules for specific IPs, you may
  want to use static IPs.
lastUpdated: 2025-10-01T13:13:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/spectrum/about/static-ip/
  md: https://developers.cloudflare.com/spectrum/about/static-ip/index.md
---

When you create a Spectrum application, you are assigned an IP. These IPs are normally dynamic, meaning that they will change over time. But, for instance, if you want to set up WAF custom rules for specific IPs, you may want to use static IPs.

A static IP, like a physical street address can tell other computers or servers on the Internet where a specific computer is located or connected. This makes the device easier to find on the network, since the IP will not change.

With static IPs, Cloudflare commits to never changing the IP address of a client's domain resolved at the Cloudflare global network. For example, `www.example.com` will always resolve and accept traffic sent to `198.51.100.10`. No other customer will be hosted on that IP.

Importantly, the static IP is associated with the DNS name, not with each individual Spectrum application. This means that all Spectrum apps using the same hostname will share the same static IP.

## Use static IPs with Spectrum

Availability

Static IP is an Enterprise feature that does not come standard with Spectrum. Contact your account team to request access.

Once you get your static IP from Cloudflare, you can use it via API, just like [BYOIP](https://developers.cloudflare.com/byoip/). For the moment, there is still no UI available for this feature.

When creating a Spectrum application through the API, specify the static IPs that you have been provided. See, for instance, the API example below that creates an application routing traffic through Cloudflare’s HTTP pipeline.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Zone Settings Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/spectrum/apps" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "protocol": "tcp/80",
    "dns": {
        "type": "ADDRESS",
        "name": "www.example.com"
    },
    "origin_direct": [
        "tcp://192.0.2.1:80"
    ],
    "tls": "off",
    "traffic_type": "http",
    "edge_ips": {
        "type": "static",
        "ips": [
            "198.51.100.10",
            "2001:DB8::1"
        ]
    }
  }'
```

## Check your static IPs

A list of your leased static IPs for Spectrum is available on the dashboard under [**IP addresses** > **Leased IPs**](https://dash.cloudflare.com/?to=/:account/ip-addresses/leased-ips).
