---
title: Error 1001 · Cloudflare Support docs
description: This error indicates a DNS resolution failure preventing access to
  the requested domain.
lastUpdated: 2025-05-14T13:30:35.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1001/
  md: https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/error-1001/index.md
---

## Error 1001: DNS resolution error

This error indicates a DNS resolution failure preventing access to the requested domain.

### Common causes

* A web request was sent to a Cloudflare IP address for a non-existent Cloudflare domain.
* An external domain that is not on using Cloudflare has a CNAME record to a domain active on Cloudflare
* The target of the DNS CNAME record does not resolve.
* A CNAME record in your Cloudflare DNS app requires resolution via a DNS provider that is currently offline.
* [Always Online](https://developers.cloudflare.com/cache/how-to/always-online/) is enabled for a [Custom Hostname (Cloudflare for SaaS)](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/) domain.

### Resolution

A non-Cloudflare domain cannot CNAME to a Cloudflare domain, unless the non-Cloudflare domain is added to a Cloudflare account.

Attempting to directly access DNS records used for [Cloudflare CNAME setups](https://developers.cloudflare.com/dns/zone-setups/partial-setup) also causes error 1001. For example, `www.example.com.cdn.cloudflare.net`.

Disable [Always Online](https://developers.cloudflare.com/cache/how-to/always-online/#enable-always-online), if using [Custom Hostname (Cloudflare for SaaS)](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/) domain.
