---
title: SameSite cookie interaction with Cloudflare · Cloudflare Web Application
  Firewall (WAF) docs
description: Google Chrome enforces SameSite cookie behavior to protect against
  marketing cookies that track users and Cross-site Request Forgery (CSRF) that
  allows attackers to steal or manipulate your cookies.
lastUpdated: 2025-07-11T17:09:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/troubleshooting/samesite-cookie-interaction/
  md: https://developers.cloudflare.com/waf/troubleshooting/samesite-cookie-interaction/index.md
---

[Google Chrome enforces SameSite cookie behavior](https://www.chromium.org/updates/same-site) to protect against marketing cookies that track users and Cross-site Request Forgery (CSRF) that allows attackers to steal or manipulate your cookies.

The `SameSite` cookie attribute has three different modes:

* **Strict**: Cookies are created by the first party (the visited domain). For example, a first-party cookie is set by Cloudflare when visiting `cloudflare.com`.
* **Lax**: Cookies are only sent to the apex domain (such as `example.com`). For example, if someone (`blog.example.net`) hotlinked an image (`img.example.com/bar.png`), the client does not send a cookie to `img.example.com` since it is neither the first-party nor apex context.
* **None**: Cookies are sent with all requests.

`SameSite` settings for [Cloudflare cookies](https://developers.cloudflare.com/fundamentals/reference/policies-compliances/cloudflare-cookies/) include:

| Cloudflare cookie | SameSite setting | HTTPS Only |
| - | - | - |
| `__cf_bm` | `SameSite=None; Secure` | Yes |
| `cf_clearance` | `SameSite=None; Secure` | Yes |
| `__cflb` | `SameSite=Lax` | No |

## SameSite attribute in session affinity cookies

Currently, to configure the `SameSite` attribute on [session affinity cookies](https://developers.cloudflare.com/load-balancing/understand-basics/session-affinity/) you must use the Cloudflare API (for example, the [Create Load Balancer](https://developers.cloudflare.com/api/resources/load_balancers/methods/create/) operation).

To configure the value of the `SameSite` cookie attribute, include the `samesite` and `secure` JSON attributes in your HTTP request, inside the `session_affinity_attributes` object.

The available values for these two attributes are the following:

**`samesite` attribute:**

* Valid values: `Auto` (default), `Lax`, `None`, `Strict`.

**`secure` attribute:**

* Valid values: `Auto` (default), `Always`, `Never`.

The `Auto` value for the `samesite` attribute will have the following behavior:

* If [**Always Use HTTPS**](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/always-use-https/) is enabled, session affinity cookies will use the `Lax` SameSite mode.
* If **Always Use HTTPS** is disabled, session affinity cookies will use the `None` SameSite mode.

The `Auto` value for the `secure` attribute will have the following behavior:

* If **Always Use HTTPS** is enabled, session affinity cookies will include `Secure` in the SameSite attribute.
* If **Always Use HTTPS** is disabled, session affinity cookies will not include `Secure` in the SameSite attribute.

If you set `samesite` to `None` in your API request, you cannot set `secure` to `Never`.

If you require a specific `SameSite` configuration in your session affinity cookies, Cloudflare recommends that you provide values for `samesite` and `secure` different from `Auto`, instead of relying on the default behavior. This way, the value of the `SameSite` cookie attribute will not change due to configuration changes (namely [**Always Use HTTPS**](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/always-use-https/)).

***

## Known issues with SameSite and `cf_clearance` cookies

When a visitor solves a [challenge](https://developers.cloudflare.com/cloudflare-challenges/) presented due to a [custom rule](https://developers.cloudflare.com/waf/custom-rules/) or an [IP access rule](https://developers.cloudflare.com/waf/tools/ip-access-rules/), a `cf_clearance` cookie is set in the visitor's browser. The `cf_clearance` cookie has a default lifetime of 30 minutes, which you can configure via [Challenge Passage](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/challenge-passage/).

Cloudflare uses `SameSite=None` in the `cf_clearance` cookie so that visitor requests from different hostnames are not met with later challenges or errors. When `SameSite=None` is used, it must be set in conjunction with the `Secure` flag.

Using the `Secure` flag requires sending the cookie via an HTTPS connection. If you use HTTP on any part of your website, the `cf_clearance` cookie defaults to `SameSite=Lax`, which may cause your website not to function properly.

To resolve the issue, move your website traffic to HTTPS. Cloudflare offers two features for this purpose: 

* [Automatic HTTPS Rewrites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/automatic-https-rewrites/)
* [Always Use HTTPS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/always-use-https/)

***

## Related resources

* [SameSite cookies explained](https://web.dev/samesite-cookies-explained/) 
* [Cloudflare Cookies](https://developers.cloudflare.com/fundamentals/reference/policies-compliances/cloudflare-cookies/)
* [Cloudflare SSL FAQ](https://developers.cloudflare.com/ssl/troubleshooting/faq/)
* [Automatic HTTPS Rewrites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/automatic-https-rewrites/)
* [Always Use HTTPS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/always-use-https/)
